/*
 * Decompiled with CFR 0.152.
 */
package org.globus.replica.rls.impl.rpc;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

class RPCOutputStream
extends FilterOutputStream {
    private static final int TERMINATOR = 0;
    private static final boolean DEBUG = false;
    private static final String RLS_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    RPCOutputStream(OutputStream out) {
        super(out);
    }

    public final void writeString(String str) throws IOException {
        if (str == null) {
            str = "";
        }
        this._debug(str);
        this.write(str.getBytes(), 0, str.length());
        this.writeTerminator();
    }

    public final void writeTerminator() throws IOException {
        this._debug("TERMINATOR");
        this.write(0);
    }

    public final void writeInt(int i) throws IOException {
        this._debug("(int) " + i);
        this.writeString(Integer.toString(i));
    }

    public final void writeDouble(double d) throws IOException {
        this._debug("(double) " + d);
        this.writeString(Double.toString(d));
    }

    public final void writeDate(Date d) throws IOException {
        this._debug("(Date) " + d);
        this.writeString(this.sdf.format(d));
    }

    private void _debug(String msg) {
    }
}

