/*
 * Decompiled with CFR 0.152.
 */
package org.globus.replica.rls.impl.rpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.replica.rls.Administrative;
import org.globus.replica.rls.AttributeResult;
import org.globus.replica.rls.AttributeSearch;
import org.globus.replica.rls.BatchCatalogQuery;
import org.globus.replica.rls.BatchIndexQuery;
import org.globus.replica.rls.CatalogExistenceQuery;
import org.globus.replica.rls.CatalogQuery;
import org.globus.replica.rls.ConfigurationOption;
import org.globus.replica.rls.IndexExistenceQuery;
import org.globus.replica.rls.IndexMapping;
import org.globus.replica.rls.IndexMappingResult;
import org.globus.replica.rls.IndexQuery;
import org.globus.replica.rls.LocalReplicaCatalog;
import org.globus.replica.rls.Mapping;
import org.globus.replica.rls.MappingResult;
import org.globus.replica.rls.QueryResults;
import org.globus.replica.rls.RLIUpdate;
import org.globus.replica.rls.RLSAttribute;
import org.globus.replica.rls.RLSAttributeObject;
import org.globus.replica.rls.RLSConnection;
import org.globus.replica.rls.RLSException;
import org.globus.replica.rls.RLSIOException;
import org.globus.replica.rls.RLSLRCInfo;
import org.globus.replica.rls.RLSOffsetLimit;
import org.globus.replica.rls.RLSRLIInfo;
import org.globus.replica.rls.RLSStats;
import org.globus.replica.rls.RLSStatusCode;
import org.globus.replica.rls.Rename;
import org.globus.replica.rls.RenameResult;
import org.globus.replica.rls.ReplicaLocationIndex;
import org.globus.replica.rls.Results;
import org.globus.replica.rls.SimpleCatalogQuery;
import org.globus.replica.rls.SimpleIndexQuery;
import org.globus.replica.rls.impl.rpc.RPCDeserializationException;
import org.globus.replica.rls.impl.rpc.RPCInputStream;
import org.globus.replica.rls.impl.rpc.RPCObjectDeserializer;
import org.globus.replica.rls.impl.rpc.RPCObjectSerializer;
import org.globus.replica.rls.impl.rpc.RPCOutputStream;
import org.globus.util.GlobusURL;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class SimpleRLSConnection
implements RLSConnection {
    private static final int DEFAULT_PORT = 39281;
    private static final String PROTOCOL_SECURE = "rls";
    private static final String PROTOCOL_UNSECURE = "rlsn";
    private static final String CLOSE = "close";
    private static final String LOCALHOST = "localhost";
    private static final int RPC_NORESPONSE = 1;
    private static final int RPC_NORESULT = 2;
    private static final int RPC_SINGLERESULT = 4;
    private static final int RPC_MULTIPLERESULTS = 8;
    private static Log logger;
    LocalReplicaCatalog catalog = null;
    ReplicaLocationIndex index = null;
    Administrative admin = null;
    Socket sock = null;
    RPCOutputStream out = null;
    RPCInputStream in = null;
    StringSerializer stringSerializer = new StringSerializer();
    MappingSerializer mappingSerializer = new MappingSerializer();
    IndexMappingSerializer indexMappingSerializer = new IndexMappingSerializer();
    MinimalAttributeSerializer minAttrSerializer = new MinimalAttributeSerializer();
    AttributeDefineSerializer attrdefSerializer = new AttributeDefineSerializer();
    AttributeObjectSerializer attrobjSerializer = new AttributeObjectSerializer();
    RemoveAttributeObjectSerializer removeAttrobjSerializer = new RemoveAttributeObjectSerializer();
    ModifyAttributeObjectSerializer modifyAttrobjSerializer = new ModifyAttributeObjectSerializer();
    AttributeSearchSerializer attributeSearchSerializer = new AttributeSearchSerializer();
    RenameSerializer renameSerializer = new RenameSerializer();
    RLIUpdateSerializer rliUpdateSerializer = new RLIUpdateSerializer();
    StringResultDeserializer stringDeserializer = new StringResultDeserializer();
    MappingResultDeserializer mappingResultDeserializer = new MappingResultDeserializer();
    MappingUpdateDeserializer mappingUpdateDeserializer = new MappingUpdateDeserializer();
    MappingExistsDeserializer mappingExistsDeserializer = new MappingExistsDeserializer();
    SimpleMappingResultDeserializer simpleMappingResultDeserializer = new SimpleMappingResultDeserializer();
    IndexMappingResultDeserializer indexMappingResultDeserializer = new IndexMappingResultDeserializer();
    IndexMappingExistsDeserializer indexMappingExistsDeserializer = new IndexMappingExistsDeserializer();
    SimpleIndexMappingResultDeserializer simpleIndexMappingResultDeserializer = new SimpleIndexMappingResultDeserializer();
    RenameResultDeserializer renameResultDeserializer = new RenameResultDeserializer();
    RLIUpdateDeserializer rliUpdateDeserializer = new RLIUpdateDeserializer();
    RLIInfoDeserializer rliInfoDeserializer = new RLIInfoDeserializer();
    SenderInfoDeserializer senderInfoDeserializer = new SenderInfoDeserializer();
    StatsDeserializer statsDeserializer = new StatsDeserializer();
    ConfigOptionDeserializer configOptionDeserializer = new ConfigOptionDeserializer();
    AttrObjResultDeserializer attrObjResultDeserializer = new AttrObjResultDeserializer();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.globus.replica.rls.impl.rpc.SimpleRLSConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((String)clazz.getName());
    }

    public SimpleRLSConnection(GlobusURL url, GSSCredential cred) throws RLSException {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (PROTOCOL_UNSECURE.equals(url.getProtocol())) {
            this._establishUnsecuredConnection(url);
        } else if (PROTOCOL_SECURE.equals(url.getProtocol())) {
            this._establishSecuredConnection(url, cred);
        } else {
            throw new IllegalArgumentException("Protocol not supported (protocol: " + url.getProtocol() + ")");
        }
    }

    private void _establishUnsecuredConnection(GlobusURL url) throws RLSException {
        try {
            String host;
            int port = url.getPort();
            if (port < 0) {
                port = 39281;
            }
            if (LOCALHOST.equalsIgnoreCase(host = url.getHost())) {
                host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            this.sock = new Socket(host, port);
            OutputStream rawOut = this.sock.getOutputStream();
            InputStream rawIn = this.sock.getInputStream();
            rawOut.flush();
            this.out = new RPCOutputStream(rawOut);
            this.in = new RPCInputStream(rawIn);
            int rc = this.in.readInt();
            if (rc != 0) {
                logger.debug((Object)("Failed to establish RLS connection, RLS server returned rc=" + rc));
                this._release();
                throw new RLSException(rc, RLSStatusCode.toMessage(rc));
            }
            this.catalog = new LRCImpl();
            this.index = new RLIImpl();
            this.admin = new AdminImpl();
        }
        catch (UnknownHostException e) {
            this._release();
            throw new RLSException(1, "Unable to resolve localhost (cause: " + e.getLocalizedMessage() + ")", e);
        }
        catch (IOException e) {
            this._release();
            throw new RLSException(1, "I/O failure when establishing connection (cause: " + e.getLocalizedMessage() + ")", e);
        }
    }

    private void _establishSecuredConnection(GlobusURL url, GSSCredential cred) throws RLSException {
        try {
            String host;
            int port = url.getPort();
            if (port < 0) {
                port = 39281;
            }
            if (LOCALHOST.equalsIgnoreCase(host = url.getHost())) {
                host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            HostAuthorization auth = HostAuthorization.getInstance();
            GSSManager manager = GlobusGSSManagerImpl.getInstance();
            ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(null, GSSConstants.MECH_OID, cred, 0);
            context.requestCredDeleg(false);
            context.requestConf(true);
            context.requestAnonymity(false);
            context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
            this.sock = GssSocketFactory.getDefault().createSocket(host, port, (GSSContext)context);
            GssSocket gssSock = (GssSocket)this.sock;
            gssSock.setWrapMode(1);
            gssSock.setAuthorization((Authorization)auth);
            OutputStream secureOut = this.sock.getOutputStream();
            this.sock.getInputStream();
            secureOut.flush();
            Socket rawSock = gssSock.getWrappedSocket();
            OutputStream rawOut = rawSock.getOutputStream();
            InputStream rawIn = rawSock.getInputStream();
            this.out = new RPCOutputStream(rawOut);
            this.in = new RPCInputStream(rawIn);
            if (!context.isEstablished()) {
                throw new RLSException(1, "Security context could not be established.");
            }
            logger.debug((Object)("Initiator : " + context.getSrcName()));
            logger.debug((Object)("Acceptor  : " + context.getTargName()));
            logger.debug((Object)("Lifetime  : " + context.getLifetime()));
            logger.debug((Object)("Privacy   : " + context.getConfState()));
            logger.debug((Object)("Anonymity : " + context.getAnonymityState()));
            int rc = this.in.readInt();
            if (rc != 0) {
                logger.debug((Object)("Failed to establish RLS connection, RLS server returned rc=" + rc));
                this._release();
                throw new RLSException(rc, RLSStatusCode.toMessage(rc));
            }
            this.catalog = new LRCImpl();
            this.index = new RLIImpl();
            this.admin = new AdminImpl();
            context.dispose();
        }
        catch (GSSException e) {
            this._release();
            throw new RLSException(1, "Failed to establish security context (cause: " + e.getLocalizedMessage() + ")", e);
        }
        catch (UnknownHostException e) {
            this._release();
            throw new RLSException(1, "Unable to resolve localhost (cause: " + e.getLocalizedMessage() + ")", e);
        }
        catch (IOException e) {
            this._release();
            throw new RLSException(1, "I/O failure when establishing connection (cause: " + e.getLocalizedMessage() + ")", e);
        }
    }

    private void _release() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {}
            this.in = null;
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {}
            this.out = null;
        }
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (Exception exception) {}
            this.sock = null;
        }
        this.catalog = null;
        this.index = null;
        this.admin = null;
    }

    public void setTimeout(int timeout) throws RLSException {
        try {
            this.sock.setSoTimeout(timeout);
        }
        catch (SocketException e) {
            throw new RLSIOException(e);
        }
    }

    public int getTimeout() throws RLSException {
        try {
            return this.sock.getSoTimeout();
        }
        catch (SocketException e) {
            throw new RLSIOException(e);
        }
    }

    public LocalReplicaCatalog catalog() {
        return this.catalog;
    }

    public ReplicaLocationIndex index() {
        return this.index;
    }

    public Administrative admin() {
        return this.admin;
    }

    public void close() throws RLSException {
        this._call(CLOSE, null, null, null, null, null, 1);
        this._release();
    }

    private Results _query(String method, List prefix, List input, RPCObjectSerializer serializer, RPCObjectDeserializer deserializer) throws RLSException {
        LinkedList<Object> results;
        int rc;
        if (input == null) {
            throw new NullPointerException("Input list is null");
        }
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Input list is empty");
        }
        if (input.get(0) == null) {
            throw new IllegalArgumentException("Input list contains null object");
        }
        if (!serializer.isValidInstance(input.get(0))) {
            throw new IllegalArgumentException("Input list contains object of type " + input.get(0).getClass().getName() + " which is not supported by this operation");
        }
        try {
            Iterator i;
            this._checkInputStream(this.in);
            this.out.writeString(method);
            if (prefix != null) {
                i = prefix.iterator();
                while (i.hasNext()) {
                    this.out.writeString(i.next().toString());
                }
            }
            i = input.iterator();
            while (i.hasNext()) {
                serializer.serialize(this.out, i.next());
            }
            this.out.writeTerminator();
            rc = this.in.readInt();
            if (rc != 0) {
                throw new RLSException(rc, this.in.readString());
            }
            results = new LinkedList<Object>();
            Object obj = deserializer.deserialize(this.in);
            while (obj != null) {
                results.add(obj);
                obj = deserializer.deserialize(this.in);
            }
        }
        catch (IOException e) {
            throw new RLSIOException(1, "I/O failure (cause: " + e.getLocalizedMessage() + ")", e);
        }
        catch (RPCDeserializationException e) {
            throw new RLSException(1, "Deserialization failure (cause: " + e.getLocalizedMessage() + ")", e);
        }
        return new QueryResults(rc, results);
    }

    private Results _query(String method, List prefix, List input, RLSOffsetLimit offsetLimit, RPCObjectSerializer serializer, RPCObjectDeserializer deserializer) throws RLSException {
        List results;
        if (input == null) {
            throw new NullPointerException("Input list is null");
        }
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Input list is empty");
        }
        if (input.get(0) == null) {
            throw new IllegalArgumentException("Input list contains null object");
        }
        if (!serializer.isValidInstance(input.get(0))) {
            throw new IllegalArgumentException("Input list contains object of type " + input.get(0).getClass().getName() + " which is not supported by this operation");
        }
        if (offsetLimit == null || offsetLimit.reslimit <= 0) {
            offsetLimit = new RLSOffsetLimit(0, 0);
            results = this._subquery(method, prefix, input, offsetLimit, serializer, deserializer);
        } else {
            results = new LinkedList();
            List subqresults = this._subquery(method, prefix, input, offsetLimit, serializer, deserializer);
            while (!subqresults.isEmpty()) {
                results.addAll(subqresults);
                subqresults = this._subquery(method, prefix, input, offsetLimit, serializer, deserializer);
            }
        }
        return new QueryResults(0, results);
    }

    private List _subquery(String method, List prefix, List input, RLSOffsetLimit offsetLimit, RPCObjectSerializer serializer, RPCObjectDeserializer deserializer) throws RLSException {
        LinkedList<Object> results;
        try {
            Iterator i;
            this._checkInputStream(this.in);
            this.out.writeString(method);
            if (prefix != null) {
                i = prefix.iterator();
                while (i.hasNext()) {
                    this.out.writeString(i.next().toString());
                }
            }
            i = input.iterator();
            while (i.hasNext()) {
                serializer.serialize(this.out, i.next());
            }
            this.out.writeInt(offsetLimit.offset);
            this.out.writeInt(offsetLimit.reslimit);
            int rc = this.in.readInt();
            if (rc != 0) {
                throw new RLSException(rc, this.in.readString());
            }
            results = new LinkedList<Object>();
            Object obj = deserializer.deserialize(this.in);
            while (obj != null) {
                if (!(obj instanceof ResultsContinuationMarker)) {
                    results.add(obj);
                    ++offsetLimit.offset;
                    obj = deserializer.deserialize(this.in);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RLSIOException(1, "I/O failure (cause: " + e.getLocalizedMessage() + ")", e);
        }
        catch (RPCDeserializationException e) {
            throw new RLSException(1, "Deserialization failure (cause: " + e.getLocalizedMessage() + ")", e);
        }
        return results;
    }

    private Results _call(String method, List prefix, List input, List suffix, RPCObjectSerializer serializer, RPCObjectDeserializer deserializer, int options) throws RLSException {
        int rc;
        if (serializer == null && input != null) {
            throw new IllegalArgumentException("Input must be null when serializer is null");
        }
        if (serializer != null) {
            if (input == null) {
                throw new NullPointerException("Input list is null");
            }
            if (input.isEmpty()) {
                throw new IllegalArgumentException("Input list is empty");
            }
            if (input.get(0) == null) {
                throw new IllegalArgumentException("Input list contains null object");
            }
            if (!serializer.isValidInstance(input.get(0))) {
                throw new IllegalArgumentException("Input list contains object of type " + input.get(0).getClass().getName() + " which is not supported by this operation");
            }
        }
        LinkedList<Object> results = null;
        try {
            Iterator i;
            this._checkInputStream(this.in);
            this.out.writeString(method);
            if (prefix != null) {
                i = prefix.iterator();
                while (i.hasNext()) {
                    this.out.writeString(i.next().toString());
                }
            }
            if (input != null) {
                i = input.iterator();
                while (i.hasNext()) {
                    serializer.serialize(this.out, i.next());
                }
            }
            if (suffix != null) {
                i = suffix.iterator();
                while (i.hasNext()) {
                    this.out.writeString(i.next().toString());
                }
            }
            rc = 0;
            if ((options & 1) == 0) {
                rc = this.in.readInt();
                if (rc != 0) {
                    throw new RLSException(rc, this.in.readString());
                }
                results = new LinkedList<Object>();
                if ((options & 4) > 0) {
                    results.add(deserializer.deserialize(this.in));
                } else if ((options & 8) > 0) {
                    Object obj = deserializer.deserialize(this.in);
                    while (obj != null) {
                        results.add(obj);
                        obj = deserializer.deserialize(this.in);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RLSIOException(1, "I/O failure (cause: " + e.getLocalizedMessage() + ")", e);
        }
        catch (RPCDeserializationException e) {
            throw new RLSException(1, "Deserialization failure (cause: " + e.getLocalizedMessage() + ")", e);
        }
        return new QueryResults(rc, results);
    }

    private Results _callBulk(String method, List prefix, List input, RPCObjectSerializer serializer, RPCObjectDeserializer deserializer) throws RLSException {
        LinkedList<Object> results;
        int rc;
        if (input == null) {
            throw new NullPointerException("Input list is null");
        }
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Input list is empty");
        }
        if (input.get(0) == null) {
            throw new IllegalArgumentException("Input list contains null object");
        }
        if (!serializer.isValidInstance(input.get(0))) {
            throw new IllegalArgumentException("Input list contains object of type " + input.get(0).getClass().getName() + " which is not supported by this operation");
        }
        try {
            Iterator i;
            this._checkInputStream(this.in);
            this.out.writeString(method);
            if (prefix != null) {
                i = prefix.iterator();
                while (i.hasNext()) {
                    this.out.writeString(i.next().toString());
                }
            }
            i = input.iterator();
            while (i.hasNext()) {
                serializer.serialize(this.out, i.next());
            }
            this.out.writeTerminator();
            rc = this.in.readInt();
            if (rc != 0) {
                throw new RLSException(rc, this.in.readString());
            }
            results = new LinkedList<Object>();
            Object obj = deserializer.deserialize(this.in);
            while (obj != null) {
                results.add(obj);
                obj = deserializer.deserialize(this.in);
            }
        }
        catch (IOException e) {
            throw new RLSIOException(1, "I/O failure (cause: " + e.getLocalizedMessage() + ")", e);
        }
        catch (RPCDeserializationException e) {
            throw new RLSException(1, "Deserialization failure (cause: " + e.getLocalizedMessage() + ")", e);
        }
        return new QueryResults(rc, results);
    }

    private void _checkInputStream(InputStream in) {
        try {
            while (in.available() > 0) {
                logger.warn((Object)("Unexpected bytes are waiting on input steam. Skipping " + in.available() + " bytes."));
                in.skip(in.available());
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Exception when checking for available bytes on the input stream: " + e.getLocalizedMessage()));
        }
    }

    class AdminImpl
    implements Administrative {
        private static final String SET_CONFIGURATION = "set_configuration";
        private static final String GET_CONFIGURATION = "get_configuration";
        private static final String STATS = "stats";
        private static final String RLI_SENDER_LIST = "rli_sender_list";
        private static final String RLI_RLI_LIST = "rli_rli_list";
        private static final String LRC_RLI_LIST = "lrc_rli_list";
        private static final String LRC_RLI_INFO = "lrc_rli_info";
        private static final String LRC_RLI_GET_PART = "lrc_rli_get_part";
        private static final String LRC_RLI_DELETE = "lrc_rli_delete";
        private static final String LRC_RLI_ADD = "lrc_rli_add";
        private static final String ADMIN = "admin";
        private static final int ADMIN_PING = 0;
        private static final int ADMIN_QUIT = 1;
        private static final int ADMIN_UPDATE = 2;

        AdminImpl() {
        }

        public void addUpdate(RLIUpdate update) throws RLSException {
            String rliurl = update.getUrl();
            if (rliurl == null || rliurl.length() == 0) {
                throw new IllegalArgumentException("RLI url is null or empty (rliurl: " + rliurl + ")");
            }
            int flags = update.getFlags();
            if (flags != 0 && flags != 1) {
                throw new IllegalArgumentException("Invalid argument (flags: " + flags + ")");
            }
            ArrayList<String> input = new ArrayList<String>(3);
            input.add(rliurl);
            input.add(Integer.toString(flags));
            input.add(update.getPattern());
            SimpleRLSConnection.this._call(LRC_RLI_ADD, null, input, null, SimpleRLSConnection.this.stringSerializer, null, 2);
        }

        public void deleteUpdate(RLIUpdate update) throws RLSException {
            String rliurl = update.getUrl();
            if (rliurl == null || rliurl.length() == 0) {
                throw new IllegalArgumentException("RLI url is null or empty (rliurl: " + rliurl + ")");
            }
            ArrayList<RLIUpdate> input = new ArrayList<RLIUpdate>(1);
            input.add(update);
            SimpleRLSConnection.this._call(LRC_RLI_DELETE, null, input, null, SimpleRLSConnection.this.rliUpdateSerializer, null, 2);
        }

        public RLSRLIInfo findUpdate(String rliurl) throws RLSException {
            ArrayList<String> input = new ArrayList<String>(1);
            input.add(rliurl);
            Results results = SimpleRLSConnection.this._call(LRC_RLI_INFO, null, input, null, SimpleRLSConnection.this.stringSerializer, SimpleRLSConnection.this.rliInfoDeserializer, 4);
            return (RLSRLIInfo)results.getBatch().get(0);
        }

        public List getConfiguration(String option) throws RLSException {
            if (option == null) {
                option = "";
            }
            ArrayList<String> input = new ArrayList<String>(1);
            input.add(option);
            Results results = SimpleRLSConnection.this._call(GET_CONFIGURATION, null, input, null, SimpleRLSConnection.this.stringSerializer, SimpleRLSConnection.this.configOptionDeserializer, 8);
            return results.getBatch();
        }

        public List listRliToRliUpdates() throws RLSException {
            Results results = SimpleRLSConnection.this._call(RLI_RLI_LIST, null, null, null, null, SimpleRLSConnection.this.rliInfoDeserializer, 8);
            return results.getBatch();
        }

        public List listUpdatePartitions(RLIUpdate update) throws RLSException {
            ArrayList<RLIUpdate> input = new ArrayList<RLIUpdate>(1);
            input.add(update);
            Results results = SimpleRLSConnection.this._call(LRC_RLI_GET_PART, null, input, null, SimpleRLSConnection.this.rliUpdateSerializer, SimpleRLSConnection.this.rliUpdateDeserializer, 8);
            return results.getBatch();
        }

        public List listUpdates() throws RLSException {
            Results results = SimpleRLSConnection.this._call(LRC_RLI_LIST, null, null, null, null, SimpleRLSConnection.this.rliInfoDeserializer, 8);
            return results.getBatch();
        }

        public void ping() throws RLSException {
            ArrayList<String> input = new ArrayList<String>(1);
            input.add(Integer.toString(0));
            SimpleRLSConnection.this._call(ADMIN, null, input, null, SimpleRLSConnection.this.stringSerializer, null, 2);
        }

        public void quit() throws RLSException {
            ArrayList<String> input = new ArrayList<String>(1);
            input.add(Integer.toString(1));
            SimpleRLSConnection.this._call(ADMIN, null, input, null, SimpleRLSConnection.this.stringSerializer, null, 2);
        }

        public void setConfiguration(String name, String value) throws RLSException {
            ArrayList<String> input = new ArrayList<String>(2);
            input.add(name);
            input.add(value);
            SimpleRLSConnection.this._call(SET_CONFIGURATION, null, input, null, SimpleRLSConnection.this.stringSerializer, null, 2);
        }

        public RLSStats stats() throws RLSException {
            Results results = SimpleRLSConnection.this._call(STATS, null, null, null, null, SimpleRLSConnection.this.statsDeserializer, 4);
            return (RLSStats)results.getBatch().get(0);
        }

        public void update() throws RLSException {
            ArrayList<String> input = new ArrayList<String>(1);
            input.add(Integer.toString(2));
            SimpleRLSConnection.this._call(ADMIN, null, input, null, SimpleRLSConnection.this.stringSerializer, null, 2);
        }

        public List updatedBy() throws RLSException {
            Results results = SimpleRLSConnection.this._call(RLI_SENDER_LIST, null, null, null, null, SimpleRLSConnection.this.senderInfoDeserializer, 8);
            return results.getBatch();
        }
    }

    class AttrDeserializer
    implements RPCObjectDeserializer {
        private int objtype;

        AttrDeserializer(int objtype) {
            this.objtype = objtype;
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            String name = in.readString();
            if (name == null) {
                return null;
            }
            int valtype = in.readInt();
            return new RLSAttribute(name, this.objtype, valtype);
        }
    }

    class AttrObjResultDeserializer
    implements RPCObjectDeserializer {
        AttrObjResultDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            Integer RC = in.readInteger();
            if (RC == null) {
                return null;
            }
            int rc = RC;
            if (rc != 0) {
                return new AttributeResult(rc, in.readString(), in.readString());
            }
            return null;
        }
    }

    class AttrSearchResultDeserializer
    extends AttrValDeserializer {
        private String name;
        private int objtype;

        AttrSearchResultDeserializer(String name, int objtype) {
            this.name = name;
            this.objtype = objtype;
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            String key = in.readString();
            if (key == null) {
                return null;
            }
            int valtype = in.readInt();
            RLSAttribute attr = this.deserializeAttribute(in, this.name, this.objtype, valtype);
            return new RLSAttributeObject(attr, key);
        }
    }

    abstract class AttrValDeserializer
    implements RPCObjectDeserializer {
        AttrValDeserializer() {
        }

        public RLSAttribute deserializeAttribute(RPCInputStream in, String name, int objtype, int valtype) throws IOException, RPCDeserializationException {
            RLSAttribute attr;
            switch (valtype) {
                case 3: {
                    attr = new RLSAttribute(name, objtype, in.readString());
                    break;
                }
                case 2: {
                    attr = new RLSAttribute(name, objtype, valtype, in.readInt());
                    break;
                }
                case 1: {
                    attr = new RLSAttribute(name, objtype, in.readDouble());
                    break;
                }
                case 0: {
                    attr = new RLSAttribute(name, objtype, in.readDate());
                    break;
                }
                default: {
                    throw new RPCDeserializationException("Invalid attribute value type: " + valtype);
                }
            }
            return attr;
        }
    }

    class AttrValGetResultDeserializer
    extends AttrValDeserializer {
        private int objtype;

        AttrValGetResultDeserializer(int objtype) {
            this.objtype = objtype;
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            Integer RC = in.readInteger();
            if (RC == null) {
                return null;
            }
            int rc = RC;
            if (rc != 0) {
                String key = in.readString();
                String name = in.readString();
                return new RLSAttributeObject(rc, new RLSAttribute(name, this.objtype, -1), key);
            }
            String key = in.readString();
            String name = in.readString();
            int valtype = in.readInt();
            RLSAttribute attr = this.deserializeAttribute(in, name, -1, valtype);
            return new RLSAttributeObject(rc, attr, key);
        }
    }

    class AttributeDefineSerializer
    implements RPCObjectSerializer {
        AttributeDefineSerializer() {
        }

        public void serialize(RPCOutputStream out, Object obj) throws IOException {
            RLSAttribute a = (RLSAttribute)obj;
            out.writeString(a.name);
            out.writeInt(a.GetObjType());
            out.writeInt(a.GetValType());
        }

        public boolean isValidInstance(Object obj) {
            return obj instanceof RLSAttribute;
        }
    }

    class AttributeObjectSerializer
    implements RPCObjectSerializer {
        AttributeObjectSerializer() {
        }

        public void serialize(RPCOutputStream out, Object obj) throws IOException {
            RLSAttributeObject ao = (RLSAttributeObject)obj;
            out.writeString(ao.key);
            out.writeInt(ao.attr.GetObjType());
            out.writeInt(ao.attr.GetValType());
            out.writeString(ao.attr.name);
            this.serializeAttributeValue(out, ao.attr);
        }

        protected void serializeAttributeValue(RPCOutputStream out, RLSAttribute attr) throws IOException {
            int valtype = attr.GetValType();
            if (valtype == 3) {
                out.writeString(attr.GetStrVal());
            } else if (valtype == 2) {
                out.writeInt(attr.GetIntVal());
            } else if (valtype == 1) {
                out.writeDouble(attr.GetDoubleVal());
            } else if (valtype == 0) {
                out.writeDate(attr.GetDateVal());
            } else {
                throw new IllegalArgumentException("Unknown attribute value type");
            }
        }

        public boolean isValidInstance(Object obj) {
            return obj instanceof RLSAttributeObject;
        }
    }

    class AttributeSearchSerializer
    extends AttributeObjectSerializer {
        AttributeSearchSerializer() {
        }

        public void serialize(RPCOutputStream out, Object obj) throws IOException {
            AttributeSearch as = (AttributeSearch)obj;
            out.writeString(as.getName());
            out.writeInt(as.getObjtype());
            out.writeInt(as.getOp());
            if (as.getOp1() != null) {
                this.serializeAttributeValue(out, as.getOp1());
            } else {
                out.writeString("");
            }
            if (as.getOp2() != null) {
                this.serializeAttributeValue(out, as.getOp2());
            } else {
                out.writeString("");
            }
        }

        public boolean isValidInstance(Object obj) {
            return obj instanceof AttributeSearch;
        }
    }

    class ConfigOptionDeserializer
    implements RPCObjectDeserializer {
        ConfigOptionDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            String name = in.readString();
            if (name == null) {
                return null;
            }
            String value = in.readString();
            if (value == null) {
                throw new RPCDeserializationException("value is null");
            }
            return new ConfigurationOption(name, value);
        }
    }

    class IndexMappingExistsDeserializer
    implements RPCObjectDeserializer {
        IndexMappingExistsDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            Integer RC = in.readInteger();
            if (RC == null) {
                return null;
            }
            int rc = RC;
            if (rc == 0) {
                return new IndexMappingResult(rc, in.readString(), null);
            }
            if (rc == 12) {
                return new IndexMappingResult(rc, in.readString(), null);
            }
            if (rc == 16) {
                return new IndexMappingResult(rc, null, in.readString());
            }
            throw new RPCDeserializationException("Unexpected result code value returned from stream (rc: " + rc + ")");
        }
    }

    class IndexMappingResultDeserializer
    implements RPCObjectDeserializer {
        IndexMappingResultDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            Integer RC = in.readInteger();
            if (RC == null) {
                return null;
            }
            int rc = RC;
            if (rc == 0) {
                return new IndexMappingResult(rc, in.readString(), in.readString());
            }
            if (rc == 12) {
                return new IndexMappingResult(rc, in.readString(), null);
            }
            if (rc == 16) {
                return new IndexMappingResult(rc, null, in.readString());
            }
            throw new RPCDeserializationException("Unexpected result code value returned from stream (rc: " + rc + ")");
        }
    }

    class IndexMappingSerializer
    implements RPCObjectSerializer {
        IndexMappingSerializer() {
        }

        public void serialize(RPCOutputStream out, Object obj) throws IOException {
            IndexMapping m = (IndexMapping)obj;
            out.writeString(m.getLogical());
            out.writeString(m.getCatalog());
        }

        public boolean isValidInstance(Object obj) {
            return obj instanceof IndexMapping;
        }
    }

    class LRCImpl
    implements LocalReplicaCatalog {
        private static final String LRC_ATTR_GET = "lrc_attr_get";
        private static final String LRC_RENAMEPFN_BULK = "lrc_renamepfn_bulk";
        private static final String LRC_RENAMELFN_BULK = "lrc_renamelfn_bulk";
        private static final String LRC_ADD_BULK = "lrc_add_bulk";
        private static final String LRC_CREATE_BULK = "lrc_create_bulk";
        private static final String LRC_DELETE_BULK = "lrc_delete_bulk";
        private static final String LRC_EXISTS_BULK = "lrc_exists_bulk";
        private static final String LRC_ATTR_SEARCH = "lrc_attr_search";
        private static final String LRC_GET_PFN_BULK = "lrc_get_pfn_bulk";
        private static final String LRC_GET_LFN_BULK = "lrc_get_lfn_bulk";
        private static final String LRC_ATTR_VALUE_GET_BULK = "lrc_attr_value_get_bulk";
        private static final String LRC_ATTR_REMOVE_BULK = "lrc_attr_remove_bulk";
        private static final String LRC_ATTR_ADD_BULK = "lrc_attr_add_bulk";
        private static final String LRC_ATTR_MODIFY = "lrc_attr_modify";
        private static final String LRC_ATTR_DELETE = "lrc_attr_delete";
        private static final String LRC_ATTR_CREATE = "lrc_attr_create";
        private static final String LRC_MAPPING_EXISTS = "lrc_mapping_exists";
        private static final String LRC_GET_PFN_WC = "lrc_get_pfn_wc";
        private static final String LRC_GET_LFN_WC = "lrc_get_lfn_wc";
        private static final String LRC_GET_PFN = "lrc_get_pfn";
        private static final String LRC_GET_LFN = "lrc_get_lfn";

        LRCImpl() {
        }

        public List createMappings(List mappings) throws RLSException {
            Results r = SimpleRLSConnection.this._callBulk(LRC_CREATE_BULK, null, mappings, SimpleRLSConnection.this.mappingSerializer, SimpleRLSConnection.this.mappingUpdateDeserializer);
            return r.getBatch();
        }

        public List deleteMappings(List mappings) throws RLSException {
            Results r = SimpleRLSConnection.this._callBulk(LRC_DELETE_BULK, null, mappings, SimpleRLSConnection.this.mappingSerializer, SimpleRLSConnection.this.mappingUpdateDeserializer);
            return r.getBatch();
        }

        public List addMappings(List mappings) throws RLSException {
            Results r = SimpleRLSConnection.this._callBulk(LRC_ADD_BULK, null, mappings, SimpleRLSConnection.this.mappingSerializer, SimpleRLSConnection.this.mappingUpdateDeserializer);
            return r.getBatch();
        }

        public List defineAttributes(List attributes) throws RLSException {
            LinkedList<AttributeResult> results = new LinkedList<AttributeResult>();
            ArrayList<RLSAttribute> input = new ArrayList<RLSAttribute>(1);
            Iterator itr = attributes.iterator();
            while (itr.hasNext()) {
                int rc;
                RLSAttribute attr = (RLSAttribute)itr.next();
                input.clear();
                input.add(attr);
                try {
                    Results subr = SimpleRLSConnection.this._call(LRC_ATTR_CREATE, null, input, null, SimpleRLSConnection.this.attrdefSerializer, null, 2);
                    rc = subr.getRC();
                }
                catch (RLSException ex) {
                    rc = ex.GetRC();
                }
                if (rc == 0) continue;
                results.add(new AttributeResult(rc, null, attr.name));
            }
            return results;
        }

        public List undefineAttributes(List attributes, boolean clearvalues) throws RLSException {
            LinkedList<AttributeResult> results = new LinkedList<AttributeResult>();
            ArrayList<Integer> suffix = new ArrayList<Integer>(1);
            suffix.add(clearvalues ? new Integer(1) : new Integer(0));
            ArrayList<RLSAttribute> input = new ArrayList<RLSAttribute>(1);
            Iterator itr = attributes.iterator();
            while (itr.hasNext()) {
                int rc;
                RLSAttribute attr = (RLSAttribute)itr.next();
                input.clear();
                input.add(attr);
                try {
                    Results subr = SimpleRLSConnection.this._call(LRC_ATTR_DELETE, null, input, suffix, SimpleRLSConnection.this.minAttrSerializer, null, 2);
                    rc = subr.getRC();
                }
                catch (RLSException ex) {
                    rc = ex.GetRC();
                }
                if (rc == 0) continue;
                results.add(new AttributeResult(rc, null, attr.name));
            }
            return results;
        }

        public List addAttributes(List attributes) throws RLSException {
            Results r = SimpleRLSConnection.this._callBulk(LRC_ATTR_ADD_BULK, null, attributes, SimpleRLSConnection.this.attrobjSerializer, SimpleRLSConnection.this.attrObjResultDeserializer);
            return r.getBatch();
        }

        public List modifyAttributes(List attributes) throws RLSException {
            LinkedList<AttributeResult> results = new LinkedList<AttributeResult>();
            ArrayList<RLSAttributeObject> input = new ArrayList<RLSAttributeObject>(1);
            Iterator itr = attributes.iterator();
            while (itr.hasNext()) {
                int rc;
                RLSAttributeObject ao = (RLSAttributeObject)itr.next();
                input.clear();
                input.add(ao);
                try {
                    Results subr = SimpleRLSConnection.this._call(LRC_ATTR_MODIFY, null, input, null, SimpleRLSConnection.this.modifyAttrobjSerializer, null, 2);
                    rc = subr.getRC();
                }
                catch (RLSException ex) {
                    rc = ex.GetRC();
                }
                if (rc == 0) continue;
                results.add(new AttributeResult(rc, null, ao.attr.name));
            }
            return results;
        }

        public List removeAttributes(List attributes) throws RLSException {
            Results r = SimpleRLSConnection.this._callBulk(LRC_ATTR_REMOVE_BULK, null, attributes, SimpleRLSConnection.this.removeAttrobjSerializer, SimpleRLSConnection.this.attrObjResultDeserializer);
            return r.getBatch();
        }

        public List renameLogicalNames(List renames) throws RLSException {
            Results r = SimpleRLSConnection.this._callBulk(LRC_RENAMELFN_BULK, null, renames, SimpleRLSConnection.this.renameSerializer, SimpleRLSConnection.this.renameResultDeserializer);
            return r.getBatch();
        }

        public List renameTargetNames(List renames) throws RLSException {
            Results r = SimpleRLSConnection.this._callBulk(LRC_RENAMEPFN_BULK, null, renames, SimpleRLSConnection.this.renameSerializer, SimpleRLSConnection.this.renameResultDeserializer);
            return r.getBatch();
        }

        public Results query(CatalogQuery query) throws RLSException {
            if (query instanceof CatalogExistenceQuery) {
                return this._existenceQuery((CatalogExistenceQuery)query);
            }
            if (query instanceof SimpleCatalogQuery) {
                return this._simpleQuery((SimpleCatalogQuery)query);
            }
            if (query instanceof AttributeSearch) {
                return this._attributeSearch((AttributeSearch)query);
            }
            if (query instanceof BatchCatalogQuery) {
                return this._batchQuery((BatchCatalogQuery)query);
            }
            throw new IllegalArgumentException("Unsupported query object (object: " + query.toString() + ")");
        }

        private Results _existenceQuery(CatalogExistenceQuery query) throws RLSException {
            if (CatalogExistenceQuery.objectExists.equals(query.getType())) {
                ArrayList<Integer> prefix = new ArrayList<Integer>(1);
                prefix.add(query.getObjectType());
                return SimpleRLSConnection.this._query(LRC_EXISTS_BULK, prefix, query.getBatch(), SimpleRLSConnection.this.stringSerializer, SimpleRLSConnection.this.mappingExistsDeserializer);
            }
            if (CatalogExistenceQuery.mappingExists.equals(query.getType())) {
                QueryResults results = new QueryResults(0, new LinkedList());
                ArrayList<Mapping> input = new ArrayList<Mapping>(1);
                Iterator itr = query.getBatch().iterator();
                while (itr.hasNext()) {
                    int rc;
                    Mapping map = (Mapping)itr.next();
                    input.clear();
                    input.add(map);
                    try {
                        Results subr = SimpleRLSConnection.this._call(LRC_MAPPING_EXISTS, null, input, null, SimpleRLSConnection.this.mappingSerializer, null, 2);
                        rc = subr.getRC();
                    }
                    catch (RLSException ex) {
                        rc = ex.GetRC();
                    }
                    results.getBatch().add(new MappingResult(rc, map));
                }
                return results;
            }
            throw new IllegalArgumentException("Unsupport existence query type (type: " + query.getObjectType() + ")");
        }

        private Results _simpleQuery(SimpleCatalogQuery query) throws RLSException {
            RPCObjectDeserializer deser;
            RPCObjectSerializer ser;
            String method;
            Integer type = query.getType();
            if (SimpleCatalogQuery.queryMappingsByLogicalNamePattern.equals(type)) {
                method = LRC_GET_PFN_WC;
            } else if (SimpleCatalogQuery.queryMappingsByTargetNamePattern.equals(type)) {
                method = LRC_GET_LFN_WC;
            } else if (SimpleCatalogQuery.queryMappingsByLogicalName.equals(type)) {
                method = LRC_GET_PFN;
            } else if (SimpleCatalogQuery.queryMappingsByTargetName.equals(type)) {
                method = LRC_GET_LFN;
            } else if (SimpleCatalogQuery.queryAttributeDefinitions.equals(type)) {
                method = LRC_ATTR_GET;
            } else {
                throw new IllegalArgumentException("Unsupported query type (type: " + type + ")");
            }
            if (query.getParam() instanceof RLSAttribute) {
                ser = SimpleRLSConnection.this.minAttrSerializer;
                deser = new AttrDeserializer(((RLSAttribute)query.getParam()).GetObjType());
            } else {
                ser = SimpleRLSConnection.this.stringSerializer;
                deser = SimpleRLSConnection.this.simpleMappingResultDeserializer;
            }
            ArrayList<Object> input = new ArrayList<Object>(1);
            input.add(query.getParam());
            return SimpleRLSConnection.this._query(method, null, input, query.getOffsetLimit(), ser, deser);
        }

        private Results _attributeSearch(AttributeSearch query) throws RLSException {
            ArrayList<AttributeSearch> input = new ArrayList<AttributeSearch>(1);
            input.add(query);
            AttrSearchResultDeserializer deser = new AttrSearchResultDeserializer(query.getName(), query.getObjtype());
            return SimpleRLSConnection.this._query(LRC_ATTR_SEARCH, null, input, query.getOffsetLimit(), SimpleRLSConnection.this.attributeSearchSerializer, deser);
        }

        private Results _batchQuery(BatchCatalogQuery query) throws RLSException {
            Integer queryType = query.getType();
            if (BatchCatalogQuery.attributeQuery.equals(queryType)) {
                ArrayList<String> prefix = new ArrayList<String>(2);
                prefix.add(query.getAttributeName());
                prefix.add(query.getAttributeObjectType().toString());
                List keys = query.getBatch();
                AttrValGetResultDeserializer deser = new AttrValGetResultDeserializer(query.getAttributeObjectType());
                return SimpleRLSConnection.this._callBulk(LRC_ATTR_VALUE_GET_BULK, prefix, keys, SimpleRLSConnection.this.stringSerializer, deser);
            }
            if (BatchCatalogQuery.mappingQueryByLogicalNames.equals(queryType)) {
                return SimpleRLSConnection.this._query(LRC_GET_PFN_BULK, null, query.getBatch(), SimpleRLSConnection.this.stringSerializer, SimpleRLSConnection.this.mappingResultDeserializer);
            }
            if (BatchCatalogQuery.mappingQueryByTargetNames.equals(queryType)) {
                return SimpleRLSConnection.this._query(LRC_GET_LFN_BULK, null, query.getBatch(), SimpleRLSConnection.this.stringSerializer, SimpleRLSConnection.this.mappingResultDeserializer);
            }
            throw new IllegalArgumentException("Unsupported query type (type: " + queryType + ")");
        }
    }

    class MappingExistsDeserializer
    implements RPCObjectDeserializer {
        MappingExistsDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            Integer RC = in.readInteger();
            if (RC == null) {
                return null;
            }
            int rc = RC;
            if (rc == 0) {
                return new MappingResult(rc, in.readString(), in.readString());
            }
            if (rc == 12) {
                return new MappingResult(rc, in.readString(), null);
            }
            if (rc == 14) {
                return new MappingResult(rc, null, in.readString());
            }
            throw new RPCDeserializationException("Unexpected result code value returned from stream (rc: " + rc + ")");
        }
    }

    class MappingResultDeserializer
    implements RPCObjectDeserializer {
        MappingResultDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            Integer RC = in.readInteger();
            if (RC == null) {
                return null;
            }
            int rc = RC;
            if (rc == 0) {
                return new MappingResult(rc, in.readString(), in.readString());
            }
            if (rc == 12) {
                return new MappingResult(rc, in.readString(), null);
            }
            if (rc == 14) {
                return new MappingResult(rc, null, in.readString());
            }
            throw new RPCDeserializationException("Unexpected result code value returned from stream (rc: " + rc + ")");
        }
    }

    class MappingSerializer
    implements RPCObjectSerializer {
        MappingSerializer() {
        }

        public void serialize(RPCOutputStream out, Object obj) throws IOException {
            Mapping m = (Mapping)obj;
            out.writeString(m.getLogical());
            out.writeString(m.getTarget());
        }

        public boolean isValidInstance(Object obj) {
            return obj instanceof Mapping;
        }
    }

    class MappingUpdateDeserializer
    implements RPCObjectDeserializer {
        MappingUpdateDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            Integer RC = in.readInteger();
            if (RC == null) {
                return null;
            }
            int rc = RC;
            return new MappingResult(rc, in.readString(), in.readString());
        }
    }

    class MinimalAttributeSerializer
    implements RPCObjectSerializer {
        MinimalAttributeSerializer() {
        }

        public void serialize(RPCOutputStream out, Object obj) throws IOException {
            RLSAttribute a = (RLSAttribute)obj;
            out.writeString(a.name);
            out.writeInt(a.GetObjType());
        }

        public boolean isValidInstance(Object obj) {
            return obj instanceof RLSAttribute;
        }
    }

    class ModifyAttributeObjectSerializer
    extends AttributeObjectSerializer {
        ModifyAttributeObjectSerializer() {
        }

        public void serialize(RPCOutputStream out, Object obj) throws IOException {
            RLSAttributeObject ao = (RLSAttributeObject)obj;
            out.writeString(ao.key);
            out.writeString(ao.attr.name);
            out.writeInt(ao.attr.GetObjType());
            out.writeInt(ao.attr.GetValType());
            this.serializeAttributeValue(out, ao.attr);
        }
    }

    class RLIImpl
    implements ReplicaLocationIndex {
        private static final String RLI_MAPPING_EXISTS = "rli_mapping_exists";
        private static final String RLI_EXISTS_BULK = "rli_exists_bulk";
        private static final String RLI_GET_LRC_BULK = "rli_get_lrc_bulk";
        private static final String RLI_GET_LRC_WC = "rli_get_lrc_wc";
        private static final String RLI_GET_LRC = "rli_get_lrc";

        RLIImpl() {
        }

        public Results query(IndexQuery query) throws RLSException {
            if (query instanceof SimpleIndexQuery) {
                return this._simpleIndexQuery((SimpleIndexQuery)query);
            }
            if (query instanceof BatchIndexQuery) {
                return this._batchIndexQuery((BatchIndexQuery)query);
            }
            if (query instanceof IndexExistenceQuery) {
                return this._existenceQuery((IndexExistenceQuery)query);
            }
            throw new IllegalArgumentException("Unsupported query object");
        }

        private Results _simpleIndexQuery(SimpleIndexQuery query) throws RLSException {
            String method;
            if (SimpleIndexQuery.queryMappingsByLogicalName.equals(query.getType())) {
                method = RLI_GET_LRC;
            } else if (SimpleIndexQuery.queryMappingsByLogicalNamePattern.equals(query.getType())) {
                method = RLI_GET_LRC_WC;
            } else {
                throw new IllegalArgumentException("Invalid query type");
            }
            ArrayList<Object> input = new ArrayList<Object>(1);
            input.add(query.getParam());
            return SimpleRLSConnection.this._query(method, null, input, query.getOffsetLimit(), SimpleRLSConnection.this.stringSerializer, SimpleRLSConnection.this.simpleIndexMappingResultDeserializer);
        }

        private Results _batchIndexQuery(BatchIndexQuery query) throws RLSException {
            if (!BatchIndexQuery.queryMappingsByLogicalNames.equals(query.getType())) {
                throw new IllegalArgumentException("Invalid query type");
            }
            String method = RLI_GET_LRC_BULK;
            return SimpleRLSConnection.this._query(method, null, query.getBatch(), SimpleRLSConnection.this.stringSerializer, SimpleRLSConnection.this.indexMappingResultDeserializer);
        }

        private Results _existenceQuery(IndexExistenceQuery query) throws RLSException {
            if (IndexExistenceQuery.objectExists.equals(query.getType())) {
                ArrayList<String> prefix = new ArrayList<String>(1);
                prefix.add(query.getObjectType().toString());
                return SimpleRLSConnection.this._query(RLI_EXISTS_BULK, prefix, query.getBatch(), SimpleRLSConnection.this.stringSerializer, SimpleRLSConnection.this.indexMappingExistsDeserializer);
            }
            if (IndexExistenceQuery.mappingExists.equals(query.getType())) {
                throw new RLSException(26, "This method is unsupported. If this method is critical to your usage of RLS, please notify the RLS developers at rls-dev@globus.org.");
            }
            throw new IllegalArgumentException("Unsupported query object");
        }
    }

    class RLIInfoDeserializer
    implements RPCObjectDeserializer {
        RLIInfoDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            String url = in.readString();
            if (url == null) {
                return null;
            }
            Integer updateinterval = in.readInteger();
            if (updateinterval == null) {
                throw new RPCDeserializationException("updateinterval is null");
            }
            Integer flags = in.readInteger();
            if (flags == null) {
                throw new RPCDeserializationException("flags is null");
            }
            Integer lastupdate = in.readInteger();
            if (lastupdate == null) {
                throw new RPCDeserializationException("lastupdate is null");
            }
            return new RLSRLIInfo(url, updateinterval, flags, lastupdate);
        }
    }

    class RLIUpdateDeserializer
    implements RPCObjectDeserializer {
        RLIUpdateDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            String url = in.readString();
            if (url == null) {
                return null;
            }
            String pattern = in.readString();
            return new RLIUpdate(url, pattern);
        }
    }

    class RLIUpdateSerializer
    implements RPCObjectSerializer {
        RLIUpdateSerializer() {
        }

        public void serialize(RPCOutputStream out, Object obj) throws IOException {
            RLIUpdate r = (RLIUpdate)obj;
            out.writeString(r.getUrl());
            out.writeString(r.getPattern());
        }

        public boolean isValidInstance(Object obj) {
            return obj instanceof RLIUpdate;
        }
    }

    class RemoveAttributeObjectSerializer
    extends AttributeObjectSerializer {
        RemoveAttributeObjectSerializer() {
        }

        public void serialize(RPCOutputStream out, Object obj) throws IOException {
            RLSAttributeObject ao = (RLSAttributeObject)obj;
            out.writeString(ao.key);
            out.writeInt(ao.attr.GetObjType());
            out.writeString(ao.attr.name);
        }
    }

    class RenameResultDeserializer
    implements RPCObjectDeserializer {
        RenameResultDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            Integer RC = in.readInteger();
            if (RC == null) {
                return null;
            }
            int rc = RC;
            return new RenameResult(rc, in.readString(), in.readString());
        }
    }

    class RenameSerializer
    implements RPCObjectSerializer {
        RenameSerializer() {
        }

        public void serialize(RPCOutputStream out, Object obj) throws IOException {
            Rename r = (Rename)obj;
            out.writeString(r.getFrom());
            out.writeString(r.getTo());
        }

        public boolean isValidInstance(Object obj) {
            return obj instanceof Rename;
        }
    }

    class ResultsContinuationMarker {
        ResultsContinuationMarker() {
        }
    }

    class SenderInfoDeserializer
    implements RPCObjectDeserializer {
        SenderInfoDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            String url = in.readString();
            if (url == null) {
                return null;
            }
            Integer lastupdate = in.readInteger();
            if (lastupdate == null) {
                throw new RPCDeserializationException("lastupdate is null");
            }
            return new RLSLRCInfo(url, lastupdate);
        }
    }

    class SimpleIndexMappingResultDeserializer
    implements RPCObjectDeserializer {
        SimpleIndexMappingResultDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            String logical = in.readString();
            if (logical == null) {
                return null;
            }
            byte[] b = logical.getBytes();
            if (b[0] == 1 && b.length == 1) {
                return new ResultsContinuationMarker();
            }
            String catalog = in.readString();
            if (catalog == null) {
                throw new RPCDeserializationException("Expected logical-catalog string pair but only found a single string");
            }
            return new IndexMappingResult(0, logical, catalog);
        }
    }

    class SimpleMappingResultDeserializer
    implements RPCObjectDeserializer {
        SimpleMappingResultDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            String logical = in.readString();
            if (logical == null) {
                return null;
            }
            byte[] b = logical.getBytes();
            if (b[0] == 1 && b.length == 1) {
                return new ResultsContinuationMarker();
            }
            String target = in.readString();
            if (target == null) {
                throw new RPCDeserializationException("Expected logical-target string pair but only found a single string");
            }
            return new MappingResult(0, logical, target);
        }
    }

    class StatsDeserializer
    implements RPCObjectDeserializer {
        StatsDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            String ver = in.readString();
            if (ver == null) {
                return null;
            }
            Integer uptime = in.readInteger();
            if (uptime == null) {
                throw new RPCDeserializationException("uptime is null");
            }
            Integer flags = in.readInteger();
            if (flags == null) {
                throw new RPCDeserializationException("flags is null");
            }
            Integer bloomfilterui = in.readInteger();
            if (bloomfilterui == null) {
                throw new RPCDeserializationException("bloomfilterui is null");
            }
            Integer lfnlistui = in.readInteger();
            if (lfnlistui == null) {
                throw new RPCDeserializationException("lfnlistui is null");
            }
            Integer numlfn = in.readInteger();
            if (numlfn == null) {
                throw new RPCDeserializationException("numlfn is null");
            }
            Integer numpfn = in.readInteger();
            if (numpfn == null) {
                throw new RPCDeserializationException("numpfn is null");
            }
            Integer nummap = in.readInteger();
            if (nummap == null) {
                throw new RPCDeserializationException("nummap is null");
            }
            Integer rli_numlfn = in.readInteger();
            if (rli_numlfn == null) {
                throw new RPCDeserializationException("rli_numlfn is null");
            }
            Integer rli_numlrc = in.readInteger();
            if (rli_numlrc == null) {
                throw new RPCDeserializationException("rli_numlrc is null");
            }
            Integer rli_numsender = in.readInteger();
            if (rli_numsender == null) {
                throw new RPCDeserializationException("rli_numsender is null");
            }
            Integer rli_nummap = in.readInteger();
            if (rli_nummap == null) {
                throw new RPCDeserializationException("rli_nummap is null");
            }
            return new RLSStats(ver, uptime, flags, bloomfilterui, lfnlistui, numlfn, numpfn, nummap, rli_numlfn, rli_numlrc, rli_numsender, rli_nummap);
        }
    }

    class StringResultDeserializer
    implements RPCObjectDeserializer {
        StringResultDeserializer() {
        }

        public Object deserialize(RPCInputStream in) throws IOException, RPCDeserializationException {
            return in.readString();
        }
    }

    class StringSerializer
    implements RPCObjectSerializer {
        StringSerializer() {
        }

        public void serialize(RPCOutputStream out, Object obj) throws IOException {
            out.writeString((String)obj);
        }

        public boolean isValidInstance(Object obj) {
            return obj == null || obj instanceof String;
        }
    }
}

