/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.DateTimeRangeMatch;
import com.pixelmed.database.DicomDatabaseInformationModel;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.network.ResponseStatus;
import com.pixelmed.query.QueryResponseGenerator;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

class DicomDatabaseQueryResponseGenerator
implements QueryResponseGenerator {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/DicomDatabaseQueryResponseGenerator.java,v 1.18 2007/01/17 23:14:17 dclunie Exp $";
    boolean usePhoneticCanonicalPersonNameMatch = true;
    boolean useCanonicalPersonNameMatch = true;
    boolean useSwappedPersonNameMatch = true;
    private static final boolean includeUnsupportedOptionalKeysInResponseWithZeroLength = false;
    private static final boolean includeModalitiesInStudyIfRequested = true;
    private static final boolean includeSOPClassesInStudyIfRequested = true;
    private static final boolean includeNumberOfStudyRelatedInstancesIfRequested = true;
    private static final boolean includeNumberOfStudyRelatedSeriesIfRequested = true;
    private static final boolean includeNumberOfSeriesRelatedInstancesIfRequested = true;
    private int status = ResponseStatus.Success;
    private AttributeTagAttribute offendingElement = null;
    private String errorComment = null;
    private int debugLevel;
    private DatabaseInformationModel databaseInformationModel;
    private DicomDictionary dictionary;
    private AttributeList requestIdentifier;
    private Statement databaseStatement;
    private ResultSet resultSet;
    private ResultSetMetaData resultSetMetaData;
    private String queryRetrieveLevel;
    private boolean unsupportedOptionalKeysPresent;
    private AttributeList additionalKeysToReturnAsZeroLength;
    private String studyTableName;
    private String seriesTableName;
    private String instanceTableName;
    private String studyPrimaryKeyColumnName;
    private String seriesPrimaryKeyColumnName;
    private String seriesParentReferenceColumnName;
    private String instanceParentReferenceColumnName;
    private String modalityColumnName;
    private String sopClassUIDColumnName;
    private String studyInstanceUIDColumnName;
    private String seriesInstanceUIDColumnName;

    protected void setErrorStatus(int n, AttributeTag attributeTag, String string) {
        this.status = n;
        if (this.offendingElement == null) {
            this.offendingElement = new AttributeTagAttribute(TagFromName.OffendingElement);
        }
        if (attributeTag != null) {
            try {
                this.offendingElement.addValue(attributeTag);
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
        }
        this.errorComment = string;
    }

    DicomDatabaseQueryResponseGenerator(DatabaseInformationModel databaseInformationModel, int n) {
        this.debugLevel = n;
        this.databaseInformationModel = databaseInformationModel;
        this.requestIdentifier = null;
        this.databaseStatement = null;
        this.resultSet = null;
        this.resultSetMetaData = null;
        this.queryRetrieveLevel = null;
        this.unsupportedOptionalKeysPresent = false;
        this.additionalKeysToReturnAsZeroLength = null;
        this.dictionary = databaseInformationModel.getDicomDictionary();
        this.studyTableName = DatabaseInformationModel.getTableNameForInformationEntity(InformationEntity.STUDY);
        this.seriesTableName = DatabaseInformationModel.getTableNameForInformationEntity(InformationEntity.SERIES);
        this.instanceTableName = DatabaseInformationModel.getTableNameForInformationEntity(InformationEntity.INSTANCE);
        this.studyPrimaryKeyColumnName = databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.STUDY);
        this.seriesPrimaryKeyColumnName = databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.SERIES);
        this.seriesParentReferenceColumnName = databaseInformationModel.getLocalParentReferenceColumnName(InformationEntity.SERIES);
        this.instanceParentReferenceColumnName = databaseInformationModel.getLocalParentReferenceColumnName(InformationEntity.INSTANCE);
        this.modalityColumnName = databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.Modality);
        this.sopClassUIDColumnName = databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.SOPClassUID);
        this.studyInstanceUIDColumnName = databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.StudyInstanceUID);
        this.seriesInstanceUIDColumnName = databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.SeriesInstanceUID);
    }

    private InformationEntity getRootInformationEntity(String string) {
        InformationEntity informationEntity = null;
        if (SOPClass.isStudyRootCompositeInstanceQuery(string)) {
            informationEntity = InformationEntity.STUDY;
        } else if (SOPClass.isPatientRootCompositeInstanceQuery(string)) {
            informationEntity = InformationEntity.PATIENT;
        }
        return informationEntity;
    }

    private InformationEntity getChildTypeForParent(String string, InformationEntity informationEntity) {
        InformationEntity informationEntity2 = null;
        if (SOPClass.isStudyRootCompositeInstanceQuery(string)) {
            if (informationEntity == InformationEntity.STUDY) {
                informationEntity2 = InformationEntity.SERIES;
            } else if (informationEntity == InformationEntity.SERIES) {
                informationEntity2 = InformationEntity.INSTANCE;
            } else if (informationEntity == InformationEntity.INSTANCE) {
                informationEntity2 = null;
            }
        } else if (SOPClass.isPatientRootCompositeInstanceQuery(string)) {
            if (informationEntity == InformationEntity.PATIENT) {
                informationEntity2 = InformationEntity.STUDY;
            } else if (informationEntity == InformationEntity.STUDY) {
                informationEntity2 = InformationEntity.SERIES;
            } else if (informationEntity == InformationEntity.SERIES) {
                informationEntity2 = InformationEntity.INSTANCE;
            } else if (informationEntity == InformationEntity.INSTANCE) {
                informationEntity2 = null;
            }
        }
        return informationEntity2;
    }

    private AttributeTag getUniqueKeyForQueryInformationModel(String string, InformationEntity informationEntity) {
        AttributeTag attributeTag = null;
        if (SOPClass.isStudyRootCompositeInstanceQuery(string)) {
            if (informationEntity == InformationEntity.STUDY) {
                attributeTag = TagFromName.StudyInstanceUID;
            } else if (informationEntity == InformationEntity.SERIES) {
                attributeTag = TagFromName.SeriesInstanceUID;
            } else if (informationEntity == InformationEntity.INSTANCE) {
                attributeTag = TagFromName.SOPInstanceUID;
            }
        } else if (SOPClass.isPatientRootCompositeInstanceQuery(string)) {
            if (informationEntity == InformationEntity.PATIENT) {
                attributeTag = TagFromName.PatientID;
            } else if (informationEntity == InformationEntity.STUDY) {
                attributeTag = TagFromName.StudyInstanceUID;
            } else if (informationEntity == InformationEntity.SERIES) {
                attributeTag = TagFromName.SeriesInstanceUID;
            } else if (informationEntity == InformationEntity.INSTANCE) {
                attributeTag = TagFromName.SOPInstanceUID;
            }
        }
        return attributeTag;
    }

    private boolean isWithinQueryLevelForModel(String string, InformationEntity informationEntity, InformationEntity informationEntity2) {
        boolean bl = false;
        if (SOPClass.isStudyRootCompositeInstanceQuery(string)) {
            if (informationEntity2 == InformationEntity.STUDY) {
                bl = informationEntity.compareTo(InformationEntity.STUDY) <= 0;
            } else if (informationEntity2 == InformationEntity.SERIES) {
                bl = informationEntity.compareTo(InformationEntity.STUDY) > 0 && informationEntity.compareTo(InformationEntity.SERIES) <= 0;
            } else if (informationEntity2 == InformationEntity.INSTANCE) {
                bl = informationEntity.compareTo(InformationEntity.SERIES) > 0 && informationEntity.compareTo(InformationEntity.INSTANCE) <= 0;
            }
        } else if (SOPClass.isPatientRootCompositeInstanceQuery(string)) {
            if (informationEntity2 == InformationEntity.PATIENT) {
                bl = informationEntity.compareTo(InformationEntity.PATIENT) <= 0;
            } else if (informationEntity2 == InformationEntity.STUDY) {
                bl = informationEntity.compareTo(InformationEntity.PATIENT) > 0 && informationEntity.compareTo(InformationEntity.STUDY) <= 0;
            } else if (informationEntity2 == InformationEntity.SERIES) {
                bl = informationEntity.compareTo(InformationEntity.STUDY) > 0 && informationEntity.compareTo(InformationEntity.SERIES) <= 0;
            } else if (informationEntity2 == InformationEntity.INSTANCE) {
                bl = informationEntity.compareTo(InformationEntity.SERIES) > 0 && informationEntity.compareTo(InformationEntity.INSTANCE) <= 0;
            }
        }
        return bl;
    }

    private InformationEntity getInformationEntityForQueryRetieveLevel(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("PATIENT")) {
            return InformationEntity.PATIENT;
        }
        if (string.equals("STUDY")) {
            return InformationEntity.STUDY;
        }
        if (string.equals("SERIES")) {
            return InformationEntity.SERIES;
        }
        if (string.equals("IMAGE")) {
            return InformationEntity.INSTANCE;
        }
        return null;
    }

    private static void addToJoinClause(StringBuffer stringBuffer, String string, String string2, String string3, String string4) {
        if (stringBuffer.length() != 0) {
            stringBuffer.append(" AND ");
        }
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string4);
        stringBuffer.append(" = ");
        stringBuffer.append(string2);
        stringBuffer.append(".");
        stringBuffer.append(string3);
    }

    private static void addToMatchClause(StringBuffer stringBuffer, String string, String string2, String string3, String string4) {
        if (stringBuffer.length() != 0) {
            stringBuffer.append(" ");
            stringBuffer.append(string4);
            stringBuffer.append(" ");
        }
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        if (string3.indexOf(42) == -1 && string3.indexOf(63) == -1) {
            stringBuffer.append(" = ");
            stringBuffer.append(string3);
        } else {
            stringBuffer.append(" LIKE ");
            String string5 = string3.replace('*', '%').replace('?', '_');
            stringBuffer.append(string5);
        }
    }

    private static void addToMatchClause(StringBuffer stringBuffer, String string, String string2, String string3) {
        DicomDatabaseQueryResponseGenerator.addToMatchClause(stringBuffer, string, string2, string3, "AND");
    }

    private static void addToSelectClause(StringBuffer stringBuffer, String string, String string2) {
        if (stringBuffer.length() != 0) {
            stringBuffer.append(",");
        }
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
    }

    private static void addToFromClause(StringBuffer stringBuffer, String string) {
        if (stringBuffer.length() == 0) {
            stringBuffer.append(string);
        } else if (stringBuffer.indexOf(string) == -1) {
            stringBuffer.append(",");
            stringBuffer.append(string);
        }
    }

    public void performQuery(String string, AttributeList attributeList, boolean bl) {
        if (this.debugLevel > 0) {
            System.err.println("DicomDatabaseQueryResponseGenerator.performQuery(): request:\n" + attributeList.toString());
        }
        this.requestIdentifier = attributeList;
        this.databaseStatement = null;
        this.resultSet = null;
        this.resultSetMetaData = null;
        this.queryRetrieveLevel = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.QueryRetrieveLevel);
        this.additionalKeysToReturnAsZeroLength = null;
        this.unsupportedOptionalKeysPresent = false;
        InformationEntity informationEntity = this.getInformationEntityForQueryRetieveLevel(this.queryRetrieveLevel);
        InformationEntity informationEntity2 = this.databaseInformationModel.getRootInformationEntity();
        InformationEntity informationEntity3 = this.getRootInformationEntity(string);
        InformationEntity informationEntity4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        if (informationEntity == null) {
            this.setErrorStatus(ResponseStatus.IdentifierDoesNotMatchSOPClass, TagFromName.QueryRetrieveLevel, "QueryRetrieveLevel is missing or invalid");
        } else if (informationEntity3 == null) {
            this.setErrorStatus(ResponseStatus.UnableToProcess, null, "Unrecognized or unsupported query model for SOP Class");
        } else {
            Comparable<StringBuffer> comparable;
            while (informationEntity3 != null && informationEntity3.compareTo(informationEntity) <= 0) {
                comparable = this.getUniqueKeyForQueryInformationModel(string, informationEntity3);
                while (informationEntity2 != null && informationEntity2.compareTo(informationEntity3) <= 0) {
                    Object object;
                    String string2 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity2);
                    if (informationEntity4 != null) {
                        object = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity4);
                        DicomDatabaseQueryResponseGenerator.addToJoinClause(stringBuffer, string2, (String)object, this.databaseInformationModel.getLocalPrimaryKeyColumnName(informationEntity2), this.databaseInformationModel.getLocalParentReferenceColumnName(informationEntity2));
                        DicomDatabaseQueryResponseGenerator.addToFromClause(stringBuffer4, (String)object);
                        DicomDatabaseQueryResponseGenerator.addToFromClause(stringBuffer4, string2);
                    }
                    object = new HashSet();
                    for (Attribute attribute : attributeList.values()) {
                        AttributeTag attributeTag = attribute.getTag();
                        InformationEntity informationEntity5 = this.databaseInformationModel.getInformationEntityFromTag(attributeTag);
                        String string3 = this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(attributeTag);
                        String string4 = null;
                        try {
                            string4 = DicomDatabaseInformationModel.getQuotedEscapedSingleStringValueOrNull(attribute);
                        }
                        catch (DicomException dicomException) {
                            this.setErrorStatus(ResponseStatus.UnableToProcess, attributeTag, "Unable to convert into value for SQL query");
                            return;
                        }
                        if (string3 == null || !this.databaseInformationModel.isAttributeUsedInTable(string2, string3)) continue;
                        if (this.isWithinQueryLevelForModel(string, informationEntity5, informationEntity) || bl) {
                            if (string4 != null && string4.length() > 0 && !string4.equals("NULL")) {
                                boolean bl2 = false;
                                byte[] byArray = attribute.getVR();
                                if (byArray != null) {
                                    if (ValueRepresentation.isDateVR(byArray) || ValueRepresentation.isTimeVR(byArray) || ValueRepresentation.isDateTimeVR(byArray)) {
                                        if (DateTimeRangeMatch.addToMatchClause(stringBuffer2, string2, string3, attributeTag, attributeList, (Set)object)) {
                                            bl2 = true;
                                        }
                                    } else if (ValueRepresentation.isPersonNameVR(byArray)) {
                                        String string5;
                                        String string6;
                                        StringBuffer stringBuffer5 = new StringBuffer();
                                        String string7 = null;
                                        if (this.usePhoneticCanonicalPersonNameMatch || this.useCanonicalPersonNameMatch) {
                                            string7 = PersonNameAttribute.getCanonicalForm(string4, true);
                                        }
                                        if (this.usePhoneticCanonicalPersonNameMatch && string7 != null && string7.length() > 0 && this.databaseInformationModel.isAttributeUsedInTable(string2, string6 = "PM_" + string3 + "_PHONETICCANONICAL")) {
                                            String string8;
                                            string5 = PersonNameAttribute.getPhoneticName(string7, true);
                                            DicomDatabaseQueryResponseGenerator.addToMatchClause(stringBuffer5, string2, string6, DicomDatabaseInformationModel.getQuotedValueOrNULL(string5), "OR");
                                            if (this.useSwappedPersonNameMatch && !string5.equals(string8 = PersonNameAttribute.swap(string5))) {
                                                DicomDatabaseQueryResponseGenerator.addToMatchClause(stringBuffer5, string2, string6, DicomDatabaseInformationModel.getQuotedValueOrNULL(string8), "OR");
                                            }
                                        }
                                        if (this.useCanonicalPersonNameMatch && string7 != null && string7.length() > 0 && this.databaseInformationModel.isAttributeUsedInTable(string2, string6 = "PM_" + string3 + "_CANONICAL")) {
                                            DicomDatabaseQueryResponseGenerator.addToMatchClause(stringBuffer5, string2, string6, DicomDatabaseInformationModel.getQuotedValueOrNULL(string7), "OR");
                                            if (this.useSwappedPersonNameMatch && !string7.equals(string5 = PersonNameAttribute.swap(string7))) {
                                                DicomDatabaseQueryResponseGenerator.addToMatchClause(stringBuffer5, string2, string6, DicomDatabaseInformationModel.getQuotedValueOrNULL(string5), "OR");
                                            }
                                        }
                                        DicomDatabaseQueryResponseGenerator.addToMatchClause(stringBuffer5, string2, string3, string4, "OR");
                                        if (stringBuffer5.length() > 0) {
                                            if (stringBuffer2.length() > 0) {
                                                stringBuffer2.append(" AND ");
                                            }
                                            stringBuffer2.append("(");
                                            stringBuffer2.append(stringBuffer5);
                                            stringBuffer2.append(")");
                                            bl2 = true;
                                        }
                                    }
                                }
                                if (!bl2 && !attributeTag.equals(TagFromName.SpecificCharacterSet)) {
                                    DicomDatabaseQueryResponseGenerator.addToMatchClause(stringBuffer2, string2, string3, string4);
                                }
                            }
                        } else if (attributeTag.equals(comparable)) {
                            if (string4 != null && string4.length() > 0 && !string4.equals("NULL")) {
                                DicomDatabaseQueryResponseGenerator.addToMatchClause(stringBuffer2, string2, string3, string4);
                            } else {
                                this.setErrorStatus(ResponseStatus.IdentifierDoesNotMatchSOPClass, attributeTag, "Unique key required above query level");
                                return;
                            }
                        }
                        if (!attributeTag.equals(TagFromName.SpecificCharacterSet)) {
                            DicomDatabaseQueryResponseGenerator.addToSelectClause(stringBuffer3, string2, string3);
                        }
                        DicomDatabaseQueryResponseGenerator.addToFromClause(stringBuffer4, string2);
                    }
                    informationEntity4 = informationEntity2;
                    informationEntity2 = this.databaseInformationModel.getChildTypeForParent(informationEntity2, false);
                }
                informationEntity3 = this.getChildTypeForParent(string, informationEntity3);
            }
            comparable = new StringBuffer();
            ((StringBuffer)comparable).append("SELECT ");
            ((StringBuffer)comparable).append(stringBuffer3);
            ((StringBuffer)comparable).append(" FROM ");
            ((StringBuffer)comparable).append(stringBuffer4);
            if (stringBuffer.length() > 0 && stringBuffer2.length() > 0) {
                ((StringBuffer)comparable).append(" WHERE ");
                ((StringBuffer)comparable).append(stringBuffer);
                ((StringBuffer)comparable).append(" AND ");
                ((StringBuffer)comparable).append(stringBuffer2);
            } else if (stringBuffer.length() > 0) {
                ((StringBuffer)comparable).append(" WHERE ");
                ((StringBuffer)comparable).append(stringBuffer);
            } else if (stringBuffer2.length() > 0) {
                ((StringBuffer)comparable).append(" WHERE ");
                ((StringBuffer)comparable).append(stringBuffer2);
            }
            ((StringBuffer)comparable).append(";");
            if (this.debugLevel > 0) {
                System.err.println("DicomDatabaseQueryResponseGenerator.performQuery(): query " + comparable);
            }
            try {
                this.databaseStatement = this.databaseInformationModel.createStatement();
                this.resultSet = this.databaseStatement.executeQuery(((StringBuffer)comparable).toString());
                this.resultSetMetaData = this.resultSet.getMetaData();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace(System.err);
                this.setErrorStatus(ResponseStatus.UnableToProcess, null, sQLException.getMessage());
            }
        }
    }

    private AttributeList makeDicomAttributeListFromResultSetRow(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws SQLException, DicomException {
        Attribute attribute;
        Object object;
        int n = resultSetMetaData.getColumnCount();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= n; ++i) {
            object = resultSet.getString(i);
            if (object == null || ((String)object).length() <= 0) continue;
            stringBuffer.append((String)object);
        }
        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet(SpecificCharacterSet.getSetOfUnicodeBlocksUsedBy(stringBuffer.toString()));
        object = new AttributeList();
        String string = specificCharacterSet.getValueToUseInSpecificCharacterSetAttribute();
        if (string != null && string.length() > 0) {
            attribute = new CodeStringAttribute(TagFromName.SpecificCharacterSet);
            ((Attribute)attribute).addValue(string);
            ((AttributeList)object).put(attribute);
        }
        for (int i = 1; i <= n; ++i) {
            attribute = this.makeDicomAttributeFromResultSetColumn(resultSet, resultSetMetaData, i, specificCharacterSet);
            if (attribute == null) continue;
            ((AttributeList)object).put(attribute);
        }
        return object;
    }

    private Attribute makeDicomAttributeFromResultSetColumn(ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n, SpecificCharacterSet specificCharacterSet) throws SQLException, DicomException {
        String string = resultSetMetaData.getColumnName(n);
        AttributeTag attributeTag = this.databaseInformationModel.getAttributeTagFromDatabaseColumnName(string);
        Attribute attribute = null;
        if (attributeTag != null) {
            byte[] byArray = this.dictionary.getValueRepresentationFromTag(attributeTag);
            attribute = AttributeFactory.newAttribute(attributeTag, byArray, specificCharacterSet, true, 2);
            String string2 = resultSet.getString(n);
            if (string2 != null && string2.length() > 0) {
                attribute.addValue(string2);
            }
        }
        return attribute;
    }

    private String makeForAllInstancesInSeriesStatement(AttributeTag attributeTag, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append(this.instanceTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(attributeTag));
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.seriesTableName);
        stringBuffer.append(",");
        stringBuffer.append(this.instanceTableName);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(this.instanceTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.instanceParentReferenceColumnName);
        stringBuffer.append(" = ");
        stringBuffer.append(this.seriesTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.seriesPrimaryKeyColumnName);
        stringBuffer.append(" AND ");
        stringBuffer.append(this.seriesTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.seriesInstanceUIDColumnName);
        stringBuffer.append(" = ");
        stringBuffer.append(string);
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private String makeForAllSeriesInStudyStatement(AttributeTag attributeTag, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append(this.seriesTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(attributeTag));
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.studyTableName);
        stringBuffer.append(",");
        stringBuffer.append(this.seriesTableName);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(this.seriesTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.seriesParentReferenceColumnName);
        stringBuffer.append(" = ");
        stringBuffer.append(this.studyTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.studyPrimaryKeyColumnName);
        stringBuffer.append(" AND ");
        stringBuffer.append(this.studyTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.studyInstanceUIDColumnName);
        stringBuffer.append(" = ");
        stringBuffer.append(string);
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private String makeForAllInstancesInStudyStatement(AttributeTag attributeTag, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append(this.instanceTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(attributeTag));
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.studyTableName);
        stringBuffer.append(",");
        stringBuffer.append(this.seriesTableName);
        stringBuffer.append(",");
        stringBuffer.append(this.instanceTableName);
        stringBuffer.append(" WHERE ");
        stringBuffer.append(this.seriesTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.seriesParentReferenceColumnName);
        stringBuffer.append(" = ");
        stringBuffer.append(this.studyTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.studyPrimaryKeyColumnName);
        stringBuffer.append(" AND ");
        stringBuffer.append(this.instanceTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.instanceParentReferenceColumnName);
        stringBuffer.append(" = ");
        stringBuffer.append(this.seriesTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.seriesPrimaryKeyColumnName);
        stringBuffer.append(" AND ");
        stringBuffer.append(this.studyTableName);
        stringBuffer.append(".");
        stringBuffer.append(this.studyInstanceUIDColumnName);
        stringBuffer.append(" = ");
        stringBuffer.append(string);
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private Set findStringValuesInSet(String[] stringArray, Set set) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (stringArray != null && set != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!set.contains(string)) continue;
                treeSet.add(string);
            }
        }
        return treeSet;
    }

    public AttributeList next() {
        AttributeList attributeList = null;
        try {
            while (attributeList == null && this.resultSet != null && this.resultSet.next()) {
                Object object;
                Object object2;
                TreeSet<Object> treeSet;
                ResultSet resultSet;
                Statement statement;
                Object object3;
                Object object4;
                Object object522;
                attributeList = this.makeDicomAttributeListFromResultSetRow(this.resultSet, this.resultSetMetaData);
                Attribute attribute = AttributeFactory.newAttribute(TagFromName.QueryRetrieveLevel, ValueRepresentation.CS, true, 2);
                attribute.addValue(this.queryRetrieveLevel);
                attributeList.put(attribute);
                if (this.additionalKeysToReturnAsZeroLength == null) {
                    this.additionalKeysToReturnAsZeroLength = new AttributeList();
                    for (Object object522 : this.requestIdentifier.values()) {
                        object4 = ((Attribute)object522).getTag();
                        if (attributeList.get((AttributeTag)object4) != null || ((AttributeTag)object4).equals(TagFromName.SpecificCharacterSet) || ((AttributeTag)object4).getElement() == 0 || ((AttributeTag)object4).equals(TagFromName.LengthToEnd)) continue;
                        this.unsupportedOptionalKeysPresent = true;
                    }
                }
                if (this.requestIdentifier.get(TagFromName.ModalitiesInStudy) != null && attributeList.get(TagFromName.ModalitiesInStudy) == null && this.queryRetrieveLevel.equals("STUDY")) {
                    try {
                        object3 = attributeList.get(TagFromName.StudyInstanceUID);
                        object522 = null;
                        try {
                            object522 = DicomDatabaseInformationModel.getQuotedEscapedSingleStringValueOrNull((Attribute)object3);
                        }
                        catch (DicomException dicomException) {
                            // empty catch block
                        }
                        object4 = this.makeForAllSeriesInStudyStatement(TagFromName.Modality, (String)object522);
                        if (this.debugLevel > 0) {
                            System.err.println("DicomDatabaseQueryResponseGenerator.next(): ModalitiesInStudy query " + (String)object4);
                        }
                        statement = this.databaseInformationModel.createStatement();
                        resultSet = this.databaseStatement.executeQuery((String)object4);
                        treeSet = new TreeSet<Object>();
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                object2 = resultSet.getString(this.modalityColumnName);
                                if (object2 == null || ((String)object2).length() <= 0) continue;
                                treeSet.add(object2);
                            }
                        }
                        statement.close();
                        object2 = Attribute.getStringValues(this.requestIdentifier, TagFromName.ModalitiesInStudy);
                        if (object2 != null && ((String[])object2).length > 0 && ((object = this.findStringValuesInSet((String[])object2, treeSet)) == null || object.size() == 0)) {
                            attributeList = null;
                            continue;
                        }
                        if (treeSet.size() > 0) {
                            object = new CodeStringAttribute(TagFromName.ModalitiesInStudy);
                            for (String string : treeSet) {
                                ((Attribute)object).addValue(string);
                            }
                            attributeList.put((Attribute)object);
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace(System.err);
                    }
                }
                assert (attributeList != null);
                if (this.requestIdentifier.get(TagFromName.SOPClassesInStudy) != null && attributeList.get(TagFromName.SOPClassesInStudy) == null && this.queryRetrieveLevel.equals("STUDY")) {
                    try {
                        object3 = attributeList.get(TagFromName.StudyInstanceUID);
                        object522 = null;
                        try {
                            object522 = DicomDatabaseInformationModel.getQuotedEscapedSingleStringValueOrNull((Attribute)object3);
                        }
                        catch (DicomException dicomException) {
                            // empty catch block
                        }
                        object4 = this.makeForAllInstancesInStudyStatement(TagFromName.SOPClassUID, (String)object522);
                        if (this.debugLevel > 0) {
                            System.err.println("DicomDatabaseQueryResponseGenerator.next(): SOPClassesInStudy query " + (String)object4);
                        }
                        statement = this.databaseInformationModel.createStatement();
                        resultSet = this.databaseStatement.executeQuery((String)object4);
                        treeSet = new TreeSet();
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                object2 = resultSet.getString(this.sopClassUIDColumnName);
                                if (object2 == null || ((String)object2).length() <= 0) continue;
                                treeSet.add(object2);
                            }
                        }
                        statement.close();
                        object2 = Attribute.getStringValues(this.requestIdentifier, TagFromName.SOPClassesInStudy);
                        if (object2 != null && ((Object)object2).length > 0 && ((object = this.findStringValuesInSet((String[])object2, treeSet)) == null || object.size() == 0)) {
                            attributeList = null;
                            continue;
                        }
                        if (treeSet.size() > 0) {
                            object = new UniqueIdentifierAttribute(TagFromName.SOPClassesInStudy);
                            for (String string : treeSet) {
                                ((Attribute)object).addValue(string);
                            }
                            attributeList.put((Attribute)object);
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace(System.err);
                    }
                }
                if (this.requestIdentifier.get(TagFromName.NumberOfStudyRelatedInstances) != null && attributeList.get(TagFromName.NumberOfStudyRelatedInstances) == null && this.queryRetrieveLevel.equals("STUDY")) {
                    try {
                        object3 = attributeList.get(TagFromName.StudyInstanceUID);
                        object522 = null;
                        try {
                            object522 = DicomDatabaseInformationModel.getQuotedEscapedSingleStringValueOrNull((Attribute)object3);
                        }
                        catch (DicomException dicomException) {
                            // empty catch block
                        }
                        object4 = this.makeForAllInstancesInStudyStatement(TagFromName.SOPInstanceUID, (String)object522);
                        if (this.debugLevel > 0) {
                            System.err.println("DicomDatabaseQueryResponseGenerator.next(): NumberOfStudyRelatedInstances query " + (String)object4);
                        }
                        statement = this.databaseInformationModel.createStatement();
                        resultSet = this.databaseStatement.executeQuery((String)object4);
                        if (resultSet != null) {
                            int n = 0;
                            while (resultSet.next()) {
                                ++n;
                            }
                            object2 = new IntegerStringAttribute(TagFromName.NumberOfStudyRelatedInstances);
                            ((Attribute)object2).addValue(n);
                            attributeList.put((Attribute)object2);
                        }
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace(System.err);
                    }
                }
                if (this.requestIdentifier.get(TagFromName.NumberOfStudyRelatedSeries) != null && attributeList.get(TagFromName.NumberOfStudyRelatedSeries) == null && this.queryRetrieveLevel.equals("STUDY")) {
                    try {
                        object3 = attributeList.get(TagFromName.StudyInstanceUID);
                        object522 = null;
                        try {
                            object522 = DicomDatabaseInformationModel.getQuotedEscapedSingleStringValueOrNull((Attribute)object3);
                        }
                        catch (DicomException dicomException) {
                            // empty catch block
                        }
                        object4 = this.makeForAllSeriesInStudyStatement(TagFromName.SeriesInstanceUID, (String)object522);
                        if (this.debugLevel > 0) {
                            System.err.println("DicomDatabaseQueryResponseGenerator.next(): NumberOfStudyRelatedSeries query " + (String)object4);
                        }
                        statement = this.databaseInformationModel.createStatement();
                        resultSet = this.databaseStatement.executeQuery((String)object4);
                        if (resultSet != null) {
                            int n = 0;
                            while (resultSet.next()) {
                                ++n;
                            }
                            object2 = new IntegerStringAttribute(TagFromName.NumberOfStudyRelatedSeries);
                            ((Attribute)object2).addValue(n);
                            attributeList.put((Attribute)object2);
                        }
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace(System.err);
                    }
                }
                if (this.requestIdentifier.get(TagFromName.NumberOfSeriesRelatedInstances) != null && attributeList.get(TagFromName.NumberOfSeriesRelatedInstances) == null && this.queryRetrieveLevel.equals("SERIES")) {
                    try {
                        object3 = attributeList.get(TagFromName.SeriesInstanceUID);
                        object522 = null;
                        try {
                            object522 = DicomDatabaseInformationModel.getQuotedEscapedSingleStringValueOrNull((Attribute)object3);
                        }
                        catch (DicomException dicomException) {
                            // empty catch block
                        }
                        object4 = this.makeForAllInstancesInSeriesStatement(TagFromName.SOPInstanceUID, (String)object522);
                        if (this.debugLevel > 0) {
                            System.err.println("DicomDatabaseQueryResponseGenerator.next(): NumberOfSeriesRelatedInstances query " + (String)object4);
                        }
                        statement = this.databaseInformationModel.createStatement();
                        resultSet = this.databaseStatement.executeQuery((String)object4);
                        if (resultSet != null) {
                            int n = 0;
                            while (resultSet.next()) {
                                ++n;
                            }
                            object2 = new IntegerStringAttribute(TagFromName.NumberOfSeriesRelatedInstances);
                            ((Attribute)object2).addValue(n);
                            attributeList.put((Attribute)object2);
                        }
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace(System.err);
                    }
                }
                if (this.debugLevel <= 0) continue;
                System.err.println("DicomDatabaseQueryResponseGenerator.next(): response:\n" + attributeList.toString());
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        return attributeList;
    }

    public int getStatus() {
        return this.status;
    }

    public AttributeTagAttribute getOffendingElement() {
        return this.offendingElement;
    }

    public String getErrorComment() {
        return this.errorComment;
    }

    public void close() {
        this.resultSet = null;
        this.resultSetMetaData = null;
        if (this.databaseStatement != null) {
            try {
                this.databaseStatement.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace(System.err);
            }
            this.databaseStatement = null;
        }
    }

    public boolean allOptionalKeysSuppliedWereSupported() {
        return !this.unsupportedOptionalKeysPresent;
    }
}

