/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BinaryInputStream
extends FilterInputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/BinaryInputStream.java,v 1.16 2006/04/08 22:24:33 dclunie Exp $";
    boolean bigEndian;
    byte[] buffer;
    File file;

    void localInit(boolean bl) {
        this.bigEndian = bl;
        this.buffer = new byte[8];
    }

    public BinaryInputStream(File file, boolean bl) throws FileNotFoundException {
        super(new BufferedInputStream(new FileInputStream(file)));
        this.file = file;
        this.localInit(bl);
    }

    public BinaryInputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.file = null;
        this.localInit(bl);
    }

    public File getFile() {
        return this.file;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean isLittleEndian() {
        return !this.bigEndian;
    }

    public void setBigEndian() {
        this.bigEndian = true;
    }

    public void setLittleEndian() {
        this.bigEndian = false;
    }

    public void setEndian(boolean bl) {
        this.bigEndian = bl;
    }

    final int extractUnsigned8() {
        return this.buffer[0] & 0xFF;
    }

    final int extractUnsigned16() {
        int n = this.buffer[0] & 0xFF;
        int n2 = this.buffer[1] & 0xFF;
        return this.bigEndian ? n << 8 | n2 : n2 << 8 | n;
    }

    final short extractSigned16() {
        short s = (short)(this.buffer[0] & 0xFF);
        short s2 = (short)(this.buffer[1] & 0xFF);
        return (short)(this.bigEndian ? s << 8 | s2 : s2 << 8 | s);
    }

    final long extractUnsigned32() {
        long l = (long)this.buffer[0] & 0xFFL;
        long l2 = (long)this.buffer[1] & 0xFFL;
        long l3 = (long)this.buffer[2] & 0xFFL;
        long l4 = (long)this.buffer[3] & 0xFFL;
        return this.bigEndian ? ((l << 8 | l2) << 8 | l3) << 8 | l4 : ((l4 << 8 | l3) << 8 | l2) << 8 | l;
    }

    final int extractSigned32() {
        int n = this.buffer[0] & 0xFF;
        int n2 = this.buffer[1] & 0xFF;
        int n3 = this.buffer[2] & 0xFF;
        int n4 = this.buffer[3] & 0xFF;
        return this.bigEndian ? ((n << 8 | n2) << 8 | n3) << 8 | n4 : ((n4 << 8 | n3) << 8 | n2) << 8 | n;
    }

    final long extractUnsigned64() {
        long l = (long)this.buffer[0] & 0xFFL;
        long l2 = (long)this.buffer[1] & 0xFFL;
        long l3 = (long)this.buffer[2] & 0xFFL;
        long l4 = (long)this.buffer[3] & 0xFFL;
        long l5 = (long)this.buffer[4] & 0xFFL;
        long l6 = (long)this.buffer[5] & 0xFFL;
        long l7 = (long)this.buffer[6] & 0xFFL;
        long l8 = (long)this.buffer[7] & 0xFFL;
        return this.bigEndian ? ((((((l << 8 | l2) << 8 | l3) << 8 | l4) << 8 | l5) << 8 | l6) << 8 | l7) << 8 | l8 : ((((((l8 << 8 | l7) << 8 | l6) << 8 | l5) << 8 | l4) << 8 | l3) << 8 | l2) << 8 | l;
    }

    public void readInsistently(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        while (n3 > 0) {
            int n4 = this.in.read(byArray, n, n3);
            if (n4 == -1) {
                throw new IOException("read failed with " + n3 + " bytes remaining to be read, wanted " + n2);
            }
            n3 -= n4;
            n += n4;
        }
    }

    public void skipInsistently(long l) throws IOException {
        long l2;
        for (long i = l; i > 0L; i -= l2) {
            l2 = this.in.skip(i);
            if (l2 > 0L) continue;
            throw new IOException("skip failed with " + i + " bytes remaining to be skipped, wanted " + l);
        }
    }

    public final int readUnsigned8() throws IOException {
        this.readInsistently(this.buffer, 0, 1);
        return this.extractUnsigned8();
    }

    public final int readUnsigned16() throws IOException {
        this.readInsistently(this.buffer, 0, 2);
        return this.extractUnsigned16();
    }

    public final int readSigned16() throws IOException {
        this.readInsistently(this.buffer, 0, 2);
        return this.extractSigned16();
    }

    public final long readUnsigned32() throws IOException {
        this.readInsistently(this.buffer, 0, 4);
        return this.extractUnsigned32();
    }

    public final int readSigned32() throws IOException {
        this.readInsistently(this.buffer, 0, 4);
        return this.extractSigned32();
    }

    public final float readFloat() throws IOException {
        this.readInsistently(this.buffer, 0, 4);
        int n = (int)this.extractUnsigned32();
        return Float.intBitsToFloat(n);
    }

    public final double readDouble() throws IOException {
        this.readInsistently(this.buffer, 0, 8);
        long l = this.extractUnsigned64();
        return Double.longBitsToDouble(l);
    }

    public final void readUnsigned16(short[] sArray, int n) throws IOException {
        this.readUnsigned16(sArray, 0, n);
    }

    public final void readUnsigned16(short[] sArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n2 * 2;
        byte[] byArray = new byte[n4];
        this.readInsistently(byArray, 0, n4);
        int n5 = 0;
        if (this.bigEndian) {
            while (n3 < n2) {
                int n6 = byArray[n5++] & 0xFF;
                int n7 = byArray[n5++] & 0xFF;
                short s = (short)((n6 << 8) + n7);
                sArray[n + n3++] = s;
            }
        } else {
            for (n3 = 0; n3 < n2; ++n3) {
                sArray[n + n3] = (short)((byArray[n5++] & 0xFF) + (byArray[n5++] << 8));
            }
        }
    }

    public final void readFloat(float[] fArray, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.readFloat();
        }
    }

    public final void readComplexFloat(float[] fArray, float[] fArray2, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            float f = this.readFloat();
            float f2 = this.readFloat();
            if (fArray != null) {
                fArray[i] = f;
            }
            if (fArray2 == null) continue;
            fArray2[i] = f2;
        }
    }

    public final void readDouble(double[] dArray, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.readDouble();
        }
    }

    public final void readComplexDouble(double[] dArray, double[] dArray2, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            double d = this.readDouble();
            double d2 = this.readDouble();
            if (dArray != null) {
                dArray[i] = d;
            }
            if (dArray2 == null) continue;
            dArray2[i] = d2;
        }
    }

    final void setBufferForTest(byte[] byArray) {
        this.buffer = byArray;
    }

    public static void main(String[] stringArray) {
        BinaryInputStream binaryInputStream = null;
        try {
            binaryInputStream = new BinaryInputStream(new FileInputStream(stringArray[0]), false);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(0);
        }
        byte[] byArray = new byte[4];
        binaryInputStream.setBufferForTest(byArray);
        byArray[0] = -1;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[1] = -1;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[2] = -1;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[3] = -1;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[0] = 127;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[1] = 127;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[2] = 127;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[3] = 127;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        try {
            binaryInputStream = new BinaryInputStream(new FileInputStream(stringArray[0]), true);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(0);
        }
        binaryInputStream.setBufferForTest(byArray);
        byArray[3] = -1;
        byArray[2] = 0;
        byArray[1] = 0;
        byArray[0] = 0;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[2] = -1;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[1] = -1;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[0] = -1;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[3] = 127;
        byArray[2] = 0;
        byArray[1] = 0;
        byArray[0] = 0;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[2] = 127;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[1] = 127;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
        byArray[0] = 127;
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned8()));
        System.err.println("Extracted 0x" + Integer.toHexString(binaryInputStream.extractUnsigned16()));
        System.err.println("Extracted 0x" + Long.toHexString(binaryInputStream.extractUnsigned32()));
    }
}

