/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import java.util.Iterator;

public class ContentItemFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ContentItemFactory.java,v 1.9 2008/02/18 18:14:40 dclunie Exp $";

    public ContentItem getNewContentItem(ContentItem contentItem, AttributeList attributeList) {
        String string;
        ContentItem contentItem2 = null;
        contentItem2 = attributeList == null ? new UnrecognizedContentItem(contentItem) : ((string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ValueType)) == null ? new UnrecognizedContentItem(contentItem, attributeList) : (string.equals("CONTAINER") ? new ContainerContentItem(contentItem, attributeList) : (string.equals("CODE") ? new CodeContentItem(contentItem, attributeList) : (string.equals("NUM") ? new NumericContentItem(contentItem, attributeList) : (string.equals("DATETIME") ? new DateTimeContentItem(contentItem, attributeList) : (string.equals("DATE") ? new DateContentItem(contentItem, attributeList) : (string.equals("TIME") ? new TimeContentItem(contentItem, attributeList) : (string.equals("PNAME") ? new PersonNameContentItem(contentItem, attributeList) : (string.equals("UIDREF") ? new UIDContentItem(contentItem, attributeList) : (string.equals("TEXT") ? new TextContentItem(contentItem, attributeList) : (string.equals("SCOORD") ? new SpatialCoordinatesContentItem(contentItem, attributeList) : (string.equals("TCOORD") ? new TemporalCoordinatesContentItem(contentItem, attributeList) : (string.equals("COMPOSITE") ? new CompositeContentItem(contentItem, attributeList) : (string.equals("IMAGE") ? new ImageContentItem(contentItem, attributeList) : (string.equals("WAVEFORM") ? new WaveformContentItem(contentItem, attributeList) : new UnrecognizedContentItem(contentItem, attributeList, string))))))))))))))));
        return contentItem2;
    }

    public class TextContentItem
    extends StringContentItem {
        public TextContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList, TagFromName.TextValue);
        }
    }

    public class UIDContentItem
    extends StringContentItem {
        public UIDContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList, TagFromName.UID);
        }
    }

    public class PersonNameContentItem
    extends StringContentItem {
        public PersonNameContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList, TagFromName.PersonName);
        }
    }

    public class TimeContentItem
    extends StringContentItem {
        public TimeContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList, TagFromName.Time);
        }
    }

    public class DateContentItem
    extends StringContentItem {
        public DateContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList, TagFromName.Date);
        }
    }

    public class DateTimeContentItem
    extends StringContentItem {
        public DateTimeContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList, TagFromName.DateTime);
        }
    }

    protected abstract class StringContentItem
    extends ContentItem {
        protected String stringValue;

        public StringContentItem(ContentItem contentItem, AttributeList attributeList, AttributeTag attributeTag) {
            super(contentItem, attributeList);
            this.stringValue = Attribute.getSingleStringValueOrDefault(attributeList, attributeTag, "");
        }

        public String getConceptValue() {
            return this.stringValue;
        }

        public String toString() {
            return super.toString() + " = " + this.stringValue;
        }
    }

    public class CodeContentItem
    extends ContentItem {
        protected CodedSequenceItem conceptCode;

        public CodeContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList);
            this.conceptCode = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.ConceptCodeSequence);
        }

        public String getConceptValue() {
            return this.conceptCode == null ? "" : this.conceptCode.getCodeMeaning();
        }

        public String toString() {
            return super.toString() + " = " + (this.conceptCode == null ? "" : this.conceptCode.getCodeMeaning());
        }

        public CodedSequenceItem getConceptCode() {
            return this.conceptCode;
        }
    }

    public class NumericContentItem
    extends ContentItem {
        protected String numericValue;
        protected CodedSequenceItem units;

        public NumericContentItem(ContentItem contentItem, AttributeList attributeList) {
            SequenceItem sequenceItem;
            Iterator iterator;
            super(contentItem, attributeList);
            SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.MeasuredValueSequence);
            if (sequenceAttribute != null && (iterator = sequenceAttribute.iterator()).hasNext() && (sequenceItem = (SequenceItem)iterator.next()) != null) {
                AttributeList attributeList2 = sequenceItem.getAttributeList();
                this.numericValue = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.NumericValue);
                this.units = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList2, TagFromName.MeasurementUnitsCodeSequence);
            }
            if (this.numericValue == null) {
                this.numericValue = "";
            }
        }

        public CodedSequenceItem getUnits() {
            return this.units;
        }

        public String getNumericValue() {
            return this.numericValue;
        }

        public String getConceptValue() {
            return this.numericValue + " " + (this.units == null ? "" : this.units.getCodeMeaning());
        }

        public String getConceptNameAndValue() {
            return this.getConceptNameCodeMeaning() + " = " + this.numericValue + " " + (this.units == null ? "" : this.units.getCodeMeaning());
        }

        public String toString() {
            return super.toString() + " = " + this.numericValue + " " + (this.units == null ? "" : this.units.getCodeMeaning());
        }
    }

    public class TemporalCoordinatesContentItem
    extends ContentItem {
        protected String temporalRangeType;
        protected int[] referencedSamplePositions;
        protected float[] referencedTimeOffsets;
        protected String[] referencedDateTimes;

        public TemporalCoordinatesContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList);
            this.temporalRangeType = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.TemporalRangeType, "");
            try {
                Attribute attribute = attributeList.get(TagFromName.ReferencedSamplePositions);
                if (attribute != null) {
                    this.referencedSamplePositions = attribute.getIntegerValues();
                }
                if ((attribute = attributeList.get(TagFromName.ReferencedTimeOffsets)) != null) {
                    this.referencedTimeOffsets = attribute.getFloatValues();
                }
                if ((attribute = attributeList.get(TagFromName.ReferencedDateTime)) != null) {
                    this.referencedDateTimes = attribute.getStringValues();
                }
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
        }

        public String getConceptValue() {
            return "";
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" = ");
            stringBuffer.append(this.temporalRangeType);
            if (this.referencedSamplePositions != null) {
                stringBuffer.append(" Sample Positions (");
                for (n = 0; n < this.referencedSamplePositions.length; ++n) {
                    if (n > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.referencedSamplePositions[n]);
                }
                stringBuffer.append(")");
            }
            if (this.referencedTimeOffsets != null) {
                stringBuffer.append(" Time Offsets (");
                for (n = 0; n < this.referencedTimeOffsets.length; ++n) {
                    if (n > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.referencedTimeOffsets[n]);
                }
                stringBuffer.append(")");
            }
            if (this.referencedDateTimes != null) {
                stringBuffer.append(" DateTimes (");
                for (n = 0; n < this.referencedDateTimes.length; ++n) {
                    if (n > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.referencedDateTimes[n]);
                }
                stringBuffer.append(")");
            }
            return stringBuffer.toString();
        }

        public String getTemporalRangeType() {
            return this.temporalRangeType;
        }

        public int[] getReferencedSamplePositions() {
            return this.referencedSamplePositions;
        }

        public float[] getReferencedTimeOffsets() {
            return this.referencedTimeOffsets;
        }

        public String[] getReferencedDateTimes() {
            return this.referencedDateTimes;
        }
    }

    public class SpatialCoordinatesContentItem
    extends ContentItem {
        protected String graphicType;
        protected float[] graphicData;

        public SpatialCoordinatesContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList);
            this.graphicType = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.GraphicType, "");
            try {
                Attribute attribute = attributeList.get(TagFromName.GraphicData);
                if (attribute != null) {
                    this.graphicData = attribute.getFloatValues();
                }
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
        }

        public String getConceptValue() {
            return "";
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" = ");
            stringBuffer.append(this.graphicType);
            stringBuffer.append(" (");
            if (this.graphicData != null) {
                for (int i = 0; i < this.graphicData.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.graphicData[i]);
                }
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public String getGraphicType() {
            return this.graphicType;
        }

        public float[] getGraphicData() {
            return this.graphicData;
        }
    }

    public class WaveformContentItem
    extends CompositeContentItem {
        protected int[] referencedWaveformChannels;

        public WaveformContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList);
            if (this.referencedSOPSequenceItemAttributeList != null) {
                this.referencedWaveformChannels = Attribute.getIntegerValues(this.referencedSOPSequenceItemAttributeList, TagFromName.ReferencedWaveformChannels);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" = [");
            if (this.referencedWaveformChannels != null) {
                for (int i = 0; i < this.referencedWaveformChannels.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.referencedWaveformChannels[i]);
                }
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public int[] getReferencedWaveformChannels() {
            return this.referencedWaveformChannels;
        }
    }

    public class ImageContentItem
    extends CompositeContentItem {
        protected int referencedFrameNumber;
        protected int referencedSegmentNumber;
        protected String presentationStateSOPClassUID;
        protected String presentationStateSOPInstanceUID;
        protected String realWorldValueMappingSOPClassUID;
        protected String realWorldValueMappingSOPInstanceUID;

        public ImageContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList);
            if (this.referencedSOPSequenceItemAttributeList != null) {
                this.referencedFrameNumber = Attribute.getSingleIntegerValueOrDefault(this.referencedSOPSequenceItemAttributeList, TagFromName.ReferencedFrameNumber, 0);
                this.referencedSegmentNumber = Attribute.getSingleIntegerValueOrDefault(this.referencedSOPSequenceItemAttributeList, TagFromName.ReferencedSegmentNumber, 0);
                AttributeList attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(this.referencedSOPSequenceItemAttributeList, TagFromName.ReferencedSOPSequence);
                if (attributeList2 != null) {
                    this.presentationStateSOPClassUID = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ReferencedSOPClassUID);
                    this.presentationStateSOPInstanceUID = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ReferencedSOPInstanceUID);
                }
                if (this.presentationStateSOPClassUID == null) {
                    this.presentationStateSOPClassUID = "";
                }
                if (this.presentationStateSOPInstanceUID == null) {
                    this.presentationStateSOPInstanceUID = "";
                }
                if ((attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(this.referencedSOPSequenceItemAttributeList, TagFromName.ReferencedRealWorldValueMappingInstanceSequence)) != null) {
                    this.realWorldValueMappingSOPClassUID = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ReferencedSOPClassUID);
                    this.realWorldValueMappingSOPInstanceUID = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ReferencedSOPInstanceUID);
                }
                if (this.realWorldValueMappingSOPClassUID == null) {
                    this.realWorldValueMappingSOPClassUID = "";
                }
                if (this.realWorldValueMappingSOPInstanceUID == null) {
                    this.realWorldValueMappingSOPInstanceUID = "";
                }
            }
        }

        public String toString() {
            return super.toString() + (this.referencedFrameNumber == 0 ? "" : "[Frame " + Integer.toString(this.referencedFrameNumber) + "]") + (this.referencedSegmentNumber == 0 ? "" : "[Segment " + Integer.toString(this.referencedSegmentNumber) + "]") + (this.presentationStateSOPInstanceUID == null || this.presentationStateSOPInstanceUID.length() == 0 ? "" : " (PS " + this.presentationStateSOPClassUID + " : " + this.presentationStateSOPInstanceUID + ")") + (this.realWorldValueMappingSOPInstanceUID == null || this.realWorldValueMappingSOPInstanceUID.length() == 0 ? "" : " (RWV " + this.realWorldValueMappingSOPClassUID + " : " + this.realWorldValueMappingSOPInstanceUID + ")");
        }

        public int getReferencedFrameNumber() {
            return this.referencedFrameNumber;
        }

        public int getReferencedSegmentNumber() {
            return this.referencedSegmentNumber;
        }

        public String getPresentationStateSOPClassUID() {
            return this.presentationStateSOPClassUID;
        }

        public String getPresentationStateSOPInstanceUID() {
            return this.presentationStateSOPInstanceUID;
        }

        public String getRealWorldValueMappingSOPClassUID() {
            return this.realWorldValueMappingSOPClassUID;
        }

        public String getRealWorldValueMappingSOPInstanceUID() {
            return this.realWorldValueMappingSOPInstanceUID;
        }
    }

    public class CompositeContentItem
    extends ContentItem {
        protected AttributeList referencedSOPSequenceItemAttributeList;
        protected String referencedSOPClassUID;
        protected String referencedSOPInstanceUID;

        public CompositeContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList);
            this.referencedSOPSequenceItemAttributeList = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(attributeList, TagFromName.ReferencedSOPSequence);
            if (this.referencedSOPSequenceItemAttributeList != null) {
                this.referencedSOPClassUID = Attribute.getSingleStringValueOrEmptyString(this.referencedSOPSequenceItemAttributeList, TagFromName.ReferencedSOPClassUID);
                this.referencedSOPInstanceUID = Attribute.getSingleStringValueOrEmptyString(this.referencedSOPSequenceItemAttributeList, TagFromName.ReferencedSOPInstanceUID);
            }
            if (this.referencedSOPClassUID == null) {
                this.referencedSOPClassUID = "";
            }
            if (this.referencedSOPInstanceUID == null) {
                this.referencedSOPInstanceUID = "";
            }
        }

        public String getConceptValue() {
            return "";
        }

        public String toString() {
            return super.toString() + " = " + this.referencedSOPClassUID + " : " + this.referencedSOPInstanceUID;
        }

        public String getReferencedSOPClassUID() {
            return this.referencedSOPClassUID;
        }

        public String getReferencedSOPInstanceUID() {
            return this.referencedSOPInstanceUID;
        }
    }

    public class ContainerContentItem
    extends ContentItem {
        public ContainerContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList);
        }

        public String getConceptValue() {
            return "";
        }
    }

    public class UnrecognizedContentItem
    extends ContentItem {
        public UnrecognizedContentItem(ContentItem contentItem) {
            super(contentItem, null);
        }

        public UnrecognizedContentItem(ContentItem contentItem, AttributeList attributeList) {
            super(contentItem, attributeList);
        }

        public UnrecognizedContentItem(ContentItem contentItem, AttributeList attributeList, String string) {
            super(contentItem, attributeList);
        }

        public String getConceptValue() {
            return "";
        }
    }
}

