/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BinaryOutputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.utils.HexDump;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class SpecificCharacterSet {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SpecificCharacterSet.java,v 1.25 2007/12/09 15:06:30 dclunie Exp $";
    private String useEncoding;
    private boolean useISO2022 = false;
    private static boolean useOwnJIS;
    private static boolean useOwnJISCheckPerformed;
    private static HashMap ownJIS0208Mapping;
    private static HashMap ownJIS0212Mapping;

    public String toString() {
        return this.useEncoding;
    }

    public static boolean byteArrayContainsNonASCIIValues(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            if ((byArray[i] & 0xFF) <= 127) continue;
            return true;
        }
        return false;
    }

    public static boolean byteArrayContainsNonASCIIValues(byte[] byArray) {
        return SpecificCharacterSet.byteArrayContainsNonASCIIValues(byArray, 0, byArray.length);
    }

    private boolean testIfNativeJISWorking() {
        boolean bl = false;
        byte[] byArray = new byte[]{59, 51, 69, 68};
        try {
            String string = new String(byArray, "JIS0208");
            byte[] byArray2 = string.getBytes("UTF8");
            bl = byArray2.length == 6 && (byArray2[0] & 0xFF) == 229 && (byArray2[1] & 0xFF) == 177 && (byArray2[2] & 0xFF) == 177 && (byArray2[3] & 0xFF) == 231 && (byArray2[4] & 0xFF) == 148 && (byArray2[5] & 0xFF) == 176;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return bl;
    }

    private static HashMap initializeOwnMapping(String string) {
        HashMap<Short, Character> hashMap = new HashMap<Short, Character>();
        InputStream inputStream = SpecificCharacterSet.class.getResourceAsStream("/com/pixelmed/dicom/" + string);
        if (inputStream != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() != 2) continue;
                    Short s = new Short(Integer.decode(stringTokenizer.nextToken()).shortValue());
                    Character c = new Character((char)Integer.decode(stringTokenizer.nextToken()).shortValue());
                    hashMap.put(s, c);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
        return hashMap;
    }

    private static void initializeOwnJIS0208Mapping() {
        ownJIS0208Mapping = SpecificCharacterSet.initializeOwnMapping("JIS0208Mapping.dat");
    }

    public static String getSuitableEncodingFromSetOfUnicodeBlocks(Set set) {
        String string = "UTF8";
        if (set == null) {
            string = "ASCII";
        } else {
            int n = set.size();
            if (n == 0) {
                string = "ASCII";
            } else if (n > 2) {
                string = "UTF8";
            } else if ((n == 1 || n == 2) && set.contains(Character.UnicodeBlock.BASIC_LATIN)) {
                if (n == 1) {
                    string = "ASCII";
                } else if (set.contains(Character.UnicodeBlock.LATIN_1_SUPPLEMENT)) {
                    string = "ISO8859_1";
                } else if (set.contains(Character.UnicodeBlock.CYRILLIC)) {
                    string = "ISO8859_5";
                } else if (set.contains(Character.UnicodeBlock.ARABIC)) {
                    string = "ISO8859_6";
                } else if (set.contains(Character.UnicodeBlock.GREEK)) {
                    string = "ISO8859_7";
                }
            }
        }
        return string;
    }

    public static Set getSetOfUnicodeBlocksUsedBy(String string) {
        HashSet<Character.UnicodeBlock> hashSet = new HashSet<Character.UnicodeBlock>();
        if (string != null && string.length() > 0) {
            int n = string.length();
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            for (int i = 0; i < string.length(); ++i) {
                char c = cArray[i];
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
                hashSet.add(unicodeBlock);
            }
        }
        return hashSet;
    }

    public SpecificCharacterSet(Set set) {
        this.useEncoding = SpecificCharacterSet.getSuitableEncodingFromSetOfUnicodeBlocks(set);
        this.useISO2022 = false;
    }

    public SpecificCharacterSet(String[] stringArray) {
        this(stringArray, null);
    }

    public SpecificCharacterSet(String[] stringArray, byte[] byArray) {
        this.useEncoding = null;
        this.useISO2022 = false;
        if (!useOwnJISCheckPerformed) {
            useOwnJIS = !this.testIfNativeJISWorking();
            useOwnJISCheckPerformed = true;
        }
        if (stringArray != null && stringArray.length >= 1) {
            String string = stringArray[0];
            if (string == null || string.equals("")) {
                this.useEncoding = "ASCII";
            } else if (string.equals("ISO_IR 100")) {
                this.useEncoding = "ISO8859_1";
            } else if (string.equals("ISO_IR 101")) {
                this.useEncoding = "ISO8859_2";
            } else if (string.equals("ISO_IR 109")) {
                this.useEncoding = "ISO8859_3";
            } else if (string.equals("ISO_IR 110")) {
                this.useEncoding = "ISO8859_4";
            } else if (string.equals("ISO_IR 144")) {
                this.useEncoding = "ISO8859_5";
            } else if (string.equals("ISO_IR 127")) {
                this.useEncoding = "ISO8859_6";
            } else if (string.equals("ISO_IR 126")) {
                this.useEncoding = "ISO8859_7";
            } else if (string.equals("ISO_IR 138")) {
                this.useEncoding = "ISO8859_8";
            } else if (string.equals("ISO_IR 148")) {
                this.useEncoding = "ISO8859_9";
            } else if (string.equals("ISO_IR 166")) {
                this.useEncoding = "TIS620";
            } else if (string.equals("ISO_IR 192")) {
                this.useEncoding = "UTF8";
            } else if (string.equals("GB18030")) {
                this.useEncoding = "GB18030";
            } else if (string.equals("GBK")) {
                this.useEncoding = "GB18030";
            } else if (string.equals("GB2312")) {
                this.useEncoding = "GB18030";
            } else if (string.equals("ISO_IR 13")) {
                this.useEncoding = "JIS0201";
            } else if (string.equals("ISO 2022 IR 6")) {
                this.useISO2022 = true;
                this.useEncoding = "ASCII";
            } else if (string.equals("ISO 2022 IR 100")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_1";
            } else if (string.equals("ISO 2022 IR 101")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_2";
            } else if (string.equals("ISO 2022 IR 109")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_3";
            } else if (string.equals("ISO 2022 IR 110")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_4";
            } else if (string.equals("ISO 2022 IR 144")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_5";
            } else if (string.equals("ISO 2022 IR 127")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_6";
            } else if (string.equals("ISO 2022 IR 126")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_7";
            } else if (string.equals("ISO 2022 IR 138")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_8";
            } else if (string.equals("ISO 2022 IR 148")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_9";
            } else if (string.equals("ISO 2022 IR 13")) {
                this.useISO2022 = true;
                this.useEncoding = "JIS0201";
            } else if (string.equals("ISO 2022 IR 166")) {
                this.useISO2022 = true;
                this.useEncoding = "TIS620";
            } else if (string.equals("ISO 2022 IR 87")) {
                this.useISO2022 = true;
                this.useEncoding = "JIS0201";
            } else if (string.equals("ISO 2022 IR 159")) {
                this.useISO2022 = true;
                this.useEncoding = "JIS0212";
            } else if (string.equals("ISO 2022 IR 149")) {
                this.useISO2022 = true;
                this.useEncoding = "Cp949";
            } else if (byArray != null && byArray.length == 4 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 190 && (byArray[2] & 0xFF) == 221 && (byArray[3] & 0xFF) == 168) {
                System.err.println("Error - encountered non-standard illegal encoding of Big5 Specific Character Set");
                this.useEncoding = "Big5";
            } else {
                System.err.println("Warning - unrecognized first value of Specific Character Set, using ASCII; first value =" + string + " (" + HexDump.dump(byArray) + ")");
                this.useEncoding = "ASCII";
            }
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || !string2.startsWith("ISO 2022")) continue;
                this.useISO2022 = true;
            }
        } else {
            this.useEncoding = "ASCII";
        }
    }

    public String getValueToUseInSpecificCharacterSetAttribute() {
        String string = "ISO_IR 192";
        if (!this.useISO2022) {
            if (this.useEncoding == "ASCII") {
                string = "";
            } else if (this.useEncoding == "ISO8859_1") {
                string = "ISO_IR 100";
            } else if (this.useEncoding == "ISO8859_2") {
                string = "ISO_IR 101";
            } else if (this.useEncoding == "ISO8859_3") {
                string = "ISO_IR 109";
            } else if (this.useEncoding == "ISO8859_4") {
                string = "ISO_IR 110";
            } else if (this.useEncoding == "ISO8859_5") {
                string = "ISO_IR 144";
            } else if (this.useEncoding == "ISO8859_6") {
                string = "ISO_IR 127";
            } else if (this.useEncoding == "ISO8859_7") {
                string = "ISO_IR 126";
            } else if (this.useEncoding == "ISO8859_8") {
                string = "ISO_IR 138";
            } else if (this.useEncoding == "ISO8859_9") {
                string = "ISO_IR 148";
            } else if (this.useEncoding == "TIS620") {
                string = "ISO_IR 166";
            } else if (this.useEncoding == "UTF8") {
                string = "ISO_IR 192";
            } else if (this.useEncoding == "GB18030") {
                string = "GB18030";
            } else if (this.useEncoding == "JIS0201") {
                string = "ISO_IR 13";
            }
        }
        return string;
    }

    private String translateByteArrayToString(byte[] byArray, int n, int n2, HashMap hashMap) {
        String string = null;
        if (hashMap != null) {
            StringBuffer stringBuffer = new StringBuffer(n2 / 2);
            int n3 = n;
            while (n3 < n + n2) {
                short s;
                short s2;
                short s3;
                Character c;
                if ((c = (Character)hashMap.get(new Short(s3 = (short)((s2 = (short)((short)byArray[n3++] & 0xFF)) << 8 | (s = (short)((short)byArray[n3++] & 0xFF)))))) == null) continue;
                stringBuffer.append(c.charValue());
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private String translateByteArrayToString(byte[] byArray, int n, int n2, String string) {
        String string2 = null;
        if (n2 > 0 && useOwnJIS && string.equals("JIS0208")) {
            if (ownJIS0208Mapping == null) {
                SpecificCharacterSet.initializeOwnJIS0208Mapping();
            }
            string2 = this.translateByteArrayToString(byArray, n, n2, ownJIS0208Mapping);
        } else {
            try {
                string2 = string.equals("ASCII") && SpecificCharacterSet.byteArrayContainsNonASCIIValues(byArray, n, n2) ? new String(byArray, n, n2, "ISO8859_1") : new String(byArray, n, n2, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace(System.err);
                string2 = new String(byArray, n, n2);
            }
        }
        return string2;
    }

    public String translateByteArrayToString(byte[] byArray, int n, int n2) {
        String string = null;
        if (this.useEncoding == null) {
            string = new String(byArray, 0, n2);
        } else if (this.useISO2022) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            int n4 = 0;
            int n5 = 1;
            String string2 = this.useEncoding;
            while (n3 < n2) {
                if (byArray[n3] == 27) {
                    if (n3 > n4) {
                        stringBuffer.append(this.translateByteArrayToString(byArray, n4, n3 - n4, string2));
                    }
                    if (byArray[n3 + 1] == 40 && byArray[n3 + 2] == 66) {
                        string2 = "ASCII";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 65) {
                        string2 = "ISO8859_1";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 66) {
                        string2 = "ISO8859_2";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 67) {
                        string2 = "ISO8859_3";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 68) {
                        string2 = "ISO8859_4";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 76) {
                        string2 = "ISO8859_5";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 71) {
                        string2 = "ISO8859_6";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 70) {
                        string2 = "ISO8859_7";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 72) {
                        string2 = "ISO8859_8";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 77) {
                        string2 = "ISO8859_9";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 84) {
                        string2 = "TIS620";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 41 && byArray[n3 + 2] == 73) {
                        string2 = "JIS0201";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 40 && byArray[n3 + 2] == 74) {
                        string2 = "JIS0201";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 36 && byArray[n3 + 2] == 66) {
                        string2 = "JIS0208";
                        n5 = 2;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 36 && byArray[n3 + 2] == 40 && byArray[n3 + 3] == 68) {
                        string2 = "JIS0212";
                        n5 = 2;
                        n3 += 4;
                    } else if (byArray[n3 + 1] == 36 && byArray[n3 + 2] == 41 && byArray[n3 + 3] == 67) {
                        string2 = "Cp949";
                        n5 = -1;
                        n3 += 4;
                    } else {
                        n3 += 3;
                    }
                    n4 = n3;
                    continue;
                }
                n3 += n5 == -1 ? ((byArray[n3] & 0x80) == 1 ? 2 : 1) : n5;
            }
            if (n3 > n4) {
                stringBuffer.append(this.translateByteArrayToString(byArray, n4, n3 - n4, string2));
            }
            string = stringBuffer.toString();
        } else {
            string = this.translateByteArrayToString(byArray, 0, n2, this.useEncoding);
        }
        return string;
    }

    public byte[] translateStringToByteArray(String string) throws UnsupportedEncodingException {
        byte[] byArray = this.useEncoding == null ? string.getBytes() : string.getBytes(this.useEncoding);
        return byArray;
    }

    private static void createDicomFileWithPatientName(String string, byte[] byArray, String string2) {
        try {
            BinaryOutputStream binaryOutputStream = new BinaryOutputStream(new FileOutputStream(string), false);
            Object object = TagFromName.SpecificCharacterSet;
            binaryOutputStream.writeUnsigned16(((AttributeTag)object).getGroup());
            binaryOutputStream.writeUnsigned16(((AttributeTag)object).getElement());
            binaryOutputStream.write(67);
            binaryOutputStream.write(83);
            object = string2.getBytes("ASCII");
            int n = ((Object)object).length;
            boolean bl = false;
            if (n % 2 != 0) {
                ++n;
                bl = true;
            }
            binaryOutputStream.writeUnsigned16(n);
            binaryOutputStream.write((byte[])object);
            if (bl) {
                binaryOutputStream.write(32);
            }
            AttributeTag attributeTag = TagFromName.PatientName;
            binaryOutputStream.writeUnsigned16(attributeTag.getGroup());
            binaryOutputStream.writeUnsigned16(attributeTag.getElement());
            binaryOutputStream.write(80);
            binaryOutputStream.write(78);
            n = byArray.length;
            bl = false;
            if (n % 2 != 0) {
                ++n;
                bl = true;
            }
            binaryOutputStream.writeUnsigned16(n);
            binaryOutputStream.write(byArray);
            if (bl) {
                binaryOutputStream.write(32);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static void main(String[] stringArray) {
        byte[] byArray;
        Object object;
        byte[] byArray2 = new byte[]{89, 97, 109, 97, 100, 97, 94, 84, 97, 114, 111, 117, 61, 27, 36, 66, 59, 51, 69, 68, 27, 40, 66, 94, 27, 36, 66, 66, 64, 79, 58, 27, 40, 66, 61, 27, 36, 66, 36, 100, 36, 94, 36, 64, 27, 40, 66, 94, 27, 36, 66, 36, 63, 36, 109, 36, 38, 27, 40, 66};
        String string = "\\ISO 2022 IR 87";
        byte[] byArray3 = new byte[]{-44, -49, -64, -34, 94, -64, -37, -77, 61, 27, 36, 66, 59, 51, 69, 68, 27, 40, 74, 94, 27, 36, 66, 66, 64, 79, 58, 27, 40, 74, 61, 27, 36, 66, 36, 100, 36, 94, 36, 64, 27, 40, 74, 94, 27, 36, 66, 36, 63, 36, 109, 36, 38, 27, 40, 74};
        String string2 = "ISO 2022 IR 13\\ISO 2022 IR 87";
        byte[] byArray4 = new byte[]{72, 111, 110, 103, 94, 71, 105, 108, 100, 111, 110, 103, 61, 27, 36, 41, 67, -5, -13, 94, 27, 36, 41, 67, -47, -50, -44, -41, 61, 27, 36, 41, 67, -56, -85, 94, 27, 36, 41, 67, -79, -26, -75, -65};
        String string3 = "\\ISO 2022 IR 149";
        byte[] byArray5 = new byte[]{87, 97, 110, 103, 94, 88, 105, 97, 111, 68, 111, 110, 103, 61, -25, -114, -117, 94, -27, -80, -113, -26, -99, -79, 61};
        String string4 = "ISO_IR 192";
        byte[] byArray6 = new byte[]{87, 97, 110, 103, 94, 88, 105, 97, 111, 68, 111, 110, 103, 61, -51, -11, 94, -48, -95, -74, -85, 61};
        String string5 = "GB18030";
        String string6 = stringArray.length > 0 && stringArray[0] != null ? stringArray[0] + "/" : "";
        SpecificCharacterSet.createDicomFileWithPatientName(string6 + "h31example.dcm", byArray2, string);
        SpecificCharacterSet.createDicomFileWithPatientName(string6 + "h32example.dcm", byArray3, string2);
        SpecificCharacterSet.createDicomFileWithPatientName(string6 + "i2example.dcm", byArray4, string3);
        SpecificCharacterSet.createDicomFileWithPatientName(string6 + "x1example.dcm", byArray5, string4);
        SpecificCharacterSet.createDicomFileWithPatientName(string6 + "x2example.dcm", byArray6, string5);
        try {
            object = "\u0394\u03b9\u03bf\u03bd\u03c5\u03c3\u03b9\u03bf\u03c2";
            byArray = ((String)object).getBytes("ISO8859_7");
            SpecificCharacterSet.createDicomFileWithPatientName(string6 + "greek.dcm", byArray, "ISO_IR 126");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            object = "Buc^J\u00e9r\u00f4me";
            byArray = ((String)object).getBytes("ISO8859_1");
            SpecificCharacterSet.createDicomFileWithPatientName(string6 + "french.dcm", byArray, "ISO_IR 100");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            object = "\u00c4neas^R\u00fcdiger";
            byArray = ((String)object).getBytes("ISO8859_1");
            SpecificCharacterSet.createDicomFileWithPatientName(string6 + "german.dcm", byArray, "ISO_IR 100");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            object = new byte[]{-30, -56, -57, -26, -22, 94, -28, -26, -46, -57, -47};
            SpecificCharacterSet.createDicomFileWithPatientName(string6 + "arabic.dcm", (byte[])object, "ISO_IR 127");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            object = new byte[]{-69, -18, -38, 99, 101, -36, -47, 121, 112, -45};
            SpecificCharacterSet.createDicomFileWithPatientName(string6 + "russian.dcm", (byte[])object, "ISO_IR 144");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            object = new byte[]{-7, -8, -27, -17, 94, -29, -31, -27, -8, -28};
            SpecificCharacterSet.createDicomFileWithPatientName(string6 + "hebrew.dcm", (byte[])object, "ISO_IR 138");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

