/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import java.util.Iterator;

public class SpectroscopyVolumeLocalization {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SpectroscopyVolumeLocalization.java,v 1.5 2004/05/01 20:19:51 dclunie Exp $";
    private int numberOfSlabs;
    private double[] slabThickness;
    private double[][] slabOrientation;
    private double[][] midSlabPosition;

    public SpectroscopyVolumeLocalization(AttributeList attributeList) throws DicomException {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.VolumeLocalizationSequence);
        if (sequenceAttribute != null) {
            this.numberOfSlabs = sequenceAttribute.getNumberOfItems();
            this.slabThickness = new double[this.numberOfSlabs];
            this.slabOrientation = new double[this.numberOfSlabs][];
            this.midSlabPosition = new double[this.numberOfSlabs][];
            int n = 0;
            Iterator iterator = sequenceAttribute.iterator();
            while (iterator.hasNext()) {
                SequenceItem sequenceItem = (SequenceItem)iterator.next();
                AttributeList attributeList2 = sequenceItem.getAttributeList();
                if (attributeList2 != null) {
                    this.slabThickness[n] = Attribute.getSingleDoubleValueOrDefault(attributeList2, TagFromName.SlabThickness, 0.0);
                    this.slabOrientation[n] = Attribute.getDoubleValues(attributeList2, TagFromName.SlabOrientation);
                    this.midSlabPosition[n] = Attribute.getDoubleValues(attributeList2, TagFromName.MidSlabPosition);
                }
                ++n;
            }
        }
    }

    public final int getNumberOfSlabs() {
        return this.numberOfSlabs;
    }

    public final double getSlabThickness(int n) {
        return this.slabThickness[n];
    }

    public final double[] getSlabOrientation(int n) {
        return this.slabOrientation[n];
    }

    public final double[] getMidSlabPosition(int n) {
        return this.midSlabPosition[n];
    }
}

