/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class UniqueIdentifierAttribute
extends StringAttribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/UniqueIdentifierAttribute.java,v 1.12 2006/10/08 14:48:34 dclunie Exp $";

    public UniqueIdentifierAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public UniqueIdentifierAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    public UniqueIdentifierAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, (long)l, dicomInputStream);
    }

    public byte[] getVR() {
        return ValueRepresentation.UI;
    }

    protected byte getPadByte() {
        return 0;
    }

    public static boolean isSOPClassRelated(AttributeTag attributeTag) {
        return attributeTag.equals(TagFromName.SOPClassUID) || attributeTag.equals(TagFromName.AffectedSOPClassUID) || attributeTag.equals(TagFromName.MediaStorageSOPClassUID) || attributeTag.equals(TagFromName.OriginalSpecializedSOPClassUID) || attributeTag.equals(TagFromName.ReferencedRelatedGeneralSOPClassUIDInFile) || attributeTag.equals(TagFromName.ReferencedSOPClassUID) || attributeTag.equals(TagFromName.ReferencedSOPClassUIDInFile) || attributeTag.equals(TagFromName.RelatedGeneralSOPClassUID) || attributeTag.equals(TagFromName.RequestedSOPClassUID) || attributeTag.equals(TagFromName.RelatedGeneralSOPClassUID) || attributeTag.equals(TagFromName.SOPClassesInStudy) || attributeTag.equals(TagFromName.SOPClassesSupported);
    }

    public static boolean isTransferSyntaxRelated(AttributeTag attributeTag) {
        return attributeTag.equals(TagFromName.TransferSyntaxUID) || attributeTag.equals(TagFromName.EncryptedContentTransferSyntaxUID) || attributeTag.equals(TagFromName.MACCalculationTransferSyntaxUID) || attributeTag.equals(TagFromName.ReferencedTransferSyntaxUIDInFile);
    }

    public static boolean isCodingSchemeRelated(AttributeTag attributeTag) {
        return attributeTag.equals(TagFromName.CodingSchemeUID) || attributeTag.equals(TagFromName.ContextGroupExtensionCreatorUID);
    }

    public static boolean isPrivateRelated(AttributeTag attributeTag) {
        return attributeTag.equals(TagFromName.PrivateInformationCreatorUID) || attributeTag.equals(TagFromName.PrivateRecordUID);
    }

    public static boolean isTransient(AttributeTag attributeTag) {
        return !UniqueIdentifierAttribute.isSOPClassRelated(attributeTag) && !UniqueIdentifierAttribute.isTransferSyntaxRelated(attributeTag) && !UniqueIdentifierAttribute.isCodingSchemeRelated(attributeTag) && !UniqueIdentifierAttribute.isPrivateRelated(attributeTag);
    }
}

