/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import java.util.ArrayList;
import java.util.Iterator;

public class VOITransform {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/VOITransform.java,v 1.10 2007/09/25 14:10:47 dclunie Exp $";
    private SingleVOITransforms[] arrayOfTransforms = null;
    private SingleVOITransforms commonTransforms = null;

    public VOITransform(AttributeList attributeList) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        if (sequenceAttribute != null) {
            int n = sequenceAttribute.getNumberOfItems();
            int n2 = 0;
            object6 = sequenceAttribute.iterator();
            while (object6.hasNext()) {
                object5 = (SequenceItem)object6.next();
                object4 = ((SequenceItem)object5).getAttributeList();
                if (object4 != null && (object3 = (SequenceAttribute)((AttributeList)object4).get(TagFromName.FrameVOILUTSequence)) != null && ((SequenceAttribute)object3).getNumberOfItems() >= 1) {
                    if (this.arrayOfTransforms == null) {
                        this.arrayOfTransforms = new SingleVOITransforms[n];
                    }
                    if (this.arrayOfTransforms[n2] == null) {
                        this.arrayOfTransforms[n2] = new SingleVOITransforms();
                    }
                    object2 = ((SequenceAttribute)object3).iterator();
                    while (object2.hasNext()) {
                        object = (SequenceItem)object2.next();
                        AttributeList attributeList2 = ((SequenceItem)object).getAttributeList();
                        this.arrayOfTransforms[n2].add(attributeList2);
                    }
                }
                ++n2;
            }
        }
        if (this.arrayOfTransforms == null) {
            Iterator iterator;
            SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
            if (sequenceAttribute2 != null && (iterator = sequenceAttribute2.iterator()).hasNext() && (object5 = ((SequenceItem)(object6 = (SequenceItem)iterator.next())).getAttributeList()) != null && (object4 = (SequenceAttribute)((AttributeList)object5).get(TagFromName.FrameVOILUTSequence)) != null && ((SequenceAttribute)object4).getNumberOfItems() >= 1) {
                this.commonTransforms = new SingleVOITransforms();
                object3 = ((SequenceAttribute)object4).iterator();
                while (object3.hasNext()) {
                    object2 = (SequenceItem)object3.next();
                    object = ((SequenceItem)object2).getAttributeList();
                    this.commonTransforms.add((AttributeList)object);
                }
            }
            if (attributeList.get(TagFromName.WindowCenter) != null && attributeList.get(TagFromName.WindowWidth) != null || attributeList.get(TagFromName.VOILUTSequence) != null) {
                if (this.commonTransforms == null) {
                    this.commonTransforms = new SingleVOITransforms();
                }
                this.commonTransforms.add(attributeList);
            }
        }
    }

    protected SingleVOITransforms getTransformsForFrame(int n) {
        SingleVOITransforms singleVOITransforms = this.arrayOfTransforms == null || n >= this.arrayOfTransforms.length ? this.commonTransforms : this.arrayOfTransforms[n];
        return singleVOITransforms;
    }

    public int getNumberOfTransforms(int n) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        return singleVOITransforms == null ? 0 : singleVOITransforms.size();
    }

    public boolean isWindowTransform(int n, int n2) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        SingleVOITransform singleVOITransform = (SingleVOITransform)singleVOITransforms.get(n2);
        return singleVOITransform != null && singleVOITransform instanceof VOIWindowTransform;
    }

    public boolean isLUTTransform(int n, int n2) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        SingleVOITransform singleVOITransform = (SingleVOITransform)singleVOITransforms.get(n2);
        return singleVOITransform != null && singleVOITransform instanceof VOILUTTransform;
    }

    public double getWidth(int n, int n2) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        SingleVOITransform singleVOITransform = (SingleVOITransform)singleVOITransforms.get(n2);
        return singleVOITransform == null ? 0.0 : (singleVOITransform instanceof VOIWindowTransform ? ((VOIWindowTransform)singleVOITransform).width : 0.0);
    }

    public double getCenter(int n, int n2) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        SingleVOITransform singleVOITransform = (SingleVOITransform)singleVOITransforms.get(n2);
        return singleVOITransform == null ? 0.0 : (singleVOITransform instanceof VOIWindowTransform ? ((VOIWindowTransform)singleVOITransform).center : 0.0);
    }

    public int getNumberOfEntries(int n, int n2) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        SingleVOITransform singleVOITransform = (SingleVOITransform)singleVOITransforms.get(n2);
        return singleVOITransform == null ? 0 : (singleVOITransform instanceof VOILUTTransform ? ((VOILUTTransform)singleVOITransform).numberOfEntries : 0);
    }

    public int getFirstValueMapped(int n, int n2) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        SingleVOITransform singleVOITransform = (SingleVOITransform)singleVOITransforms.get(n2);
        return singleVOITransform == null ? 0 : (singleVOITransform instanceof VOILUTTransform ? ((VOILUTTransform)singleVOITransform).firstValueMapped : 0);
    }

    public int getBitsPerEntry(int n, int n2) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        SingleVOITransform singleVOITransform = (SingleVOITransform)singleVOITransforms.get(n2);
        return singleVOITransform == null ? 0 : (singleVOITransform instanceof VOILUTTransform ? ((VOILUTTransform)singleVOITransform).bitsPerEntry : 0);
    }

    public int getEntryMinimum(int n, int n2) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        SingleVOITransform singleVOITransform = (SingleVOITransform)singleVOITransforms.get(n2);
        return singleVOITransform == null ? 0 : (singleVOITransform instanceof VOILUTTransform ? ((VOILUTTransform)singleVOITransform).entryMin : 0);
    }

    public int getEntryMaximum(int n, int n2) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        SingleVOITransform singleVOITransform = (SingleVOITransform)singleVOITransforms.get(n2);
        return singleVOITransform == null ? 0 : (singleVOITransform instanceof VOILUTTransform ? ((VOILUTTransform)singleVOITransform).entryMax : 0);
    }

    public int getTopOfEntryRange(int n, int n2) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        SingleVOITransform singleVOITransform = (SingleVOITransform)singleVOITransforms.get(n2);
        return singleVOITransform == null ? 0 : (singleVOITransform instanceof VOILUTTransform ? ((VOILUTTransform)singleVOITransform).topOfEntryRange : 0);
    }

    public short[] getLUTData(int n, int n2) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        SingleVOITransform singleVOITransform = (SingleVOITransform)singleVOITransforms.get(n2);
        return singleVOITransform == null ? null : (singleVOITransform instanceof VOILUTTransform ? ((VOILUTTransform)singleVOITransform).table : null);
    }

    public String getExplanation(int n, int n2) {
        SingleVOITransforms singleVOITransforms = this.getTransformsForFrame(n);
        SingleVOITransform singleVOITransform = (SingleVOITransform)singleVOITransforms.get(n2);
        return singleVOITransform == null ? "" : singleVOITransform.explanation;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Common = ");
        stringBuffer.append(this.commonTransforms == null ? "None" : this.commonTransforms.toString());
        stringBuffer.append("\n");
        if (this.arrayOfTransforms == null || this.arrayOfTransforms.length == 0) {
            stringBuffer.append("Frames: None\n");
        } else {
            for (int i = 0; i < this.arrayOfTransforms.length; ++i) {
                stringBuffer.append("[");
                stringBuffer.append(Integer.toString(i));
                stringBuffer.append("] = ");
                stringBuffer.append(this.arrayOfTransforms[i] == null ? "None" : this.arrayOfTransforms[i].toString());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private class SingleVOITransforms
    extends ArrayList {
        private SingleVOITransforms() {
        }

        void add(AttributeList attributeList) {
            SequenceAttribute sequenceAttribute;
            double[] dArray = Attribute.getDoubleValues(attributeList, TagFromName.WindowCenter);
            double[] dArray2 = Attribute.getDoubleValues(attributeList, TagFromName.WindowWidth);
            String[] stringArray = Attribute.getStringValues(attributeList, TagFromName.WindowCenterWidthExplanation);
            if (dArray != null && dArray2 != null) {
                int n = dArray.length;
                if (dArray2.length < n) {
                    n = dArray2.length;
                }
                for (int i = 0; i < n; ++i) {
                    this.add(new VOIWindowTransform(dArray[i], dArray2[i], stringArray != null && i < stringArray.length ? stringArray[i] : ""));
                }
            }
            if ((sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.VOILUTSequence)) != null) {
                Iterator iterator = sequenceAttribute.iterator();
                while (iterator.hasNext()) {
                    Attribute attribute;
                    SequenceItem sequenceItem = (SequenceItem)iterator.next();
                    AttributeList attributeList2 = sequenceItem.getAttributeList();
                    if (attributeList2 == null || (attribute = attributeList2.get(TagFromName.LUTDescriptor)) == null || attribute == null || attribute.getVM() != 3) continue;
                    try {
                        int n = attribute.getIntegerValues()[0];
                        if (n == 0) {
                            n = 65536;
                        }
                        int n2 = attribute.getIntegerValues()[1];
                        int n3 = attribute.getIntegerValues()[2];
                        Attribute attribute2 = attributeList2.get(TagFromName.LUTData);
                        if (attribute2 == null) continue;
                        short[] sArray = attribute2.getShortValues();
                        String string = Attribute.getDelimitedStringValuesOrEmptyString(attributeList2, TagFromName.LUTExplanation);
                        this.add(new VOILUTTransform(n, n2, n3, sArray, string));
                    }
                    catch (DicomException dicomException) {
                        dicomException.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    private class VOILUTTransform
    extends SingleVOITransform {
        int numberOfEntries;
        int firstValueMapped;
        int bitsPerEntry;
        short[] table;
        String explanation;
        int entryMin;
        int entryMax;
        int topOfEntryRange;

        VOILUTTransform(int n, int n2, int n3, short[] sArray, String string) {
            super(string);
            this.numberOfEntries = n;
            this.firstValueMapped = n2;
            this.bitsPerEntry = n3;
            this.table = sArray;
            if (sArray != null) {
                int n4;
                int n5;
                this.entryMin = (1 << n3) - 1;
                this.entryMax = 0;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = sArray[n5] & 0xFFFF;
                    if (n4 < this.entryMin) {
                        this.entryMin = n4;
                    }
                    if (n4 <= this.entryMax) continue;
                    this.entryMax = n4;
                }
                this.topOfEntryRange = (1 << n3) - 1;
                for (n5 = n3 - 1; n5 > 0 && (n4 = (1 << n5) - 1) >= this.entryMax; --n5) {
                    this.topOfEntryRange = n4;
                }
            }
        }

        public final String toString() {
            return "numberOfEntries=" + this.numberOfEntries + ",firstValueMapped=" + this.firstValueMapped + ",bitsPerEntry=" + this.bitsPerEntry + ",entryMin=" + this.entryMin + ",entryMax=" + this.entryMax + " explanation=" + this.explanation;
        }
    }

    private class VOIWindowTransform
    extends SingleVOITransform {
        double center;
        double width;

        VOIWindowTransform(double d, double d2, String string) {
            super(string);
            this.center = d;
            this.width = d2;
            this.explanation = string;
        }

        public final String toString() {
            return this.center + "," + this.width + " " + this.explanation;
        }
    }

    private class SingleVOITransform {
        String explanation;

        SingleVOITransform(String string) {
            this.explanation = string;
        }
    }
}

