/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.CFindRequestCommandMessage;
import com.pixelmed.network.CompositeResponseHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.IdentifierHandler;
import com.pixelmed.network.IdentifierMessage;
import com.pixelmed.network.PresentationContext;
import java.io.IOException;
import java.util.LinkedList;

public class FindSOPClassSCU
extends SOPClass {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/FindSOPClassSCU.java,v 1.20 2007/03/22 18:02:36 dclunie Exp $";
    private int debugLevel;

    public FindSOPClassSCU(String string, int n, String string2, String string3, String string4, AttributeList attributeList, IdentifierHandler identifierHandler, int n2) throws DicomNetworkException, DicomException, IOException {
        this.debugLevel = n2;
        if (n2 > 0) {
            System.err.println("FindSOPClassSCU(): request identifier");
        }
        if (n2 > 0) {
            System.err.print(attributeList);
        }
        LinkedList<PresentationContext> linkedList = new LinkedList<PresentationContext>();
        Object object = new LinkedList<String>();
        ((LinkedList)object).add("1.2.840.10008.1.2");
        ((LinkedList)object).add("1.2.840.10008.1.2.1");
        linkedList.add(new PresentationContext(1, string4, (LinkedList)object));
        linkedList.add(new PresentationContext(3, string4, "1.2.840.10008.1.2"));
        linkedList.add(new PresentationContext(5, string4, "1.2.840.10008.1.2.1"));
        object = AssociationFactory.createNewAssociation(string, n, string2, string3, linkedList, null, false, n2);
        if (n2 > 0) {
            System.err.println(object);
        }
        byte by = ((Association)object).getSuitablePresentationContextID(string4);
        if (n2 > 0) {
            System.err.println("Using context ID " + by);
        }
        byte[] byArray = new CFindRequestCommandMessage(string4).getBytes();
        byte[] byArray2 = new IdentifierMessage(attributeList, ((Association)object).getTransferSyntaxForPresentationContextID(by)).getBytes();
        ((Association)object).setReceivedDataHandler(new CFindResponseHandler(identifierHandler, n2));
        ((Association)object).send(by, byArray, null);
        ((Association)object).send(by, null, byArray2);
        if (n2 > 0) {
            System.err.println("FindSOPClassSCU: waiting for PDUs");
        }
        try {
            ((Association)object).waitForPDataPDUsUntilHandlerReportsDone();
            if (n2 > 0) {
                System.err.println("FindSOPClassSCU: got PDU, now releasing association");
            }
            ((Association)object).release();
        }
        catch (AReleaseException aReleaseException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length > 4 ? Integer.parseInt(stringArray[4]) : 1;
        try {
            SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet((String[])null);
            AttributeList attributeList = new AttributeList();
            attributeList.putNewAttribute(TagFromName.QueryRetrieveLevel).addValue("STUDY");
            attributeList.putNewAttribute(TagFromName.PatientName, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.PatientID, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.PatientBirthDate);
            attributeList.putNewAttribute(TagFromName.PatientSex);
            attributeList.putNewAttribute(TagFromName.StudyInstanceUID);
            attributeList.putNewAttribute(TagFromName.ReferringPhysicianName, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.ModalitiesInStudy);
            attributeList.putNewAttribute(TagFromName.StudyDescription, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.StudyID, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.AccessionNumber, specificCharacterSet);
            new FindSOPClassSCU(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3], "1.2.840.10008.5.1.4.1.2.2.1", attributeList, new IdentifierHandler(), n);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    private class CFindResponseHandler
    extends CompositeResponseHandler {
        private IdentifierHandler identifierHandler;

        CFindResponseHandler(IdentifierHandler identifierHandler, int n) {
            super(n);
            this.identifierHandler = identifierHandler;
            this.allowData = true;
        }

        protected void evaluateStatusAndSetSuccess(AttributeList attributeList) {
            if (this.debugLevel > 0) {
                System.err.println("FindSOPClassSCU.CFindResponseHandler.evaluateStatusAndSetSuccess:");
            }
            if (this.debugLevel > 0) {
                System.err.println(attributeList);
            }
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Status, 65535);
            if (this.debugLevel > 0) {
                System.err.println("FindSOPClassSCU.CFindResponseHandler.evaluateStatusAndSetSuccess: status = 0x" + Integer.toHexString(n));
            }
            boolean bl = this.success = n == 0;
            if (n != 65280 && n != 65281) {
                if (this.debugLevel > 0) {
                    System.err.println("FindSOPClassSCU.CFindResponseHandler.evaluateStatusAndSetSuccess: status no longer pending, so stop");
                }
                this.setDone(true);
            }
        }

        protected void makeUseOfDataSet(AttributeList attributeList) {
            if (this.debugLevel > 0) {
                System.err.println("FindSOPClassSCU.CFindResponseHandler.makeUseOfDataSet:");
            }
            if (this.debugLevel > 0) {
                System.err.print(attributeList);
            }
            try {
                this.identifierHandler.doSomethingWithIdentifier(attributeList);
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
        }
    }
}

