/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PresentationContext;
import java.util.LinkedList;
import java.util.Set;

public class PresentationContextListFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/PresentationContextListFactory.java,v 1.7 2005/10/16 17:02:55 dclunie Exp $";
    private static final int presentationContextIDStart = 1;
    private static final int presentationContextIDIncrement = 2;
    private static final int presentationContextIDMaximum = 255;
    private static boolean haveBzip2Support = PresentationContextListFactory.haveBzip2Support();
    private static String[][] supportedTransferSyntaxes = new String[][]{{"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2"}, {"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.2.840.10008.1.2.1.99"}, {"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.3.6.1.4.1.5962.300.1", "1.2.840.10008.1.2.1.99"}};

    private static final byte incrementPresentationContextID(byte by) throws DicomNetworkException {
        if ((by & 0xFF) >= 255) {
            throw new DicomNetworkException("Too many presentation contexts");
        }
        return (byte)(by + 2);
    }

    static boolean haveBzip2Support() {
        boolean bl = true;
        try {
            Class<?> clazz = Class.forName("org.apache.excalibur.bzip2.CBZip2InputStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public static LinkedList createNewPresentationContextList(String string, String string2, int n, boolean bl, boolean bl2, boolean bl3) throws DicomNetworkException {
        if (!(haveBzip2Support || n <= 1 || string2 != null && string2.equals("1.3.6.1.4.1.5962.300.1"))) {
            n = 1;
        }
        LinkedList linkedList = new LinkedList();
        byte by = 1;
        by = PresentationContextListFactory.addPresentationContextsForAbstractSyntax(linkedList, by, string, string2, n, bl, bl2, bl3);
        return linkedList;
    }

    public static LinkedList createNewPresentationContextList(String string, String string2, int n) throws DicomNetworkException {
        return PresentationContextListFactory.createNewPresentationContextList(string, string2, n, true, true, true);
    }

    public static LinkedList createNewPresentationContextList(Set set, int n, boolean bl, boolean bl2, boolean bl3) throws DicomNetworkException {
        if (!haveBzip2Support && n > 1) {
            n = 1;
        }
        LinkedList linkedList = new LinkedList();
        byte by = 1;
        for (String string : set) {
            by = PresentationContextListFactory.addPresentationContextsForAbstractSyntax(linkedList, by, string, null, n, bl, bl2, false);
        }
        return linkedList;
    }

    public static LinkedList createNewPresentationContextList(Set set, int n) throws DicomNetworkException {
        return PresentationContextListFactory.createNewPresentationContextList(set, n, true, true, true);
    }

    public static LinkedList createNewPresentationContextList(SetOfDicomFiles setOfDicomFiles, int n, boolean bl, boolean bl2, boolean bl3) throws DicomNetworkException {
        return PresentationContextListFactory.createNewPresentationContextList(setOfDicomFiles.getSetOfSOPClassUIDs(), n, bl, bl2, bl3);
    }

    public static LinkedList createNewPresentationContextList(SetOfDicomFiles setOfDicomFiles, int n) throws DicomNetworkException {
        return PresentationContextListFactory.createNewPresentationContextList(setOfDicomFiles, n, true, true, true);
    }

    private static byte addPresentationContextsForAbstractSyntax(LinkedList linkedList, byte by, String string, String string2, int n, boolean bl, boolean bl2, boolean bl3) throws DicomNetworkException {
        if (bl) {
            LinkedList<String> linkedList2 = new LinkedList<String>();
            if (string2 != null && string2.length() > 0) {
                linkedList2.add(string2);
            }
            for (int i = 0; i < supportedTransferSyntaxes[n].length; ++i) {
                if (string2 != null && string2.equals(supportedTransferSyntaxes[n][i])) continue;
                linkedList2.add(supportedTransferSyntaxes[n][i]);
            }
            linkedList.add(new PresentationContext(by, string, linkedList2));
        }
        if (bl3 && string2 != null && string2.length() > 0) {
            by = PresentationContextListFactory.incrementPresentationContextID(by);
            linkedList.add(new PresentationContext(by, string, string2));
        }
        if (bl2) {
            for (int i = 0; i < supportedTransferSyntaxes[n].length; ++i) {
                by = PresentationContextListFactory.incrementPresentationContextID(by);
                if (string2 != null && string2.equals(supportedTransferSyntaxes[n][i])) continue;
                linkedList.add(new PresentationContext(by, string, supportedTransferSyntaxes[n][i]));
            }
        }
        return PresentationContextListFactory.incrementPresentationContextID(by);
    }
}

