/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class Syslog {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/Syslog.java,v 1.6 2003/11/28 19:00:39 dclunie Exp $";
    public static final int KERN = 0;
    public static final int USER = 8;
    public static final int MAIL = 16;
    public static final int DAEMON = 24;
    public static final int AUTH = 32;
    public static final int SYSLOG = 40;
    public static final int LPR = 48;
    public static final int NEWS = 56;
    public static final int UUCP = 64;
    public static final int CRON = 120;
    public static final int LOCAL0 = 128;
    public static final int LOCAL1 = 136;
    public static final int LOCAL2 = 144;
    public static final int LOCAL3 = 152;
    public static final int LOCAL4 = 160;
    public static final int LOCAL5 = 168;
    public static final int LOCAL6 = 176;
    public static final int LOCAL7 = 184;
    private static Map facilityByName;
    public static final int EMERG = 0;
    public static final int ALERT = 1;
    public static final int CRIT = 2;
    public static final int ERR = 3;
    public static final int WARNING = 4;
    public static final int NOTICE = 5;
    public static final int INFO = 6;
    public static final int DEBUG = 7;
    private static Map priorityByName;
    private static final int SYSLOG_PORT = 514;
    private InetAddress address;
    private DatagramSocket socket;

    private static void makeFacilityByName() {
        facilityByName = new HashMap();
        facilityByName.put("kern", new Integer(0));
        facilityByName.put("user", new Integer(8));
        facilityByName.put("mail", new Integer(16));
        facilityByName.put("daemon", new Integer(24));
        facilityByName.put("auth", new Integer(32));
        facilityByName.put("syslog", new Integer(40));
        facilityByName.put("lpr", new Integer(48));
        facilityByName.put("news", new Integer(56));
        facilityByName.put("uucp", new Integer(64));
        facilityByName.put("cron", new Integer(120));
        facilityByName.put("local0", new Integer(128));
        facilityByName.put("local1", new Integer(136));
        facilityByName.put("local2", new Integer(144));
        facilityByName.put("local3", new Integer(152));
        facilityByName.put("local4", new Integer(160));
        facilityByName.put("local5", new Integer(168));
        facilityByName.put("local6", new Integer(176));
        facilityByName.put("local7", new Integer(184));
    }

    public int getFacilityByName(String string) {
        return (Integer)facilityByName.get(string.toLowerCase());
    }

    private static void makePriorityByName() {
        priorityByName = new HashMap();
        priorityByName.put("emerg", new Integer(0));
        priorityByName.put("alert", new Integer(1));
        priorityByName.put("crit", new Integer(2));
        priorityByName.put("err", new Integer(3));
        priorityByName.put("warning", new Integer(4));
        priorityByName.put("notice", new Integer(5));
        priorityByName.put("info", new Integer(6));
        priorityByName.put("debug", new Integer(7));
    }

    public int getPriorityByName(String string) {
        return (Integer)priorityByName.get(string.toLowerCase());
    }

    public Syslog(String string) throws UnknownHostException, SocketException {
        this.address = InetAddress.getByName(string);
        this.socket = new DatagramSocket();
        this.socket.connect(this.address, 514);
        if (facilityByName == null) {
            Syslog.makeFacilityByName();
        }
        if (priorityByName == null) {
            Syslog.makePriorityByName();
        }
    }

    public final void send(int n, int n2, String string) throws IOException, UnknownHostException, SocketException {
        String string2 = "<" + Integer.toString(n + n2) + ">" + string;
        byte[] byArray = string2.getBytes();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        this.socket.send(datagramPacket);
    }

    public static void main(String[] stringArray) {
        try {
            Syslog syslog = new Syslog("localhost");
            syslog.send(syslog.getFacilityByName("local6"), syslog.getPriorityByName("notice"), "deidentify: dclunie - hello again more");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

