/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class HttpServer
implements Runnable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/HttpServer.java,v 1.7 2005/09/25 12:51:45 dclunie Exp $";
    private int port;
    private int numberOfWorkers;
    private Vector threadPool;
    protected int webServerDebugLevel;

    public HttpServer(int n) {
        this.webServerDebugLevel = n;
    }

    public HttpServer(int n, int n2) {
        this.webServerDebugLevel = n2;
        this.initializeThreadPool(n);
    }

    public void initializeThreadPool(int n) {
        if (this.webServerDebugLevel > 1) {
            System.err.println("HttpServer.initializeThreadPool(): start");
        }
        this.port = n;
        this.numberOfWorkers = 20;
        this.threadPool = new Vector();
        for (int i = 0; i < this.numberOfWorkers; ++i) {
            Worker worker = this.createWorker();
            new Thread((Runnable)worker, "worker #" + i).start();
            this.threadPool.addElement(worker);
        }
        if (this.webServerDebugLevel > 1) {
            System.err.println("HttpServer.initializeThreadPool(): end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        if (this.webServerDebugLevel > 1) {
            System.err.println("HttpServer.run(): start");
        }
        try {
            ServerSocket serverSocket = new ServerSocket(this.port);
            while (true) {
                Socket socket = serverSocket.accept();
                Worker worker = null;
                Vector vector = this.threadPool;
                synchronized (vector) {
                    if (this.threadPool.isEmpty()) {
                        if (this.webServerDebugLevel > 1) {
                            System.err.println("HttpServer.run(): additional worker");
                        }
                        Worker worker2 = this.createWorker();
                        worker2.setSocket(socket);
                        new Thread((Runnable)worker2, "additional worker").start();
                    } else {
                        worker = (Worker)this.threadPool.elementAt(0);
                        this.threadPool.removeElementAt(0);
                        worker.setSocket(socket);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    protected abstract Worker createWorker();

    protected abstract class Worker
    implements Runnable {
        private Socket socket;

        protected Worker() {
        }

        private synchronized void setSocket(Socket socket) {
            this.socket = socket;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (HttpServer.this.webServerDebugLevel > 1) {
                System.err.println("HttpServer.Worker.run(): start");
            }
            while (true) {
                if (this.socket == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                }
                try {
                    this.handleConnection();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (HttpServer.this.webServerDebugLevel > 1) {
                    System.err.println("HttpServer.Worker.run(): done");
                }
                this.socket = null;
                Vector vector = HttpServer.this.threadPool;
                synchronized (vector) {
                    if (HttpServer.this.threadPool.size() >= HttpServer.this.numberOfWorkers) {
                        if (HttpServer.this.webServerDebugLevel > 1) {
                            System.err.println("HttpServer.Worker.run(): not needed");
                        }
                        return;
                    }
                    if (HttpServer.this.webServerDebugLevel > 1) {
                        System.err.println("HttpServer.Worker.run(): going back into pool");
                    }
                    HttpServer.this.threadPool.addElement(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleConnection() {
            if (HttpServer.this.webServerDebugLevel > 1) {
                System.err.println("HttpServer.Worker.handleConnection():");
            }
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                Vector<String> vector = new Vector<String>();
                while ((string = bufferedReader.readLine()) != null && string.length() > 0) {
                    if (HttpServer.this.webServerDebugLevel > 1) {
                        System.err.println("HttpServer.Worker.handleConnection(): read line=\"" + string + "\"");
                    }
                    vector.add(string);
                }
                if (vector.size() > 0) {
                    StringTokenizer stringTokenizer;
                    String string2 = (String)vector.get(0);
                    if (HttpServer.this.webServerDebugLevel > 1) {
                        System.err.println("HttpServer.Worker.handleConnection(): requestLine=\"" + string2 + "\"");
                    }
                    if ((stringTokenizer = new StringTokenizer(string2, " ")).countTokens() != 3) {
                        printWriter.print("HTTP/1.1 400 Bad Request\r\n");
                        printWriter.flush();
                    } else {
                        String string3 = stringTokenizer.nextToken();
                        String string4 = stringTokenizer.nextToken();
                        String string5 = stringTokenizer.nextToken();
                        if (string5 == null || !string5.equals("HTTP/1.0") && !string5.equals("HTTP/1.1")) {
                            printWriter.print("HTTP/1.1 505 HTTP Version Not Supported\r\n");
                            printWriter.flush();
                        } else if (string3 != null) {
                            if (string3.equals("GET")) {
                                this.generateResponseToGetRequest(string4, this.socket.getOutputStream());
                            } else {
                                printWriter.print("HTTP/1.1 501 Not Implemented\r\n");
                                printWriter.flush();
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            finally {
                try {
                    if (HttpServer.this.webServerDebugLevel > 1) {
                        System.err.println("HttpServer.Worker.handleConnection(): closing socket");
                    }
                    this.socket.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }

        protected abstract void generateResponseToGetRequest(String var1, OutputStream var2) throws IOException;
    }
}

