/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.WebRequest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

class PathRequestHandler
extends RequestHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/PathRequestHandler.java,v 1.7 2006/05/16 10:16:48 dclunie Exp $";
    private static final String faviconPath = "favicon.ico";
    private static final String actualIndexPath = "index.html";

    protected PathRequestHandler(String string, int n) {
        super(string, n);
    }

    protected void generateResponseToGetRequest(DatabaseInformationModel databaseInformationModel, String string, String string2, WebRequest webRequest, String string3, OutputStream outputStream) throws IOException {
        block24: {
            try {
                String string4 = webRequest.getPath();
                if (this.webServerDebugLevel > 0) {
                    System.err.println("PathRequestHandler.generateResponseToGetRequest(): Was asked for requestPath " + string4);
                }
                if (string4 == null) {
                    throw new Exception("No such path - path is null - =\"" + string4 + "\"");
                }
                if (string4.equals("/") || string4.toLowerCase().equals("/index.html") || string4.toLowerCase().equals("/index.htm")) {
                    if (this.webServerDebugLevel > 1) {
                        System.err.println("PathRequestHandler.generateResponseToGetRequest(): root path");
                    }
                    string4 = "/index.html";
                }
                if (string4.equals("/" + this.stylesheetPath) || string4.equals("/favicon.ico") || string4.equals("/index.html") || string4.startsWith("/dicomviewer")) {
                    String string5;
                    InputStream inputStream;
                    if (this.webServerDebugLevel > 1) {
                        System.err.println("PathRequestHandler.generateResponseToGetRequest(): Was asked for file " + string4);
                    }
                    String string6 = new File(string4).getName();
                    if (string4.startsWith("/dicomviewer")) {
                        string6 = "dicomviewer/" + string6;
                    }
                    if (this.webServerDebugLevel > 1) {
                        System.err.println("PathRequestHandler.generateResponseToGetRequest(): Trying to find amongst resources " + string6);
                    }
                    String string7 = "/" + string6;
                    if (this.webServerDebugLevel > 2) {
                        System.err.println("PathRequestHandler.generateResponseToGetRequest(): Looking for " + string7);
                    }
                    if ((inputStream = PathRequestHandler.class.getResourceAsStream(string7)) == null) {
                        string7 = "/com/pixelmed/web/" + string6;
                        if (this.webServerDebugLevel > 2) {
                            System.err.println("PathRequestHandler.generateResponseToGetRequest(): Failed; so look instead for " + string7);
                        }
                        if ((inputStream = PathRequestHandler.class.getResourceAsStream(string7)) == null) {
                            throw new Exception("No such resource as " + string4);
                        }
                    }
                    boolean bl = false;
                    if (string6.matches(".*[.][cC][sS][sS]$")) {
                        string5 = "text/css";
                        bl = true;
                    } else if (string6.matches(".*[.][hH][tT][mM][lL]*$")) {
                        string5 = "text/html";
                        bl = true;
                    } else {
                        string5 = string6.matches(".*[.][iI][cC][oO]$") ? "image/x-icon" : "application/octet-stream";
                    }
                    if (this.webServerDebugLevel > 1) {
                        System.err.println("PathRequestHandler.generateResponseToGetRequest(): contentType " + string5);
                    }
                    if (bl) {
                        int n;
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(inputStream), "UTF-8");
                        StringBuffer stringBuffer = new StringBuffer();
                        char[] cArray = new char[1024];
                        while ((n = inputStreamReader.read(cArray, 0, 1024)) > 0) {
                            if (this.webServerDebugLevel > 2) {
                                System.err.println("PathRequestHandler.generateResponseToGetRequest(): Read " + n + " chars");
                            }
                            stringBuffer.append(cArray, 0, n);
                        }
                        this.sendHeaderAndBodyText(outputStream, stringBuffer.toString(), string6, string5);
                    } else {
                        this.sendHeaderAndBodyOfStream(outputStream, inputStream, string6, string5);
                    }
                    break block24;
                }
                throw new Exception("No such path is permitted =\"" + string4 + "\"");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                if (this.webServerDebugLevel > 0) {
                    System.err.println("PathRequestHandler.generateResponseToGetRequest(): Sending 404 Not Found");
                }
                PathRequestHandler.send404NotFound(outputStream, exception.getMessage());
            }
        }
    }
}

