/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.web.AppletDisplayRequestHandler;
import com.pixelmed.web.HttpServer;
import com.pixelmed.web.ImageDisplayRequestHandler;
import com.pixelmed.web.InstanceListRequestHandler;
import com.pixelmed.web.PathRequestHandler;
import com.pixelmed.web.PatientListRequestHandler;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.SeriesListRequestHandler;
import com.pixelmed.web.StudyListRequestHandler;
import com.pixelmed.web.WadoRequestHandler;
import com.pixelmed.web.WebRequest;
import com.pixelmed.web.WebServerApplicationProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RequestTypeServer
extends HttpServer {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/RequestTypeServer.java,v 1.15 2006/10/08 17:09:51 dclunie Exp $";
    private static final String imageDisplayTemplateFileName = "ImageDisplayTemplate.tpl";
    private static final String appletDisplayTemplateFileName = "AppletDisplayTemplate.tpl";
    private String rootURL;
    private String stylesheetPath;
    private String requestTypeToUseForInstances;
    private DatabaseInformationModel databaseInformationModel;

    protected HttpServer.Worker createWorker() {
        return new RequestTypeWorker();
    }

    public RequestTypeServer(String string, String string2, int n, String string3, int n2, int n3, int n4, String string4, String string5, String string6) {
        super(n4);
        try {
            this.databaseInformationModel = new PatientStudySeriesConcatenationInstanceModel(string);
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            new Thread(new StorageSOPClassSCPDispatcher(n, string3, file, new OurReceivedObjectHandler(), null, null, null, false, n2)).start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        this.doCommonConstructorStuff(this.databaseInformationModel, n3, string4, string5, string6);
    }

    public RequestTypeServer(DatabaseInformationModel databaseInformationModel, WebServerApplicationProperties webServerApplicationProperties) {
        super(webServerApplicationProperties.getWebServerDebugLevel());
        this.doCommonConstructorStuff(databaseInformationModel, webServerApplicationProperties.getListeningPort(), webServerApplicationProperties.getRootURL(), webServerApplicationProperties.getStylesheetPath(), webServerApplicationProperties.getRequestTypeToUseForInstances());
    }

    public RequestTypeServer(DatabaseInformationModel databaseInformationModel, int n, int n2, String string, String string2, String string3) {
        super(n2);
        this.doCommonConstructorStuff(databaseInformationModel, n, string, string2, string3);
    }

    private void doCommonConstructorStuff(DatabaseInformationModel databaseInformationModel, int n, String string, String string2, String string3) {
        this.rootURL = string;
        if (this.webServerDebugLevel > 1) {
            System.err.println("RequestTypeServer.doCommonConstructorStuff(): rootURL = " + string);
        }
        this.stylesheetPath = string2;
        if (this.webServerDebugLevel > 1) {
            System.err.println("RequestTypeServer.doCommonConstructorStuff(): stylesheetPath = " + string2);
        }
        this.databaseInformationModel = databaseInformationModel;
        this.requestTypeToUseForInstances = string3;
        try {
            if (this.webServerDebugLevel > 1) {
                System.err.println("RequestTypeServer.doCommonConstructorStuff(): port = " + n);
            }
            super.initializeThreadPool(n);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        if (this.webServerDebugLevel > 0) {
            System.err.println("RequestTypeServer(): ready");
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 7 && stringArray.length != 9) {
            System.err.println("Usage: database imagefolder DICOMport DICOMAET HTTPport hostAddress requesttype [storageSCPDebugLevel [webServerDebugLevel]]");
            System.exit(0);
        }
        String string = "stylesheet.css";
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        int n = Integer.parseInt(stringArray[2]);
        String string4 = stringArray[3];
        int n2 = Integer.parseInt(stringArray[4]);
        String string5 = "http://" + stringArray[5] + ":" + stringArray[4] + "/";
        String string6 = stringArray[6];
        int n3 = stringArray.length > 7 ? Integer.parseInt(stringArray[7]) : 0;
        int n4 = stringArray.length > 8 ? Integer.parseInt(stringArray[8]) : 0;
        new Thread(new RequestTypeServer(string2, string3, n, string4, n3, n2, n4, string5, string, string6)).start();
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                if (RequestTypeServer.this.webServerDebugLevel > 0) {
                    System.err.println("Received: " + string + " from " + string3 + " in " + string2);
                }
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    fileInputStream.close();
                    RequestTypeServer.this.databaseInformationModel.insertObject(attributeList, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }

    protected class RequestTypeWorker
    extends HttpServer.Worker {
        private PathRequestHandler pathRequestHandler = null;
        private WadoRequestHandler wadoRequestHandler = null;
        private PatientListRequestHandler patientListRequestHandler = null;
        private StudyListRequestHandler studyListRequestHandler = null;
        private SeriesListRequestHandler seriesListRequestHandler = null;
        private InstanceListRequestHandler instanceListRequestHandler = null;
        private ImageDisplayRequestHandler imageDisplayRequestHandler = null;
        private AppletDisplayRequestHandler appletDisplayRequestHandler = null;

        protected RequestTypeWorker() {
        }

        protected void generateResponseToGetRequest(String string, OutputStream outputStream) throws IOException {
            block20: {
                if (RequestTypeServer.this.webServerDebugLevel > 0) {
                    System.err.println("RequestTypeServer.RequestTypeWorker.generateResponseToGetRequest(): Requested URI: " + string);
                }
                try {
                    WebRequest webRequest = new WebRequest(string);
                    String string2 = webRequest.getRequestType();
                    if (string2 == null) {
                        if (this.pathRequestHandler == null) {
                            this.pathRequestHandler = new PathRequestHandler(RequestTypeServer.this.stylesheetPath, RequestTypeServer.this.webServerDebugLevel);
                        }
                        this.pathRequestHandler.generateResponseToGetRequest(null, null, null, webRequest, null, outputStream);
                        break block20;
                    }
                    if (string2.equals("WADO")) {
                        if (this.wadoRequestHandler == null) {
                            this.wadoRequestHandler = new WadoRequestHandler(null, RequestTypeServer.this.webServerDebugLevel);
                        }
                        this.wadoRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, null, null, webRequest, null, outputStream);
                        break block20;
                    }
                    if (string2.equals("PATIENTLIST")) {
                        if (this.patientListRequestHandler == null) {
                            this.patientListRequestHandler = new PatientListRequestHandler(RequestTypeServer.this.stylesheetPath, RequestTypeServer.this.webServerDebugLevel);
                        }
                        this.patientListRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, RequestTypeServer.this.rootURL, null, null, null, outputStream);
                        break block20;
                    }
                    if (string2.equals("STUDYLIST")) {
                        if (this.studyListRequestHandler == null) {
                            this.studyListRequestHandler = new StudyListRequestHandler(RequestTypeServer.this.stylesheetPath, RequestTypeServer.this.webServerDebugLevel);
                        }
                        this.studyListRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, RequestTypeServer.this.rootURL, null, webRequest, null, outputStream);
                        break block20;
                    }
                    if (string2.equals("SERIESLIST")) {
                        if (this.seriesListRequestHandler == null) {
                            this.seriesListRequestHandler = new SeriesListRequestHandler(RequestTypeServer.this.stylesheetPath, RequestTypeServer.this.requestTypeToUseForInstances, RequestTypeServer.this.webServerDebugLevel);
                        }
                        this.seriesListRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, RequestTypeServer.this.rootURL, null, webRequest, null, outputStream);
                        break block20;
                    }
                    if (string2.equals("INSTANCELIST")) {
                        if (this.instanceListRequestHandler == null) {
                            this.instanceListRequestHandler = new InstanceListRequestHandler(RequestTypeServer.this.stylesheetPath, RequestTypeServer.this.webServerDebugLevel);
                        }
                        this.instanceListRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, RequestTypeServer.this.rootURL, null, webRequest, null, outputStream);
                        break block20;
                    }
                    if (string2.equals("IMAGEDISPLAY")) {
                        if (this.imageDisplayRequestHandler == null) {
                            this.imageDisplayRequestHandler = new ImageDisplayRequestHandler(RequestTypeServer.this.stylesheetPath, RequestTypeServer.imageDisplayTemplateFileName, RequestTypeServer.this.webServerDebugLevel);
                        }
                        this.imageDisplayRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, RequestTypeServer.this.rootURL, null, webRequest, null, outputStream);
                        break block20;
                    }
                    if (string2.equals("APPLETDISPLAY")) {
                        if (this.appletDisplayRequestHandler == null) {
                            this.appletDisplayRequestHandler = new AppletDisplayRequestHandler(RequestTypeServer.this.stylesheetPath, RequestTypeServer.appletDisplayTemplateFileName, RequestTypeServer.this.webServerDebugLevel);
                        }
                        this.appletDisplayRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, RequestTypeServer.this.rootURL, null, webRequest, null, outputStream);
                        break block20;
                    }
                    throw new Exception("Unrecognized requestType \"" + string2 + "\"");
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    if (RequestTypeServer.this.webServerDebugLevel > 0) {
                        System.err.println("RequestTypeServer.RequestTypeWorker.generateResponseToGetRequest(): Sending 404 Not Found");
                    }
                    RequestHandler.send404NotFound(outputStream, exception.getMessage());
                }
            }
        }
    }
}

