/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.WebRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

class SeriesListRequestHandler
extends RequestHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/SeriesListRequestHandler.java,v 1.4 2006/01/06 16:44:06 dclunie Exp $";
    protected String requestTypeToUseForInstances;
    private Comparator compareDatabaseAttributesBySeriesNumber = new CompareDatabaseAttributesBySeriesNumber();

    protected SeriesListRequestHandler(String string, String string2, int n) {
        super(string, n);
        this.requestTypeToUseForInstances = string2;
    }

    protected void generateResponseToGetRequest(DatabaseInformationModel databaseInformationModel, String string, String string2, WebRequest webRequest, String string3, OutputStream outputStream) throws IOException {
        try {
            Map map = webRequest.getParameters();
            if (map == null) {
                throw new Exception("Missing parameters for requestType \"" + string3 + "\"");
            }
            String string4 = (String)map.get("primaryKey");
            if (string4 == null || string4.length() == 0) {
                throw new Exception("Missing primaryKey parameter for requestType \"" + string3 + "\"");
            }
            String string5 = (String)map.get("studyUID");
            if (string5 == null || string5.length() == 0) {
                throw new Exception("Missing studyUID parameter for requestType \"" + string3 + "\"");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append("<head>");
            if (this.stylesheetPath != null) {
                stringBuffer.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
                stringBuffer.append(string);
                stringBuffer.append(this.stylesheetPath);
                stringBuffer.append("\">");
            }
            stringBuffer.append("</head>\r\n");
            stringBuffer.append("<body><table>\r\n");
            stringBuffer.append("<tr><th>Series #</th><th>Series Date</th><th>Series Time</th><th>Modality</th><th>Series Description</th></tr>\r\n");
            String string6 = databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.SERIES).toUpperCase();
            ArrayList arrayList = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(InformationEntity.SERIES, string4);
            Collections.sort(arrayList, this.compareDatabaseAttributesBySeriesNumber);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Map map2 = (Map)arrayList.get(i);
                String string7 = (String)map2.get("SERIESNUMBER");
                String string8 = (String)map2.get("SERIESDATE");
                String string9 = (String)map2.get("SERIESTIME");
                String string10 = (String)map2.get("MODALITY");
                String string11 = (String)map2.get("SERIESDESCRIPTION");
                String string12 = (String)map2.get("SERIESINSTANCEUID");
                String string13 = (String)map2.get(string6);
                stringBuffer.append("<tr>");
                stringBuffer.append("<td class=\"centered\">");
                stringBuffer.append("<a href=\"");
                stringBuffer.append(string);
                stringBuffer.append("?requestType=");
                stringBuffer.append(this.requestTypeToUseForInstances);
                stringBuffer.append("&primaryKey=");
                stringBuffer.append(string13);
                stringBuffer.append("&studyUID=");
                stringBuffer.append(string5);
                stringBuffer.append("&seriesUID=");
                stringBuffer.append(string12);
                stringBuffer.append("\">");
                stringBuffer.append(string7 == null || string7.length() == 0 ? "NONE" : string7);
                stringBuffer.append("</a>");
                stringBuffer.append("</td>");
                stringBuffer.append("<td class=\"centered\">");
                stringBuffer.append(string8 == null ? "&nbsp;" : string8);
                stringBuffer.append("</span>");
                stringBuffer.append("</td>");
                stringBuffer.append("<td class=\"centered\">");
                stringBuffer.append(string9 == null ? "&nbsp;" : string9);
                stringBuffer.append("</td>");
                stringBuffer.append("<td class=\"centered\">");
                stringBuffer.append(string10 == null ? "&nbsp;" : string10);
                stringBuffer.append("</td>");
                stringBuffer.append("<td>");
                stringBuffer.append(string11 == null ? "&nbsp;" : string11);
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
            }
            stringBuffer.append("</table></body></html>\r\n");
            String string14 = stringBuffer.toString();
            this.sendHeaderAndBodyText(outputStream, string14, "series.html", "text/html");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            if (this.webServerDebugLevel > 0) {
                System.err.println("SeriesListRequestHandler.generateResponseToGetRequest(): Sending 404 Not Found");
            }
            SeriesListRequestHandler.send404NotFound(outputStream, exception.getMessage());
        }
    }

    private class CompareDatabaseAttributesBySeriesNumber
    implements Comparator {
        private CompareDatabaseAttributesBySeriesNumber() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            String string = (String)((Map)object).get("SERIESNUMBER");
            String string2 = (String)((Map)object2).get("SERIESNUMBER");
            try {
                int n2 = Integer.parseInt(string);
                int n3 = Integer.parseInt(string2);
                n = n2 - n3;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
            return n;
        }
    }
}

