/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBStatement;
import oracle.jdbc.driver.OracleCancelThread;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.util.RepConversion;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

public class OracleStatement
implements oracle.jdbc.internal.OracleStatement,
ScrollRsetStatement {
    static final boolean DEBUG = false;
    static final boolean DEBUG_DATASET = false;
    static final int VALID_ROWS_UNINIT = -999;
    DBColumn[] dbdescription;
    DBDataSet binds_out = null;
    DBDataSet binds_in = null;
    public DBDataSet defines;
    OracleConnection connection;
    OracleInputStream streams;
    InputStream[] stream_array;
    OracleResultSetImpl current_result_set;
    boolean process_escapes;
    protected int m_queryTimeout;
    public DBStatement dbstmt;
    int batch;
    protected int m_currentRank;
    int current_row;
    int valid_rows;
    int max_field_size;
    int max_rows;
    int total_rows_visited;
    int row_prefetch;
    int default_row_prefetch;
    boolean row_prefetch_changed;
    boolean got_last_batch;
    boolean clear_params;
    public boolean closed;
    boolean sql_string_changed;
    String sql_query;
    boolean need_to_parse;
    boolean need_to_prepare_define_buffer;
    boolean columns_defined_by_user;
    byte sql_kind;
    byte[] array_sql;
    public int auto_rollback;
    public int wait_option;
    private int m_lastFetchedColumn;
    private DBDataSet m_currentDataSet;
    int default_fetch_direction;
    boolean m_autoRefetch;
    boolean serverCursor;
    boolean fixedString = false;
    OracleResultSet m_scrollRset;
    oracle.jdbc.OracleResultSetCache m_cache;
    int m_userRsetType;
    int m_realRsetType;
    static int DEFAULT_RSET_TYPE = 1;
    String m_originalSql;
    String m_revisedSql;
    boolean m_needToAddIdentifier;
    SQLWarning m_warning;
    static int CLOSED = 0;
    static int ACTIVE = 1;
    static int CACHE = 2;
    static int NON_CACHED = 3;
    OracleStatement next = null;
    OracleStatement prev = null;
    int m_cacheState = ACTIVE;
    int m_stmtType = 0;
    int m_createState = 0;
    String m_key = null;
    boolean columnSetNull = false;
    boolean last_was_column;
    int last_index;
    private Vector m_batchItems = new Vector();

    public OracleStatement(OracleConnection oracleConnection, int n, int n2) throws SQLException {
        this.connection = oracleConnection;
        try {
            this.connection.needLine();
            this.dbstmt = this.connection.db_access.open();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.initialize(n, n2, false);
    }

    public OracleStatement(OracleConnection oracleConnection, int n, int n2, int n3, int n4) throws SQLException {
        this(oracleConnection, n, n2);
        this.m_realRsetType = 0;
        this.m_userRsetType = ResultSetUtil.getRsetTypeCode(n3, n4);
        this.m_needToAddIdentifier = ResultSetUtil.needIdentifier(this.m_userRsetType);
    }

    public OracleStatement(OracleConnection oracleConnection, DBStatement dBStatement, int n, int n2) throws SQLException {
        this.connection = oracleConnection;
        DBAccess dBAccess = this.connection.db_access;
        this.dbstmt = dBStatement;
        boolean bl = dBAccess.getFetchOnNewRefCursor();
        this.initialize(n, n2, true);
        this.prepare_for_new_result(true);
        this.current_result_set = new OracleResultSetImpl(this.connection, this);
        this.current_result_set.close_statement_on_close = true;
        try {
            this.connection.needLine();
            this.dbdescription = this.connection.db_access.describe(this.dbstmt);
            this.need_to_parse = false;
            this.doDefaultTypes();
            this.doDefinesFromTypes();
            this.need_to_prepare_define_buffer = false;
            if (bl) {
                this.connection.needLine();
                this.valid_rows = dBAccess.fetch(this.dbstmt, this.defines, this.row_prefetch);
            }
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        if (bl) {
            this.checkValidRowsStatus();
        }
    }

    public synchronized void addBatch(String string) throws SQLException {
        this.addBatchItem(string);
    }

    private void addBatchItem(String string) {
        this.m_batchItems.addElement(string);
    }

    void adjustUserDefines(int n) throws SQLException {
        if (n == 1) {
            this.defines.prependRowidColumn();
        } else if (n == -1) {
            this.columns_defined_by_user = true;
            this.need_to_prepare_define_buffer = true;
            this.defines.removeRowidColumn();
        }
    }

    public void cancel() throws SQLException {
        try {
            if (this.connection.statement_holding_line != null) {
                this.freeLine();
            } else {
                this.connection.db_access.cancel();
            }
            this.connection.releaseLine();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
    }

    void checkBindsInAndOut() throws SQLException {
        if (!this.clear_params) {
            return;
        }
        this.clear_params = false;
        int n = -1;
        if (this.binds_in != null) {
            n = this.binds_in.checkBindsInAndOut(this.binds_out, this.m_currentRank);
        } else if (this.binds_out != null) {
            n = this.binds_out.checkBindsInAndOut(null, this.m_currentRank);
        }
        if (n != -1) {
            DBError.throwSqlException(41, new Integer(n + 1));
        }
    }

    private void checkIfJdbcBatchExists() throws SQLException {
        if (this.getBatchSize() > 0) {
            DBError.throwSqlException(81, "batch must be either executed or cleared");
        }
    }

    void checkValidRowsStatus() {
        if (this.valid_rows == -2) {
            this.valid_rows = 1;
            this.connection.holdLine(this);
            if (this.streams != null) {
                this.streams.resetLong();
            }
        } else if (this.sql_kind == 0 && this.valid_rows < this.row_prefetch) {
            this.got_last_batch = true;
        }
    }

    void check_defines() throws SQLException {
        int n;
        if (this.defines.getNoOfArgs() == 0) {
            DBError.throwSqlException(21);
        }
        if ((n = this.defines.getMissingType()) != -1) {
            DBError.throwSqlException(22, new Integer(n + 1));
        }
    }

    void check_row_prefetch_changed() throws SQLException {
        if (this.row_prefetch_changed) {
            if (!this.defines.hasStreamType()) {
                this.defines.setBatchSize(this.row_prefetch);
                this.need_to_parse = true;
            }
            this.row_prefetch_changed = false;
            this.dbstmt.setDefinesInitialized(false);
        }
    }

    private void cleanup() {
        int n;
        if (this.defines != null) {
            this.defines.cleanup();
            this.defines = null;
        }
        this.streams = null;
        if (this.dbdescription != null) {
            n = 0;
            while (n < this.dbdescription.length) {
                this.dbdescription[n] = null;
                ++n;
            }
            this.dbdescription = null;
        }
        if (this.stream_array != null) {
            n = 0;
            while (n < this.stream_array.length) {
                this.stream_array[n] = null;
                ++n;
            }
            this.stream_array = null;
        }
        this.m_currentDataSet = null;
    }

    protected final void cleanupForBatching() {
        if (this.binds_in != null && this.binds_in.getNoOfArgs() > 0 && this.binds_in.isDynamic()) {
            this.binds_in.clearItems();
        }
        this.m_currentRank = 0;
    }

    public synchronized void clearBatch() throws SQLException {
        this.clearBatchItems();
    }

    private void clearBatchItems() {
        this.m_batchItems.removeAllElements();
    }

    public synchronized void clearDefines() throws SQLException {
        this.columns_defined_by_user = false;
        this.need_to_prepare_define_buffer = true;
        this.defines.cleanup();
        this.defines.setBatchSize(0);
        this.stream_array = null;
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (this.connection.isClosed()) {
                    return;
                }
                try {
                    boolean bl = this.connection.XA_wants_error;
                    this.connection.XA_wants_error = false;
                    this.connection.needLine();
                    if (this.current_result_set != null) {
                        this.current_result_set.internal_close();
                        this.current_result_set = null;
                    }
                    this.internal_close();
                    this.connection.db_access.close(this.dbstmt);
                    this.connection.XA_wants_error = bl;
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeLeaveCursorOpen() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (this.closed) {
                    return;
                }
                this.internal_close();
                this.current_result_set = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeWithKey(String string) throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (this.closed) {
                    return;
                }
                if (string == null) {
                    this.close();
                }
                if (!this.connection.isStmtCacheEnabled()) {
                    DBError.throwSqlException(95);
                }
                if (!this.connection.isStmtCacheEnabled() || this.m_cacheState == CLOSED || this.m_cacheState == NON_CACHED) return;
                this.connection.cacheStatement(this);
                this.m_key = string;
                this.m_createState = 2;
                return;
            }
        }
    }

    public synchronized int creationState() {
        return this.m_createState;
    }

    public synchronized void defineColumnType(int n, int n2) throws SQLException {
        this.defineColumnType(n, n2, null);
    }

    public synchronized void defineColumnType(int n, int n2, int n3) throws SQLException {
        int n4;
        if (n3 < 0) {
            DBError.throwSqlException(53);
        }
        if (!this.columns_defined_by_user) {
            this.clearDefines();
            this.columns_defined_by_user = true;
        }
        this.need_to_prepare_define_buffer = true;
        int n5 = n3;
        if (this.max_field_size != 0 && this.max_field_size < n3) {
            n5 = this.max_field_size;
        }
        if ((n4 = this.defines.getType(n - 1)) != -1 && n4 != n2) {
            this.need_to_parse = true;
        }
        short s = this.dbdescription == null ? (short)1 : this.dbdescription[n - 1].FormOfUse;
        this.defines.setType(n - 1, this.get_internal_type(n2), n2, n5, s);
    }

    public synchronized void defineColumnType(int n, int n2, String string) throws SQLException {
        if (this.current_result_set != null && !this.current_result_set.closed) {
            DBError.throwSqlException(28);
        }
        if (!this.columns_defined_by_user) {
            this.clearDefines();
            this.columns_defined_by_user = true;
        }
        this.need_to_prepare_define_buffer = true;
        OracleNamedType oracleNamedType = null;
        int n3 = this.get_internal_type(n2);
        int n4 = this.defines.getType(n - 1);
        if (n4 != -1 && n4 != n2) {
            this.need_to_parse = true;
        }
        if (n3 == 109 || n3 == 111) {
            TypeDescriptor typeDescriptor = TypeDescriptor.getTypeDescriptor(string, this.connection);
            oracleNamedType = typeDescriptor.getPickler();
            this.defines.setType(n - 1, n3, oracleNamedType);
        } else {
            short s = this.dbdescription == null ? (short)1 : this.dbdescription[n - 1].FormOfUse;
            this.defines.setType(n - 1, n3, n2, this.max_field_size, s);
        }
    }

    public void defineColumnTypeChars(int n, int n2, int n3) throws SQLException {
        int n4 = this.connection.db_access.getNlsRatio();
        if (n2 == 1 || n2 == 12) {
            this.defineColumnType(n, n2, n3 * n4);
        } else {
            this.defineColumnType(n, n2, n3);
        }
    }

    public void describe() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (this.dbdescription == null) {
                    try {
                        this.connection.needLine();
                        this.dbdescription = this.connection.db_access.describe(this.dbstmt);
                    }
                    catch (IOException iOException) {
                        DBError.throwSqlException(iOException);
                    }
                }
            }
        }
    }

    void doDefaultTypes() throws SQLException {
        Object var2_1 = null;
        this.connection.trace("doDefaultTypes");
        int n = this.dbdescription.length;
        int n2 = this.connection.db_access.getNlsRatio();
        this.defines.setNoOfDefineCol(n);
        int n3 = 0;
        while (n3 < n) {
            DBColumn dBColumn = this.dbdescription[n3];
            switch (dBColumn.type) {
                case 8: 
                case 24: {
                    this.defines.setType(n3, dBColumn.type, this.max_field_size, dBColumn.FormOfUse);
                    break;
                }
                case 23: {
                    int n4 = dBColumn.max_length;
                    if (this.max_field_size != 0) {
                        n4 = Math.min(this.max_field_size, n4);
                    }
                    this.defines.setType(n3, dBColumn.type, n4, dBColumn.FormOfUse);
                    break;
                }
                case 1: 
                case 96: {
                    int n4 = dBColumn.max_length;
                    n4 = this.max_field_size != 0 && this.max_field_size <= n4 ? this.max_field_size : (n4 *= n2);
                    this.defines.setType(n3, dBColumn.type, n4, dBColumn.FormOfUse);
                    break;
                }
                case 2: 
                case 6: {
                    this.defines.setType(n3, 6, 0, dBColumn.FormOfUse);
                    break;
                }
                case 12: 
                case 102: 
                case 104: 
                case 180: 
                case 181: 
                case 231: {
                    this.defines.setType(n3, dBColumn.type, 0, dBColumn.FormOfUse);
                    break;
                }
                case 109: 
                case 111: {
                    this.defines.setType(n3, dBColumn.type, dBColumn.otype);
                    break;
                }
                default: {
                    this.defines.setType(n3, dBColumn.type, dBColumn.max_length, dBColumn.FormOfUse);
                    break;
                }
            }
            ++n3;
        }
    }

    void doDefinesFromTypes() throws SQLException {
        this.streams = null;
        int n = this.defines.getNoOfArgs();
        this.connection.trace("doDefinesFromTypes");
        if (this.defines.hasStreamType()) {
            this.row_prefetch = 1;
            this.stream_array = new InputStream[n];
        }
        this.defines.setBatchSize(this.row_prefetch);
        this.defines.rowCompleted(this.m_currentRank);
        if (this.stream_array != null) {
            this.stream_array[0] = null;
            int n2 = 0;
            while (n2 < n) {
                if (this.defines.isStreamType(n2)) {
                    OracleInputStream oracleInputStream = new OracleInputStream(this, n2 + 1, this.streams);
                    this.defines.setStreamItem(n2, 0, oracleInputStream);
                    this.streams = oracleInputStream;
                    if (n2 + 1 < n) {
                        this.stream_array[n2 + 1] = oracleInputStream;
                    }
                } else if (n2 + 1 < n) {
                    this.stream_array[n2 + 1] = this.stream_array[n2];
                }
                ++n2;
            }
        }
        this.initializeColumnsToFetch(this.defines);
    }

    void doExecuteOther(boolean bl) throws SQLException {
        this.connection.needLine();
        this.initializeColumnsToFetch(this.binds_out);
        this.executeNonQuery(bl);
        this.need_to_parse = false;
        this.fetchedFirstColumns();
        this.checkValidRowsStatus();
    }

    void doExecuteQuery() throws SQLException {
        DBAccess dBAccess = this.connection.db_access;
        boolean bl = this.dbstmt.getFetchOnExec();
        try {
            this.connection.needLine();
            if (this.need_to_parse) {
                if (this.need_to_prepare_define_buffer) {
                    if (this.columns_defined_by_user) {
                        this.check_defines();
                        this.check_row_prefetch_changed();
                        this.doDefinesFromTypes();
                        this.need_to_prepare_define_buffer = false;
                        this.valid_rows = dBAccess.parseExecuteFetch(this.dbstmt, this.sql_kind, this.array_sql, this.binds_in, 1, this.defines, this.row_prefetch);
                        this.need_to_parse = false;
                        if (bl) {
                            this.fetchedFirstColumns();
                        }
                    } else {
                        this.dbdescription = dBAccess.parseExecuteDescribe(this.dbstmt, this.array_sql, this.binds_in);
                        this.need_to_parse = false;
                        this.doDefaultTypes();
                        this.check_row_prefetch_changed();
                        this.doDefinesFromTypes();
                        this.need_to_prepare_define_buffer = false;
                        if (bl) {
                            this.valid_rows = dBAccess.fetch(this.dbstmt, this.defines, this.row_prefetch);
                            this.fetchedFirstColumns();
                        }
                    }
                } else {
                    this.check_row_prefetch_changed();
                    this.valid_rows = dBAccess.parseExecuteFetch(this.dbstmt, this.sql_kind, this.array_sql, this.binds_in, 1, this.defines, this.row_prefetch);
                    if (bl) {
                        this.fetchedFirstColumns();
                    }
                }
            } else if (this.need_to_prepare_define_buffer) {
                if (this.columns_defined_by_user) {
                    this.check_defines();
                    this.check_row_prefetch_changed();
                    this.doDefinesFromTypes();
                    this.need_to_prepare_define_buffer = false;
                    this.valid_rows = dBAccess.executeFetchNeedDefines(this.dbstmt, this.sql_kind, this.binds_in, 1, this.defines, this.row_prefetch);
                    this.need_to_parse = false;
                    if (bl) {
                        this.fetchedFirstColumns();
                    }
                } else {
                    this.dbdescription = dBAccess.parseExecuteDescribe(this.dbstmt, this.array_sql, this.binds_in);
                    this.need_to_parse = false;
                    this.doDefaultTypes();
                    this.check_row_prefetch_changed();
                    this.doDefinesFromTypes();
                    this.need_to_prepare_define_buffer = false;
                    if (bl) {
                        this.valid_rows = dBAccess.fetch(this.dbstmt, this.defines, this.row_prefetch);
                        this.fetchedFirstColumns();
                    }
                }
            } else {
                this.check_row_prefetch_changed();
                this.valid_rows = dBAccess.executeFetch(this.dbstmt, this.sql_kind, this.binds_in, 1, this.defines, this.row_prefetch);
                if (bl) {
                    this.fetchedFirstColumns();
                }
            }
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        if (bl) {
            this.checkValidRowsStatus();
        }
    }

    void doExecuteWithTimeout() throws SQLException {
        if (this.sql_query == null || this.sql_query == "") {
            DBError.throwSqlException(104);
        }
        this.dbstmt.rows_processed = 0;
        this.checkBindsInAndOut();
        if (this.sql_string_changed) {
            this.parseSqlKind();
        }
        if (this.sql_kind == 0) {
            if (this.m_queryTimeout != 0) {
                OracleCancelThread oracleCancelThread = null;
                try {
                    oracleCancelThread = new OracleCancelThread(this, this.m_queryTimeout);
                    oracleCancelThread.start();
                    this.doExecuteQuery();
                }
                finally {
                    Object var3_4 = null;
                    oracleCancelThread.interrupt();
                }
            } else {
                this.doExecuteQuery();
            }
        } else {
            ++this.m_currentRank;
            if (this.m_currentRank >= this.batch) {
                if (this.m_queryTimeout != 0) {
                    OracleCancelThread oracleCancelThread = null;
                    try {
                        oracleCancelThread = new OracleCancelThread(this, this.m_queryTimeout);
                        oracleCancelThread.start();
                        this.doExecuteOther(false);
                    }
                    finally {
                        Object var3_6 = null;
                        oracleCancelThread.interrupt();
                        this.cleanupForBatching();
                    }
                }
                try {
                    this.doExecuteOther(false);
                }
                finally {
                    Object var2_10 = null;
                    this.cleanupForBatching();
                }
            }
        }
    }

    private OracleResultSet doScrollStmtExecuteQuery(String string) throws SQLException {
        this.scrollStmt_cleanup(true);
        this.parseSqlKind();
        if (this.sql_kind != 0) {
            this.doExecuteWithTimeout();
            return null;
        }
        this.m_originalSql = string;
        boolean bl = true;
        String string2 = null;
        if (!this.m_needToAddIdentifier) {
            this.doExecuteWithTimeout();
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            this.m_realRsetType = this.m_userRsetType;
        } else {
            try {
                this.m_revisedSql = ResultSetUtil.addIdentifierToSql(string);
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.sql_query = this.m_revisedSql;
                this.prepare_for_new_result(true);
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(1);
                }
                this.doExecuteWithTimeout();
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
            }
            catch (SQLException sQLException) {
                bl = false;
                string2 = sQLException.getMessage();
            }
            if (bl) {
                this.m_realRsetType = this.m_userRsetType;
            } else {
                this.m_realRsetType = this.m_userRsetType > 3 ? 3 : 1;
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.sql_query = string;
                this.prepare_for_new_result(true);
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(-1);
                }
                this.doExecuteWithTimeout();
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                bl = true;
            }
        }
        if (this.current_result_set != null && bl) {
            if (this.m_userRsetType != this.m_realRsetType) {
                this.m_warning = DBError.addSqlWarning(this.m_warning, 91, string2);
            }
            this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
            return this.m_scrollRset;
        }
        DBError.check_error(1, "Unable to create result set");
        return null;
    }

    void end_of_result_set() throws SQLException {
        this.prepare_for_new_result(false);
        this.clearDefines();
    }

    final void ensureOpen() throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(9);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(String string) throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.checkIfJdbcBatchExists();
                this.ensureOpen();
                this.sendBatch();
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.sql_query = string;
                this.prepare_for_new_result(true);
                if (this.isRegularResultSet()) {
                    this.doExecuteWithTimeout();
                } else {
                    this.doScrollStmtExecuteQuery(string);
                }
                DBAccess cfr_ignored_0 = this.connection.db_access;
                if (this.sql_kind == 0) return true;
                return false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] executeBatch() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                int n = 0;
                int n2 = this.getBatchSize();
                if (n2 <= 0) {
                    return new int[0];
                }
                int[] nArray = new int[n2];
                String string = null;
                String string2 = null;
                byte[] byArray = null;
                byte by = 0;
                this.ensureOpen();
                this.prepare_for_new_result(true);
                try {
                    try {
                        this.connection.needLine();
                        n = 0;
                        while (n < n2) {
                            string = this.getBatchItem(n);
                            string2 = this.expandSqlEscapes(string);
                            byArray = this.strToDbaccessBytes(string2);
                            by = this.getSqlKind(string2);
                            if (by == 0) {
                                DBError.throwBatchUpdateException(80, "invalid SELECT batch command " + n, n, nArray);
                            }
                            nArray[n] = this.parseExecuteFetchWithTimeout(this.dbstmt, by, byArray, null, 1, null, 1);
                            if (nArray[n] < 0) {
                                DBError.throwBatchUpdateException(81, "command return value " + nArray[n], n, nArray);
                            }
                            ++n;
                        }
                    }
                    catch (IOException iOException) {
                        DBError.throwBatchUpdateException(81, iOException.getMessage(), n, nArray);
                    }
                    catch (SQLException sQLException) {
                        if (sQLException instanceof BatchUpdateException) {
                            throw sQLException;
                        }
                        DBError.throwBatchUpdateException(81, sQLException.getMessage(), n, nArray);
                    }
                    Object var14_18 = null;
                    this.clearBatchItems();
                    return nArray;
                }
                catch (Throwable throwable) {
                    Object var14_19 = null;
                    this.clearBatchItems();
                    throw throwable;
                }
            }
        }
    }

    private void executeNonQuery(boolean bl) throws SQLException {
        int n = this.m_currentRank;
        DBAccess dBAccess = this.connection.db_access;
        try {
            if (bl && this.sql_kind == 1 && n > 1) {
                int n2 = 0;
                while (n2 < n) {
                    this.valid_rows = this.need_to_parse ? dBAccess.parseExecuteFetch(this.dbstmt, this.sql_kind, this.array_sql, this.binds_in, 1, this.binds_out, 1) : dBAccess.executeFetch(this.dbstmt, this.sql_kind, this.binds_in, 1, this.binds_out, 1);
                    this.binds_in.removeFirstRow();
                    ++n2;
                }
            } else {
                this.valid_rows = this.need_to_parse ? dBAccess.parseExecuteFetch(this.dbstmt, this.sql_kind, this.array_sql, this.binds_in, n, this.binds_out, n) : dBAccess.executeFetch(this.dbstmt, this.sql_kind, this.binds_in, n, this.binds_out, n);
            }
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet executeQuery(String string) throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.checkIfJdbcBatchExists();
                this.ensureOpen();
                this.sendBatch();
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.sql_query = string;
                this.prepare_for_new_result(true);
                if (this.isRegularResultSet()) {
                    this.doExecuteWithTimeout();
                    this.current_result_set = new OracleResultSetImpl(this.connection, this);
                    return this.current_result_set;
                }
                this.m_scrollRset = this.doScrollStmtExecuteQuery(string);
                if (this.m_scrollRset != null) return this.m_scrollRset;
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                return this.current_result_set;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate(String string) throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.checkIfJdbcBatchExists();
                this.ensureOpen();
                this.sendBatch();
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.sql_query = string;
                this.prepare_for_new_result(true);
                if (this.isRegularResultSet()) {
                    this.doExecuteWithTimeout();
                    return this.valid_rows;
                } else {
                    this.doScrollStmtExecuteQuery(string);
                }
                return this.valid_rows;
            }
        }
    }

    final String expandSqlEscapes(String string) throws SQLException {
        return this.process_escapes ? this.connection.nativeSQL(string) : string;
    }

    synchronized void fetchNextColumns() throws SQLException, IOException {
        int[] nArray = this.getNextFetchColumnRange();
        if (nArray != null) {
            DBAccess dBAccess = this.connection.db_access;
            int n = dBAccess.fetch(this.dbstmt, this.m_currentDataSet, nArray[0], nArray[1]);
        }
    }

    synchronized void fetchedFirstColumns() {
        int n = this.getNextStreamColumn(1);
        this.m_lastFetchedColumn = n > 0 ? n - 1 : (n == 0 ? this.m_currentDataSet.getNoOfArgs() : 0);
    }

    void freeLine() throws SQLException {
        block2: {
            if (this.streams == null) break block2;
            try {
                this.streams.close();
            }
            catch (IOException iOException) {
                DBError.throwSqlException(iOException);
            }
        }
    }

    ARRAY getARRAYValue(boolean bl, int n) throws SQLException {
        return (ARRAY)this.getNamedTypeValue(bl, n);
    }

    InputStream getAsciiStreamValue(boolean bl, int n) throws SQLException {
        int n2;
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        if (dBDataSet.isNull(n3, n2)) {
            return null;
        }
        int n4 = dBDataSet.getType(n3);
        DBConversion dBConversion = this.connection.conversion;
        switch (n4) {
            case 23: 
            case 24: {
                if (dBDataSet.isStreamType(n3)) {
                    OracleInputStream oracleInputStream = (OracleInputStream)dBDataSet.getStreamItem(n3, n2);
                    if (oracleInputStream == null) {
                        return null;
                    }
                    return dBConversion.ConvertStream(oracleInputStream, 2);
                }
                byte[] byArray = dBDataSet.getBytesItem(n3, n2);
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 2);
            }
            case 1: 
            case 8: {
                if (dBDataSet.isStreamType(n3)) {
                    OracleInputStream oracleInputStream = (OracleInputStream)dBDataSet.getStreamItem(n3, n2);
                    if (oracleInputStream == null) {
                        return null;
                    }
                    return dBConversion.ConvertStream(oracleInputStream, 0);
                }
                byte[] byArray = dBDataSet.getBytesItem(n3, n2);
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 0);
            }
            case 96: {
                int n5;
                if (dBDataSet.isStreamType(n3)) {
                    OracleInputStream oracleInputStream = (OracleInputStream)dBDataSet.getStreamItem(n3, n2);
                    if (oracleInputStream == null) {
                        return null;
                    }
                    return dBConversion.ConvertStream(oracleInputStream, 0);
                }
                byte[] byArray = dBDataSet.getBytesItem(n - 1, n2);
                char[] cArray = new char[byArray.length];
                int n6 = dBConversion.CHARBytesToJavaChars(byArray, byArray.length, cArray);
                if (bl && this.connection.db_access.getNlsRatio() > 1 && n6 > 0 && this.dbdescription != null && this.dbdescription.length >= n && (n5 = this.dbdescription[n - 1].max_length) > 0 && n6 > n5) {
                    n6 = n5;
                }
                n5 = DBConversion.javaCharsToAsciiBytes(cArray, n6, byArray);
                return new ByteArrayInputStream(byArray, 0, n5);
            }
            case 113: {
                BLOB bLOB = this.get_blob_value(dBDataSet, n3, n2);
                return ((Datum)bLOB).asciiStreamValue();
            }
            case 112: {
                CLOB cLOB = this.get_clob_value(dBDataSet, n3, n2);
                return ((Datum)cLOB).asciiStreamValue();
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    public boolean getAutoRefetch() throws SQLException {
        return this.m_autoRefetch;
    }

    BFILE getBFILEValue(boolean bl, int n) throws SQLException {
        int n2;
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        if (dBDataSet.getType(n3) != 114) {
            DBError.throwSqlException(4);
        }
        return this.get_bfile_value(dBDataSet, n3, n2);
    }

    BLOB getBLOBValue(boolean bl, int n) throws SQLException {
        int n2;
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        if (dBDataSet.getType(n3) != 113) {
            DBError.throwSqlException(4);
        }
        return this.get_blob_value(dBDataSet, n3, n2);
    }

    private String getBatchItem(int n) {
        return (String)this.m_batchItems.elementAt(n);
    }

    private int getBatchSize() {
        return this.m_batchItems.size();
    }

    BigDecimal getBigDecimalValue(boolean bl, int n, int n2) throws SQLException {
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            int n4 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            int n5 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n6 = dBDataSet.getType(n3);
        switch (n6) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                BigDecimal bigDecimal = new BigDecimal(string);
                return bigDecimal;
            }
            case 2: 
            case 6: {
                DBConversion cfr_ignored_0 = this.connection.conversion;
                return DBConversion.NumberBytesToBigDecimal(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    InputStream getBinaryStreamValue(boolean bl, int n) throws SQLException {
        int n2;
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        if (dBDataSet.isNull(n3, n2)) {
            return null;
        }
        int n4 = dBDataSet.getType(n3);
        switch (n4) {
            case 1: 
            case 8: 
            case 23: 
            case 24: {
                if (dBDataSet.isStreamType(n3)) {
                    OracleInputStream oracleInputStream = (OracleInputStream)dBDataSet.getStreamItem(n3, n2);
                    if (oracleInputStream == null) {
                        return null;
                    }
                    return oracleInputStream;
                }
                byte[] byArray = dBDataSet.getBytesItem(n3, n2);
                return new ByteArrayInputStream(byArray);
            }
            case 96: {
                if (dBDataSet.isStreamType(n3)) {
                    OracleInputStream oracleInputStream = (OracleInputStream)dBDataSet.getStreamItem(n3, n2);
                    if (oracleInputStream.isClosed()) {
                        DBError.throwSqlException(27);
                    }
                    if (oracleInputStream == null) {
                        return null;
                    }
                    return oracleInputStream;
                }
                byte[] byArray = dBDataSet.getBytesItem(n3, n2);
                if (bl && this.connection.db_access.getNlsRatio() > 1 && byArray != null && this.dbdescription != null && this.dbdescription.length >= n) {
                    char[] cArray = new char[byArray.length];
                    DBConversion dBConversion = this.connection.conversion;
                    int n5 = dBConversion.CHARBytesToJavaChars(byArray, byArray.length, cArray);
                    int n6 = this.dbdescription[n - 1].max_length;
                    if (n6 > 0 && n5 > n6) {
                        n5 = n6;
                    }
                    int n7 = dBConversion.javaCharsToCHARBytes(cArray, n5, byArray);
                    return new ByteArrayInputStream(byArray, 0, n7);
                }
                return new ByteArrayInputStream(byArray);
            }
            case 113: {
                BLOB bLOB = this.get_blob_value(dBDataSet, n3, n2);
                return ((Datum)bLOB).binaryStreamValue();
            }
            case 112: {
                CLOB cLOB = this.get_clob_value(dBDataSet, n3, n2);
                return ((Datum)cLOB).binaryStreamValue();
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    public DBDataSet getBinds() {
        return null;
    }

    boolean getBooleanValue(boolean bl, int n) throws SQLException {
        DBDataSet dBDataSet = bl ? this.defines : this.binds_out;
        this.prepare_for_new_get(bl, n);
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        int n2 = dBDataSet.getType(n - 1);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                long l;
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                if (string == null) {
                    return false;
                }
                if (n2 == 96) {
                    string = string.trim();
                }
                return (l = Double.valueOf(string).longValue()) != 0L;
            }
            case 2: 
            case 6: {
                DBConversion cfr_ignored_0 = this.connection.conversion;
                return DBConversion.NumberBytesToBoolean(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return false;
    }

    byte getByteValue(boolean bl, int n) throws SQLException {
        long l = this.getLongValue(bl, n);
        if (l > 127L || l < -128L) {
            DBError.throwSqlException(26);
        }
        return (byte)l;
    }

    byte[] getBytesInternal(boolean bl, int n) throws SQLException {
        DBDataSet dBDataSet;
        int n2 = n - 1;
        int n3 = 0;
        if (bl) {
            dBDataSet = this.defines;
            n3 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n3 = this.m_currentRank;
        }
        if (dBDataSet.isStreamType(n2)) {
            OracleInputStream oracleInputStream = (OracleInputStream)dBDataSet.getStreamItem(n2, n3);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] byArray = new byte[1024];
            if (oracleInputStream == null) {
                return null;
            }
            try {
                int n4;
                while ((n4 = oracleInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n4);
                }
            }
            catch (IOException iOException) {
                DBError.throwSqlException(iOException);
            }
            return byteArrayOutputStream.toByteArray();
        }
        return dBDataSet.getBytesItem(n2, n3);
    }

    byte[] getBytesValue(boolean bl, int n) throws SQLException {
        this.prepare_for_new_get(bl, n);
        byte[] byArray = this.getBytesInternal(bl, n);
        return byArray;
    }

    CHAR getCHARValue(boolean bl, int n) throws SQLException {
        CharacterSet characterSet = null;
        DBDataSet dBDataSet = bl ? this.defines : this.binds_out;
        this.prepare_for_new_get(bl, n);
        int n2 = dBDataSet.getType(n - 1);
        short s = this.getDBTypeForm(n - 1);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                if (s == 2) {
                    characterSet = this.connection.conversion.getAccessNCharSetObj();
                    break;
                }
                characterSet = this.connection.conversion.getAccessCharSetObj();
                break;
            }
            case 23: {
                characterSet = this.connection.conversion.getDbCharSetObj();
                break;
            }
            default: {
                DBError.throwSqlException(4);
            }
        }
        boolean bl2 = this.connection.getProtocolType().equals("thin");
        if (bl2) {
            char[] cArray = null;
            int[] nArray = new int[1];
            cArray = this.getCharsInternal(bl, n, nArray, s, n2);
            if (cArray == null || cArray.length == 0) {
                return null;
            }
            return new CHAR(new String(cArray, 0, nArray[0]), characterSet);
        }
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        return new CHAR(byArray, characterSet);
    }

    CLOB getCLOBValue(boolean bl, int n) throws SQLException {
        int n2;
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        if (dBDataSet.getType(n3) != 112) {
            DBError.throwSqlException(4);
        }
        return this.get_clob_value(dBDataSet, n3, n2);
    }

    Reader getCharacterStreamValue(boolean bl, int n) throws SQLException {
        int n2;
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        if (dBDataSet.isNull(n3, n2)) {
            return null;
        }
        int n4 = dBDataSet.getType(n3);
        DBConversion dBConversion = this.connection.conversion;
        switch (n4) {
            case 23: 
            case 24: {
                if (dBDataSet.isStreamType(n3)) {
                    OracleInputStream oracleInputStream = (OracleInputStream)dBDataSet.getStreamItem(n3, n2);
                    if (oracleInputStream == null) {
                        return null;
                    }
                    return dBConversion.ConvertCharacterStream(oracleInputStream, 8);
                }
                byte[] byArray = dBDataSet.getBytesItem(n3, n2);
                char[] cArray = new char[byArray.length * 2];
                int n5 = DBConversion.RAWBytesToHexChars(byArray, byArray.length, cArray);
                return new CharArrayReader(cArray, 0, n5);
            }
            case 1: 
            case 8: {
                short s = this.getDBTypeForm(n3);
                if (dBDataSet.isStreamType(n3)) {
                    OracleInputStream oracleInputStream = (OracleInputStream)dBDataSet.getStreamItem(n3, n2);
                    if (oracleInputStream == null) {
                        return null;
                    }
                    return dBConversion.ConvertCharacterStream(oracleInputStream, 9, s);
                }
                byte[] byArray = dBDataSet.getBytesItem(n3, n2);
                String string = null;
                string = s == 2 ? dBConversion.NCharBytesToString(byArray, byArray.length) : dBConversion.CharBytesToString(byArray, byArray.length);
                return new StringReader(string);
            }
            case 96: {
                int n6;
                if (dBDataSet.isStreamType(n3)) {
                    OracleInputStream oracleInputStream = (OracleInputStream)dBDataSet.getStreamItem(n3, n2);
                    if (oracleInputStream == null) {
                        return null;
                    }
                    return dBConversion.ConvertCharacterStream(oracleInputStream, 9);
                }
                byte[] byArray = dBDataSet.getBytesItem(n3, n2);
                String string = dBConversion.CharBytesToString(byArray, byArray.length);
                if (bl && this.connection.db_access.getNlsRatio() > 1 && this.dbdescription != null && this.dbdescription.length >= n && string != null && (n6 = this.dbdescription[n - 1].max_length) > 0 && string.length() > n6) {
                    string = string.substring(0, n6);
                }
                return new StringReader(string);
            }
            case 113: {
                BLOB bLOB = this.get_blob_value(dBDataSet, n3, n2);
                return ((Datum)bLOB).characterStreamValue();
            }
            case 112: {
                CLOB cLOB = this.get_clob_value(dBDataSet, n3, n2);
                return ((Datum)cLOB).characterStreamValue();
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    char[] getCharsInternal(boolean bl, int n, int[] nArray, short s, int n2) throws SQLException {
        DBDataSet dBDataSet;
        int n3 = n - 1;
        int n4 = 0;
        if (bl) {
            dBDataSet = this.defines;
            n4 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n4 = this.m_currentRank;
        }
        if (dBDataSet.isStreamType(n3)) {
            return dBDataSet.getCharsStreamItem(n3, n4, nArray);
        }
        char[] cArray = dBDataSet.getCharsItem(n3, n4, nArray, s);
        if (bl && n2 == 96 && this.connection.db_access.getNlsRatio() > 1 && this.dbdescription != null && this.dbdescription.length >= n) {
            int n5 = this.dbdescription[n - 1].max_length;
            nArray[0] = this.max_field_size > 0 && this.max_field_size < n5 ? this.max_field_size : n5;
        }
        return cArray;
    }

    protected byte[] getColumnBytes(boolean bl, int n) throws SQLException {
        byte[] byArray = null;
        this.prepare_for_new_get(bl, n);
        byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            byArray = null;
        }
        return byArray;
    }

    protected int getColumnDBType(boolean bl, int n) throws SQLException {
        int n2 = n - 1;
        int n3 = 0;
        n3 = bl ? this.defines.getType(n2) : this.binds_out.getType(n2);
        return n3;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    ResultSet getCursorValue(boolean bl, int n) throws SQLException {
        byte[] byArray;
        int n2;
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        if (dBDataSet.getType(n3) != 102) {
            DBError.throwSqlException(4);
        }
        if ((byArray = dBDataSet.getBytesItem(n3, n2)) == null || byArray.length == 0) {
            return null;
        }
        DBAccess dBAccess = this.connection.db_access;
        DBStatement dBStatement = null;
        try {
            dBStatement = dBAccess.RefCursorBytesToDBStatement(byArray);
            dBStatement.setFetchOnExec(this.dbstmt.getFetchOnExec());
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {
            DBError.throwSqlException(62);
        }
        OracleStatement oracleStatement = new OracleStatement(this.connection, dBStatement, 1, this.connection.default_row_prefetch);
        return oracleStatement.getResultSet();
    }

    CustomDatum getCustomDatumValue(boolean bl, int n, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = this.getOracleObjectValue(bl, n);
        return customDatumFactory.create(datum, 0);
    }

    DATE getDATEValue(boolean bl, int n) throws SQLException {
        byte[] byArray;
        int n2;
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        if (dBDataSet.getType(n3) != 12) {
            DBError.throwSqlException(4);
        }
        if ((byArray = dBDataSet.getBytesItem(n3, n2)) == null || byArray.length == 0) {
            return null;
        }
        return new DATE(byArray);
    }

    public DBColumn[] getDBDescription() throws SQLException {
        if (this.dbdescription == null) {
            this.describe();
        }
        return this.dbdescription;
    }

    public short getDBTypeForm(int n) {
        short s = this.sql_kind == 1 ? this.binds_out.getFormOfUse(n) : (this.dbdescription == null ? (short)1 : this.dbdescription[n].FormOfUse);
        return s;
    }

    Date getDateValue(boolean bl, int n) throws SQLException {
        DBDataSet dBDataSet;
        int n2 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            int n3 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            int n4 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n5 = dBDataSet.getType(n2);
        switch (n5) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                return Date.valueOf(string);
            }
            case 12: {
                return this.connection.conversion.DateBytesToDate(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    Date getDateValue(boolean bl, int n, Calendar calendar) throws SQLException {
        DATE dATE = this.getDATEValue(bl, n);
        return dATE == null ? null : dATE.dateValue(calendar);
    }

    double getDoubleValue(boolean bl, int n) throws SQLException {
        DBDataSet dBDataSet = bl ? this.defines : this.binds_out;
        this.prepare_for_new_get(bl, n);
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return 0.0;
        }
        int n2 = dBDataSet.getType(n - 1);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                double d = 0.0;
                try {
                    d = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    DBError.throwSqlException(59);
                }
                return d;
            }
            case 2: 
            case 6: {
                DBConversion cfr_ignored_0 = this.connection.conversion;
                return DBConversion.NumberBytesToDouble(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return 0.0;
    }

    public int getFetchDirection() throws SQLException {
        return this.default_fetch_direction;
    }

    public int getFetchSize() throws SQLException {
        return this.getPrefetchInternal(true);
    }

    public boolean getFixedString() {
        return this.fixedString;
    }

    float getFloatValue(boolean bl, int n) throws SQLException {
        DBDataSet dBDataSet = bl ? this.defines : this.binds_out;
        this.prepare_for_new_get(bl, n);
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return 0.0f;
        }
        int n2 = dBDataSet.getType(n - 1);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                float f = 0.0f;
                try {
                    f = Float.valueOf(string).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    DBError.throwSqlException(59);
                }
                return f;
            }
            case 2: 
            case 6: {
                DBConversion cfr_ignored_0 = this.connection.conversion;
                return DBConversion.NumberBytesToFloat(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return 0.0f;
    }

    int getIntValue(boolean bl, int n) throws SQLException {
        long l = this.getLongValue(bl, n);
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            DBError.throwSqlException(26);
        }
        return (int)l;
    }

    String getKeyOrQuery() {
        if (this.m_createState == 2) {
            return this.m_key;
        }
        return this.sql_query;
    }

    long getLongValue(boolean bl, int n) throws SQLException {
        DBDataSet dBDataSet = bl ? this.defines : this.binds_out;
        this.prepare_for_new_get(bl, n);
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return 0L;
        }
        int n2 = dBDataSet.getType(n - 1);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                if (n2 == 96) {
                    string = string.trim();
                }
                long l = 0L;
                try {
                    l = Long.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    DBError.throwSqlException(59);
                }
                return l;
            }
            case 2: 
            case 6: {
                DBConversion cfr_ignored_0 = this.connection.conversion;
                return DBConversion.NumberBytesToLong(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return 0L;
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public int getMaxRows() throws SQLException {
        return this.max_rows;
    }

    public boolean getMoreResults() throws SQLException {
        this.connection.trace("Statement.getMoreResults");
        return false;
    }

    NUMBER getNUMBERValue(boolean bl, int n) throws SQLException {
        byte[] byArray;
        int n2;
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        int n4 = dBDataSet.getType(n3);
        if (n4 != 2 && n4 != 6) {
            DBError.throwSqlException(4);
        }
        if ((byArray = dBDataSet.getBytesItem(n3, n2)) == null || byArray.length == 0) {
            return null;
        }
        return new NUMBER(byArray);
    }

    private Datum getNamedTypeValue(boolean bl, int n) throws SQLException {
        byte[] byArray;
        int n2;
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        if (dBDataSet.getType(n3) != 109) {
            DBError.throwSqlException(4);
        }
        if ((byArray = dBDataSet.getBytesItem(n3, n2)) == null || byArray.length == 0) {
            return null;
        }
        OracleTypeADT oracleTypeADT = (OracleTypeADT)dBDataSet.getOtype(n3);
        TypeDescriptor typeDescriptor = TypeDescriptor.getTypeDescriptor(oracleTypeADT.getFullName(), this.connection, byArray, 0L);
        switch (typeDescriptor.getTypeCode()) {
            case 2003: {
                return new ARRAY((ArrayDescriptor)typeDescriptor, byArray, this.connection);
            }
            case 2002: {
                return new STRUCT((StructDescriptor)typeDescriptor, byArray, this.connection);
            }
            case 2007: {
                return new OPAQUE((OpaqueDescriptor)typeDescriptor, byArray, this.connection);
            }
            case 2008: {
                return new JAVA_STRUCT((StructDescriptor)typeDescriptor, byArray, this.connection);
            }
        }
        DBError.throwSqlException(1);
        return null;
    }

    private synchronized int[] getNextFetchColumnRange() {
        int[] nArray;
        ++this.m_lastFetchedColumn;
        if (this.m_currentDataSet == null) {
            return null;
        }
        int n = this.m_currentDataSet.getNoOfArgs();
        if (n == 0) {
            return null;
        }
        if (this.m_lastFetchedColumn >= n) {
            return null;
        }
        if (this.m_currentDataSet.isStreamType(this.m_lastFetchedColumn)) {
            return null;
        }
        int n2 = this.getNextStreamColumn(nArray[0]);
        nArray = new int[]{this.m_lastFetchedColumn + 1, n2 > 0 ? n2 - 1 : n};
        this.m_lastFetchedColumn = nArray[1];
        return nArray;
    }

    private int getNextStreamColumn(int n) {
        int n2;
        int n3 = -1;
        if (this.m_currentDataSet != null && (n2 = this.m_currentDataSet.getNoOfArgs()) > 0) {
            int n4 = n - 1;
            if (n4 < 0) {
                n4 = 0;
            }
            boolean bl = false;
            while (!bl && n4 < n2) {
                if (this.m_currentDataSet.isStreamType(n4)) {
                    n3 = n4 + 1;
                    bl = true;
                }
                ++n4;
            }
            if (!bl) {
                n3 = 0;
            }
        }
        return n3;
    }

    OPAQUE getOPAQUEValue(boolean bl, int n) throws SQLException {
        return (OPAQUE)this.getNamedTypeValue(bl, n);
    }

    ORAData getORADataValue(boolean bl, int n, ORADataFactory oRADataFactory) throws SQLException {
        Datum datum = this.getOracleObjectValue(bl, n);
        return oRADataFactory.create(datum, 0);
    }

    Object getObjectValue(boolean bl, int n) throws SQLException {
        return this.getObjectValue(bl, n, this.connection.getTypeMap());
    }

    Object getObjectValue(boolean bl, int n, Map map) throws SQLException {
        this.prepare_for_new_get(bl, n);
        int n2 = this.get_value_external_type(bl, n);
        if (n2 == 0) {
            int n3 = this.get_value_type(bl, n);
            switch (n3) {
                case 1: 
                case 8: 
                case 96: {
                    return this.getStringValue(bl, n);
                }
                case 2: 
                case 6: {
                    int n4 = this.get_value_scale(bl, n);
                    return this.getBigDecimalValue(bl, n, n4);
                }
                case 23: 
                case 24: {
                    return this.getBytesValue(bl, n);
                }
                case 12: {
                    return this.getTimestampValue(bl, n);
                }
                case 180: {
                    return this.getTIMESTAMPValue(bl, n);
                }
                case 181: {
                    return this.getTIMESTAMPTZValue(bl, n);
                }
                case 231: {
                    return this.getTIMESTAMPLTZValue(bl, n);
                }
                case 104: {
                    return this.getROWIDValue(bl, n);
                }
                case 113: {
                    return this.getBLOBValue(bl, n);
                }
                case 112: {
                    return this.getCLOBValue(bl, n);
                }
                case 114: {
                    return this.getBFILEValue(bl, n);
                }
                case 102: {
                    return this.getCursorValue(bl, n);
                }
                case 109: {
                    Datum datum = this.getNamedTypeValue(bl, n);
                    if (datum == null) {
                        return null;
                    }
                    if (datum instanceof JAVA_STRUCT) {
                        return ((JAVA_STRUCT)datum).toJdbc();
                    }
                    if (datum instanceof STRUCT) {
                        return ((STRUCT)datum).toJdbc(map);
                    }
                    return datum.toJdbc();
                }
                case 111: {
                    return this.getREFValue(bl, n);
                }
            }
            DBError.throwSqlException(4);
            return null;
        }
        switch (n2) {
            case -7: {
                return new Boolean(this.getBooleanValue(bl, n));
            }
            case -6: {
                return new Byte(this.getByteValue(bl, n));
            }
            case 5: {
                return new Short(this.getShortValue(bl, n));
            }
            case 4: {
                return new Integer(this.getIntValue(bl, n));
            }
            case -5: {
                return new Long(this.getLongValue(bl, n));
            }
            case 6: 
            case 8: {
                return new Double(this.getDoubleValue(bl, n));
            }
            case 7: {
                return new Float(this.getFloatValue(bl, n));
            }
            case 2: 
            case 3: {
                int n5 = this.get_value_scale(bl, n);
                return this.getBigDecimalValue(bl, n, n5);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getStringValue(bl, n);
            }
            case 91: {
                return this.getDateValue(bl, n);
            }
            case 92: {
                return this.getTimeValue(bl, n);
            }
            case 93: {
                return this.getTimestampValue(bl, n);
            }
            case -100: {
                return this.getTIMESTAMPValue(bl, n);
            }
            case -101: {
                return this.getTIMESTAMPTZValue(bl, n);
            }
            case -102: {
                return this.getTIMESTAMPLTZValue(bl, n);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytesValue(bl, n);
            }
            case -8: {
                return this.getROWIDValue(bl, n);
            }
            case -10: {
                return this.getCursorValue(bl, n);
            }
            case 2004: {
                return this.getBLOBValue(bl, n);
            }
            case 2005: {
                return this.getCLOBValue(bl, n);
            }
            case -13: {
                return this.getBFILEValue(bl, n);
            }
            case 2008: {
                map = null;
            }
            case 2000: 
            case 2002: 
            case 2003: 
            case 2007: {
                Datum datum = this.getNamedTypeValue(bl, n);
                if (datum instanceof STRUCT) {
                    return ((STRUCT)datum).toJdbc(map);
                }
                return datum.toJdbc();
            }
            case 2006: {
                return this.getREFValue(bl, n);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    Datum getOracleObjectValue(boolean bl, int n) throws SQLException {
        this.prepare_for_new_get(bl, n);
        int n2 = this.get_value_type(bl, n);
        switch (n2) {
            case 1: 
            case 8: 
            case 96: {
                return this.getCHARValue(bl, n);
            }
            case 2: 
            case 6: {
                return this.getNUMBERValue(bl, n);
            }
            case 23: 
            case 24: {
                return this.getRAWValue(bl, n);
            }
            case 12: {
                return this.getDATEValue(bl, n);
            }
            case 180: {
                return this.getTIMESTAMPValue(bl, n);
            }
            case 181: {
                return this.getTIMESTAMPTZValue(bl, n);
            }
            case 231: {
                return this.getTIMESTAMPLTZValue(bl, n);
            }
            case 104: {
                return this.getROWIDValue(bl, n);
            }
            case 113: {
                return this.getBLOBValue(bl, n);
            }
            case 112: {
                return this.getCLOBValue(bl, n);
            }
            case 114: {
                return this.getBFILEValue(bl, n);
            }
            case 109: {
                return this.getNamedTypeValue(bl, n);
            }
            case 111: {
                return this.getREFValue(bl, n);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    public String getOriginalSql() throws SQLException {
        return this.m_originalSql;
    }

    protected int getPrefetchInternal(boolean bl) {
        int n = bl ? this.default_row_prefetch : this.row_prefetch;
        return n;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        return this.m_queryTimeout;
    }

    RAW getRAWValue(boolean bl, int n) throws SQLException {
        byte[] byArray;
        DBDataSet dBDataSet = bl ? this.defines : this.binds_out;
        this.prepare_for_new_get(bl, n);
        int n2 = dBDataSet.getType(n - 1);
        if (n2 != 23 && n2 != 24) {
            DBError.throwSqlException(4);
        }
        if ((byArray = this.getBytesInternal(bl, n)) == null || byArray.length == 0) {
            return null;
        }
        return new RAW(byArray);
    }

    REF getREFValue(boolean bl, int n) throws SQLException {
        byte[] byArray;
        DBDataSet dBDataSet;
        int n2 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            int n3 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            int n4 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        if (dBDataSet.getType(n2) != 111) {
            DBError.throwSqlException(4);
        }
        if ((byArray = this.getBytesInternal(bl, n)) == null || byArray.length == 0) {
            return null;
        }
        OracleTypeADT oracleTypeADT = (OracleTypeADT)dBDataSet.getOtype(n2);
        return new REF(oracleTypeADT.getFullName(), (Connection)this.connection, byArray);
    }

    ROWID getROWIDValue(boolean bl, int n) throws SQLException {
        byte[] byArray;
        int n2;
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        if (dBDataSet.getType(n3) != 104) {
            DBError.throwSqlException(4);
        }
        if ((byArray = dBDataSet.getBytesItem(n3, n2)) == null || byArray.length == 0) {
            return null;
        }
        return new ROWID(byArray);
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        this.connection.trace("Statement.getResultSet");
        if (this.isRegularResultSet()) {
            DBAccess cfr_ignored_0 = this.connection.db_access;
            if (this.sql_kind == 0) {
                if (this.current_result_set == null) {
                    this.current_result_set = new OracleResultSetImpl(this.connection, this);
                }
                return this.current_result_set;
            }
        } else {
            return this.m_scrollRset;
        }
        return null;
    }

    public synchronized OracleResultSetCache getResultSetCache() throws SQLException {
        return (OracleResultSetCache)this.m_cache;
    }

    public int getResultSetConcurrency() throws SQLException {
        return ResultSetUtil.getUpdateConcurrency(this.m_userRsetType);
    }

    public int getResultSetType() throws SQLException {
        return ResultSetUtil.getScrollType(this.m_userRsetType);
    }

    public String getRevisedSql() throws SQLException {
        return ResultSetUtil.removeForUpdate(this.m_revisedSql);
    }

    public synchronized int getRowPrefetch() {
        return this.getPrefetchInternal(true);
    }

    STRUCT getSTRUCTValue(boolean bl, int n) throws SQLException {
        return (STRUCT)this.getNamedTypeValue(bl, n);
    }

    short getShortValue(boolean bl, int n) throws SQLException {
        long l = this.getLongValue(bl, n);
        if (l > 32767L || l < -32768L) {
            DBError.throwSqlException(26);
        }
        return (short)l;
    }

    public byte getSqlKind() {
        return this.sql_kind;
    }

    byte getSqlKind(String string) {
        String string2 = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "\n \r \t ( ) /", true);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("select") || string2.equalsIgnoreCase("with")) {
                    DBAccess cfr_ignored_0 = this.connection.db_access;
                    return 0;
                }
                if (string2.equalsIgnoreCase("begin") || string2.equalsIgnoreCase("call") || string2.equalsIgnoreCase("declare")) {
                    DBAccess cfr_ignored_1 = this.connection.db_access;
                    return 1;
                }
                if (string2.equalsIgnoreCase("insert") || string2.equalsIgnoreCase("delete") || string2.equalsIgnoreCase("update")) {
                    DBAccess cfr_ignored_2 = this.connection.db_access;
                    return 2;
                }
                if (string2.equals("/")) {
                    string2 = stringTokenizer.nextToken();
                    while (!string2.equals("*") || !stringTokenizer.nextToken().equals("/")) {
                        string2 = stringTokenizer.nextToken();
                    }
                    continue;
                }
                if (string2.equals("--")) {
                    while (!stringTokenizer.nextToken().equals("\n")) {
                    }
                    continue;
                }
                if (string2.equals("\n") || string2.equals("\t") || string2.equals(" ") || string2.equals("\r") || string2.equals("(") || string2.equals(")")) continue;
                DBAccess cfr_ignored_3 = this.connection.db_access;
                return 3;
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        DBAccess cfr_ignored_4 = this.connection.db_access;
        return 3;
    }

    OracleInputStream getStreamInternal(boolean bl, int n) throws SQLException {
        int n2;
        DBDataSet dBDataSet;
        --n;
        Object var3_3 = null;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        return (OracleInputStream)dBDataSet.getStreamItem(n, n2);
    }

    String getStringValue(boolean bl, int n) throws SQLException {
        DBDataSet dBDataSet = bl ? this.defines : this.binds_out;
        this.prepare_for_new_get(bl, n);
        char[] cArray = null;
        int[] nArray = new int[1];
        byte[] byArray = null;
        int n2 = dBDataSet.getType(n - 1);
        switch (n2) {
            case 12: {
                byArray = this.getBytesInternal(bl, n);
                if (byArray == null || byArray.length == 0) {
                    return null;
                }
                Timestamp timestamp = this.connection.conversion.DateBytesToTimestamp(byArray, byArray.length);
                return timestamp.toString();
            }
            case 2: 
            case 6: {
                byArray = this.getBytesInternal(bl, n);
                if (byArray == null || byArray.length == 0) {
                    return null;
                }
                NUMBER nUMBER = new NUMBER(byArray);
                return nUMBER.stringValue();
            }
            case 23: 
            case 24: {
                byArray = this.getBytesInternal(bl, n);
                if (byArray == null || byArray.length == 0) {
                    return null;
                }
                return RepConversion.bArray2String(byArray);
            }
            case 1: 
            case 8: 
            case 96: {
                String string = null;
                boolean bl2 = this.connection.getProtocolType().equals("thin");
                short s = this.getDBTypeForm(n - 1);
                if (bl2) {
                    cArray = this.getCharsInternal(bl, n, nArray, s, n2);
                    if (cArray == null || cArray.length == 0) {
                        return null;
                    }
                    string = new String(cArray, 0, nArray[0]);
                } else {
                    byArray = this.getBytesInternal(bl, n);
                    if (byArray == null || byArray.length == 0) {
                        return null;
                    }
                    string = s == 2 ? this.connection.conversion.NCharBytesToString(byArray, byArray.length) : this.connection.conversion.CharBytesToString(byArray, byArray.length);
                }
                return string;
            }
            case 104: {
                byArray = this.getBytesInternal(bl, n);
                if (byArray == null || byArray.length == 0) {
                    return null;
                }
                return new String(byArray, 0, 0, byArray.length);
            }
            case 180: {
                byArray = this.getBytesInternal(bl, n);
                if (byArray == null || byArray.length == 0) {
                    return null;
                }
                return TIMESTAMP.toString(byArray);
            }
            case 181: {
                byArray = this.getBytesInternal(bl, n);
                if (byArray == null || byArray.length == 0) {
                    return null;
                }
                return TIMESTAMPTZ.toString(this.connection, byArray);
            }
            case 231: {
                byArray = this.getBytesInternal(bl, n);
                if (byArray == null || byArray.length == 0) {
                    return null;
                }
                return TIMESTAMPLTZ.toString(this.connection, byArray, this.connection.getDbTzCalendar());
            }
        }
        return null;
    }

    TIMESTAMPLTZ getTIMESTAMPLTZValue(boolean bl, int n) throws SQLException {
        byte[] byArray = this.getColumnBytes(bl, n);
        int n2 = this.getColumnDBType(bl, n);
        TIMESTAMPLTZ tIMESTAMPLTZ = null;
        switch (n2) {
            case 231: {
                tIMESTAMPLTZ = new TIMESTAMPLTZ(byArray);
                break;
            }
            default: {
                DBError.throwSqlException(4, "type number " + n2);
            }
        }
        return tIMESTAMPLTZ;
    }

    TIMESTAMPTZ getTIMESTAMPTZValue(boolean bl, int n) throws SQLException {
        byte[] byArray = this.getColumnBytes(bl, n);
        int n2 = this.getColumnDBType(bl, n);
        TIMESTAMPTZ tIMESTAMPTZ = null;
        switch (n2) {
            case 181: {
                tIMESTAMPTZ = new TIMESTAMPTZ(byArray);
                break;
            }
            default: {
                DBError.throwSqlException(4, "type number " + n2);
            }
        }
        return tIMESTAMPTZ;
    }

    TIMESTAMP getTIMESTAMPValue(boolean bl, int n) throws SQLException {
        byte[] byArray = this.getColumnBytes(bl, n);
        int n2 = this.getColumnDBType(bl, n);
        TIMESTAMP tIMESTAMP = null;
        switch (n2) {
            case 180: {
                tIMESTAMP = new TIMESTAMP(byArray);
                break;
            }
            default: {
                DBError.throwSqlException(4, "type number " + n2);
            }
        }
        return tIMESTAMP;
    }

    Time getTimeValue(boolean bl, int n) throws SQLException {
        DBDataSet dBDataSet;
        int n2 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            int n3 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            int n4 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n5 = dBDataSet.getType(n2);
        switch (n5) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                return Time.valueOf(string);
            }
            case 12: {
                return this.connection.conversion.DateBytesToTime(byArray, byArray.length);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    Time getTimeValue(boolean bl, int n, Calendar calendar) throws SQLException {
        DATE dATE = this.getDATEValue(bl, n);
        return dATE == null ? null : dATE.timeValue(calendar);
    }

    Timestamp getTimestampValue(boolean bl, int n) throws SQLException {
        DBDataSet dBDataSet;
        int n2 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            int n3 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            int n4 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        byte[] byArray = this.getBytesInternal(bl, n);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n5 = dBDataSet.getType(n2);
        switch (n5) {
            case 1: 
            case 8: 
            case 96: {
                String string = this.connection.conversion.CharBytesToString(byArray, byArray.length);
                return Timestamp.valueOf(string);
            }
            case 12: {
                return this.connection.conversion.DateBytesToTimestamp(byArray, byArray.length);
            }
            case 180: {
                return TIMESTAMP.toTimestamp(byArray);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    Timestamp getTimestampValue(boolean bl, int n, Calendar calendar) throws SQLException {
        DATE dATE = this.getDATEValue(bl, n);
        return dATE == null ? null : dATE.timestampValue(calendar);
    }

    InputStream getUnicodeStreamValue(boolean bl, int n) throws SQLException {
        int n2;
        DBDataSet dBDataSet;
        int n3 = n - 1;
        if (bl) {
            dBDataSet = this.defines;
            n2 = this.current_row;
        } else {
            dBDataSet = this.binds_out;
            n2 = this.m_currentRank;
        }
        this.prepare_for_new_get(bl, n);
        if (dBDataSet.isNull(n3, n2)) {
            return null;
        }
        int n4 = dBDataSet.getType(n3);
        DBConversion dBConversion = this.connection.conversion;
        switch (n4) {
            case 23: 
            case 24: {
                if (dBDataSet.isStreamType(n3)) {
                    OracleInputStream oracleInputStream = (OracleInputStream)dBDataSet.getStreamItem(n3, n2);
                    if (oracleInputStream == null) {
                        return null;
                    }
                    return dBConversion.ConvertStream(oracleInputStream, 3);
                }
                byte[] byArray = dBDataSet.getBytesItem(n3, n2);
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
            }
            case 1: 
            case 8: {
                if (dBDataSet.isStreamType(n3)) {
                    OracleInputStream oracleInputStream = (OracleInputStream)dBDataSet.getStreamItem(n3, n2);
                    if (oracleInputStream == null) {
                        return null;
                    }
                    return dBConversion.ConvertStream(oracleInputStream, 1);
                }
                byte[] byArray = dBDataSet.getBytesItem(n3, n2);
                return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
            }
            case 96: {
                int n5;
                if (dBDataSet.isStreamType(n3)) {
                    OracleInputStream oracleInputStream = this.getStreamInternal(bl, n);
                    if (oracleInputStream == null) {
                        return null;
                    }
                    return dBConversion.ConvertStream(oracleInputStream, 1);
                }
                byte[] byArray = dBDataSet.getBytesItem(n3, n2);
                char[] cArray = new char[byArray.length];
                int n6 = dBConversion.CHARBytesToJavaChars(byArray, byArray.length, cArray);
                if (bl && this.connection.db_access.getNlsRatio() > 1 && n6 > 0 && this.dbdescription != null && this.dbdescription.length >= n && (n5 = this.dbdescription[n - 1].max_length) > 0 && n6 > n5) {
                    n6 = n5;
                }
                byte[] byArray2 = new byte[n6 * 2];
                int n7 = DBConversion.javaCharsToUcs2Bytes(cArray, n6, byArray2);
                return new ByteArrayInputStream(byArray2, 0, n7);
            }
        }
        DBError.throwSqlException(4);
        return null;
    }

    public synchronized int getUpdateCount() throws SQLException {
        this.connection.trace("Statement.getUpdateCount");
        DBAccess cfr_ignored_0 = this.connection.db_access;
        if (this.sql_kind != 2) {
            return -1;
        }
        return this.dbstmt.rows_processed;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warning;
    }

    private BFILE get_bfile_value(DBDataSet dBDataSet, int n, int n2) throws SQLException {
        byte[] byArray = dBDataSet.getBytesItem(n, n2);
        if (byArray == null) {
            return null;
        }
        return new BFILE(this.connection, byArray);
    }

    private BLOB get_blob_value(DBDataSet dBDataSet, int n, int n2) throws SQLException {
        byte[] byArray = dBDataSet.getBytesItem(n, n2);
        if (byArray == null) {
            return null;
        }
        return new BLOB(this.connection, byArray);
    }

    private CLOB get_clob_value(DBDataSet dBDataSet, int n, int n2) throws SQLException {
        byte[] byArray = dBDataSet.getBytesItem(n, n2);
        short s = this.getDBTypeForm(n);
        if (byArray == null) {
            return null;
        }
        return new CLOB(this.connection, byArray, s);
    }

    int get_column_index(String string) throws SQLException {
        if (this.dbdescription == null) {
            this.describe();
        }
        int n = this.dbdescription.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.dbdescription[n2].getColumnName().equalsIgnoreCase(string)) {
                return n2 + 1;
            }
            ++n2;
        }
        DBError.throwSqlException(6);
        return 0;
    }

    int get_internal_type(int n) throws SQLException {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 6;
            }
            case 999: {
                return 999;
            }
            case 1: {
                return 96;
            }
            case 12: {
                return 1;
            }
            case -1: {
                return 8;
            }
            case 91: 
            case 92: 
            case 93: {
                return 12;
            }
            case -100: {
                return 180;
            }
            case -101: {
                return 181;
            }
            case -102: {
                return 231;
            }
            case -3: 
            case -2: {
                return 23;
            }
            case -4: {
                return 24;
            }
            case -8: {
                return 104;
            }
            case 2004: {
                return 113;
            }
            case 2005: {
                return 112;
            }
            case -13: {
                return 114;
            }
            case -10: {
                return 102;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                return 109;
            }
            case 2006: {
                return 111;
            }
            case -14: {
                return 998;
            }
        }
        DBError.throwSqlException(4);
        return 0;
    }

    int get_value_external_type(boolean bl, int n) {
        if (bl) {
            return this.defines.getExternalType(n - 1);
        }
        return this.binds_out.getExternalType(n - 1);
    }

    int get_value_scale(boolean bl, int n) {
        return 0;
    }

    int get_value_type(boolean bl, int n) {
        if (bl) {
            return this.defines.getType(n - 1);
        }
        return this.binds_out.getType(n - 1);
    }

    private void initBatch() {
    }

    void initialize(int n, int n2, boolean bl) throws SQLException {
        this.connection.add_statement(this);
        this.initializeStateAndData(n, n2, this.connection.getDefaultAutoRefetch(), bl, false);
        this.initializeMetaData();
    }

    private synchronized void initializeColumnsToFetch(DBDataSet dBDataSet) {
        this.m_lastFetchedColumn = 0;
        this.m_currentDataSet = dBDataSet;
    }

    void initializeMetaData() throws SQLException {
        if (this.binds_in != null) {
            this.binds_in.cleanup();
        }
        if (this.binds_out != null) {
            this.binds_out.cleanup();
        }
        if (this.defines != null) {
            this.defines.cleanup();
        }
        this.defines = this.connection.db_access.createDBDataSet(this.connection, this, 0, 0);
        this.dbdescription = null;
        this.sql_string_changed = true;
        this.need_to_parse = true;
        this.need_to_prepare_define_buffer = true;
        this.columns_defined_by_user = false;
        this.m_userRsetType = DEFAULT_RSET_TYPE;
        this.m_realRsetType = 1;
        this.m_originalSql = null;
        this.m_revisedSql = null;
    }

    void initializeStateAndData(int n, int n2, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        this.current_result_set = null;
        this.last_index = 0;
        this.process_escapes = true;
        this.m_queryTimeout = 0;
        this.auto_rollback = 2;
        this.wait_option = 0;
        this.row_prefetch_changed = false;
        this.m_currentRank = 0;
        this.current_row = 0;
        this.valid_rows = 0;
        this.max_rows = 0;
        this.total_rows_visited = 0;
        this.max_field_size = 0;
        this.got_last_batch = false;
        this.closed = false;
        this.clear_params = true;
        this.serverCursor = bl2;
        this.m_scrollRset = null;
        this.m_needToAddIdentifier = false;
        this.default_fetch_direction = 1000;
        this.fixedString = this.connection.getDefaultFixedString();
        if (this.binds_in != null) {
            this.binds_in.cleanData();
        }
        if (this.binds_out != null) {
            this.binds_out.cleanData();
        }
        if (this.columns_defined_by_user && this.defines != null) {
            this.defines.cleanTypes();
        }
        if (bl3) {
            if (this.row_prefetch != n2) {
                this.need_to_parse = true;
            }
            if (this.batch != n) {
                this.need_to_parse = true;
            }
            if (this.m_autoRefetch != bl) {
                this.need_to_parse = true;
            }
        }
        this.row_prefetch = n2;
        this.default_row_prefetch = n2;
        this.batch = n;
        this.m_autoRefetch = bl;
        this.streams = null;
        this.stream_array = null;
    }

    private void internal_close() throws SQLException {
        this.closed = true;
        if (!this.connection.isStmtCacheEnabled() || this.m_cacheState == CLOSED || this.m_cacheState == NON_CACHED) {
            this.connection.remove_statement(this);
        }
        this.scrollStmt_cleanup(true);
        this.clearWarnings();
        this.cleanup();
    }

    public boolean isColumnSetNull(int n) {
        return this.columnSetNull;
    }

    boolean isRegularResultSet() throws SQLException {
        return this.m_userRsetType == DEFAULT_RSET_TYPE;
    }

    public boolean is_value_null(boolean bl, int n) throws SQLException {
        if (bl) {
            return this.defines.isNull(n - 1, this.current_row);
        }
        return this.binds_out.isNull(n - 1, this.m_currentRank);
    }

    public void notify_close_rset() throws SQLException {
        this.m_scrollRset = null;
        this.end_of_result_set();
    }

    protected final int parseExecuteFetchWithTimeout(DBStatement dBStatement, byte by, byte[] byArray, DBDataSet dBDataSet, int n, DBDataSet dBDataSet2, int n2) throws SQLException, IOException {
        int n3 = -1;
        if (this.m_queryTimeout == 0) {
            n3 = this.connection.db_access.parseExecuteFetch(dBStatement, by, byArray, dBDataSet, n, dBDataSet2, n2);
        } else {
            OracleCancelThread oracleCancelThread = null;
            try {
                oracleCancelThread = new OracleCancelThread(this, this.m_queryTimeout);
                oracleCancelThread.start();
                n3 = this.connection.db_access.parseExecuteFetch(dBStatement, by, byArray, dBDataSet, n, dBDataSet2, n2);
            }
            finally {
                Object var11_10 = null;
                oracleCancelThread.interrupt();
            }
        }
        return n3;
    }

    final int parseSqlKind() throws SQLException {
        String string = this.expandSqlEscapes(this.sql_query);
        this.sql_kind = this.getSqlKind(string);
        this.array_sql = this.strToDbaccessBytes(string);
        this.sql_string_changed = false;
        return this.sql_kind;
    }

    void prepare_for_new_get(boolean bl, int n) throws SQLException {
        if (bl) {
            if (this.current_result_set == null || this.current_result_set.closed) {
                DBError.throwSqlException(11);
            }
            if (this.defines == null || n > this.defines.getNoOfArgs() || n <= 0) {
                DBError.throwSqlException(3);
            }
            if (this.current_row < 0) {
                DBError.throwSqlException(14);
            }
        } else if (this.binds_out == null || n > this.binds_out.getNoOfArgs() || n <= 0 || !this.binds_out.dataAllocated(n - 1)) {
            DBError.throwSqlException(3);
        }
        if (this.stream_array != null && this.stream_array[n - 1] != null) {
            try {
                this.stream_array[n - 1].close();
            }
            catch (IOException iOException) {
                DBError.throwSqlException(iOException);
            }
        }
        this.last_was_column = bl;
        this.last_index = n;
    }

    void prepare_for_new_result(boolean bl) throws SQLException {
        this.clearWarnings();
        if (this.streams != null) {
            try {
                this.streams.close();
            }
            catch (IOException iOException) {
                DBError.throwSqlException(iOException);
            }
        }
        if (this.current_result_set != null) {
            this.current_result_set.internal_close();
            this.current_result_set = null;
        }
        this.current_row = -1;
        this.valid_rows = 0;
        this.total_rows_visited = 0;
        this.got_last_batch = false;
        if (!this.columns_defined_by_user && this.need_to_parse) {
            this.need_to_prepare_define_buffer = true;
        }
        if (this.need_to_parse) {
            this.dbdescription = null;
        }
        if (bl && this.row_prefetch != this.default_row_prefetch && !this.defines.hasStreamType()) {
            this.row_prefetch = this.default_row_prefetch;
            this.row_prefetch_changed = true;
        }
    }

    void printState(String string) throws SQLException {
        System.out.println(String.valueOf(String.valueOf(this)) + ": " + string + ":");
        System.out.println("  sql_query=" + this.sql_query);
        System.out.println("  sql_string_changed=" + this.sql_string_changed);
        System.out.println("  row_prefetch=" + this.row_prefetch);
        System.out.println("  default_row_prefetch=" + this.default_row_prefetch);
        System.out.println("  row_prefetch_changed=" + this.row_prefetch_changed);
        System.out.println("  batch=" + this.batch);
        System.out.println("  m_currentRank=" + this.m_currentRank);
        System.out.println("  current_row=" + this.current_row);
        System.out.println("  valid_rows=" + this.valid_rows);
        System.out.println("  m_autoRefetch=" + this.m_autoRefetch);
        System.out.println("  serverCursor=" + this.serverCursor);
        System.out.println("  current_result_set=" + this.current_result_set);
        System.out.println("  process_escapes=" + this.process_escapes);
        System.out.println("  m_queryTimeout=" + this.m_queryTimeout);
        System.out.println("  dbstmt=" + this.dbstmt);
        System.out.println("  streams=" + this.streams);
        System.out.println("  stream_array=" + this.stream_array);
        System.out.println("  need_to_parse=" + this.need_to_parse);
        System.out.println("  need_to_prepare_define_buffer=" + this.need_to_prepare_define_buffer);
        System.out.println("  columns_defined_by_user=" + this.columns_defined_by_user);
        if (this.array_sql != null) {
            System.out.println("  array_sql: " + OracleLog.bytesToFormattedStr(this.array_sql, this.array_sql.length, "  "));
        } else {
            System.out.println("  array_sql: null");
        }
        if (this.binds_in != null) {
            System.out.println("  binds_in: " + this.binds_in.getInfoString());
        } else {
            System.out.println("  binds_in: null");
        }
        if (this.defines != null) {
            System.out.println("  defines: " + this.defines.getInfoString());
        } else {
            System.out.println("  defines: null");
        }
        System.out.println(String.valueOf(String.valueOf(this)) + ": end statement state");
    }

    boolean sameKey(String string) {
        if (this.m_createState == 2 && this.m_key != null) {
            return this.m_key.equals(string);
        }
        if (this.m_createState == 1 && this.sql_query != null) {
            return this.sql_query.equals(string);
        }
        return false;
    }

    void scrollStmt_cleanup(boolean bl) throws SQLException {
        if (bl) {
            this.m_originalSql = null;
            this.m_revisedSql = null;
        }
        if (this.m_scrollRset != null) {
            this.m_scrollRset.close();
            this.m_scrollRset = null;
        }
    }

    public int sendBatch() throws SQLException {
        return 0;
    }

    public void setAutoRefetch(boolean bl) throws SQLException {
        this.m_autoRefetch = bl;
    }

    public void setCursorName(String string) throws SQLException {
        this.connection.trace("Statement.setCursorName");
        DBError.throwSqlException(23);
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.connection.trace("Statement.setEscapeProcessing");
        this.process_escapes = bl;
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n == 1000) {
            this.default_fetch_direction = n;
        } else if (n == 1001 || n == 1002) {
            this.default_fetch_direction = 1000;
            this.m_warning = DBError.addSqlWarning(this.m_warning, 87);
        } else {
            DBError.throwSqlException(68, "setFetchDirection");
        }
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.setPrefetchInternal(n, false, true);
    }

    public void setFixedString(boolean bl) {
        this.fixedString = bl;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            DBError.throwSqlException(68);
        }
        this.max_field_size = n;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            DBError.throwSqlException(68);
        }
        this.max_rows = n;
    }

    protected void setPrefetchInternal(int n, boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            if (n <= 0) {
                DBError.throwSqlException(20);
            }
        } else if (n < 0) {
            DBError.throwSqlException(68, "setFetchSize");
        } else if (n == 0) {
            n = this.connection.getDefaultRowPrefetch();
        }
        if (bl2) {
            if (n != this.default_row_prefetch) {
                this.default_row_prefetch = n;
                if (this.current_result_set == null || this.current_result_set.closed) {
                    this.row_prefetch_changed = true;
                }
            }
        } else if (n != this.row_prefetch && !this.defines.hasStreamType()) {
            this.row_prefetch = n;
            this.row_prefetch_changed = true;
        }
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            DBError.throwSqlException(68);
        }
        this.m_queryTimeout = n;
    }

    public synchronized void setResultSetCache(oracle.jdbc.OracleResultSetCache oracleResultSetCache) throws SQLException {
        try {
            if (oracleResultSetCache == null) {
                DBError.throwSqlException(68);
            }
            if (this.m_cache != null) {
                this.m_cache.close();
            }
            this.m_cache = oracleResultSetCache;
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
    }

    public synchronized void setResultSetCache(OracleResultSetCache oracleResultSetCache) throws SQLException {
        this.setResultSetCache((oracle.jdbc.OracleResultSetCache)oracleResultSetCache);
    }

    public synchronized void setRowPrefetch(int n) throws SQLException {
        this.setPrefetchInternal(n, true, true);
    }

    final byte[] strToDbaccessBytes(String string) throws SQLException {
        return this.connection.conversion.StringToCharBytes(string);
    }

    boolean wasNullValue() throws SQLException {
        if (this.last_index == 0) {
            DBError.throwSqlException(24);
        }
        DBAccess cfr_ignored_0 = this.connection.db_access;
        if (this.sql_kind == 0) {
            return this.defines.isNull(this.last_index - 1, this.current_row);
        }
        return this.binds_out.isNull(this.last_index - 1, this.m_currentRank);
    }
}

