/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oci.OracleOCIConnection;
import oracle.jdbc.oci8.OCIDBAccess;
import oracle.jdbc.pool.OracleDataSource;

public class OracleOCIConnectionPool
extends OracleDataSource {
    public OracleOCIConnection m_connection_pool;
    public static final String IS_CONNECTION_POOLING = "is_connection_pooling";
    private int m_conn_min_limit = 0;
    private int m_conn_max_limit = 0;
    private int m_conn_increment = 0;
    private int m_conn_active_size = 0;
    private int m_conn_pool_size = 0;
    private int m_conn_timeout = 0;
    private String m_conn_nowait = "false";
    private int m_is_transactions_distributed = 0;
    public static final String CONNPOOL_OBJECT = "connpool_object";
    public static final String CONNPOOL_LOGON_MODE = "connection_pool";
    public static final String CONNECTION_POOL = "connection_pool";
    public static final String CONNPOOL_CONNECTION = "connpool_connection";
    public static final String CONNPOOL_PROXY_CONNECTION = "connpool_proxy_connection";
    public static final String CONNPOOL_ALIASED_CONNECTION = "connpool_alias_connection";
    public static final String PROXY_USER_NAME = "proxy_user_name";
    public static final String PROXY_DISTINGUISHED_NAME = "proxy_distinguished_name";
    public static final String PROXY_CERTIFICATE = "proxy_certificate";
    public static final String PROXY_ROLES = "proxy_roles";
    public static final String PROXY_NUM_ROLES = "proxy_num_roles";
    public static final String PROXY_PASSWORD = "proxy_password";
    public static final String PROXYTYPE = "proxytype";
    public static final String PROXYTYPE_USER_NAME = "proxytype_user_name";
    public static final String PROXYTYPE_DISTINGUISHED_NAME = "proxytype_distinguished_name";
    public static final String PROXYTYPE_CERTIFICATE = "proxytype_certificate";
    public static final String CONNECTION_ID = "connection_id";
    public static String CONNPOOL_MIN_LIMIT = "connpool_min_limit";
    public static String CONNPOOL_MAX_LIMIT = "connpool_max_limit";
    public static String CONNPOOL_INCREMENT = "connpool_increment";
    public static String CONNPOOL_ACTIVE_SIZE = "connpool_active_size";
    public static String CONNPOOL_POOL_SIZE = "connpool_pool_size";
    public static String CONNPOOL_TIMEOUT = "connpool_timeout";
    public static String CONNPOOL_NOWAIT = "connpool_nowait";
    public static String CONNPOOL_IS_POOLCREATED = "connpool_is_poolcreated";
    public static final String TRANSACTIONS_DISTRIBUTED = "transactions_distributed";
    private Hashtable m_lconnections = null;
    private boolean m_poolCreated = false;
    protected int m_stmtCacheSize = 0;
    protected boolean m_stmtClearMetaData = false;

    public OracleOCIConnectionPool() throws SQLException {
        this.m_lconnections = new Hashtable(10);
        this.setDriverType("oci8");
    }

    public OracleOCIConnectionPool(String string, String string2, String string3) throws SQLException {
        this.trace("User us " + string + "URL is " + string3);
        this.m_lconnections = new Hashtable(10);
        this.setDriverType("oci8");
        this.setURL(string3);
        this.setUser(string);
        this.setPassword(string2);
        this.createConnectionPool(null);
    }

    public OracleOCIConnectionPool(String string, String string2, String string3, Properties properties) throws SQLException {
        this.trace("User us " + string + "URL is " + string3);
        this.m_lconnections = new Hashtable(10);
        this.setDriverType("oci8");
        this.setURL(string3);
        this.setUser(string);
        this.setPassword(string2);
        this.createConnectionPool(properties);
    }

    private void checkPoolConfig(Properties properties, Properties properties2) throws SQLException {
        String string = (String)((Hashtable)properties).get(TRANSACTIONS_DISTRIBUTED);
        String string2 = (String)((Hashtable)properties).get(CONNPOOL_NOWAIT);
        if (string != null && !string.equalsIgnoreCase("true") || string2 != null && !string2.equalsIgnoreCase("true") || ((Hashtable)properties).get(CONNPOOL_MIN_LIMIT) == null || ((Hashtable)properties).get(CONNPOOL_MAX_LIMIT) == null || ((Hashtable)properties).get(CONNPOOL_INCREMENT) == null || Integer.decode((String)((Hashtable)properties).get(CONNPOOL_MIN_LIMIT)) < 0 || Integer.decode((String)((Hashtable)properties).get(CONNPOOL_MAX_LIMIT)) < 0 || Integer.decode((String)((Hashtable)properties).get(CONNPOOL_INCREMENT)) < 0) {
            DBError.throwSqlException(106, "");
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = properties.getProperty(string3);
            if (string3 == TRANSACTIONS_DISTRIBUTED || string3 == CONNPOOL_NOWAIT) {
                ((Hashtable)properties2).put(string3, "true");
                continue;
            }
            ((Hashtable)properties2).put(string3, string4);
        }
    }

    public synchronized void close() throws SQLException {
        this.trace("User us " + this.m_user + "URL is " + this.getURL());
        if (!this.isPoolCreated()) {
            return;
        }
        Enumeration enumeration = this.m_lconnections.elements();
        while (enumeration.hasMoreElements()) {
            OracleOCIConnection oracleOCIConnection = (OracleOCIConnection)enumeration.nextElement();
            if (oracleOCIConnection == null || oracleOCIConnection == this.m_connection_pool) continue;
            oracleOCIConnection.close();
        }
        this.m_connection_pool.close();
    }

    public synchronized void connectionClosed(OracleOCIConnection oracleOCIConnection) throws SQLException {
        if (this.m_lconnections.remove(oracleOCIConnection) == null) {
            DBError.throwSqlException(1, "internal OracleOCIConnectionPool error");
        }
    }

    private void createConnectionPool(Properties properties) throws SQLException {
        if (this.isPoolCreated()) {
            return;
        }
        if (this.m_user == null || this.m_password == null) {
            DBError.throwSqlException(106, " ");
        } else {
            Properties properties2 = new Properties();
            if (properties != null) {
                this.checkPoolConfig(properties, properties2);
            }
            ((Hashtable)properties2).put(IS_CONNECTION_POOLING, "true");
            ((Hashtable)properties2).put("user", this.m_user);
            ((Hashtable)properties2).put("password", this.m_password);
            ((Hashtable)properties2).put("connection_pool", "connection_pool");
            if (this.getURL() == null) {
                this.makeURL();
            }
            this.trace("User us " + this.m_user + "URL is " + this.getURL());
            this.m_connection_pool = (OracleOCIConnection)DriverManager.getConnection(this.m_url, properties2);
            this.m_poolCreated = true;
            this.m_connection_pool.setConnectionPool(this);
            this.m_lconnections.put(this.m_connection_pool, this.m_connection_pool);
            this.storePoolProperties();
            if (properties != null && properties.getProperty(TRANSACTIONS_DISTRIBUTED) != null) {
                this.m_is_transactions_distributed = 1;
            }
        }
    }

    public synchronized int getActiveSize() throws SQLException {
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties properties = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_ACTIVE_SIZE);
        int n = Integer.decode(string);
        return n;
    }

    public synchronized OracleConnection getAliasedConnection(byte[] byArray) throws SQLException {
        this.trace("User us " + this.m_user + "URL is " + this.getURL());
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties properties = new Properties();
        ((Hashtable)properties).put(IS_CONNECTION_POOLING, "true");
        ((Hashtable)properties).put(CONNECTION_ID, byArray);
        ((Hashtable)properties).put("connection_pool", CONNPOOL_ALIASED_CONNECTION);
        ((Hashtable)properties).put(CONNPOOL_OBJECT, (OCIDBAccess)this.m_connection_pool.db_access);
        OracleOCIConnection oracleOCIConnection = (OracleOCIConnection)DriverManager.getConnection(this.m_url, properties);
        oracleOCIConnection.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        this.m_lconnections.put(oracleOCIConnection, oracleOCIConnection);
        oracleOCIConnection.setConnectionPool(this);
        return oracleOCIConnection;
    }

    public synchronized Connection getConnection() throws SQLException {
        this.trace("User us " + this.m_user + "URL is " + this.getURL());
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Connection connection = this.getConnection(this.m_user, this.m_password);
        return connection;
    }

    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        this.trace("User us " + this.m_user + "URL is " + this.getURL());
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties properties = new Properties();
        ((Hashtable)properties).put(IS_CONNECTION_POOLING, "true");
        ((Hashtable)properties).put("user", string);
        ((Hashtable)properties).put("password", string2);
        ((Hashtable)properties).put("connection_pool", CONNPOOL_CONNECTION);
        ((Hashtable)properties).put(CONNPOOL_OBJECT, (OCIDBAccess)this.m_connection_pool.db_access);
        OracleOCIConnection oracleOCIConnection = (OracleOCIConnection)DriverManager.getConnection(this.m_url, properties);
        oracleOCIConnection.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        this.m_lconnections.put(oracleOCIConnection, oracleOCIConnection);
        oracleOCIConnection.setConnectionPool(this);
        return oracleOCIConnection;
    }

    public synchronized int getConnectionIncrement() throws SQLException {
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties properties = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_INCREMENT);
        int n = Integer.decode(string);
        return n;
    }

    public synchronized int getMaxLimit() throws SQLException {
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties properties = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_MAX_LIMIT);
        int n = Integer.decode(string);
        return n;
    }

    public synchronized int getMinLimit() throws SQLException {
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties properties = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_MIN_LIMIT);
        int n = Integer.decode(string);
        return n;
    }

    public synchronized String getNoWait() throws SQLException {
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties properties = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        return properties.getProperty(CONNPOOL_NOWAIT);
    }

    public synchronized Properties getPoolConfig() throws SQLException {
        this.trace("User us " + this.m_user + "URL is " + this.getURL());
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties properties = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        ((Hashtable)properties).put(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated()));
        return properties;
    }

    public synchronized int getPoolSize() throws SQLException {
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties properties = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_POOL_SIZE);
        int n = Integer.decode(string);
        return n;
    }

    public synchronized OracleConnection getProxyConnection(String string, Properties properties) throws SQLException {
        this.trace("User us " + this.m_user + "URL is " + this.getURL());
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        if (string == PROXYTYPE_USER_NAME) {
            ((Hashtable)properties).put("user", properties.getProperty(PROXY_USER_NAME));
        } else if (string == PROXYTYPE_DISTINGUISHED_NAME) {
            ((Hashtable)properties).put("user", properties.getProperty(PROXY_DISTINGUISHED_NAME));
        } else if (string == PROXYTYPE_CERTIFICATE) {
            ((Hashtable)properties).put("user", String.valueOf(properties.getProperty(PROXY_USER_NAME)));
        } else {
            DBError.throwSqlException(107, "null properties");
        }
        ((Hashtable)properties).put(IS_CONNECTION_POOLING, "true");
        ((Hashtable)properties).put(PROXYTYPE, string);
        String[] stringArray = (String[])((Hashtable)properties).get(PROXY_ROLES);
        if (stringArray != null) {
            ((Hashtable)properties).put(PROXY_NUM_ROLES, new Integer(stringArray.length));
        } else {
            ((Hashtable)properties).put(PROXY_NUM_ROLES, new Integer(0));
        }
        ((Hashtable)properties).put("connection_pool", CONNPOOL_PROXY_CONNECTION);
        ((Hashtable)properties).put(CONNPOOL_OBJECT, (OCIDBAccess)this.m_connection_pool.db_access);
        OracleOCIConnection oracleOCIConnection = (OracleOCIConnection)DriverManager.getConnection(this.m_url, properties);
        oracleOCIConnection.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        this.m_lconnections.put(oracleOCIConnection, oracleOCIConnection);
        oracleOCIConnection.setConnectionPool(this);
        return oracleOCIConnection;
    }

    public synchronized Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        super.addRefProperties(reference);
        reference.add(new StringRefAddr(CONNPOOL_MIN_LIMIT, String.valueOf(this.m_conn_min_limit)));
        reference.add(new StringRefAddr(CONNPOOL_MAX_LIMIT, String.valueOf(this.m_conn_max_limit)));
        reference.add(new StringRefAddr(CONNPOOL_INCREMENT, String.valueOf(this.m_conn_increment)));
        reference.add(new StringRefAddr(CONNPOOL_ACTIVE_SIZE, String.valueOf(this.m_conn_active_size)));
        reference.add(new StringRefAddr(CONNPOOL_POOL_SIZE, String.valueOf(this.m_conn_pool_size)));
        reference.add(new StringRefAddr(CONNPOOL_TIMEOUT, String.valueOf(this.m_conn_timeout)));
        reference.add(new StringRefAddr(CONNPOOL_NOWAIT, this.m_conn_nowait));
        reference.add(new StringRefAddr(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated())));
        reference.add(new StringRefAddr(TRANSACTIONS_DISTRIBUTED, String.valueOf(this.isDistributedTransEnabled())));
        return reference;
    }

    public synchronized int getStmtCacheSize() {
        return this.m_stmtCacheSize;
    }

    public synchronized int getTimeout() throws SQLException {
        if (!this.isPoolCreated()) {
            this.createConnectionPool(null);
        }
        Properties properties = ((OCIDBAccess)this.m_connection_pool.db_access).getConnectionPoolInfo();
        String string = properties.getProperty(CONNPOOL_TIMEOUT);
        int n = Integer.decode(string);
        return n;
    }

    public synchronized boolean isDistributedTransEnabled() {
        return this.m_is_transactions_distributed == 1;
    }

    public synchronized boolean isPoolCreated() {
        return this.m_poolCreated;
    }

    public synchronized boolean isStmtCacheEnabled() {
        return this.m_stmtCacheSize > 0;
    }

    public synchronized void setPoolConfig(Properties properties) throws SQLException {
        this.trace("User us " + this.m_user + "URL is " + this.getURL());
        Properties properties2 = new Properties();
        if (properties == null) {
            DBError.throwSqlException(106, "null properties");
        }
        if (!this.isPoolCreated()) {
            this.createConnectionPool(properties);
        } else {
            this.checkPoolConfig(properties, properties2);
            ((OCIDBAccess)this.m_connection_pool.db_access).setConnectionPoolInfo(properties2, this.m_connection_pool);
        }
        this.storePoolProperties();
    }

    public synchronized void setStmtCacheSize(int n) throws SQLException {
        this.setStmtCacheSize(n, false);
    }

    public synchronized void setStmtCacheSize(int n, boolean bl) throws SQLException {
        this.trace("User us " + this.m_user + "URL is " + this.getURL());
        if (n < 0) {
            DBError.throwSqlException(68);
        }
        this.m_stmtCacheSize = n;
        this.m_stmtClearMetaData = bl;
    }

    private synchronized void storePoolProperties() throws SQLException {
        Properties properties = this.getPoolConfig();
        this.m_conn_min_limit = Integer.decode(properties.getProperty(CONNPOOL_MIN_LIMIT));
        this.m_conn_max_limit = Integer.decode(properties.getProperty(CONNPOOL_MAX_LIMIT));
        this.m_conn_increment = Integer.decode(properties.getProperty(CONNPOOL_INCREMENT));
        this.m_conn_active_size = Integer.decode(properties.getProperty(CONNPOOL_ACTIVE_SIZE));
        this.m_conn_pool_size = Integer.decode(properties.getProperty(CONNPOOL_POOL_SIZE));
        this.m_conn_timeout = Integer.decode(properties.getProperty(CONNPOOL_TIMEOUT));
        this.m_conn_nowait = properties.getProperty(CONNPOOL_NOWAIT);
    }
}

