/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.io.IOException;
import java.io.InputStream;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataSource;

public class DataSourceStream
implements DataSource {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    protected InputStream in;
    protected int bufferSize;
    protected long totalRead = 0L;

    public DataSourceStream(InputStream in) {
        this(in, 16384);
    }

    public DataSourceStream(InputStream in, int bufferSize) {
        this.in = in;
        this.bufferSize = bufferSize;
    }

    @Override
    public Buffer read() throws IOException {
        byte[] buf = new byte[this.bufferSize];
        int read = this.in.read(buf);
        if (read == -1) {
            return null;
        }
        Buffer result = new Buffer(buf, read, this.totalRead);
        this.totalRead += (long)read;
        return result;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long totalSize() {
        return -1L;
    }
}

