/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.urlcopy;

import java.io.PrintStream;
import java.util.Calendar;
import org.globus.io.urlcopy.UrlCopyListener;

public class XferBars
implements UrlCopyListener,
Runnable {
    protected long totalBytes = -1L;
    protected long sentBytes = -1L;
    protected PrintStream outStream;
    protected int colCount;
    protected int freq;
    protected boolean pretty;
    protected boolean done = false;
    protected boolean first = true;
    protected Thread lT;
    protected Calendar nextUpdate = null;

    protected void init(boolean pretty, PrintStream out, int cols, int freq) {
        this.pretty = pretty;
        this.outStream = out;
        this.colCount = cols;
        this.freq = freq;
    }

    public XferBars() {
        this.init(true, System.out, 80, 250);
    }

    public XferBars(boolean pretty) {
        this.init(pretty, System.out, 80, 250);
    }

    public XferBars(boolean pretty, PrintStream out) {
        this.init(pretty, out, 80, 250);
    }

    public XferBars(boolean pretty, PrintStream out, int cols) {
        this.init(pretty, out, cols, 250);
    }

    public XferBars(boolean pretty, PrintStream out, int cols, int freq) {
        this.init(pretty, out, cols, freq);
    }

    protected void printOut() {
        String outS = this.pretty && this.totalBytes > 0L && this.sentBytes >= 0L ? this.makeBar(this.sentBytes, this.totalBytes) : this.prettyCount(this.sentBytes, 6);
        this.outStream.print("\r");
        this.outStream.print(outS);
        this.outStream.flush();
    }

    @Override
    public synchronized void transfer(long transferedBytes, long totalBytes) {
        this.totalBytes = totalBytes;
        this.sentBytes = transferedBytes;
        if (this.first) {
            this.outStream.print("\n");
            this.first = false;
        } else {
            Calendar now = Calendar.getInstance();
            if (now.before(this.nextUpdate)) {
                return;
            }
        }
        this.nextUpdate = Calendar.getInstance();
        this.nextUpdate.add(14, this.freq);
        this.printOut();
    }

    @Override
    public synchronized void transferError(Exception exception) {
        this.printOut();
        this.outStream.print("\n");
        this.outStream.println("Error");
        this.outStream.flush();
    }

    @Override
    public synchronized void transferCompleted() {
        this.printOut();
        this.outStream.print("\n");
        this.outStream.println("Done\n");
        this.outStream.flush();
    }

    protected String prettyCount(long tb, int maxLen) {
        float tbF;
        int ndx = 0;
        String[] suffix = new String[]{" B", "KB", "MB", "GB"};
        if (tb < 0L) {
            return "Unknown";
        }
        for (tbF = (float)tb; tbF > 10240.0f && ndx < suffix.length - 1; ++ndx, tbF /= 1024.0f) {
        }
        tb = (int)tbF;
        String rc = new Long(tb).toString();
        if (rc.length() > maxLen) {
            int endNdx = maxLen - 3;
            rc = rc.substring(0, endNdx) + "...";
        } else {
            if (rc.length() < maxLen - 2) {
                tb = (int)(tbF * 100.0f);
                tbF = (float)tb / 100.0f;
                rc = new Float(tbF).toString();
            }
            int spaceCount = maxLen - rc.length();
            for (int i = 0; i < spaceCount; ++i) {
                rc = " " + rc;
            }
        }
        rc = rc + suffix[ndx];
        return rc;
    }

    protected String makeBar(long sofar, long total) {
        String byteString = this.prettyCount(sofar, 6);
        String doneCh = "X";
        String notDoneCh = ".";
        int pad = 9;
        int pgLen = this.colCount - byteString.length() - pad;
        int percent = (int)(sofar * 100L / total);
        int xCount = percent * this.colCount / 100;
        String bar = byteString + " [";
        for (int i = 0; i < pgLen; ++i) {
            bar = i < xCount ? bar + doneCh : bar + notDoneCh;
        }
        bar = bar + "] " + percent + "% ";
        return bar;
    }

    @Override
    public synchronized void run() {
    }
}

