/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.globus.net.PortRange;

public class DatagramSocketFactory {
    private static DatagramSocketFactory defaultFactory = null;
    private PortRange portRange = PortRange.getUdpSourceInstance();

    protected DatagramSocketFactory() {
    }

    public static synchronized DatagramSocketFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = new DatagramSocketFactory();
        }
        return defaultFactory;
    }

    public DatagramSocket createDatagramSocket() throws IOException {
        return this.createDatagramSocket(0, null);
    }

    public DatagramSocket createDatagramSocket(int port) throws IOException {
        return this.createDatagramSocket(port, null);
    }

    public DatagramSocket createDatagramSocket(int port, InetAddress localAddr) throws IOException {
        if (this.portRange.isEnabled() && port == 0) {
            return new PrDatagramSocket(this.createDatagramSocket(localAddr));
        }
        return new DatagramSocket(port, localAddr);
    }

    private DatagramSocket createDatagramSocket(InetAddress localAddr) throws IOException {
        DatagramSocket socket = null;
        int localPort = 0;
        while (true) {
            localPort = this.portRange.getFreePort(localPort);
            try {
                socket = new DatagramSocket(localPort, localAddr);
                this.portRange.setUsed(localPort);
                return socket;
            }
            catch (BindException e) {
                ++localPort;
                continue;
            }
            break;
        }
    }

    class PrDatagramSocket
    extends DatagramSocket {
        private DatagramSocket socket;

        public PrDatagramSocket(DatagramSocket socket) throws SocketException {
            this.socket = socket;
        }

        @Override
        public void connect(InetAddress address, int port) {
            this.socket.connect(address, port);
        }

        @Override
        public void disconnect() {
            this.socket.disconnect();
        }

        @Override
        public InetAddress getInetAddress() {
            return this.socket.getInetAddress();
        }

        @Override
        public int getPort() {
            return this.socket.getPort();
        }

        @Override
        public void send(DatagramPacket p) throws IOException {
            this.socket.send(p);
        }

        @Override
        public void receive(DatagramPacket p) throws IOException {
            this.socket.receive(p);
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.socket.getLocalAddress();
        }

        @Override
        public int getLocalPort() {
            return this.socket.getLocalPort();
        }

        @Override
        public void setSoTimeout(int timeout) throws SocketException {
            this.socket.setSoTimeout(timeout);
        }

        @Override
        public int getSoTimeout() throws SocketException {
            return this.socket.getSoTimeout();
        }

        @Override
        public void setSendBufferSize(int size) throws SocketException {
            this.socket.setSendBufferSize(size);
        }

        @Override
        public int getSendBufferSize() throws SocketException {
            return this.socket.getSendBufferSize();
        }

        @Override
        public void setReceiveBufferSize(int size) throws SocketException {
            this.socket.setReceiveBufferSize(size);
        }

        @Override
        public int getReceiveBufferSize() throws SocketException {
            return this.socket.getReceiveBufferSize();
        }

        @Override
        public void close() {
            int port = this.getLocalPort();
            this.socket.close();
            if (port != -1) {
                DatagramSocketFactory.this.portRange.free(port);
            }
        }
    }
}

