/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    public static final int DES_KEY_LEN = 8;
    private byte[] keyBytes = new byte[8];
    private static final int N_DES_WEAK_KEYS = 16;
    private static byte[] DES_weak_keys = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 31, 31, 31, 31, 14, 14, 14, 14, -32, -32, -32, -32, -15, -15, -15, -15, -2, -2, -2, -2, -2, -2, -2, -2, 1, -2, 1, -2, 1, -2, 1, -2, 31, -32, 31, -32, 14, -15, 14, -15, 1, -32, 1, -32, 1, -15, 1, -15, 31, -2, 31, -2, 14, -2, 14, -2, 1, 31, 1, 31, 1, 14, 1, 14, -32, -2, -32, -2, -15, -2, -15, -2, -2, 1, -2, 1, -2, 1, -2, 1, -32, 31, -32, 31, -15, 14, -15, 14, -32, 1, -32, 1, -15, 1, -15, 1, -2, 31, -2, 31, -2, 14, -2, 14, 31, 1, 31, 1, 14, 1, 14, 1, -2, -32, -2, -32, -2, -15, -2, -15};

    public DESKeySpec(byte[] byArray) throws InvalidKeyException {
        if (byArray.length < 8) {
            throw new InvalidKeyException("DES key material too short in construction");
        }
        System.arraycopy(byArray, 0, this.keyBytes, 0, this.keyBytes.length);
    }

    public DESKeySpec(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("DES key material too short in construction");
        }
        System.arraycopy(byArray, n, this.keyBytes, 0, this.keyBytes.length);
    }

    public byte[] getKey() {
        byte[] byArray = new byte[8];
        System.arraycopy(this.keyBytes, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public static boolean isParityAdjusted(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("key material too short in DESKeySpec.isParityAdjusted");
        }
        int n2 = 0;
        while (n2 < 8) {
            byte by = byArray[n2 + n];
            int n3 = 0;
            while (by != 0) {
                if ((by & 1) != 0) {
                    ++n3;
                }
                by = (byte)((by & 0xFF) >> 1);
            }
            if (n3 & true ? (byArray[n2 + n] & 1) == 1 : (byArray[n2 + n] & 1) != 1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isWeak(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("key material too short in DESKeySpec.isWeak");
        }
        int n2 = 0;
        while (n2 < 16) {
            block4: {
                int n3 = 0;
                while (n3 < 8) {
                    if (byArray[n3 + n] == DES_weak_keys[n2 * 8 + n3]) {
                        ++n3;
                        continue;
                    }
                    break block4;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }
}

