/*
 * Decompiled with CFR 0.152.
 */
package org.birncommunity.gridftp.tar.impl.compress;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.birncommunity.gridftp.tar.impl.compress.UntarFileEntryHandler;

public class UntarFileEntryHandlerImplementation
implements UntarFileEntryHandler {
    private Log log = LogFactory.getLog(UntarFileEntryHandlerImplementation.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUntarFileEntry(TarArchiveInputStream tais, File destDir, TarArchiveEntry tae) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(destDir, tae.getName()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("processing tar entry " + tae.getName()));
        }
        try {
            long entryLength = tae.getSize();
            int numRead = 0;
            long totalNumWritten = 0L;
            byte[] buffer = new byte[512];
            while ((numRead = tais.read(buffer)) >= 0) {
                fos.write(buffer, 0, numRead);
                totalNumWritten += (long)numRead;
            }
            if (totalNumWritten != entryLength) {
                throw new IOException("Unable to write file " + tae.getName() + " completely");
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }
}

