/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirndownloader;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.birncommunity.sample.proxy.LocalCredentialHelper;
import org.globus.myproxy.MyProxy;
import org.ietf.jgss.GSSCredential;
import org.nbirn.fbirndownloader.CanceledException;
import org.nbirn.fbirndownloader.CredentialManagerException;
import org.nbirn.fbirndownloader.Main;

public class CredentialManager {
    private GSSCredential _credential = null;
    private Component _parent = null;
    private Main _main = null;
    private String _myproxyuser = null;
    private String _myproxypwd = null;
    private String _myproxyhost = null;
    private int _myproxyport = 7512;
    private boolean _canceled = false;
    GetMyProxyConnectionParams _getparamsobj = null;

    CredentialManager(Main main) {
        this(main, null);
    }

    CredentialManager(Main main, Component parent) {
        if (main == null) {
            throw new NullPointerException("Got null pointer for main");
        }
        this._main = main;
        this._parent = parent;
    }

    public boolean wasCanceled() {
        return this._canceled;
    }

    public void resetCanceled() {
        this._canceled = false;
    }

    public boolean canGetUserInput() {
        return this._parent != null;
    }

    synchronized GSSCredential getCredential() {
        return this._credential;
    }

    synchronized GSSCredential getLocalCredential() {
        this._canceled = false;
        try {
            return new LocalCredentialHelper().getDefaultCredential();
        }
        catch (Exception e) {
            return null;
        }
    }

    synchronized GSSCredential getNewCredential(String msg) throws CanceledException, CredentialManagerException {
        String tmpport;
        this._canceled = false;
        this._credential = null;
        if (this._myproxyhost == null) {
            this._myproxyhost = this._main.getProperties().getProperty("MyProxyHost");
        }
        if (this._myproxyhost == null) {
            this._myproxyhost = System.getenv("MYPROXY_SERVER");
        }
        if (this._myproxyport == -1 && (tmpport = this._main.getProperties().getProperty("MyProxyPort")) != null) {
            this._myproxyport = Integer.valueOf(tmpport);
        }
        if (this._myproxyport == -1) {
            this._myproxyport = 7512;
        }
        if (this._myproxyuser == null) {
            this._myproxyuser = this._main.getProperties().getProperty("MyProxyUser");
        }
        if (this._parent != null) {
            if (this._getparamsobj == null) {
                this._getparamsobj = new GetMyProxyConnectionParams(this._parent, this._myproxyhost, this._myproxyport == -1 ? null : new Integer(this._myproxyport).toString(), this._myproxyuser, this._myproxypwd);
            }
            this._getparamsobj.setMessage(msg);
            this._getparamsobj._canceled = false;
            try {
                SwingUtilities.invokeAndWait(this._getparamsobj);
            }
            catch (Exception e) {
                throw new CredentialManagerException("Error occurred getting credential params", e);
            }
            if (this._getparamsobj._canceled) {
                this._canceled = true;
                throw new CanceledException("Operation canceled by user");
            }
            this._myproxyhost = this._getparamsobj._host;
            this._myproxyport = this._getparamsobj._port != null ? Integer.valueOf(this._getparamsobj._port) : -1;
            this._myproxyuser = this._getparamsobj._user;
            this._myproxypwd = this._getparamsobj._pwd;
        }
        this._main.changeProperty("MyProxyHost", this._myproxyhost);
        this._main.changeProperty("MyProxyPort", "" + this._myproxyport);
        this._main.changeProperty("MyProxyUser", this._myproxyuser);
        MyProxy myproxy = new MyProxy(this._myproxyhost, this._myproxyport);
        try {
            this._credential = myproxy.get(this._myproxyuser, this._myproxypwd, 0);
        }
        catch (Exception e) {
            this._credential = null;
        }
        return this._credential;
    }

    private class GetMyProxyConnectionParams
    implements Runnable {
        Component _parent = null;
        String _host = null;
        String _port = null;
        String _user = null;
        String _pwd = null;
        String _message = null;
        boolean _canceled = false;

        GetMyProxyConnectionParams(Component parent, String host, String port, String user, String pwd) {
            this._parent = parent;
            this._host = host;
            this._port = port;
            this._user = user;
            this._pwd = pwd;
        }

        void setMessage(String message) {
            this._message = message;
        }

        public void run() {
            int ret;
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            JPanel panel = new JPanel(layout);
            JTextField hostfield = new JTextField(this._host);
            JTextField portfield = new JTextField(this._port);
            JTextField userfield = new JTextField(this._user);
            JPasswordField pwdfield = new JPasswordField(this._pwd);
            constraints.fill = 2;
            constraints.gridx = 0;
            constraints.gridy = 1;
            panel.add((Component)new JLabel("MyProxy host:"), constraints);
            constraints.gridx = 0;
            constraints.gridy = 2;
            panel.add((Component)new JLabel("MyProxy port:"), constraints);
            constraints.gridx = 0;
            constraints.gridy = 3;
            panel.add((Component)new JLabel("User name:"), constraints);
            constraints.gridx = 0;
            constraints.gridy = 4;
            panel.add((Component)new JLabel("Password:"), constraints);
            constraints.weightx = 1.0;
            constraints.gridx = 1;
            constraints.gridy = 1;
            panel.add((Component)hostfield, constraints);
            constraints.gridx = 1;
            constraints.gridy = 2;
            panel.add((Component)portfield, constraints);
            constraints.gridx = 1;
            constraints.gridy = 3;
            panel.add((Component)userfield, constraints);
            constraints.gridx = 1;
            constraints.gridy = 4;
            panel.add((Component)pwdfield, constraints);
            if (this._message != null) {
                constraints.fill = 2;
                constraints.gridwidth = 2;
                constraints.gridx = 0;
                constraints.gridy = 0;
                panel.add((Component)new JLabel(this._message), constraints);
            }
            if ((ret = JOptionPane.showConfirmDialog(this._parent, panel, "MyProxy connection parameters", 2)) == 2) {
                this._canceled = true;
            }
            this._host = hostfield.getText();
            this._port = portfield.getText();
            this._user = userfield.getText();
            this._pwd = ((JTextComponent)pwdfield).getText();
        }
    }
}

