/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirndownloader;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbirn.fbirndownloader.MainFrame;

public class TeeOutputStream
extends OutputStream {
    private static Log _logger = LogFactory.getLog((String)MainFrame.class.getName());
    OutputStream tee = null;
    OutputStream out = null;
    int bytesread = 0;

    public TeeOutputStream(OutputStream chainedStream, OutputStream teeStream) {
        this.out = chainedStream;
        this.tee = teeStream == null ? System.out : teeStream;
        this.bytesread = 0;
    }

    public void write(int c) throws IOException {
        ++this.bytesread;
        _logger.debug((Object)("Writing char " + c + " (bytesread=" + this.bytesread + ")"));
        this.tee.write(c);
        this.out.write(c);
    }

    public void write(byte[] b) throws IOException {
        this.bytesread += b.length;
        _logger.debug((Object)("Writing byte array of length " + b.length + " (bytesread=" + this.bytesread + ")"));
        this.tee.write(b);
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.bytesread += len;
        _logger.debug((Object)("Writing byte array, offset " + off + ", length " + len + " (bytesread=" + this.bytesread + ")"));
        this.tee.write(b, off, len);
        this.out.write(b, off, len);
    }

    public void close() throws IOException {
        this.flush();
        this.tee.close();
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
        this.tee.flush();
    }
}

