/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirndownloader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.birncommunity.gridftp.tar.TwoPartyTarClientFactoryI;
import org.birncommunity.gridftp.tar.TwoPartyTarClientFactoryImpl;
import org.birncommunity.gridftp.tar.TwoPartyTarTransfer;
import org.birncommunity.gridftp.tar.UntarFromPipeRunnable;
import org.birncommunity.gridftp.tar.UntarI;
import org.birncommunity.gridftp.tar.impl.compress.CompressUntar;
import org.birncommunity.gridftp.tar.impl.compress.UntarDirectoryEntryHandler;
import org.birncommunity.gridftp.tar.impl.compress.UntarDirectoryEntryHandlerImplementation;
import org.birncommunity.gridftp.tar.impl.compress.UntarFileEntryHandler;
import org.birncommunity.gridftp.tar.impl.compress.UntarFileEntryHandlerImplementation;
import org.globus.ftp.FTPClient;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.MlsxEntry;
import org.ietf.jgss.GSSCredential;
import org.nbirn.fbirndownloader.CanceledException;
import org.nbirn.fbirndownloader.CredentialManager;
import org.nbirn.fbirndownloader.CredentialManagerException;
import org.nbirn.fbirndownloader.GridFTPException;
import org.nbirn.fbirndownloader.MainFrame;
import org.nbirn.fbirndownloader.ProgressUpdate;
import org.nbirn.fbirndownloader.WorkerProgressReporter;

public abstract class WorkerDownload
extends WorkerProgressReporter {
    private static Log _logger = LogFactory.getLog((String)MainFrame.class.getName());
    private static final int DEFAULT_MINCHUNKS = 100;
    boolean _dryrun = false;

    protected WorkerDownload(boolean dryrun) {
        this._dryrun = dryrun;
    }

    Exception downloadURLDefault(URI url, File dest) {
        try {
            InputStream is = url.toURL().openStream();
            FileOutputStream fos = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            int bytesread = 0;
            while ((bytesread = is.read(buf)) != -1) {
                fos.write(buf, 0, bytesread);
            }
            fos.close();
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    public void resetPassive(FTPClient ftpclient) throws GridFTPException {
        try {
            ftpclient.setPassive();
        }
        catch (Exception e) {
            throw new GridFTPException("Error calling GridFTPClient::setLocalPassive()", e);
        }
        try {
            ftpclient.setLocalActive();
        }
        catch (Exception e) {
            throw new GridFTPException("Error calling GridFTPClient::setActive()", e);
        }
    }

    private Exception tryConnect(GridFTPClient ftpclient, GSSCredential cred) {
        if (cred == null) {
            return new NullPointerException("tryConnect() received cred==null!");
        }
        if (ftpclient == null) {
            return new NullPointerException("tryConnect() received ftpclient==null!");
        }
        try {
            ftpclient.authenticate(cred);
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridFTPClient gridFTPConnect(CredentialManager credman, String gridftphost, int gridftpport) throws CanceledException, GridFTPException {
        GridFTPClient ftpclient = null;
        try {
            ftpclient = new GridFTPClient(gridftphost, gridftpport);
        }
        catch (Exception e) {
            throw new GridFTPException("Error getting new GridFTP client", e);
        }
        CredentialManager e = credman;
        synchronized (e) {
            block29: {
                if (this.isCancelled() || credman.wasCanceled()) {
                    throw new CanceledException("Operation canceled by user.");
                }
                Exception retval = null;
                GSSCredential cred = credman.getCredential();
                if (cred != null) {
                    retval = this.tryConnect(ftpclient, cred);
                    if (retval != null) {
                        cred = null;
                        try {
                            ftpclient.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        ftpclient = null;
                    } else {
                        return ftpclient;
                    }
                }
                String msg = "Please enter MyProxy and GridFTP connection parameters";
                while (true) {
                    if ((cred = credman.getLocalCredential()) != null) {
                        if (ftpclient == null) {
                            try {
                                ftpclient = new GridFTPClient(gridftphost, gridftpport);
                            }
                            catch (Exception e3) {
                                throw new GridFTPException("Error getting new GridFTP client", e3);
                            }
                        }
                        if ((retval = this.tryConnect(ftpclient, cred)) == null) break block29;
                        cred = null;
                        try {
                            ftpclient.close();
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        ftpclient = null;
                    }
                    try {
                        credman.getNewCredential(msg);
                    }
                    catch (CredentialManagerException e5) {
                        throw new GridFTPException("Error getting new credential", e5);
                    }
                    cred = credman.getCredential();
                    if (cred == null) {
                        if (credman.canGetUserInput()) {
                            msg = "Error in connection parameters.  Try again:";
                            continue;
                        }
                        throw new GridFTPException("Can't get valid credential (try getting one by running myproxy-logon)");
                    }
                    if (ftpclient == null) {
                        try {
                            ftpclient = new GridFTPClient(gridftphost, gridftpport);
                        }
                        catch (Exception e6) {
                            throw new GridFTPException("Error getting new GridFTP client", e6);
                        }
                    }
                    if ((retval = this.tryConnect(ftpclient, cred)) == null) break;
                    cred = null;
                    try {
                        ftpclient.close();
                    }
                    catch (Exception e7) {
                        // empty catch block
                    }
                    ftpclient = null;
                }
                return ftpclient;
            }
        }
        try {
            ftpclient.setType(1);
            ftpclient.setMode(1);
        }
        catch (Exception e2) {
            throw new GridFTPException("Error setting type or mode on FTP client", e2);
        }
        return ftpclient;
    }

    protected GridFTPClient checkConnection(CredentialManager credman, GridFTPClient ftpclient, String gridftphost, int gridftpport) throws CanceledException, GridFTPException {
        if (ftpclient == null) {
            return this.gridFTPConnect(credman, gridftphost, gridftpport);
        }
        try {
            ftpclient.quote("NOOP");
            return ftpclient;
        }
        catch (Exception e) {
            try {
                ftpclient.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return this.gridFTPConnect(credman, gridftphost, gridftpport);
        }
    }

    Exception downloadURLGSIFTP(URI url, File dest, CredentialManager credman, boolean updateOnly, TimeZone remoteTimeZone, int timeStampCheckDepth) throws CanceledException, GridFTPException {
        return this.downloadURLGSIFTP(url, dest, credman, 100, timeStampCheckDepth, updateOnly, remoteTimeZone, 0.0, 100.0);
    }

    Exception downloadURLGSIFTP(URI url, File dest, CredentialManager credman, int minChunks, int minDepth, boolean updateOnly, TimeZone remoteTimeZone, double progressStart, double progressEnd) throws CanceledException, GridFTPException {
        if (this.isCancelled()) {
            throw new CanceledException("Operation canceled by user.");
        }
        String gridftphost = url.getHost();
        int gridftpport = url.getPort() == -1 ? 2811 : url.getPort();
        String remotepath = url.getPath();
        GridFTPClient ftpclient = this.gridFTPConnect(credman, gridftphost, gridftpport);
        double progress = progressStart;
        while (remotepath.length() > 1 && remotepath.endsWith("/")) {
            remotepath = remotepath.substring(0, remotepath.length() - 1);
        }
        ftpclient = this.checkConnection(credman, ftpclient, gridftphost, gridftpport);
        File localfile = dest;
        if (localfile.exists() && localfile.isDirectory()) {
            int lastremoteslash = remotepath.lastIndexOf(47);
            localfile = lastremoteslash == -1 ? new File(localfile, remotepath) : new File(localfile, remotepath.substring(lastremoteslash + 1));
        }
        this.downloadGSIFTPAux(ftpclient, gridftphost, gridftpport, remotepath, localfile, null, credman, minChunks, minDepth, updateOnly, remoteTimeZone, progressStart, progressEnd);
        if (ftpclient != null) {
            try {
                ftpclient.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private long getTimestamp(MlsxEntry info, TimeZone remoteTimeZone) {
        String modifystr = info.get("modify");
        if (modifystr.length() != 14) {
            return -1L;
        }
        int year = Integer.parseInt(modifystr.substring(0, 4));
        int mon = Integer.parseInt(modifystr.substring(4, 6)) - 1;
        int mday = Integer.parseInt(modifystr.substring(6, 8));
        int hour = Integer.parseInt(modifystr.substring(8, 10));
        int min = Integer.parseInt(modifystr.substring(10, 12));
        int sec = Integer.parseInt(modifystr.substring(12, 14));
        Calendar cal = null;
        cal = GregorianCalendar.getInstance();
        cal.set(year, mon, mday, hour, min, sec);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void downloadGSIFTPAux(GridFTPClient ftpclient, String gridftphost, int gridftpport, String remotepath, File localfile, MlsxEntry info, CredentialManager credman, int minChunks, int minDepth, boolean updateOnly, TimeZone remoteTimeZone, double progressStart, double progressEnd) throws CanceledException, GridFTPException {
        boolean localoutofdate;
        long remotelastmod;
        String infotype;
        class TimeStampQueueEntry {
            File _file;
            long _timestamp;

            TimeStampQueueEntry(File file, long timestamp) {
                this._file = file;
                this._timestamp = timestamp;
            }
        }
        ArrayList<TimeStampQueueEntry> timestampqueue;
        SimpleDateFormat dateformat;
        block62: {
            if (this.isCancelled()) {
                throw new CanceledException("Operation canceled by user.");
            }
            _logger.debug((Object)("downloadGSIFTPAux(gridftphost='" + gridftphost + "', gridftpport=" + gridftpport + ", remotepath='" + remotepath + "', localfile='" + localfile.getAbsolutePath() + "', minChunks=" + minChunks + ", minDepth=" + minDepth + ", updateOnly=" + updateOnly + ", remoteTimeZone='" + (remoteTimeZone == null ? "<null>" : remoteTimeZone.getDisplayName()) + ", progressStart=" + progressStart + ", progressEnd=" + progressEnd + ")"));
            dateformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            timestampqueue = new ArrayList<TimeStampQueueEntry>();
            ftpclient = this.checkConnection(credman, ftpclient, gridftphost, gridftpport);
            if (info == null) {
                try {
                    info = ftpclient.mlst(remotepath);
                }
                catch (Exception e) {
                    throw new GridFTPException("Error getting file listing for remotepath " + remotepath, e);
                }
            }
            infotype = info.get("type");
            if (localfile.getName().startsWith("__DELETE__")) {
                String delname = localfile.getName().substring(10);
                File delfile = new File(localfile.getParent(), delname);
                if (!delfile.exists()) return;
                if (!"file".equals(infotype) || !delfile.isFile()) {
                    if (!"dir".equals(infotype)) return;
                    if (!delfile.isDirectory()) return;
                }
                this.publish(new ProgressUpdate((this._dryrun ? "(not) " : "") + "Deleting " + delfile.getAbsolutePath(), null, 0.0, 1));
                if (this._dryrun) return;
                File deldir = new File(localfile.getParent(), "__DELETED__");
                deldir.mkdir();
                delfile.renameTo(new File(deldir, delname));
                return;
            }
            remotelastmod = this.getTimestamp(info, remoteTimeZone);
            localoutofdate = true;
            if (updateOnly) {
                String outofdatestr = "out of date";
                if (remotelastmod != -1L && localfile.exists() && remotelastmod <= localfile.lastModified()) {
                    outofdatestr = "up-to-date";
                    localoutofdate = false;
                }
                _logger.debug((Object)("Local file " + localfile.getAbsolutePath() + " seems " + outofdatestr + " (local " + dateformat.format(new Date(localfile.lastModified())) + ", remote " + dateformat.format(new Date(remotelastmod)) + ") " + localfile.getAbsolutePath()));
            }
            if (!"file".equals(infotype)) break block62;
            try {
                block64: {
                    block63: {
                        this.setProgress((int)progressStart);
                        if (!localoutofdate) break block63;
                        this.publish(new ProgressUpdate((this._dryrun ? "(not) " : "") + "Downloading '" + remotepath + "'", null, 0.0, 1));
                        this.resetPassive((FTPClient)ftpclient);
                        if (!this._dryrun) {
                            block61: {
                                try {
                                    ftpclient.get(remotepath, localfile);
                                    Object var24_26 = null;
                                    if (remotelastmod == -1L || !localfile.exists()) break block61;
                                }
                                catch (Throwable throwable) {
                                    Object var24_27 = null;
                                    if (remotelastmod == -1L) throw throwable;
                                    if (!localfile.exists()) throw throwable;
                                    _logger.debug((Object)("Setting timestamp: " + localfile.getPath() + " " + dateformat.format(new Date(remotelastmod))));
                                    localfile.setLastModified(remotelastmod);
                                    throw throwable;
                                }
                                _logger.debug((Object)("Setting timestamp: " + localfile.getPath() + " " + dateformat.format(new Date(remotelastmod))));
                                localfile.setLastModified(remotelastmod);
                            }
                            if (remotelastmod != -1L) {
                                _logger.debug((Object)("Setting timestamp: " + localfile.getPath() + " " + dateformat.format(new Date(remotelastmod))));
                                localfile.setLastModified(remotelastmod);
                            }
                        }
                        break block64;
                    }
                    _logger.debug((Object)("Skipped up-to-date '" + remotepath + "'"));
                    this.publish(new ProgressUpdate("Skipped up-to-date '" + remotepath + "'", 0.0));
                }
                this.setProgress((int)progressEnd);
                return;
            }
            catch (Exception e) {
                throw new GridFTPException("Error getting file '" + remotepath + "' to local file '" + localfile.toString() + "'", e);
            }
        }
        if (infotype.equals("dir") && !localfile.exists()) {
            this.publish(new ProgressUpdate((this._dryrun ? "(not) " : "") + "Making directory '" + localfile.getAbsolutePath() + "'", 0.0));
            if (!this._dryrun) {
                localfile.mkdir();
                if (remotelastmod != -1L) {
                    _logger.debug((Object)("Setting temporary timestamp: " + localfile.getPath() + " " + dateformat.format(new Date(remotelastmod - 1000L))));
                    localfile.setLastModified(remotelastmod - 1000L);
                    timestampqueue.add(new TimeStampQueueEntry(localfile, remotelastmod));
                }
            }
        }
        boolean fallthrough = true;
        if (minChunks <= 1 && minDepth <= 0) {
            if (localoutofdate) {
                ExecutorService executorService = null;
                TwoPartyTarClientFactoryImpl clientFactory = new TwoPartyTarClientFactoryImpl();
                GSSCredential cred = null;
                CredentialManager credentialManager = credman;
                synchronized (credentialManager) {
                    cred = credman.getCredential();
                    if (cred == null && (cred = credman.getLocalCredential()) == null) {
                        try {
                            credman.getNewCredential("Please enter MyProxy and GridFTP connection parameters");
                        }
                        catch (CredentialManagerException e) {
                            throw new GridFTPException("Error getting new credential", e);
                        }
                    }
                }
                TwoPartyTarTransfer tptt = new TwoPartyTarTransfer((TwoPartyTarClientFactoryI)clientFactory, gridftphost, gridftpport, cred);
                boolean dopopen = false;
                try {
                    dopopen = tptt.isPopenDriverSupported();
                }
                catch (Exception e) {
                    throw new GridFTPException("Error checking if popen is supported", e);
                }
                if (dopopen) {
                    this.publish(new ProgressUpdate((this._dryrun ? "(not) " : "") + "Downloading (with tar-stream) '" + remotepath + "'", null, 0.0, 1));
                    if (!this._dryrun) {
                        PipedOutputStream pipeOut = new PipedOutputStream();
                        PipedInputStream pipeIn = null;
                        try {
                            pipeIn = new PipedInputStream(pipeOut);
                        }
                        catch (IOException e) {
                            throw new GridFTPException("Error creating pipe", e);
                        }
                        final int localfilelen = localfile.getAbsolutePath().length();
                        executorService = Executors.newSingleThreadExecutor();
                        Future<?> untarfuture = null;
                        try {
                            UntarDirectoryEntryHandlerImplementation dirhandler = new UntarDirectoryEntryHandlerImplementation(){

                                public void handleUntarDirectoryEntry(TarArchiveEntry tae, File destDir) throws IOException {
                                    if (tae.getName().startsWith("__DELETE__")) {
                                        String delname = tae.getName().substring(10);
                                        File newfile = new File(destDir, delname);
                                        if (newfile.exists() && newfile.isDirectory()) {
                                            WorkerDownload.this.publish(new ProgressUpdate[]{new ProgressUpdate(null, "...deleting " + newfile.getAbsolutePath().substring(localfilelen), 0.0, -1)});
                                            File deldir = new File(destDir, "__DELETED__");
                                            deldir.mkdir();
                                            newfile.renameTo(new File(deldir, delname));
                                        }
                                    } else {
                                        File newfile = new File(destDir, tae.getName());
                                        WorkerDownload.this.publish(new ProgressUpdate[]{new ProgressUpdate(null, "..." + newfile.getAbsolutePath().substring(localfilelen), 0.0, -1)});
                                        super.handleUntarDirectoryEntry(tae, destDir);
                                        newfile.setLastModified(tae.getModTime().getTime());
                                        timestampqueue.add(new TimeStampQueueEntry(newfile, tae.getModTime().getTime()));
                                    }
                                }
                            };
                            UntarFileEntryHandlerImplementation filehandler = new UntarFileEntryHandlerImplementation(){

                                public void handleUntarFileEntry(TarArchiveInputStream tais, File destDir, TarArchiveEntry tae) throws IOException {
                                    if (tae.getName().startsWith("__DELETE__")) {
                                        String delname = tae.getName().substring(10);
                                        File newfile = new File(destDir, delname);
                                        if (newfile.exists() && newfile.isDirectory()) {
                                            WorkerDownload.this.publish(new ProgressUpdate[]{new ProgressUpdate(null, "...deleting " + newfile.getAbsolutePath().substring(localfilelen), 0.0, -1)});
                                            File deldir = new File(destDir, "__DELETED__");
                                            deldir.mkdir();
                                            newfile.renameTo(new File(deldir, delname));
                                        }
                                    } else {
                                        File newfile = new File(destDir, tae.getName());
                                        WorkerDownload.this.publish(new ProgressUpdate[]{new ProgressUpdate(null, "..." + newfile.getAbsolutePath().substring(localfilelen), 0.0, -1)});
                                        super.handleUntarFileEntry(tais, destDir, tae);
                                        newfile.setLastModified(tae.getModTime().getTime());
                                    }
                                }
                            };
                            untarfuture = executorService.submit((Runnable)new UntarFromPipeRunnable((InputStream)pipeIn, localfile.getParentFile().getAbsolutePath(), (UntarI)new CompressUntar((UntarDirectoryEntryHandler)dirhandler, (UntarFileEntryHandler)filehandler)));
                        }
                        catch (Exception e) {
                            throw new GridFTPException("Error submitting untar task for execution", e);
                        }
                        String fullremotepath = remotepath;
                        this.setProgress((int)progressStart);
                        try {
                            tptt.downloadTarToPipe(fullremotepath, (OutputStream)pipeOut);
                        }
                        catch (Exception e) {
                            throw new GridFTPException("Error downloading tar stream", e);
                        }
                        try {
                            try {
                                untarfuture.get();
                            }
                            catch (InterruptedException e) {
                                throw new CanceledException("Operation canceled", e);
                            }
                            catch (Exception e) {
                                throw new GridFTPException("Error running untar task", e);
                            }
                            Object var35_54 = null;
                        }
                        catch (Throwable throwable) {
                            Object var35_55 = null;
                            int i = 0;
                            while (i < timestampqueue.size()) {
                                TimeStampQueueEntry e = (TimeStampQueueEntry)timestampqueue.get(i);
                                _logger.debug((Object)("Setting timestamp: " + e._file.getPath() + " " + dateformat.format(new Date(e._timestamp))));
                                e._file.setLastModified(e._timestamp);
                                ++i;
                            }
                            throw throwable;
                        }
                        for (int i = 0; i < timestampqueue.size(); ++i) {
                            TimeStampQueueEntry e = (TimeStampQueueEntry)timestampqueue.get(i);
                            _logger.debug((Object)("Setting timestamp: " + e._file.getPath() + " " + dateformat.format(new Date(e._timestamp))));
                            e._file.setLastModified(e._timestamp);
                        }
                        if (remotelastmod != -1L) {
                            _logger.debug((Object)("Setting timestamp: " + localfile.getPath() + " " + dateformat.format(new Date(remotelastmod))));
                            localfile.setLastModified(remotelastmod);
                        }
                    }
                    this.setProgress((int)progressEnd);
                    return;
                }
            } else {
                _logger.debug((Object)("Skipped up-to-date '" + remotepath + "'"));
                this.setProgress((int)progressEnd);
                this.publish(new ProgressUpdate("Skipped up-to-date '" + remotepath + "'", 0.0));
                return;
            }
        }
        if (!fallthrough) {
            return;
        }
        this.setProgress((int)progressStart);
        ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
        class StackEntry {
            String _remotepath = null;
            File _localfile = null;
            int _mindepth = 0;
            MlsxEntry _info = null;

            StackEntry(String remotepath, File localfile, int mindepth, MlsxEntry info) {
                this._remotepath = remotepath;
                this._localfile = localfile;
                this._mindepth = mindepth;
                this._info = info;
            }
        }
        stack.push(new StackEntry(remotepath, localfile, minDepth, info));
        while (!stack.isEmpty()) {
            int i;
            if (this.isCancelled()) {
                throw new CanceledException("Operation canceled by user.");
            }
            StackEntry sentry = null;
            sentry = stack.size() < --minChunks || minDepth > 0 ? (StackEntry)stack.removeFirst() : (StackEntry)stack.removeLast();
            String curremotepath = sentry._remotepath;
            File curlocalfile = sentry._localfile;
            int curmindepth = sentry._mindepth;
            MlsxEntry curinfo = sentry._info;
            _logger.debug((Object)(" curremotepath='" + curremotepath + "' curlocalfile='" + curlocalfile + "' stack.size()=" + stack.size() + " minChunks=" + minChunks + " minDepth=" + curmindepth));
            if (stack.size() >= minChunks && curmindepth <= 0) {
                double progressChunk = (progressEnd - progressStart) / (double)(stack.size() + 1);
                this.downloadGSIFTPAux(ftpclient, gridftphost, gridftpport, curremotepath, curlocalfile, curinfo, credman, 1, 0, updateOnly, remoteTimeZone, progressStart, progressStart + progressChunk);
                progressStart += progressChunk;
                continue;
            }
            this.checkConnection(credman, ftpclient, gridftphost, gridftpport);
            this.resetPassive((FTPClient)ftpclient);
            Vector filelist = null;
            try {
                filelist = ftpclient.mlsd(curremotepath);
            }
            catch (Exception e) {
                throw new GridFTPException("Error getting listing for directory " + curremotepath, e);
            }
            int numsubfiles = 0;
            int numsubdirs = 0;
            for (i = 0; i < filelist.size(); ++i) {
                MlsxEntry linfo = (MlsxEntry)filelist.elementAt(i);
                if (linfo.getFileName().equals(".") || linfo.getFileName().equals("..")) {
                    filelist.remove(i);
                    --i;
                    continue;
                }
                String linfotype = linfo.get("type");
                if (linfotype.equals("file")) {
                    ++numsubfiles;
                    continue;
                }
                if (!linfotype.equals("dir")) continue;
                ++numsubdirs;
            }
            if (numsubdirs == 0 && curmindepth <= 0) {
                double progressChunk = (progressEnd - progressStart) / (double)(stack.size() + 1);
                this.downloadGSIFTPAux(ftpclient, gridftphost, gridftpport, curremotepath, curlocalfile, info, credman, 1, 0, updateOnly, remoteTimeZone, progressStart, progressStart + progressChunk);
                progressStart += progressChunk;
                continue;
            }
            for (i = 0; i < filelist.size(); ++i) {
                if (this.isCancelled()) {
                    throw new CanceledException("Operation canceled by user.");
                }
                MlsxEntry subinfo = (MlsxEntry)filelist.elementAt(i);
                _logger.debug((Object)("  file " + subinfo.getFileName()));
                File newlocalfile = new File(curlocalfile, subinfo.getFileName());
                String newremotepath = curremotepath + "/" + subinfo.getFileName();
                String subinfotype = subinfo.get("type");
                if (subinfotype.equals("dir")) {
                    if (!newlocalfile.exists()) {
                        this.publish(new ProgressUpdate((this._dryrun ? "(not) " : "") + "Making directory '" + localfile.getAbsolutePath() + "'", 0.0));
                        if (!this._dryrun) {
                            newlocalfile.mkdir();
                            long sublastmod = this.getTimestamp(subinfo, remoteTimeZone);
                            if (sublastmod != -1L) {
                                _logger.debug((Object)("Setting temporary timestamp: " + newlocalfile.getPath() + " " + dateformat.format(new Date(sublastmod - 1000L))));
                                newlocalfile.setLastModified(sublastmod - 1000L);
                                timestampqueue.add(new TimeStampQueueEntry(newlocalfile, sublastmod));
                            }
                        }
                    }
                    stack.addLast(new StackEntry(newremotepath, newlocalfile, curmindepth - 1, subinfo));
                    continue;
                }
                if (!subinfotype.equals("file")) continue;
                double progressChunk = (progressEnd - progressStart) / (double)(stack.size() + 1);
                this.downloadGSIFTPAux(ftpclient, gridftphost, gridftpport, newremotepath, newlocalfile, subinfo, credman, 1, 0, updateOnly, remoteTimeZone, progressStart, progressStart + progressChunk);
                progressStart += progressChunk;
            }
        }
        int i = 0;
        while (true) {
            if (i >= timestampqueue.size()) {
                this.setProgress((int)progressEnd);
                return;
            }
            TimeStampQueueEntry e = (TimeStampQueueEntry)timestampqueue.get(i);
            _logger.debug((Object)("Setting timestamp: " + e._file.getPath() + " " + dateformat.format(new Date(e._timestamp))));
            e._file.setLastModified(e._timestamp);
            ++i;
        }
    }
}

