/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirndownloader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.TimeZone;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbirn.fbirn.xcede2.catalog.Catalog;
import org.nbirn.fbirn.xcede2.catalog.CatalogEntry;
import org.nbirn.fbirndownloader.CatalogEntryDownload;

public class CatalogDownload
extends Catalog
implements PropertyChangeListener {
    private static Log _logger = LogFactory.getLog((String)CatalogDownload.class.getName());
    private static final String KEY_DOWNLOAD_STRATEGY = "downloadStrategy";
    private static final String KEY_TIME_ZONE = "timeZone";
    private static final String KEY_TIMESTAMP_CHECK_DEPTH = "timeStampCheckDepth";
    public static final int SOURCE_UNKNOWN = 0;
    public static final int SOURCE_SERIAL = 1;
    public static final int SOURCE_PARALLEL = 2;
    JPanel _panel;
    TitledBorder _border = null;

    public CatalogDownload(int downloadtype, String name, File file) throws Exception {
        super(name, file);
    }

    public CatalogDownload(int downloadtype, String name) {
        super(name);
    }

    public CatalogDownload() {
        this(0, null);
    }

    public CatalogDownload getCatalog(int index) {
        return (CatalogDownload)super.getCatalog(index);
    }

    public CatalogEntryDownload getEntry(int index) {
        return (CatalogEntryDownload)super.getEntry(index);
    }

    public int getDownloadType() {
        return this.hasMetaField(KEY_DOWNLOAD_STRATEGY) ? (Integer)this.getMetaField(KEY_DOWNLOAD_STRATEGY) : 0;
    }

    public void setDownloadType(int type) {
        this.addMetaField(KEY_DOWNLOAD_STRATEGY, new Integer(type));
    }

    public TimeZone getTimeZone() {
        return this.hasMetaField(KEY_TIME_ZONE) ? (TimeZone)this.getMetaField(KEY_TIME_ZONE) : null;
    }

    public void setTimeZone(TimeZone timezone) {
        this.addMetaField(KEY_TIME_ZONE, timezone);
    }

    public int getTimeStampCheckDepth() {
        return this.hasMetaField(KEY_TIMESTAMP_CHECK_DEPTH) ? (Integer)this.getMetaField(KEY_TIMESTAMP_CHECK_DEPTH) : -1;
    }

    public void setTimeStampCheckDepth(int timeStampCheckDepth) {
        this.addMetaField(KEY_TIMESTAMP_CHECK_DEPTH, timeStampCheckDepth);
    }

    public JPanel getPanel() {
        return this._panel;
    }

    public void setPanel(JPanel panel) {
        this._panel = panel;
    }

    public TitledBorder getBorder() {
        return this._border;
    }

    public void setBorder(TitledBorder border) {
        this._border = border;
    }

    protected CatalogEntry getNewEntry() {
        return new CatalogEntryDownload();
    }

    protected Catalog getNewCatalog() {
        return new CatalogDownload();
    }

    public void addMetaFieldString(String mfname, String mfvalue) {
        if (mfvalue == null) {
            return;
        }
        _logger.debug((Object)("CatalogDownload.addMetaField:     adding name='" + mfname + "' value='" + mfvalue + "'"));
        if (KEY_DOWNLOAD_STRATEGY.equals(mfname)) {
            if (mfvalue.equals("serial")) {
                super.addMetaField(mfname, (Object)new Integer(1));
            } else if (mfvalue.equals("parallel")) {
                super.addMetaField(mfname, (Object)new Integer(2));
            } else {
                super.addMetaField(mfname, (Object)new Integer(0));
            }
        } else if (KEY_TIME_ZONE.equals(mfname)) {
            super.addMetaField(mfname, (Object)TimeZone.getTimeZone(mfvalue));
        } else if (KEY_TIMESTAMP_CHECK_DEPTH.equals(mfname)) {
            super.addMetaField(mfname, (Object)Integer.parseInt(mfvalue));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("state".equals(propName) && SwingWorker.StateValue.DONE == evt.getNewValue() && this._panel != null) {
            this._panel.setEnabled(false);
        }
    }
}

