/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirndownloader;

import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbirn.fbirndownloader.CatalogDownload;
import org.nbirn.fbirndownloader.CredentialManager;
import org.nbirn.fbirndownloader.MainFrame;
import org.nbirn.fbirndownloader.TextProgressBarListener;
import org.nbirn.fbirndownloader.WorkerDownloadFromCatalog;
import org.nbirn.fbirndownloader.WorkerDownloadFromURL;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    Properties _properties = null;
    WorkerDownloadFromCatalog _downloadworker = null;
    private static Log _logger = LogFactory.getLog((String)Main.class.getName());
    private final int _numsavedprops = 10;

    public Main() {
        try {
            this.loadProperties();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File getPropertyFile() {
        try {
            File propFile = new File(MainFrame.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            propFile = new File(propFile.getParentFile(), "FBIRNDownloader.properties");
            return propFile;
        }
        catch (Exception e) {
            return null;
        }
    }

    final Properties getProperties() {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        return this._properties;
    }

    public String getProperty(String name) {
        return this.getProperties().getProperty(name);
    }

    public Vector<String> getPropertySet(String name) {
        Vector<String> retval = new Vector<String>();
        Properties props = this.getProperties();
        for (int i = 0; i < 10; ++i) {
            String val = props.getProperty(name + (i == 0 ? "" : Integer.valueOf(i)));
            if (val == null) continue;
            retval.add(val);
        }
        return retval;
    }

    public void setPropertySet(String name, Vector<String> set) throws IOException {
        int i;
        Properties props = this.getProperties();
        for (i = 0; i < set.size(); ++i) {
            props.setProperty(name + (i == 0 ? "" : Integer.valueOf(i)), set.get(i));
        }
        for (i = set.size(); i < 10; ++i) {
            props.remove(name + (i == 0 ? "" : Integer.valueOf(i)));
        }
        this.saveProperties();
    }

    private void loadProperties() throws IOException {
        File propFile = this.getPropertyFile();
        if (propFile != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propFile);
                this.getProperties().load(fis);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void saveProperties() throws IOException {
        File propFile = this.getPropertyFile();
        if (propFile != null) {
            FileOutputStream fos = new FileOutputStream(propFile);
            this.getProperties().store(fos, "Written by " + this.getClass().getName());
        }
    }

    public void changeProperty(String name, String value) {
        Vector<String> propset = this.getPropertySet(name);
        int foundind = propset.indexOf(value);
        if (foundind == 0) {
            return;
        }
        if (foundind != -1) {
            propset.remove(foundind);
        }
        propset.insertElementAt(value, 0);
        try {
            this.setPropertySet(name, propset);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private ArrayList<Element> getChildElementsByTagNameNS(Element elem, String namespaceURI, String localName) throws DOMException {
        ArrayList<Element> retval = new ArrayList<Element>();
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !namespaceURI.equals(child.getNamespaceURI()) || !localName.equals(child.getLocalName())) continue;
            retval.add((Element)child);
        }
        return retval;
    }

    public static void main(String[] args) {
        boolean opt_dryrun = false;
        boolean opt_nochecktimestamps = false;
        int logPriority = 0;
        ArrayList<String> newargs = new ArrayList<String>();
        newargs.addAll(Arrays.asList(args));
        for (int i = 0; i < newargs.size(); ++i) {
            String arg = (String)newargs.get(i);
            if ("--dryrun".equals(arg)) {
                opt_dryrun = true;
                newargs.remove(i);
                --i;
                continue;
            }
            if ("--overwrite".equals(arg)) {
                opt_nochecktimestamps = true;
                newargs.remove(i);
                --i;
                continue;
            }
            if ("--quiet".equals(arg)) {
                logPriority = 1;
                newargs.remove(i);
                --i;
                continue;
            }
            if ("--verbose".equals(arg)) {
                logPriority = -1;
                newargs.remove(i);
                --i;
                continue;
            }
            if (arg == null || !arg.startsWith("--")) continue;
            System.err.println("ERROR: unrecognized option " + arg);
        }
        if (newargs.size() != 2 && !newargs.isEmpty()) {
            System.err.println("Usage:");
            System.err.println("  for graphical interface start with no arguments:");
            System.err.println("    java -jar FBIRNDownloader.jar");
            System.err.println("  for command-line/batch interface:");
            System.err.println("    java -jar FBIRNDownloader [--dryrun] [--overwrite] catalogURL outputDir");
            System.exit(1);
        }
        if (newargs.size() == 2) {
            System.setProperty("java.awt.headless", "true");
            Toolkit tk = Toolkit.getDefaultToolkit();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String catalogurlstr = (String)newargs.get(0);
            String destdir = (String)newargs.get(1);
            File tempfile = null;
            try {
                tempfile = File.createTempFile("fbirndownload.", ".xml");
            }
            catch (IOException e) {
                System.err.println("Error creating temporary file: " + e.getMessage());
            }
            Main main = new Main();
            CredentialManager credman = new CredentialManager(main, null);
            CatalogDownload catalog = null;
            try {
                WorkerDownloadFromURL worker = new WorkerDownloadFromURL(new URI(catalogurlstr), tempfile, credman);
                if (logPriority <= 0) {
                    TextProgressBarListener pblistener = new TextProgressBarListener("Catalog download");
                    worker.addPropertyChangeListener(pblistener);
                }
                worker.execute();
                worker.get();
                if (worker.getError() != null) {
                    System.err.println("Error downloading catalog document: " + worker.getError().getLocalizedMessage());
                    System.exit(1);
                }
                catalog = new CatalogDownload();
                try {
                    catalog.parseCatalogFile(tempfile);
                }
                catch (Exception e) {
                    System.err.println("Error parsing catalog document '" + catalogurlstr + "': " + e.getMessage());
                    System.exit(1);
                }
            }
            catch (Exception e) {
                System.err.println("Error downloading/parsing catalog document '" + catalogurlstr + "': " + e.getMessage());
                System.exit(1);
            }
            File outputDirFile = new File(destdir);
            if (!outputDirFile.exists()) {
                System.err.println("ERROR: Specified output directory '" + outputDirFile.getPath() + "' does not exist.");
                System.exit(1);
            } else if (!outputDirFile.isDirectory()) {
                System.err.println("ERROR: Specified output target exists but is not a directory!");
                System.exit(1);
            }
            WorkerDownloadFromCatalog worker = new WorkerDownloadFromCatalog(catalog, outputDirFile, null, null, credman, !opt_nochecktimestamps, opt_dryrun, null, 100.0);
            if (logPriority <= 0) {
                TextProgressBarListener pblistener = new TextProgressBarListener("Download data");
                worker.addPropertyChangeListener(pblistener);
            }
            worker.setLoggingPriority(logPriority);
            worker.execute();
            try {
                worker.get();
                if (logPriority <= 0) {
                    System.err.println("Success!");
                }
                System.exit(0);
            }
            catch (Exception e) {
                System.err.println("Error downloading data: " + e.getMessage());
                System.exit(1);
            }
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainFrame(new Main()).setVisible(true);
            }
        });
    }
}

