/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirndownloader;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbirn.fbirndownloader.CanceledException;
import org.nbirn.fbirndownloader.CatalogDownload;
import org.nbirn.fbirndownloader.CredentialManager;
import org.nbirn.fbirndownloader.ExceptionCollection;
import org.nbirn.fbirndownloader.GridFTPException;
import org.nbirn.fbirndownloader.MainFrame;
import org.nbirn.fbirndownloader.ProgressUpdate;
import org.nbirn.fbirndownloader.WorkerDownload;
import org.nbirn.fbirndownloader.WorkerProgressReporter;
import org.nbirn.fbirndownloader.WorkerURLUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerDownloadFromCatalog
extends WorkerDownload
implements PropertyChangeListener {
    private static Log _logger = LogFactory.getLog((String)MainFrame.class.getName());
    private CatalogDownload _catalog = null;
    private File _dest = null;
    private JPanel _topprogpanel = null;
    private TitledBorder _border = null;
    private CredentialManager _credman = null;
    private boolean _updateOnly = false;
    private WorkerProgressReporter _parentworker = null;
    private double _parentProgressAmount = -1.0;
    private double _lastprogress = -1.0;
    private double _curprogress = 0.0;
    private int _logPriority = 0;
    final ArrayList<WorkerProgressReporter> _tasks;
    final ArrayList<WorkerProgressReporter> _idletasks;

    WorkerDownloadFromCatalog(CatalogDownload catalog, File dest, JPanel progpanel, TitledBorder border, CredentialManager credman, boolean updateOnly, boolean dryRun, WorkerProgressReporter parentworker, double parentProgressAmount) {
        super(dryRun);
        this._catalog = catalog;
        this._dest = dest;
        this._topprogpanel = progpanel;
        this._border = border;
        this._credman = credman;
        this._updateOnly = updateOnly;
        this._curprogress = 0.0;
        this._parentworker = parentworker;
        this._parentProgressAmount = parentProgressAmount;
        this._tasks = new ArrayList();
        this._idletasks = new ArrayList();
    }

    public void setLoggingPriority(int priority) {
        this._logPriority = priority;
    }

    @Override
    protected void process(List<ProgressUpdate> chunks) {
        for (int i = 0; i < chunks.size(); ++i) {
            ProgressUpdate update = chunks.get(i);
            double incprog = update.getIncrementalProgress();
            _logger.debug((Object)("WorkerDownloadFromCatalog: catalog '" + this._catalog.getName() + "' processing incremental progress " + incprog + " (current progress " + this._curprogress + ") message='" + update.getMessage()));
            this._curprogress += incprog;
            if (update.getMessage() == null && update.getSubMessage() == null) continue;
            String msg = (this._catalog == null ? "" : this._catalog.getName()) + " | " + update.getMessage() + (update.getSubMessage() == null ? "" : " [" + update.getSubMessage() + "]");
            if (this._parentworker != null) {
                this._parentworker.sendUpdate(new ProgressUpdate(msg, null, 0.0, update.getPriority()));
                continue;
            }
            if (this._parentworker != null) continue;
            if (this._topprogpanel == null && update.getPriority() > this._logPriority) {
                _logger.info((Object)msg);
                continue;
            }
            _logger.debug((Object)msg);
        }
        if (this._curprogress > 100.0) {
            this._curprogress = 100.0;
        }
        this.setProgress((int)Math.floor(this._curprogress + 0.5));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("state".equals(propName) && evt.getNewValue() == SwingWorker.StateValue.DONE) {
            Throwable result = null;
            try {
                this.get();
            }
            catch (InterruptedException e) {
                result = new CanceledException("Operation canceled.");
            }
            catch (ExecutionException e) {
                result = e.getCause();
            }
            catch (CancellationException e) {
                result = new CanceledException("Operation canceled.");
            }
            if (this._border != null && result != null) {
                String title = this._border.getTitle();
                int errind = title.indexOf(" (ERR: ");
                if (errind != -1) {
                    title = title.substring(0, errind);
                }
                title = title + " (ERR: " + result.getMessage() + ")";
                this._border.setTitle(title);
            }
        } else if (propName.equals("progress")) {
            int val = (Integer)evt.getNewValue();
            _logger.debug((Object)("WorkerDownloadFromCatalog: catalog '" + this._catalog.getName() + "' got progress " + val + " (last progress " + this._lastprogress + ")"));
            if (this._lastprogress == -1.0 || (double)val - this._lastprogress != 0.0) {
                double parentincval = (this._lastprogress == -1.0 ? (double)val : (double)val - this._lastprogress) * (this._parentProgressAmount / 100.0);
                if (this._lastprogress == -1.0) {
                    _logger.debug((Object)("WorkerDownloadFromCatalog:   reporting incremental progress of " + val + " * ( " + this._parentProgressAmount + " / 100.0) = " + parentincval + " to parent"));
                } else {
                    _logger.debug((Object)("WorkerDownloadFromCatalog:   reporting incremental progress of (" + val + " - " + this._lastprogress + ") * ( " + this._parentProgressAmount + " / 100.0) = " + parentincval + " to parent"));
                }
                this._parentworker.sendUpdate(new ProgressUpdate(null, parentincval));
            }
            this._lastprogress = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelTasks() {
        ArrayList<WorkerProgressReporter> arrayList = this._tasks;
        synchronized (arrayList) {
            _logger.debug((Object)("Canceling " + this._tasks.size() + " subtasks for catalog '" + this._catalog.getName() + "'."));
            for (int i = 0; i < this._tasks.size(); ++i) {
                this._tasks.get(i).cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void doDownload(CatalogDownload catalog) throws InvocationTargetException, CanceledException, ExceptionCollection {
        block61: {
            numentries = catalog.getNumEntries();
            numcatalogs = catalog.getNumCatalogs();
            downloadtype = catalog.getDownloadType();
            remoteTimeZone = catalog.getTimeZone();
            timeStampCheckDepth = catalog.getTimeStampCheckDepth();
            subfrac = 0.0;
            if (numentries + numcatalogs <= 0) {
                this.setProgress(100);
                return;
            }
            result = new ExceptionCollection();
            try {
                if (catalog.getPanel() != null) {
                    for (i = 0; i < numentries; ++i) {
                        entry = catalog.getEntry(i);
                        invokee /* !! */  = new AddEntryProgressBar(catalog.getPanel(), entry.getName(), i);
                        SwingUtilities.invokeAndWait(invokee /* !! */ );
                        if (downloadtype != 2) {
                            invokee /* !! */ ._progbar.setEnabled(false);
                        }
                        entry.setProgressBar(invokee /* !! */ ._progbar);
                        entry.setMessageLabel(invokee /* !! */ ._messageLabel);
                        entry.setSubMessageLabel(invokee /* !! */ ._submessageLabel);
                        entry.setCancelButton(invokee /* !! */ ._cancelButton);
                        entry.setRefreshButton(invokee /* !! */ ._refreshButton);
                    }
                    for (i = 0; i < numcatalogs; ++i) {
                        subcat = catalog.getCatalog(i);
                        invokee /* !! */  = new AddCatalogPanel(catalog.getPanel(), subcat.getName());
                        SwingUtilities.invokeAndWait(invokee /* !! */ );
                        subcat.setPanel(invokee /* !! */ ._panel);
                    }
                    ((JFrame)catalog.getPanel().getTopLevelAncestor()).pack();
                }
                progressChunk = 100.0 / (double)(numentries + numcatalogs);
                for (i = 0; i < numentries; ++i) {
                    entry = catalog.getEntry(i);
                    tz = entry.getTimeZone();
                    if (remoteTimeZone != null && tz == null) {
                        tz = remoteTimeZone;
                    }
                    if ((tscd = entry.getTimeStampCheckDepth()) == -1 && timeStampCheckDepth != -1) {
                        tscd = timeStampCheckDepth;
                    }
                    worker = new WorkerURLUpdater(entry, this._dest, this._credman, this._updateOnly, this._dryrun, tz, tscd, this, 1.0 * progressChunk);
                    var17_29 = this._tasks;
                    synchronized (var17_29) {
                        this._tasks.add(worker);
                    }
                    Executors.newCachedThreadPool().execute(worker);
                    if (catalog.getDownloadType() != 2) {
                        WorkerDownloadFromCatalog._logger.debug((Object)("Doing serial download of entry " + entry.getURL().toString()));
                        try {
                            worker.get();
                            this.publish(new ProgressUpdate[]{new ProgressUpdate(null, 0.0 * progressChunk)});
                            continue;
                        }
                        catch (ExecutionException e) {
                            ret = e.getCause();
                            if (ret == null || ret.getClass() != CanceledException.class) continue;
                            throw (CanceledException)ret;
                        }
                    }
                    WorkerDownloadFromCatalog._logger.debug((Object)("Doing parallel download of entry " + entry.getURL().toString()));
                }
                for (i = 0; i < numcatalogs; ++i) {
                    subcat = catalog.getCatalog(i);
                    if (remoteTimeZone != null && subcat.getTimeZone() == null) {
                        subcat.setTimeZone(remoteTimeZone);
                    }
                    if (timeStampCheckDepth != -1 && subcat.getTimeStampCheckDepth() == -1) {
                        subcat.setTimeStampCheckDepth(timeStampCheckDepth);
                    }
                    worker = new WorkerDownloadFromCatalog(subcat, this._dest, subcat.getPanel(), subcat.getBorder(), this._credman, this._updateOnly, this._dryrun, this, 1.0 * progressChunk);
                    worker.addPropertyChangeListener(worker);
                    tscd = this._tasks;
                    synchronized (tscd) {
                        this._tasks.add(worker);
                    }
                    Executors.newCachedThreadPool().execute(worker);
                    if (catalog.getDownloadType() != 2) {
                        WorkerDownloadFromCatalog._logger.debug((Object)("Doing serial download of catalog " + subcat.getName()));
                        try {
                            worker.get();
                            this.publish(new ProgressUpdate[]{new ProgressUpdate(null, 0.0 * progressChunk)});
                            continue;
                        }
                        catch (ExecutionException e) {
                            ret = e.getCause();
                            if (ret == null || ret.getClass() != CanceledException.class) continue;
                            throw (CanceledException)ret;
                        }
                    }
                    WorkerDownloadFromCatalog._logger.debug((Object)("Doing parallel download of catalog " + subcat.getName()));
                }
                WorkerDownloadFromCatalog._logger.debug((Object)("Catalog '" + this._catalog.getName() + "' waiting for " + this._tasks.size() + " subtasks to complete."));
                while (true) {
                    if (this.isCancelled()) {
                        throw new InterruptedException("Catalog '" + this._catalog.getName() + "' was canceled.  Throwing interrupt...");
                    }
                    i = this._tasks;
                    synchronized (i) lbl-1000:
                    // 2 sources

                    {
                        for (i = 0; i < this._tasks.size(); ++i) {
                            block62: {
                                block59: {
                                    subworker = this._tasks.get(i);
                                    if (!subworker.isDone()) continue;
                                    WorkerDownloadFromCatalog._logger.debug((Object)("Catalog '" + this._catalog.getName() + "' removing completed task " + i + " (" + (this._tasks.size() - 1) + " tasks remaining)"));
                                    this._tasks.remove(i);
                                    --i;
                                    subresult = null;
                                    try {
                                        subworker.get();
                                        if (catalog.getDownloadType() == 2) {
                                            this.publish(new ProgressUpdate[]{new ProgressUpdate(null, 0.0 * progressChunk)});
                                        }
                                    }
                                    catch (CancellationException e) {
                                        subresult = e;
                                    }
                                    catch (ExecutionException e) {
                                        subresult = e.getCause();
                                        if (subresult == null || subresult.getClass() != CanceledException.class) break block59;
                                        throw (CanceledException)subresult;
                                    }
                                }
                                WorkerDownloadFromCatalog._logger.debug((Object)("Task " + (i + 1) + " return value is " + subresult));
                                if (subresult == null) continue;
                                if (subresult.getClass() != ExceptionCollection.class) break block62;
                                errlist = ((ExceptionCollection)subresult).getList();
                                for (errind = 0; errind < errlist.size(); ++errind) {
                                    result.add(errlist.get(errind));
                                }
                                ** GOTO lbl-1000
                            }
                            result.add(subresult);
                        }
                        if (this._tasks.isEmpty()) {
                            break;
                        }
                    }
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {}
                }
                var22_37 = null;
            }
            catch (Throwable var21_47) {
                var22_38 = null;
                while (true) {
                    var23_40 = this._tasks;
                    synchronized (var23_40) {
                        for (i = 0; i < this._tasks.size(); ++i) {
                            subworker = this._tasks.get(i);
                            if (!subworker.isDone()) continue;
                            WorkerDownloadFromCatalog._logger.debug((Object)("(Dying) Catalog '" + this._catalog.getName() + "' removing completed task " + i + " out of " + this._tasks.size() + ""));
                            subworker.cleanup(false);
                            this._tasks.remove(i);
                            --i;
                        }
                        if (this._tasks.isEmpty()) {
                            break;
                        }
                    }
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {}
                }
                WorkerDownloadFromCatalog._logger.debug((Object)("All tasks for catalog '" + this._catalog.getName() + "' completed."));
                this.cleanup(false);
                throw var21_47;
            }
            while (true) {
                var23_39 = this._tasks;
                synchronized (var23_39) {
                    for (i = 0; i < this._tasks.size(); ++i) {
                        subworker = this._tasks.get(i);
                        if (!subworker.isDone()) continue;
                        WorkerDownloadFromCatalog._logger.debug((Object)("(Dying) Catalog '" + this._catalog.getName() + "' removing completed task " + i + " out of " + this._tasks.size() + ""));
                        subworker.cleanup(false);
                        this._tasks.remove(i);
                        --i;
                    }
                    if (this._tasks.isEmpty()) {
                        break;
                    }
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {}
            }
            {
                break block61;
                catch (InterruptedException e) {
                    WorkerDownloadFromCatalog._logger.debug((Object)("Catalog '" + this._catalog.getName() + "' got interrupted."));
                    this.cancelTasks();
                    throw new CanceledException("Operation canceled.", e);
                }
                catch (CanceledException e) {
                    if (this._parentworker == null) {
                        WorkerDownloadFromCatalog._logger.debug((Object)("Catalog '" + this._catalog.getName() + "' got a CanceledException."));
                        this.cancelTasks();
                    } else {
                        WorkerDownloadFromCatalog._logger.debug((Object)("Catalog '" + this._catalog.getName() + "' got a CanceledException.  Passing it up to parent."));
                    }
                    throw e;
                }
            }
        }
        WorkerDownloadFromCatalog._logger.debug((Object)("All tasks for catalog '" + this._catalog.getName() + "' completed."));
        this.cleanup(false);
        if (!result.getList().isEmpty()) {
            WorkerDownloadFromCatalog._logger.debug((Object)("doDownload() returning " + result));
            throw result;
        }
        WorkerDownloadFromCatalog._logger.debug((Object)"doDownload() returning null");
    }

    @Override
    protected Void doInBackground() throws CanceledException, GridFTPException {
        if (this._parentworker == null && this._topprogpanel != null) {
            AddCatalogPanel invokee = new AddCatalogPanel(this._topprogpanel, this._catalog.getName());
            try {
                SwingUtilities.invokeAndWait(invokee);
            }
            catch (InterruptedException e) {
                throw new CanceledException("Operation canceled.", e);
            }
            catch (InvocationTargetException e) {
                throw new GridFTPException("Error adding panel", e);
            }
            this._catalog.setPanel(invokee._panel);
        }
        this.setProgress(0);
        try {
            this.doDownload(this._catalog);
        }
        catch (CanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GridFTPException("Error in download", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanup(boolean error) {
        int i;
        ArrayList<WorkerProgressReporter> arrayList = this._tasks;
        synchronized (arrayList) {
            if (this._tasks != null) {
                for (i = 0; i < this._tasks.size(); ++i) {
                    this._tasks.get(i).cleanup(error);
                }
            }
        }
        arrayList = this._idletasks;
        synchronized (arrayList) {
            if (this._idletasks != null) {
                for (i = 0; i < this._idletasks.size(); ++i) {
                    this._idletasks.get(i).cleanup(error);
                }
            }
        }
    }

    @Override
    public void done() {
        block5: {
            if (this._parentworker != null) {
                return;
            }
            try {
                this.get();
            }
            catch (Exception e) {
                _logger.debug((Object)("Download resulted in Exception '" + e.getClass().getCanonicalName() + "': " + e.getMessage()));
                if (this._topprogpanel == null) break block5;
                if (e.getClass() == GridFTPException.class && e.getCause() != null && e.getCause().getClass() == ExceptionCollection.class) {
                    ExceptionCollection ec = (ExceptionCollection)e.getCause();
                    ArrayList<Throwable> errlist = ec.getList();
                    JTabbedPane tp = new JTabbedPane();
                    for (int i = 0; i < errlist.size(); ++i) {
                        JPanel panel = new JPanel(false);
                        _logger.debug((Object)errlist.get(i).getMessage());
                        JLabel textpane = new JLabel(errlist.get(i).getMessage());
                        panel.setLayout(new GridLayout(1, 1));
                        panel.add(textpane);
                        tp.addTab("Error " + i, panel);
                    }
                    JOptionPane.showMessageDialog(this._topprogpanel, tp);
                }
                if (e.getClass() == CancellationException.class || e.getClass() == ExecutionException.class && e.getCause() != null && e.getCause().getClass() == CanceledException.class) break block5;
                JOptionPane.showMessageDialog(this._topprogpanel, "Error getting result of download: \n" + e.getMessage());
            }
        }
        this.cleanup(false);
    }

    private class AddEntryProgressBar
    implements Runnable {
        JPanel _parentpanel = null;
        String _title = null;
        JProgressBar _progbar = null;
        JLabel _messageLabel = null;
        JLabel _submessageLabel = null;
        JButton _cancelButton = null;
        JButton _refreshButton = null;
        int _rownum;

        AddEntryProgressBar(JPanel parentpanel, String title, int rownum) {
            this._parentpanel = parentpanel;
            this._title = title;
            this._rownum = rownum;
        }

        public void run() {
            GridBagConstraints constraints = new GridBagConstraints();
            JPanel panel = new JPanel(new GridBagLayout());
            constraints.gridx = 0;
            constraints.gridy = this._rownum;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            panel.setBorder(new EmptyBorder(this._rownum == 0 ? 0 : 8, 0, 0, 0));
            this._parentpanel.add((Component)panel, constraints);
            constraints = new GridBagConstraints();
            JLabel label = new JLabel(this._title == null ? "" : this._title);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 17;
            panel.add((Component)label, constraints);
            this._progbar = new JProgressBar();
            this._progbar.setBorder(new EmptyBorder(0, 10, 0, 0));
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            panel.add((Component)this._progbar, constraints);
            this._messageLabel = new JLabel(" ");
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 2;
            constraints.fill = 2;
            this._messageLabel.setFont(new Font("Dialog", 0, 9));
            panel.add((Component)this._messageLabel, constraints);
            this._submessageLabel = new JLabel(" ");
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 2;
            this._submessageLabel.setFont(new Font("Dialog", 0, 9));
            panel.add((Component)this._submessageLabel, constraints);
            this._progbar.setStringPainted(true);
            this._progbar.setIndeterminate(true);
            constraints = new GridBagConstraints();
            JPanel buttonpanel = new JPanel(new GridBagLayout());
            constraints.gridx = 1;
            constraints.gridy = this._rownum;
            buttonpanel.setBorder(new EmptyBorder(this._rownum == 0 ? 0 : 8, 0, 0, 0));
            this._parentpanel.add((Component)buttonpanel, constraints);
            constraints = new GridBagConstraints();
            this._cancelButton = new JButton();
            this._cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/org/nbirn/fbirndownloader/resources/cancel.png")));
            this._cancelButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            constraints.gridx = 0;
            constraints.gridy = 0;
            buttonpanel.add((Component)this._cancelButton, constraints);
            this._refreshButton = new JButton();
            this._refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/nbirn/fbirndownloader/resources/refresh.png")));
            this._refreshButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            constraints.gridx = 0;
            constraints.gridy = 1;
            buttonpanel.add((Component)this._refreshButton, constraints);
        }
    }

    private class AddCatalogPanel
    implements Runnable {
        JPanel _parentpanel = null;
        String _title = null;
        JPanel _panel = null;
        TitledBorder _titledborder = null;

        AddCatalogPanel(JPanel parentpanel, String title) {
            this._parentpanel = parentpanel;
            this._title = title;
        }

        public void run() {
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this._panel = new JPanel(layout);
            this._titledborder = BorderFactory.createTitledBorder(this._title == null ? "" : this._title);
            this._panel.setBorder(this._titledborder);
            constraints.gridx = 0;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            this._parentpanel.add((Component)this._panel, constraints);
        }
    }
}

