/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirndownloader;

import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.util.TimeZone;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbirn.fbirn.xcede2.catalog.Catalog;
import org.nbirn.fbirndownloader.CanceledException;
import org.nbirn.fbirndownloader.CredentialManager;
import org.nbirn.fbirndownloader.GridFTPException;
import org.nbirn.fbirndownloader.MainFrame;
import org.nbirn.fbirndownloader.WorkerDownload;

public class WorkerDownloadFromURL
extends WorkerDownload {
    private static Log logger = LogFactory.getLog((String)MainFrame.class.getName());
    private Catalog _topcatalog = null;
    private Exception _error = null;
    private URI _url = null;
    private File _dest = null;
    private Component _parent = null;
    private CredentialManager _credman = null;
    private boolean _updateonly = false;
    private TimeZone _timezone = null;
    private int _timeStampCheckDepth = 0;

    WorkerDownloadFromURL(URI url, File dest, CredentialManager credman) {
        super(false);
        this._url = url;
        this._dest = dest;
        this._credman = credman;
        this._updateonly = false;
        this._timezone = null;
        this._timeStampCheckDepth = 0;
    }

    WorkerDownloadFromURL(URI url, File dest, CredentialManager credman, boolean updateonly, boolean dryRun, TimeZone remoteTimeZone, int timeStampCheckDepth) {
        super(dryRun);
        this._url = url;
        this._dest = dest;
        this._credman = credman;
        this._updateonly = updateonly;
        this._timezone = remoteTimeZone;
        this._timeStampCheckDepth = timeStampCheckDepth;
    }

    public Exception getError() {
        return this._error;
    }

    public Void doInBackground() throws CanceledException, GridFTPException {
        this.setProgress(0);
        if (this._url.getScheme() != null && this._url.getScheme().equals("gsiftp")) {
            this.downloadURLGSIFTP(this._url, this._dest, this._credman, this._updateonly, this._timezone, this._timeStampCheckDepth);
        } else {
            this.downloadURLDefault(this._url, this._dest);
        }
        return null;
    }

    public void done() {
        this.cleanup(false);
        if (this._error != null && this._parent != null) {
            logger.error((Object)"Error getting result of download", (Throwable)this._error);
            JOptionPane.showMessageDialog(this._parent, "Error downloading file(s): " + this._error.getMessage());
        }
    }
}

