/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class ArrayLocatorResultSet
extends OracleResultSetImpl {
    static int COUNT_UNLIMITED = -1;
    Map m_map;
    long m_beginIdx;
    int m_count;
    long m_idx;

    public ArrayLocatorResultSet(OracleConnection oracleConnection, ArrayDescriptor arrayDescriptor, byte[] byArray, long l, int n, Map map) throws SQLException {
        super(oracleConnection, null);
        if (arrayDescriptor == null || oracleConnection == null) {
            DBError.check_error(1, "Invalid arguments");
        }
        this.close_statement_on_close = true;
        this.m_count = n;
        this.m_idx = 0L;
        this.m_beginIdx = l;
        this.m_map = map;
        OraclePreparedStatement oraclePreparedStatement = null;
        ARRAY aRRAY = new ARRAY(arrayDescriptor, oracleConnection, null);
        aRRAY.setLocator(byArray);
        oraclePreparedStatement = arrayDescriptor.getBaseType() == 2002 || arrayDescriptor.getBaseType() == 2008 ? (OraclePreparedStatement)oracleConnection.prepareStatement("SELECT ROWNUM, SYS_NC_ROWINFO$ FROM TABLE( CAST(? AS " + arrayDescriptor.getName() + ") )") : (OraclePreparedStatement)oracleConnection.prepareStatement("SELECT ROWNUM, COLUMN_VALUE FROM TABLE( CAST(? AS " + arrayDescriptor.getName() + ") )");
        oraclePreparedStatement.setArray(1, aRRAY);
        oraclePreparedStatement.executeQuery();
        this.statement = oraclePreparedStatement;
    }

    public ArrayLocatorResultSet(OracleConnection oracleConnection, ArrayDescriptor arrayDescriptor, byte[] byArray, Map map) throws SQLException {
        this(oracleConnection, arrayDescriptor, byArray, 0L, COUNT_UNLIMITED, map);
    }

    public synchronized int findColumn(String string) throws SQLException {
        this.connection.trace("ResultSet.findColumn");
        if (string.equalsIgnoreCase("index")) {
            return 1;
        }
        if (string.equalsIgnoreCase("value")) {
            return 2;
        }
        DBError.check_error(6, "get_column_index");
        return 0;
    }

    public synchronized Object getObject(int n) throws SQLException {
        return this.getObject(n, this.m_map);
    }

    public synchronized boolean next() throws SQLException {
        if (this.m_idx < this.m_beginIdx) {
            while (this.m_idx < this.m_beginIdx) {
                ++this.m_idx;
                if (super.next()) continue;
                return false;
            }
            return true;
        }
        if (this.m_count == COUNT_UNLIMITED) {
            return super.next();
        }
        if (this.m_idx < this.m_beginIdx + (long)this.m_count - 1L) {
            ++this.m_idx;
            return super.next();
        }
        return false;
    }
}

