/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.pool.OracleConnectionCacheImpl;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXADataSource;

public class OracleXAConnectionCacheImpl
extends OracleConnectionCacheImpl {
    public OracleXAConnectionCacheImpl() throws SQLException {
        this(null);
    }

    public OracleXAConnectionCacheImpl(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        super(connectionPoolDataSource);
        this.m_dataSourceName = "OracleXAConnectionCacheImpl";
    }

    PooledConnection getNewPoolOrXAConnection() throws SQLException {
        if (this.m_cpds == null) {
            if (this.m_user == null || this.m_password == null) {
                DBError.throwSqlException(79);
            }
            this.m_cpds = new OracleXADataSource();
            this.copy((OracleDataSource)((Object)this.m_cpds));
        }
        XAConnection xAConnection = ((oracle.jdbc.xa.OracleXADataSource)this.m_cpds).getXAConnection();
        ((OracleXAConnection)xAConnection).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        return xAConnection;
    }

    public synchronized XAConnection getXAConnection() throws SQLException {
        XAConnection xAConnection = (XAConnection)super.getPooledConnection(this.m_user, this.m_password);
        return xAConnection;
    }

    public synchronized XAConnection getXAConnection(String string, String string2) throws SQLException {
        XAConnection xAConnection = (XAConnection)super.getPooledConnection(string, string2);
        return xAConnection;
    }
}

