/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class LobPlsqlUtil {
    static boolean PLSQL_DEBUG = false;
    static final int MAX_PLSQL_SIZE = 32512;
    static final int MAX_PLSQL_INSTR_SIZE = 32512;
    static final int MAX_CHUNK_SIZE = 32512;

    private static int getPlsqlMaxInstrSize(OracleConnection oracleConnection) throws SQLException {
        DBConversion dBConversion = oracleConnection.conversion;
        boolean bl = DBConversion.isCharSetMultibyte(dBConversion.getAccessCharSet());
        int n = dBConversion.getMaxCharbyteSize();
        if (bl) {
            return 32512 / (oracleConnection.db_access.getC2SNlsRatio() * n);
        }
        return 32512;
    }

    private static boolean isNCLOB(Datum datum) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("oracle.sql.CLOB");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        if (!clazz.isInstance(datum)) {
            return false;
        }
        CLOB cLOB = (CLOB)datum;
        return cLOB.isNCLOB();
    }

    public static void plsql_closeLob(Connection connection, Datum datum, int n) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.close (?); end;");
            oracleCallableStatement.registerOutParameter(1, n);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setOracleObject(1, datum);
            oracleCallableStatement.execute();
            datum.setShareBytes(oracleCallableStatement.getOracleObject(1).shareBytes());
        }
        finally {
            Object var5_4 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
    }

    public static Datum plsql_createTemporaryLob(Connection connection, boolean bl, int n, int n2) throws SQLException {
        Datum datum;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.createTemporary (?," + (bl ? "TRUE" : "FALSE") + ", ?); end;");
            oracleCallableStatement.registerOutParameter(1, n2);
            oracleCallableStatement.setInt(2, n);
            oracleCallableStatement.execute();
            datum = oracleCallableStatement.getOracleObject(1);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return datum;
    }

    public static void plsql_fileClose(BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getConnection().prepareCall("begin dbms_lob.fileclose (?); end;");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.registerOutParameter(1, -13);
            oracleCallableStatement.execute();
            bFILE.setLocator(oracleCallableStatement.getBFILE(1).getLocator());
        }
        finally {
            Object var3_2 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
    }

    public static boolean plsql_fileExists(BFILE bFILE) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getConnection().prepareCall("begin ? := dbms_lob.fileExists(?); end; ");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBFILE(2, bFILE);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return bl;
    }

    public static String plsql_fileGetDirAlias(BFILE bFILE) throws SQLException {
        String string;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getConnection().prepareCall("begin dbms_lob.fileGetName(?, ?, ?); end; ");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return string;
    }

    public static String plsql_fileGetName(BFILE bFILE) throws SQLException {
        String string;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getConnection().prepareCall("begin dbms_lob.fileGetName(?, ?, ?); end; ");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(3);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return string;
    }

    public static boolean plsql_fileIsOpen(BFILE bFILE) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getConnection().prepareCall("begin ? := dbms_lob.fileIsOpen(?); end; ");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBFILE(2, bFILE);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return bl;
    }

    public static void plsql_fileOpen(BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getConnection().prepareCall("begin dbms_lob.fileopen (?, ?); end;");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.setInt(2, 0);
            oracleCallableStatement.registerOutParameter(1, -13);
            oracleCallableStatement.execute();
            bFILE.setLocator(oracleCallableStatement.getBFILE(1).getLocator());
        }
        finally {
            Object var3_2 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
    }

    public static void plsql_freeTemporaryLob(Connection connection, Datum datum, int n) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.freeTemporary (?); end;");
            oracleCallableStatement.registerOutParameter(1, n);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setOracleObject(1, datum);
            oracleCallableStatement.execute();
            datum.setShareBytes(oracleCallableStatement.getBytes(1));
        }
        finally {
            Object var5_4 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
    }

    public static long plsql_getChunkSize(OracleConnection oracleConnection, Datum datum, int n) throws SQLException {
        long l = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            try {
                oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin ? := dbms_lob.getchunksize(?); end;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (LobPlsqlUtil.isNCLOB(datum)) {
                    oracleCallableStatement.setFormOfUse(2, (short)2);
                }
                oracleCallableStatement.setObject(2, (Object)datum, n);
                oracleCallableStatement.execute();
                l = oracleCallableStatement.getLong(1);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 6550) {
                    throw sQLException;
                }
                l = 32512L;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return l;
    }

    public static long plsql_getChunkSize(BLOB bLOB) throws SQLException {
        return LobPlsqlUtil.plsql_getChunkSize(bLOB.getConnection(), bLOB, 2004);
    }

    public static long plsql_getChunkSize(CLOB cLOB) throws SQLException {
        return LobPlsqlUtil.plsql_getChunkSize(cLOB.getConnection(), cLOB, 2005);
    }

    public static long plsql_hasPattern(OracleConnection oracleConnection, Datum datum, int n, byte[] byArray, long l) throws SQLException {
        if (byArray == null || l <= 0L) {
            return 0L;
        }
        long l2 = byArray.length;
        long l3 = LobPlsqlUtil.plsql_length(oracleConnection, datum, n);
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= 32512L) {
            long l4;
            OracleCallableStatement oracleCallableStatement = null;
            try {
                oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin ? := dbms_lob.instr(?, ?, ?); end;");
                oracleCallableStatement.registerOutParameter(1, 2);
                oracleCallableStatement.setObject(2, (Object)datum, n);
                oracleCallableStatement.setBytes(3, byArray);
                oracleCallableStatement.setLong(4, l);
                oracleCallableStatement.execute();
                l4 = oracleCallableStatement.getLong(1);
                Object var14_11 = null;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                oracleCallableStatement.close();
                oracleCallableStatement = null;
                throw throwable;
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            return l4;
        }
        int n2 = 0;
        long l5 = l;
        boolean bl = false;
        long l6 = 0L;
        while (!bl) {
            if (l2 > l3 - l5 + 1L) {
                return 0L;
            }
            n2 = 0;
            int n3 = (int)Math.min(32512L, l2 - (long)n2);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            long l7 = LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n, byArray2, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n2 += n3;
            l5 = l7 + (long)n3;
            boolean bl2 = true;
            while (bl2) {
                n3 = (int)Math.min(32512L, l2 - (long)n2);
                byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                l7 = LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n, byArray2, l5);
                if (l7 == l5) {
                    l5 += (long)n3;
                    if ((long)(n2 += n3) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n2;
                bl2 = false;
            }
        }
        return l6;
    }

    public static long plsql_hasPattern(BFILE bFILE, byte[] byArray, long l) throws SQLException {
        return LobPlsqlUtil.plsql_hasPattern(bFILE.getConnection(), bFILE, -13, byArray, l);
    }

    public static long plsql_hasPattern(BLOB bLOB, byte[] byArray, long l) throws SQLException {
        return LobPlsqlUtil.plsql_hasPattern(bLOB.getConnection(), bLOB, 2004, byArray, l);
    }

    public static long plsql_hasPattern(CLOB cLOB, char[] cArray, long l) throws SQLException {
        if (cArray == null || l <= 0L) {
            return 0L;
        }
        OracleConnection oracleConnection = cLOB.getConnection();
        long l2 = cArray.length;
        long l3 = LobPlsqlUtil.plsql_length(oracleConnection, cLOB, 2005);
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection)) {
            long l4;
            OracleCallableStatement oracleCallableStatement = null;
            try {
                oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin ? := dbms_lob.instr(?, ?, ?); end;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (cLOB.isNCLOB()) {
                    oracleCallableStatement.setFormOfUse(2, (short)2);
                    oracleCallableStatement.setFormOfUse(3, (short)2);
                }
                oracleCallableStatement.setCLOB(2, cLOB);
                oracleCallableStatement.setString(3, new String(cArray));
                oracleCallableStatement.setLong(4, l);
                oracleCallableStatement.execute();
                l4 = oracleCallableStatement.getLong(1);
                Object var13_10 = null;
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                oracleCallableStatement.close();
                oracleCallableStatement = null;
                throw throwable;
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            return l4;
        }
        int n = 0;
        long l5 = l;
        boolean bl = false;
        long l6 = 0L;
        while (!bl) {
            if (l2 > l3 - l5 + 1L) {
                return 0L;
            }
            n = 0;
            int n2 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l2 - (long)n);
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            long l7 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray2, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n += n2;
            l5 = l7 + (long)n2;
            boolean bl2 = true;
            while (bl2) {
                n2 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l2 - (long)n);
                cArray2 = new char[n2];
                System.arraycopy(cArray, n, cArray2, 0, n2);
                l7 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray2, l5);
                if (l7 == l5) {
                    l5 += (long)n2;
                    if ((long)(n += n2) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n;
                bl2 = false;
            }
        }
        return l6;
    }

    public static boolean plsql_isLobOpen(Connection connection, Datum datum, int n) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin ? := dbms_lob.isOpen(?); end; ");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(2, (short)2);
            }
            oracleCallableStatement.setOracleObject(2, datum);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return bl;
    }

    public static long plsql_isSubLob(OracleConnection oracleConnection, Datum datum, int n, Datum datum2, long l) throws SQLException {
        if (datum2 == null || l <= 0L) {
            return 0L;
        }
        long l2 = LobPlsqlUtil.plsql_length(oracleConnection, datum2, n);
        long l3 = LobPlsqlUtil.plsql_length(oracleConnection, datum, n);
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= 32512L) {
            byte[] byArray = new byte[(int)l2];
            LobPlsqlUtil.plsql_read(oracleConnection, datum2, n, 1L, l2, byArray);
            return LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n, byArray, l);
        }
        int n2 = 0;
        long l4 = l;
        boolean bl = false;
        long l5 = 0L;
        while (!bl) {
            if (l2 > l3 - l4 + 1L) {
                return 0L;
            }
            n2 = 0;
            int n3 = (int)Math.min(32512L, l2 - (long)n2);
            byte[] byArray = new byte[n3];
            LobPlsqlUtil.plsql_read(oracleConnection, datum2, n, n2 + 1, n3, byArray);
            long l6 = LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n, byArray, l4);
            if (l6 == 0L) {
                return 0L;
            }
            l5 = l6;
            n2 += n3;
            l4 = l6 + (long)n3;
            boolean bl2 = true;
            while (bl2) {
                n3 = (int)Math.min(32512L, l2 - (long)n2);
                byArray = new byte[n3];
                LobPlsqlUtil.plsql_read(oracleConnection, datum2, n, n2 + 1, n3, byArray);
                l6 = LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n, byArray, l4);
                if (l6 == l4) {
                    l4 += (long)n3;
                    if ((long)(n2 += n3) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l6 == 0L) {
                    return 0L;
                }
                l4 = l6 - (long)n2;
                bl2 = false;
            }
        }
        return l5;
    }

    public static long plsql_isSubLob(BFILE bFILE, BFILE bFILE2, long l) throws SQLException {
        return LobPlsqlUtil.plsql_isSubLob(bFILE.getConnection(), bFILE, -13, bFILE2, l);
    }

    public static long plsql_isSubLob(BLOB bLOB, BLOB bLOB2, long l) throws SQLException {
        return LobPlsqlUtil.plsql_isSubLob(bLOB.getConnection(), bLOB, 2004, bLOB2, l);
    }

    public static long plsql_isSubLob(CLOB cLOB, CLOB cLOB2, long l) throws SQLException {
        if (cLOB2 == null || l <= 0L) {
            return 0L;
        }
        OracleConnection oracleConnection = cLOB.getConnection();
        long l2 = LobPlsqlUtil.plsql_length(oracleConnection, cLOB2, 2005);
        long l3 = LobPlsqlUtil.plsql_length(oracleConnection, cLOB, 2005);
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection)) {
            char[] cArray = new char[(int)l2];
            cLOB2.getChars(1L, (int)l2, cArray);
            return LobPlsqlUtil.plsql_hasPattern(cLOB, cArray, l);
        }
        int n = 0;
        long l4 = l;
        boolean bl = false;
        long l5 = 0L;
        while (!bl) {
            if (l2 > l3 - l4 + 1L) {
                return 0L;
            }
            n = 0;
            int n2 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l2 - (long)n);
            char[] cArray = new char[n2];
            cLOB2.getChars(n + 1, n2, cArray);
            long l6 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray, l4);
            if (l6 == 0L) {
                return 0L;
            }
            l5 = l6;
            n += n2;
            l4 = l6 + (long)n2;
            boolean bl2 = true;
            while (bl2) {
                n2 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l2 - (long)n);
                cArray = new char[n2];
                cLOB2.getChars(n + 1, n2, cArray);
                l6 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray, l4);
                if (l6 == l4) {
                    l4 += (long)n2;
                    if ((long)(n += n2) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l6 == 0L) {
                    return 0L;
                }
                l4 = l6 - (long)n;
                bl2 = false;
            }
        }
        return l5;
    }

    public static boolean plsql_isTemporaryLob(Connection connection, Datum datum, int n) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin ? := dbms_lob.isTemporary (?); end;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(2, (short)2);
            }
            oracleCallableStatement.setOracleObject(2, datum);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return bl;
    }

    public static long plsql_length(OracleConnection oracleConnection, Datum datum, int n) throws SQLException {
        long l = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin ? := dbms_lob.getLength (?); end;");
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(2, (short)2);
            }
            oracleCallableStatement.setObject(2, (Object)datum, n);
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.execute();
            l = oracleCallableStatement.getLong(1);
        }
        finally {
            Object var7_5 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
        return l;
    }

    public static long plsql_length(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_length(bFILE.getConnection(), bFILE, -13);
    }

    public static long plsql_length(BLOB bLOB) throws SQLException {
        return LobPlsqlUtil.plsql_length(bLOB.getConnection(), bLOB, 2004);
    }

    public static long plsql_length(CLOB cLOB) throws SQLException {
        return LobPlsqlUtil.plsql_length(cLOB.getConnection(), cLOB, 2005);
    }

    public static void plsql_openLob(Connection connection, Datum datum, int n, int n2) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.open (?, ?); end;");
            oracleCallableStatement.registerOutParameter(1, n2);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setOracleObject(1, datum);
            oracleCallableStatement.setInt(2, n);
            oracleCallableStatement.execute();
            datum.setShareBytes(oracleCallableStatement.getOracleObject(1).shareBytes());
        }
        finally {
            Object var6_5 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
    }

    public static long plsql_read(OracleConnection oracleConnection, Datum datum, int n, long l, long l2, byte[] byArray) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        int n2 = 0;
        try {
            block11: {
                try {
                    oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin dbms_lob.read (?, ?, ?, ?); end;");
                    int n3 = 0;
                    int n4 = 0;
                    if (LobPlsqlUtil.isNCLOB(datum)) {
                        oracleCallableStatement.setFormOfUse(1, (short)2);
                        oracleCallableStatement.setFormOfUse(4, (short)2);
                    }
                    oracleCallableStatement.setObject(1, (Object)datum, n);
                    oracleCallableStatement.registerOutParameter(2, 2);
                    oracleCallableStatement.registerOutParameter(4, -3);
                    while ((long)n2 < l2) {
                        n4 = Math.min((int)l2, 32512);
                        if (PLSQL_DEBUG) {
                            System.out.println("read chunks: chunkSize=" + n4);
                        }
                        oracleCallableStatement.setInt(2, n4);
                        oracleCallableStatement.setInt(3, (int)l + n2);
                        oracleCallableStatement.execute();
                        n3 = oracleCallableStatement.getInt(2);
                        byte[] byArray2 = oracleCallableStatement.getBytes(4);
                        System.arraycopy(byArray2, 0, byArray, n2, n3);
                        if (PLSQL_DEBUG) {
                            System.out.println("==> sizeRead=" + n3);
                        }
                        n2 += n3;
                    }
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() != 1403) {
                        throw sQLException;
                    }
                    if (!PLSQL_DEBUG) break block11;
                    System.out.println("end of file");
                }
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            if (PLSQL_DEBUG) {
                System.out.println("end plsql_read =" + n2);
            }
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        if (PLSQL_DEBUG) {
            System.out.println("end plsql_read =" + n2);
        }
        return n2;
    }

    public static long plsql_read(BFILE bFILE, long l, long l2, byte[] byArray) throws SQLException {
        return LobPlsqlUtil.plsql_read(bFILE.getConnection(), bFILE, -13, l, l2, byArray);
    }

    public static long plsql_read(BLOB bLOB, long l, long l2, byte[] byArray) throws SQLException {
        return LobPlsqlUtil.plsql_read(bLOB.getConnection(), bLOB, 2004, l, l2, byArray);
    }

    public static long plsql_read(CLOB cLOB, long l, long l2, char[] cArray) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        int n = 0;
        int n2 = 1;
        try {
            block9: {
                try {
                    Object var11_7 = null;
                    boolean bl = false;
                    OracleConnection oracleConnection = cLOB.getConnection();
                    DBConversion dBConversion = oracleConnection.conversion;
                    boolean bl2 = DBConversion.isCharSetMultibyte(dBConversion.getAccessCharSet());
                    if (bl2) {
                        n2 = oracleConnection.db_access.getNlsRatio();
                    }
                    oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin dbms_lob.read(?, ?, ?, ?); end;");
                    int n3 = 0;
                    int n4 = 0;
                    byte[] byArray = null;
                    char[] cArray2 = new char[32512];
                    if (cLOB.isNCLOB()) {
                        oracleCallableStatement.setFormOfUse(1, (short)2);
                        oracleCallableStatement.setFormOfUse(4, (short)2);
                        if (dBConversion.IsNCharFixedWith()) {
                            n2 = 2;
                        }
                    }
                    oracleCallableStatement.setCLOB(1, cLOB);
                    oracleCallableStatement.registerOutParameter(2, 2);
                    oracleCallableStatement.registerOutParameter(4, 12);
                    while ((long)n < l2) {
                        n4 = (int)Math.min(l2 - (long)n, (long)(32512 / n2));
                        oracleCallableStatement.setInt(2, n4);
                        oracleCallableStatement.setInt(3, (int)l + n);
                        oracleCallableStatement.execute();
                        n3 = oracleCallableStatement.getInt(2);
                        byArray = oracleCallableStatement.getBytes(4);
                        int n5 = 0;
                        n5 = cLOB.isNCLOB() ? dBConversion.NCHARBytesToJavaChars(byArray, byArray.length, cArray2) : dBConversion.CHARBytesToJavaChars(byArray, byArray.length, cArray2);
                        if (n5 != n3) {
                            DBError.check_error(37, null);
                        }
                        System.arraycopy(cArray2, 0, cArray, n, n3);
                        n += n3;
                    }
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 1403) break block9;
                    throw sQLException;
                }
            }
            Object var10_18 = null;
        }
        catch (Throwable throwable) {
            Object var10_19 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        oracleCallableStatement = null;
        return n;
    }

    public static void plsql_trimLob(Connection connection, Datum datum, int n, long l) throws SQLException {
        long l2 = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.trim (?, ?); end;");
        oracleCallableStatement.registerOutParameter(1, n);
        if (LobPlsqlUtil.isNCLOB(datum)) {
            oracleCallableStatement.setFormOfUse(1, (short)2);
        }
        oracleCallableStatement.setObject(1, (Object)datum, n);
        oracleCallableStatement.setLong(2, l);
        oracleCallableStatement.execute();
        datum.setShareBytes(oracleCallableStatement.getBytes(1));
    }

    public static long plsql_write(Connection connection, Datum datum, int n, long l, byte[] byArray, long l2, long l3) throws SQLException {
        return 0L;
    }

    public static long plsql_write(BLOB bLOB, long l, byte[] byArray) throws SQLException {
        int n = byArray.length;
        OracleCallableStatement oracleCallableStatement = null;
        int n2 = 0;
        oracleCallableStatement = (OracleCallableStatement)bLOB.getConnection().prepareCall("begin dbms_lob.write (?, ?, ?, ?); end;");
        try {
            int n3 = Math.min(n, 32512);
            byte[] byArray2 = new byte[n3];
            oracleCallableStatement.registerOutParameter(1, 2004);
            while (n2 < n) {
                n3 = Math.min(n - n2, 32512);
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                oracleCallableStatement.setBLOB(1, bLOB);
                oracleCallableStatement.setInt(2, n3);
                oracleCallableStatement.setInt(3, (int)l + n2);
                oracleCallableStatement.setBytes(4, byArray2);
                oracleCallableStatement.execute();
                n2 += n3;
                bLOB.setLocator(oracleCallableStatement.getBLOB(1).getLocator());
            }
        }
        finally {
            Object var8_8 = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
        return n2;
    }

    public static long plsql_write(CLOB cLOB, long l, char[] cArray) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        OracleConnection oracleConnection = cLOB.getConnection();
        int n = cArray.length;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            String string = null;
            int n3 = 0;
            DBConversion dBConversion = oracleConnection.conversion;
            boolean bl3 = DBConversion.isCharSetMultibyte(dBConversion.getAccessCharSet());
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin dbms_lob.write (?, ?, ?, ?); end;");
            if (cLOB.isNCLOB()) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.registerOutParameter(1, 2005);
            if (!bl3 && !cLOB.isNCLOB()) {
                while (n2 < n) {
                    oracleCallableStatement.setCLOB(1, cLOB);
                    oracleCallableStatement.setInt(3, (int)l + n2);
                    n3 = Math.min(n - n2, 32512);
                    string = new String(cArray, n2, n3);
                    oracleCallableStatement.setInt(2, n3);
                    oracleCallableStatement.setString(4, string);
                    oracleCallableStatement.execute();
                    n2 += n3;
                    cLOB.setLocator(oracleCallableStatement.getCLOB(1).getLocator());
                }
            } else {
                int n4 = oracleConnection.db_access.getC2SNlsRatio();
                int n5 = dBConversion.getMaxCharbyteSize();
                if (cLOB.isNCLOB()) {
                    n5 = dBConversion.getMaxNCharbyteSize();
                    if (dBConversion.IsNCharFixedWith()) {
                        n4 = 2;
                    }
                }
                int n6 = 32512 / n4;
                int n7 = Math.min(n6 / n5, n);
                int n8 = n7 / 3;
                int n9 = 100;
                byte[] byArray = new byte[n7 * n5];
                char[] cArray2 = new char[n7];
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                boolean bl4 = false;
                boolean bl5 = true;
                while (n2 < n) {
                    oracleCallableStatement.setCLOB(1, cLOB);
                    oracleCallableStatement.setInt(3, (int)l + n2);
                    bl4 = false;
                    n13 = 0;
                    n14 = 0;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bl5 = true;
                    while (!bl4) {
                        if (n11 != 0) {
                            bl5 = false;
                            byteArrayOutputStream.write(byArray, 0, n11);
                            n13 += n11;
                            n11 = 0;
                            n14 += n12;
                            n12 = 0;
                        }
                        if (bl5) {
                            n12 = Math.min(n7, n - n10);
                            bl5 = false;
                        } else {
                            n12 = Math.min(n8, n - n10);
                            if (n12 * n5 + n13 > n6 && n12 > n9) {
                                n12 = n9;
                            }
                        }
                        if (PLSQL_DEBUG) {
                            System.out.println("while !done    " + n12 + " " + n14);
                        }
                        if (n12 > 0) {
                            int n15 = 0;
                            while (n15 < n12) {
                                cArray2[n15] = cArray[n10 + n15];
                                ++n15;
                            }
                            n10 += n12;
                            n11 = cLOB.isNCLOB() ? dBConversion.javaCharsToNCHARBytes(cArray2, n12, byArray) : dBConversion.javaCharsToCHARBytes(cArray2, n12, byArray);
                            if (n13 + n11 <= n6) {
                                byteArrayOutputStream.write(byArray, 0, n11);
                                n14 += n12;
                                n13 += n11;
                                n11 = 0;
                                n12 = 0;
                                if (n13 != n6) continue;
                                bl4 = true;
                                continue;
                            }
                            bl4 = true;
                            continue;
                        }
                        bl4 = true;
                    }
                    if (n14 > 0) {
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        if (PLSQL_DEBUG) {
                            System.out.println("execute  .... " + n14 + " " + byArray2.length + " " + n6);
                        }
                        oracleCallableStatement.setInt(2, n14);
                        if (cLOB.isNCLOB()) {
                            oracleCallableStatement.setFormOfUse(4, (short)2);
                        }
                        oracleCallableStatement.setInternalBytes(4, byArray2, 1);
                        oracleCallableStatement.execute();
                        n2 += n14;
                        cLOB.setLocator(oracleCallableStatement.getCLOB(1).getLocator());
                        continue;
                    }
                    if (n2 >= n) continue;
                    DBError.throwSqlException(1);
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_32 = null;
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
            throw throwable;
        }
        Object var11_31 = null;
        if (oracleCallableStatement != null) {
            oracleCallableStatement.close();
            oracleCallableStatement = null;
        }
        return n2;
    }
}

