/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.md;

import java.security.MessageDigest;

public class MD2
extends MessageDigest
implements Cloneable {
    private static final int BLOCK_LENGTH = 16;
    private int[] checksum = new int[16];
    private int count;
    private int[] buffer = new int[16];
    private int[] X = new int[48];
    private static final int[] S = new int[]{41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6, 19, 98, 167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188, 76, 130, 202, 30, 155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24, 138, 23, 229, 18, 190, 78, 196, 214, 218, 158, 222, 73, 160, 251, 245, 142, 187, 47, 238, 122, 169, 104, 121, 145, 21, 178, 7, 63, 148, 194, 16, 137, 11, 34, 95, 33, 128, 127, 93, 154, 90, 144, 50, 39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48, 179, 72, 165, 181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56, 210, 150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157, 112, 89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27, 96, 37, 173, 174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, 163, 35, 221, 81, 175, 58, 195, 92, 249, 206, 186, 197, 234, 38, 44, 83, 13, 110, 133, 40, 132, 9, 211, 223, 205, 244, 65, 129, 77, 82, 106, 220, 55, 200, 108, 193, 171, 250, 36, 225, 123, 8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99, 232, 109, 233, 203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88, 208, 228, 166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237, 31, 26, 219, 153, 141, 51, 159, 17, 131, 20};

    public MD2() {
        super("MD2");
        this.engineReset();
    }

    private MD2(MD2 md) {
        this();
        this.X = (int[])md.X.clone();
        this.checksum = (int[])md.checksum.clone();
        this.buffer = (int[])md.buffer.clone();
        this.count = md.count;
    }

    public Object clone() {
        return new MD2(this);
    }

    public void engineReset() {
        this.count = 0;
        int i = 0;
        while (i < 16) {
            this.X[i] = 0;
            this.checksum[i] = 0;
            ++i;
        }
    }

    public void engineUpdate(byte input) {
        this.buffer[this.count] = input & 0xFF;
        if (this.count == 15) {
            this.transform(this.buffer, 0);
            this.count = 0;
        } else {
            ++this.count;
        }
    }

    public void engineUpdate(byte[] input, int offset, int len) {
        int j;
        if (offset < 0 || len < 0 || (long)offset + (long)len > (long)input.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int partLen = 16 - this.count;
        int i = 0;
        if (len >= partLen) {
            j = 0;
            while (j < partLen) {
                this.buffer[this.count + j] = input[offset + j] & 0xFF;
                ++j;
            }
            this.transform(this.buffer, 0);
            this.count = 0;
            i = partLen;
            while (i + 16 - 1 < len) {
                this.transform(input, offset + i);
                i += 16;
            }
        }
        if (i < len) {
            j = 0;
            while (j < len - i) {
                this.buffer[this.count + j] = input[offset + i + j] & 0xFF;
                ++j;
            }
            this.count += len - i;
        }
    }

    public byte[] engineDigest() {
        int padLen = 16 - this.count;
        int i = this.count;
        while (i < 16) {
            this.buffer[i] = (byte)padLen;
            ++i;
        }
        this.transform(this.buffer, 0);
        this.transform(this.checksum, 0);
        byte[] result = new byte[16];
        int i2 = 0;
        while (i2 < 16) {
            result[i2] = (byte)this.X[i2];
            ++i2;
        }
        this.engineReset();
        return result;
    }

    private void transform(int[] block, int offset) {
        int i = 0;
        while (i < 16) {
            this.X[16 + i] = block[offset + i] & 0xFF;
            this.X[32 + i] = this.X[i] ^ this.X[16 + i];
            ++i;
        }
        int t = 0;
        int i2 = 0;
        while (i2 < 18) {
            int j = 0;
            while (j < 48) {
                int n = j++;
                int n2 = this.X[n] ^ S[t];
                this.X[n] = n2;
                t = n2;
            }
            t = t + i2 & 0xFF;
            ++i2;
        }
        t = this.checksum[15];
        int i3 = 0;
        while (i3 < 16) {
            int n = i3;
            int n3 = this.checksum[n] ^ S[block[offset + i3] & 0xFF ^ t];
            this.checksum[n] = n3;
            t = n3;
            ++i3;
        }
    }

    private void transform(byte[] block, int offset) {
        int i = 0;
        while (i < 16) {
            this.X[16 + i] = block[offset + i] & 0xFF;
            this.X[32 + i] = this.X[i] ^ this.X[16 + i];
            ++i;
        }
        int t = 0;
        int i2 = 0;
        while (i2 < 18) {
            int j = 0;
            while (j < 48) {
                int n = j++;
                int n2 = this.X[n] ^ S[t];
                this.X[n] = n2;
                t = n2;
            }
            t = t + i2 & 0xFF;
            ++i2;
        }
        t = this.checksum[15];
        int i3 = 0;
        while (i3 < 16) {
            int n = i3;
            int n3 = this.checksum[n] ^ S[block[offset + i3] & 0xFF ^ t];
            this.checksum[n] = n3;
            t = n3;
            ++i3;
        }
    }
}

