/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.xcede2.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nbirn.fbirn.xcede2.catalog.CatalogException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogEntry {
    static final String XCEDE2NS = "http://www.xcede.org/xcede-2";
    private static final Logger _logger = Logger.getLogger(CatalogEntry.class.getName());
    private String _name = null;
    private URI _uri = null;
    private HashMap<String, Object> _metaFields = new HashMap();

    public CatalogEntry() {
    }

    public CatalogEntry(URI uri, String name) {
        this();
        this._uri = uri;
        this._name = name;
    }

    private static ArrayList<Element> getChildElementsByTagNameNS(Element elem, String namespaceURI, String localName) throws DOMException {
        ArrayList<Element> retval = new ArrayList<Element>();
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !namespaceURI.equals(child.getNamespaceURI()) || !localName.equals(child.getLocalName())) continue;
            retval.add((Element)child);
        }
        return retval;
    }

    public final boolean hasMetaField(String name) {
        return this._metaFields.containsKey(name);
    }

    public final Object getMetaField(String name) {
        return this._metaFields.get(name);
    }

    public void addMetaField(String name, Object value) {
        this._metaFields.put(name, value);
    }

    public void addMetaFieldString(String name, String value) throws IllegalArgumentException {
        _logger.log(Level.FINE, "CatalogEntry.addMetaField:     adding name=''{0}'' value=''{1}''", new Object[]{name, value});
        this.addMetaField(name, value);
    }

    void parseEntry(Element entryelem) throws IllegalArgumentException {
        String name = entryelem.getAttribute("name");
        URI uri = null;
        _logger.log(Level.FINE, "parseCatalog:   parsing entry ''{0}''", name);
        ArrayList<Element> uris = CatalogEntry.getChildElementsByTagNameNS(entryelem, XCEDE2NS, "uri");
        if (uris.size() != 1) {
            throw new IllegalArgumentException("parseCatalog: too many <uri> elements in this entry!");
        }
        try {
            String uristr = uris.get(0).getTextContent();
            uri = new URI(uristr);
            if (uri.getScheme() == null) {
                uri = new URI("file", uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
        }
        catch (URISyntaxException e) {
            System.err.println("ERROR: " + e.getMessage());
        }
        this.setURI(uri);
        this.setName(name);
        ArrayList<Element> metafieldslist = CatalogEntry.getChildElementsByTagNameNS(entryelem, XCEDE2NS, "metaFields");
        for (int mflistind = 0; mflistind < metafieldslist.size(); ++mflistind) {
            ArrayList<Element> metafields = CatalogEntry.getChildElementsByTagNameNS(metafieldslist.get(mflistind), XCEDE2NS, "metaField");
            for (int mfind = 0; mfind < metafields.size(); ++mfind) {
                String mfname = metafields.get(mfind).getAttribute("name");
                String mfvalue = metafields.get(mfind).getTextContent();
                this.addMetaFieldString(mfname, mfvalue);
            }
        }
    }

    public static void addEntryToElement(CatalogEntry entry, Element root) throws CatalogException {
        if (entry._uri == null) {
            throw new CatalogException("No URI element in catalog entry!");
        }
        Document doc = root.getOwnerDocument();
        Element entryNode = doc.createElementNS(XCEDE2NS, "entry");
        root.appendChild(entryNode);
        entryNode.setAttribute("name", entry._name);
        if (!entry._metaFields.isEmpty()) {
            Element metaFields = doc.createElementNS(XCEDE2NS, "metaFields");
            entryNode.appendChild(metaFields);
            for (String name : entry._metaFields.keySet()) {
                Object val = entry._metaFields.get(name);
                Element metaField = doc.createElementNS(XCEDE2NS, "metaField");
                metaFields.appendChild(metaField);
                metaField.setAttribute("name", name);
                Text textNode = doc.createTextNode(val.toString());
                metaField.appendChild(textNode);
            }
        }
        Element uri = doc.createElementNS(XCEDE2NS, "uri");
        entryNode.appendChild(uri);
        Text uriText = doc.createTextNode(entry._uri.toString());
        uri.appendChild(uriText);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public URI getURI() {
        return this._uri;
    }

    public void setURI(URI url) {
        this._uri = url;
    }
}

