/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.xcede2.catalog;

import java.net.URI;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nbirn.fbirn.xcede2.catalog.CatalogEntry;

public class DownloadCatalogEntry
extends CatalogEntry {
    private static final Logger _logger = Logger.getLogger(DownloadCatalogEntry.class.getName());
    private TimeZone _timezone = null;
    private int _timeStampCheckDepth = -1;

    public DownloadCatalogEntry() {
    }

    public DownloadCatalogEntry(URI url, String name, TimeZone timezone, int timeStampCheckDepth) {
        super(url, name);
        this._timezone = timezone;
        this._timeStampCheckDepth = timeStampCheckDepth;
    }

    public void addMetaFieldString(String mfname, String mfvalue) throws IllegalArgumentException {
        _logger.log(Level.FINE, "CatalogEntryDownload.addMetaField:     adding name=''{0}'' value=''{1}''", new Object[]{mfname, mfvalue});
        if (mfvalue == null) {
            return;
        }
        if ("timeZone".equals(mfname)) {
            super.addMetaField(mfname, TimeZone.getTimeZone(mfvalue));
        } else if ("timeStampCheckDepth".equals(mfname)) {
            super.addMetaField(mfname, Integer.parseInt(mfvalue));
        } else {
            super.addMetaField(mfname, mfvalue);
        }
    }

    public TimeZone getTimeZone() {
        return this._timezone;
    }

    public void setTimeZone(TimeZone timezone) {
        this._timezone = timezone;
    }

    public int getTimeStampCheckDepth() {
        return this._timeStampCheckDepth;
    }

    public void setTimeStampCheckDepth(int timeStampCheckDepth) {
        this._timeStampCheckDepth = timeStampCheckDepth;
    }
}

