/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.xcede2.catalog;

import java.io.File;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nbirn.fbirn.xcede2.catalog.Catalog;
import org.nbirn.fbirn.xcede2.catalog.CatalogEntry;
import org.nbirn.fbirn.xcede2.catalog.DownloadCatalogEntry;

public class DownloadCatalog
extends Catalog {
    private static final Logger _logger = Logger.getLogger(DownloadCatalog.class.getName());
    private static final String KEY_DOWNLOAD_STRATEGY = "downloadStrategy";
    private static final String KEY_TIME_ZONE = "timeZone";
    private static final String KEY_TIMESTAMP_CHECK_DEPTH = "timeStampCheckDepth";
    public static final int SOURCE_UNKNOWN = 0;
    public static final int SOURCE_SERIAL = 1;
    public static final int SOURCE_PARALLEL = 2;

    public DownloadCatalog(int downloadtype, String name, File file) throws Exception {
        super(name, file);
    }

    public DownloadCatalog(int downloadtype, String name) {
        super(name);
    }

    public DownloadCatalog() {
        this(0, null);
    }

    public DownloadCatalog getCatalog(int index) {
        return (DownloadCatalog)super.getCatalog(index);
    }

    public DownloadCatalogEntry getEntry(int index) {
        return (DownloadCatalogEntry)super.getEntry(index);
    }

    public int getDownloadType() {
        return this.hasMetaField(KEY_DOWNLOAD_STRATEGY) ? (Integer)this.getMetaField(KEY_DOWNLOAD_STRATEGY) : 0;
    }

    public void setDownloadType(int type) {
        this.addMetaField(KEY_DOWNLOAD_STRATEGY, new Integer(type));
    }

    public TimeZone getTimeZone() {
        return this.hasMetaField(KEY_TIME_ZONE) ? (TimeZone)this.getMetaField(KEY_TIME_ZONE) : null;
    }

    public void setTimeZone(TimeZone timezone) {
        this.addMetaField(KEY_TIME_ZONE, timezone);
    }

    public int getTimeStampCheckDepth() {
        return this.hasMetaField(KEY_TIMESTAMP_CHECK_DEPTH) ? (Integer)this.getMetaField(KEY_TIMESTAMP_CHECK_DEPTH) : -1;
    }

    public void setTimeStampCheckDepth(int timeStampCheckDepth) {
        this.addMetaField(KEY_TIMESTAMP_CHECK_DEPTH, timeStampCheckDepth);
    }

    protected CatalogEntry getNewEntry() {
        return new DownloadCatalogEntry();
    }

    protected Catalog getNewCatalog() {
        return new DownloadCatalog();
    }

    public void addMetaFieldString(String mfname, String mfvalue) {
        if (mfvalue == null) {
            return;
        }
        _logger.log(Level.FINE, "CatalogDownload.addMetaField:     adding name=''{0}'' value=''{1}''", new Object[]{mfname, mfvalue});
        if (KEY_DOWNLOAD_STRATEGY.equals(mfname)) {
            if (mfvalue.equals("serial")) {
                super.addMetaField(mfname, new Integer(1));
            } else if (mfvalue.equals("parallel")) {
                super.addMetaField(mfname, new Integer(2));
            } else {
                super.addMetaField(mfname, new Integer(0));
            }
        } else if (KEY_TIME_ZONE.equals(mfname)) {
            super.addMetaField(mfname, TimeZone.getTimeZone(mfvalue));
        } else if (KEY_TIMESTAMP_CHECK_DEPTH.equals(mfname)) {
            super.addMetaField(mfname, Integer.parseInt(mfvalue));
        }
    }
}

