/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import xjava.security.Parameterized;

public class HMACInputStream
extends InputStream {
    private InputStream sub;
    private MessageDigest md;

    protected void _HMACInputStream(String digest, byte[] key, InputStream in) {
        this.sub = in;
        try {
            this.md = MessageDigest.getInstance("HMAC-" + digest);
            ((Parameterized)this.md).setParameter("key", (Object)key);
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
    }

    public HMACInputStream(String digest, byte[] key, InputStream in) {
        this._HMACInputStream(digest, key, in);
    }

    public HMACInputStream(String digest, String key, InputStream out) {
        try {
            this.md = MessageDigest.getInstance(digest);
            this._HMACInputStream(digest, this.md.digest(key.getBytes()), out);
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
    }

    public int read() throws IOException {
        int b = this.sub.read();
        this.md.update((byte)(0xFF & b));
        return b;
    }

    public int read(byte[] b) throws IOException {
        int ret = this.sub.read(b);
        this.md.update(b, 0, ret);
        return ret;
    }

    public byte[] digest() {
        return this.md.digest();
    }
}

