/*
 * Decompiled with CFR 0.152.
 */
package org.birncommunity.gridftp.tar.impl.compress;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.birncommunity.gridftp.tar.TarI;
import org.birncommunity.gridftp.tar.impl.compress.TarDirectoryEntryHandler;
import org.birncommunity.gridftp.tar.impl.compress.TarDirectoryEntryHandlerImplementation;
import org.birncommunity.gridftp.tar.impl.compress.TarFileEntryHandler;
import org.birncommunity.gridftp.tar.impl.compress.TarFileEntryHandlerImplementation;
import org.birncommunity.util.FileNameUtil;
import org.birncommunity.util.MethodParameterChecker;

public class CompressTar
implements TarI {
    private Log log = LogFactory.getLog(CompressTar.class);
    private TarDirectoryEntryHandler dirHandler = null;
    private TarFileEntryHandler fileHandler = null;

    public static void main(String[] args) throws Exception {
        CompressTar ct = new CompressTar();
        ct.tarDirectoryToFile(new File("/tmp/testdir"), new File("/tmp/testfile.tar"));
    }

    public CompressTar() {
        this.fileHandler = new TarFileEntryHandlerImplementation();
        this.dirHandler = new TarDirectoryEntryHandlerImplementation(this.fileHandler);
    }

    public CompressTar(TarDirectoryEntryHandlerImplementation d_handler, TarFileEntryHandlerImplementation f_handler) {
        this.dirHandler = d_handler;
        this.fileHandler = f_handler;
    }

    public void tarDirectoryToStream(File dir, OutputStream os) throws Exception {
        new MethodParameterChecker().verifyNotNull(new Object[]{dir, os});
        this.checkDirectory(dir);
        FileNameUtil fnu = new FileNameUtil();
        try {
            TarArchiveOutputStream taos = new TarArchiveOutputStream(os);
            taos.setLongFileMode(2);
            this.dirHandler.handleTarDirectoryEntry(dir, taos, fnu.getParentDirName(dir.getAbsolutePath()));
            taos.finish();
            taos.close();
        }
        catch (Exception e) {
            try {
                os.close();
            }
            catch (Exception e2) {
                this.log.warn((Object)"Failed to close output stream after previous error.", (Throwable)e2);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tarDirectoryToFile(File dir, File tarFile) throws Exception {
        new MethodParameterChecker().verifyNotNull(new Object[]{dir, tarFile});
        if (tarFile.exists() && !tarFile.canWrite()) {
            throw new IOException(tarFile.getAbsolutePath() + " cannot be written.");
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tarFile);
            this.tarDirectoryToStream(dir, fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void checkDirectory(File dir) throws IOException {
        if (!dir.exists()) {
            throw new IOException("Directory " + dir.getAbsolutePath() + " does not exist.");
        }
        if (!dir.isDirectory()) {
            throw new IOException("Directory " + dir.getAbsolutePath() + " is not a directory.");
        }
        if (!dir.canRead()) {
            throw new IOException(dir.getAbsolutePath() + " cannot be read");
        }
    }
}

