/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.utilities;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;

public class AppendOnlyFileContent
implements AbstractDocument.Content {
    File _file;
    long _strLength;
    long _byteLength;
    RandomAccessFile _raf;
    List<MyPosition> _positions = new ArrayList<MyPosition>();
    List<MarkPoint> _markPoints;
    final ReentrantReadWriteLock _lock;
    final ReentrantReadWriteLock.WriteLock _writeLock;
    final ReentrantReadWriteLock.ReadLock _readLock;

    public AppendOnlyFileContent(File file) {
        this._file = file;
        this._lock = new ReentrantReadWriteLock();
        this._writeLock = this._lock.writeLock();
        this._readLock = this._lock.readLock();
        this.setupFile();
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (true) {
                        AppendOnlyFileContent.this._writeLock.lock();
                        try {
                            int numpos = AppendOnlyFileContent.this._positions.size();
                            int lastunreferenced = -1;
                            ArrayList<MyPosition> newPositions = new ArrayList<MyPosition>();
                            for (int i = 0; i < numpos; ++i) {
                                MyPosition mp = AppendOnlyFileContent.this._positions.get(i);
                                if (mp.refCount != 0) continue;
                                if (lastunreferenced + 1 != i) {
                                    newPositions.addAll(AppendOnlyFileContent.this._positions.subList(lastunreferenced + 1, i));
                                }
                                lastunreferenced = i;
                            }
                            if (lastunreferenced != -1) {
                                AppendOnlyFileContent.this._positions = newPositions;
                            }
                        }
                        finally {
                            AppendOnlyFileContent.this._writeLock.unlock();
                        }
                        Thread.sleep(10000L);
                    }
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(AppendOnlyFileContent.class.getName()).log(Level.SEVERE, null, ex);
                    return;
                }
            }
        });
    }

    public Position createPosition(int offset) throws BadLocationException {
        if ((long)offset > this._strLength + 1L) {
            throw new BadLocationException("Attempt to access beyond end of file", offset);
        }
        MyPosition myPos = new MyPosition(offset);
        int ind = Collections.binarySearch(this._positions, myPos);
        if (ind >= 0) {
            return new YourPosition(this._positions.get(ind));
        }
        this._positions.add(-1 * (ind + 1), myPos);
        return new YourPosition(myPos);
    }

    public int length() {
        return (int)this._strLength + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String t) throws IOException, BadLocationException {
        this._writeLock.lock();
        try {
            this._raf.close();
            this._file.delete();
            this.setupFile();
            this.insertString(0, t);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupFile() {
        this._writeLock.lock();
        try {
            String line;
            this._raf = new RandomAccessFile(this._file, "rw");
            this._markPoints = new ArrayList<MarkPoint>();
            this._raf.seek(0L);
            this._strLength = 0L;
            this._byteLength = 0L;
            while ((line = this._raf.readLine()) != null) {
                byte[] bytes = line.getBytes("UTF-8");
                this._markPoints.add(new MarkPoint(this._byteLength, this._strLength, bytes.length, line.length()));
                this._byteLength += (long)bytes.length;
                this._strLength += (long)line.length();
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(AppendOnlyFileContent.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(AppendOnlyFileContent.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UndoableEdit insertString(int where, String str) throws BadLocationException {
        this._writeLock.lock();
        try {
            if ((long)where != this._strLength) {
                throw new BadLocationException("Inserts only allowed at end of document (curLength=" + this._strLength + ")", where);
            }
            try {
                this._raf.seek(this._raf.length());
                byte[] bs = str.getBytes("UTF-8");
                this._markPoints.add(new MarkPoint(this._byteLength, this._strLength, bs.length, str.length()));
                this._raf.write(bs);
                this._byteLength += (long)bs.length;
                this._strLength += (long)str.length();
            }
            catch (IOException ex) {
                Logger.getLogger(AppendOnlyFileContent.class.getName()).log(Level.SEVERE, null, ex);
            }
            int posind = Collections.binarySearch(this._positions, new MyPosition(where));
            int n = this._positions.size();
            if (posind < 0) {
                posind = -1 * (posind + 1);
            }
            for (int i = posind; i < n; ++i) {
                MyPosition pos = this._positions.get(i);
                if (pos.curPos < where || pos.curPos == 0) continue;
                pos.curPos += str.length();
            }
        }
        finally {
            this._writeLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UndoableEdit remove(int where, int nitems) throws BadLocationException {
        if (where < 0) {
            throw new BadLocationException("Negative position!", where);
        }
        this._writeLock.lock();
        try {
            if ((long)(where + nitems) != this._strLength && (long)(where + nitems) != this._strLength + 1L) {
                throw new BadLocationException("Can only remove items from end of document", where);
            }
            try {
                this._raf.setLength(where);
            }
            catch (IOException ex) {
                Logger.getLogger(AppendOnlyFileContent.class.getName()).log(Level.SEVERE, null, ex);
            }
            int posind = Collections.binarySearch(this._positions, new MyPosition(where));
            int n = this._positions.size();
            if (posind < 0) {
                posind = -1 * (posind + 1);
            }
            for (int i = posind; i < n; ++i) {
                MyPosition pos = this._positions.get(i);
                if (pos.curPos < where || pos.curPos == 0) continue;
                pos.curPos = where + 1;
            }
            this._strLength = where;
            MarkPoint comparemp = new MarkPoint(0L, where, 0L, nitems);
            int mpind = Collections.binarySearch(this._markPoints, comparemp);
            if (mpind < 0 && (mpind = -1 * (mpind + 1)) != 0) {
                MarkPoint lastmp = this._markPoints.get(--mpind);
                if (lastmp.strPos <= (long)where && (long)where < lastmp.strPos + lastmp.strLength) {
                    Segment s = new Segment();
                    this.getChars((int)lastmp.strPos, (int)((long)where - lastmp.strPos), s);
                    CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
                    CharBuffer cbuf = CharBuffer.wrap(s);
                    try {
                        ByteBuffer bbuf = encoder.encode(cbuf);
                        lastmp.byteLength = bbuf.remaining();
                    }
                    catch (CharacterCodingException e) {
                        throw new BadLocationException("Error encoding character buffer: '" + cbuf + "'", where);
                    }
                    lastmp.strLength = (long)where - lastmp.strPos;
                    ++mpind;
                }
            }
            for (int nummps = this._markPoints.size(); mpind < nummps; --nummps) {
                this._markPoints.remove(mpind);
            }
        }
        finally {
            this._writeLock.unlock();
        }
        return null;
    }

    public String getString(int where, int len) throws BadLocationException {
        Segment txt = new Segment();
        this.getChars(where, len, txt);
        return txt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getChars(int where, int len, Segment txt) throws BadLocationException {
        if (where < 0) {
            throw new BadLocationException("Negative position!", where);
        }
        this._readLock.lock();
        try {
            if ((long)(where + len) > this._strLength + 1L) {
                throw new BadLocationException("Reading beyond end of file!", where);
            }
            MarkPoint comparemp = new MarkPoint(0L, where, 0L, len);
            int mpind = Collections.binarySearch(this._markPoints, comparemp);
            if (mpind < 0) {
                mpind = -1 * (mpind + 1);
            }
            if (mpind > 0) {
                --mpind;
            }
            int nummps = this._markPoints.size();
            while (mpind < nummps) {
                MarkPoint tmpmp = this._markPoints.get(mpind);
                if ((long)where >= tmpmp.strPos && (long)where < tmpmp.strPos + tmpmp.strLength) break;
                ++mpind;
            }
            char[] chars = new char[len];
            CharBuffer cbuf = CharBuffer.wrap(chars, 0, len);
            int numread = 0;
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
            try {
                while (mpind < nummps && numread < len) {
                    MarkPoint mp = this._markPoints.get(mpind);
                    this._raf.seek(mp.bytePos);
                    byte[] bytes = new byte[(int)mp.byteLength];
                    this._raf.read(bytes);
                    ByteBuffer bbuf = ByteBuffer.wrap(bytes);
                    if (mp.strPos < (long)where) {
                        decoder.decode(bbuf, CharBuffer.wrap(new char[(int)((long)where - mp.strPos)]), false);
                    }
                    decoder.decode(bbuf, cbuf, true);
                    numread = cbuf.position();
                    ++mpind;
                }
            }
            catch (IOException e) {
                throw new BadLocationException("Error reading from file", (int)this._markPoints.get((int)mpind).bytePos);
            }
            if (cbuf.position() < len && (long)(where + cbuf.position()) == this._strLength) {
                cbuf.append('\n');
            }
            if (cbuf.position() < len) {
                throw new BadLocationException("Could not find enough data?  Stopped reading", where + cbuf.position());
            }
            txt.array = chars;
            txt.offset = 0;
            txt.count = len;
        }
        finally {
            this._readLock.unlock();
        }
    }

    class YourPosition
    implements Position {
        MyPosition myPos;

        YourPosition(MyPosition myPos_) {
            this.myPos = myPos_;
            this.myPos.incRef();
        }

        protected void finalize() throws Throwable {
            this.myPos.decRef();
        }

        public int getOffset() {
            return this.myPos.curPos;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            return ((YourPosition)obj).myPos.curPos == this.myPos.curPos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyPosition
    implements Comparable<MyPosition> {
        int curPos;
        int refCount;

        MyPosition(int curPos_) {
            this.curPos = curPos_;
            this.refCount = 1;
        }

        void incRef() {
            ++this.refCount;
        }

        void decRef() {
            --this.refCount;
        }

        @Override
        public int compareTo(MyPosition o) {
            if (this.curPos < o.curPos) {
                return -1;
            }
            if (this.curPos > o.curPos) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MarkPoint
    implements Comparable<MarkPoint> {
        long bytePos;
        long strPos;
        long byteLength;
        long strLength;

        public MarkPoint(long bytePos_, long strPos_, long byteLength_, long strLength_) {
            this.bytePos = bytePos_;
            this.strPos = strPos_;
            this.byteLength = byteLength_;
            this.strLength = strLength_;
        }

        @Override
        public int compareTo(MarkPoint o) {
            if (this.strPos < o.strPos) {
                return -1;
            }
            if (this.strPos > o.strPos) {
                return 1;
            }
            return 0;
        }
    }
}

