/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySetManager {
    static final Logger _logger = Logger.getLogger(PropertySetManager.class.getName());
    private final int _numsavedprops = 10;
    private Properties _properties = null;
    private Class _refClass = null;
    private String _propBaseName = "app";

    public PropertySetManager() {
        this(PropertySetManager.class);
    }

    public PropertySetManager(Class refClass) {
        this(refClass, null);
    }

    public PropertySetManager(Class refClass, String propBaseName) {
        this._refClass = refClass;
        if (propBaseName != null) {
            this._propBaseName = "app-" + propBaseName;
        }
        try {
            this.loadProperties();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void changeProperty(String name, String value) {
        Vector<String> propset = this.getPropertySet(name);
        int foundind = propset.indexOf(value);
        if (foundind == 0) {
            return;
        }
        if (foundind != -1) {
            propset.remove(foundind);
        }
        propset.insertElementAt(value, 0);
        try {
            this.setPropertySet(name, propset);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getProperty(String name) {
        return this.getProperties().getProperty(name);
    }

    public Vector<String> getPropertySet(String name) {
        Vector<String> retval = new Vector<String>();
        Properties props = this.getProperties();
        for (int i = 0; i < 10; ++i) {
            String val = props.getProperty(name + (i == 0 ? "" : Integer.valueOf(i)));
            if (val == null) continue;
            retval.add(val);
        }
        return retval;
    }

    public void setPropertySet(String name, Vector<String> set) throws IOException {
        int i;
        Properties props = this.getProperties();
        for (i = 0; i < set.size(); ++i) {
            props.setProperty(name + (i == 0 ? "" : Integer.valueOf(i)), set.get(i));
        }
        for (i = set.size(); i < 10; ++i) {
            props.remove(name + (i == 0 ? "" : Integer.valueOf(i)));
        }
        this.saveProperties();
    }

    public final Properties getProperties() {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        return this._properties;
    }

    private File getPropertyFile() {
        try {
            File propFile = new File(new File(System.getProperty("user.dir")).getParentFile(), this._propBaseName + ".properties");
            return propFile;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void loadProperties() throws IOException {
        File propFile = this.getPropertyFile();
        if (propFile != null) {
            _logger.log(Level.INFO, "Loading properties from file ''{0}''", propFile.getPath());
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propFile);
                this.getProperties().load(fis);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void saveProperties() throws IOException {
        File propFile = this.getPropertyFile();
        if (propFile != null) {
            FileOutputStream fos = new FileOutputStream(propFile);
            this.getProperties().store(fos, "Written by " + this.getClass().getName());
        }
    }
}

