/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.utilities.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogStatement
implements Statement {
    private Statement _stmt;
    private String _ID;
    private Logger _logger;
    private List<String> _batches = new ArrayList<String>();

    public LogStatement(Statement stmt, String ID, Logger logger) {
        this._stmt = stmt;
        this._ID = ID;
        this._logger = logger;
    }

    private void logStatement(String methodName, String sql) {
        this._logger.log(Level.FINE, "[{0}] {1}: {2}", new Object[]{this._ID, methodName, sql});
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.logStatement("executeQuery", sql);
        return this._stmt.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.logStatement("executeUpdate", sql);
        return this._stmt.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        this._stmt.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this._stmt.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this._stmt.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this._stmt.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this._stmt.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this._stmt.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this._stmt.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this._stmt.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this._stmt.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._stmt.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._stmt.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this._stmt.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.logStatement("execute", sql);
        return this._stmt.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this._stmt.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this._stmt.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this._stmt.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this._stmt.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._stmt.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this._stmt.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._stmt.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this._stmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this._stmt.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this._batches.add(sql);
        this._stmt.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this._batches.clear();
        this._stmt.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        for (String sql : this._batches) {
            this.logStatement("execute", sql);
        }
        return this._stmt.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._stmt.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this._stmt.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this._stmt.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.logStatement("executeUpdate", sql);
        return this._stmt.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.logStatement("executeUpdate", sql);
        return this._stmt.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.logStatement("executeUpdate", sql);
        return this._stmt.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.logStatement("execute", sql);
        return this._stmt.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.logStatement("execute", sql);
        return this._stmt.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.logStatement("execute", sql);
        return this._stmt.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this._stmt.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._stmt.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this._stmt.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this._stmt.isPoolable();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this._stmt.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this._stmt.isWrapperFor(iface);
    }
}

