/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.utilities.download;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.birncommunity.gridftp.tar.TwoPartyTarClientFactoryI;
import org.birncommunity.gridftp.tar.TwoPartyTarClientFactoryImpl;
import org.birncommunity.gridftp.tar.TwoPartyTarTransfer;
import org.birncommunity.gridftp.tar.UntarFromPipeRunnable;
import org.birncommunity.gridftp.tar.UntarI;
import org.birncommunity.gridftp.tar.impl.compress.CompressUntar;
import org.birncommunity.gridftp.tar.impl.compress.UntarDirectoryEntryHandler;
import org.birncommunity.gridftp.tar.impl.compress.UntarDirectoryEntryHandlerImplementation;
import org.birncommunity.gridftp.tar.impl.compress.UntarFileEntryHandler;
import org.birncommunity.gridftp.tar.impl.compress.UntarFileEntryHandlerImplementation;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSinkStream;
import org.globus.ftp.FTPClient;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.MlsxEntry;
import org.globus.ftp.exception.ServerException;
import org.globus.myproxy.MyProxyException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.nbirn.fbirn.utilities.CanceledException;
import org.nbirn.fbirn.utilities.CredentialManager;
import org.nbirn.fbirn.utilities.CredentialManagerException;
import org.nbirn.fbirn.utilities.download.DownloadException;
import org.nbirn.fbirn.utilities.download.ProgressUpdate;
import org.nbirn.fbirn.utilities.download.WorkerProgressReporter;

public abstract class WorkerDownload
extends WorkerProgressReporter {
    private static final Logger _logger = Logger.getLogger(WorkerDownload.class.getName());
    private static final int DEFAULT_MINCHUNKS = 100;
    boolean _dryrun = false;

    protected WorkerDownload(boolean dryrun) {
        this._dryrun = dryrun;
    }

    Exception downloadURLDefault(URI url, File dest) {
        try {
            FileOutputStream fos = new FileOutputStream(dest);
            Exception e = this.downloadURLDefault(url, fos);
            fos.close();
            return e;
        }
        catch (Exception e) {
            return e;
        }
    }

    Exception downloadURLDefault(URI url, OutputStream os) {
        try {
            InputStream is = url.toURL().openStream();
            byte[] buf = new byte[1024];
            int bytesread = 0;
            while ((bytesread = is.read(buf)) != -1) {
                os.write(buf, 0, bytesread);
            }
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    public void resetPassive(FTPClient ftpclient) throws DownloadException {
        try {
            ftpclient.setPassive();
        }
        catch (Exception e) {
            throw new DownloadException("Error calling GridFTPClient::setLocalPassive()", e);
        }
        try {
            ftpclient.setLocalActive();
        }
        catch (Exception e) {
            throw new DownloadException("Error calling GridFTPClient::setActive()", e);
        }
    }

    private void tryConnect(GridFTPClient ftpclient, GSSCredential cred) throws ServerException, IOException {
        if (cred == null) {
            throw new NullPointerException("tryConnect() received cred==null!");
        }
        if (ftpclient == null) {
            throw new NullPointerException("tryConnect() received ftpclient==null!");
        }
        ftpclient.authenticate(cred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridFTPClient gridFTPConnect(CredentialManager credman, String gridftphost, int gridftpport) throws CanceledException, DownloadException {
        GridFTPClient ftpclient = null;
        try {
            ftpclient = new GridFTPClient(gridftphost, gridftpport);
        }
        catch (Exception e) {
            throw new DownloadException("Error getting new GridFTP client", e);
        }
        CredentialManager e = credman;
        synchronized (e) {
            block37: {
                GSSCredential cred;
                block36: {
                    if (this.isCancelled() || credman.wasCanceled()) {
                        throw new CanceledException("Operation canceled by user.");
                    }
                    Object retval = null;
                    cred = credman.getCredential();
                    try {
                        if (cred == null || cred.getRemainingLifetime() <= 0) break block36;
                        try {
                            this.tryConnect(ftpclient, cred);
                            return ftpclient;
                        }
                        catch (Exception e2) {
                            try {
                                ftpclient.close();
                                ftpclient = null;
                            }
                            catch (Exception unused) {
                                // empty catch block
                            }
                            throw new DownloadException("Error  connecting to GridFTP server " + gridftphost + ":" + String.valueOf(gridftpport), e2);
                        }
                    }
                    catch (GSSException e3) {
                        throw new DownloadException("Error getting credential", e3);
                    }
                }
                String msg = "Please enter MyProxy and GridFTP connection parameters";
                while (true) {
                    if ((cred = credman.getLocalCredential()) != null) {
                        if (ftpclient == null) {
                            try {
                                ftpclient = new GridFTPClient(gridftphost, gridftpport);
                            }
                            catch (Exception e4) {
                                throw new DownloadException("Error getting new GridFTP client", e4);
                            }
                        }
                        try {
                            this.tryConnect(ftpclient, cred);
                            break block37;
                        }
                        catch (Exception e5) {
                            try {
                                ftpclient.close();
                                ftpclient = null;
                            }
                            catch (Exception unused) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        credman.getNewCredential(msg);
                        cred = credman.getCredential();
                        if (cred == null) {
                            if (credman.canGetUserInput()) {
                                msg = "Error in connection parameters.  Try again:";
                                continue;
                            }
                            throw new DownloadException("Can't get valid credential (try getting one by running myproxy-logon)");
                        }
                    }
                    catch (CredentialManagerException e6) {
                        throw new DownloadException("Error getting new credential", e6);
                    }
                    catch (MyProxyException e7) {
                        if (credman.canGetUserInput()) {
                            msg = e7.toString();
                            continue;
                        }
                        throw new DownloadException("Can't get valid credential (" + e7.toString() + ").  Alternative: get one by running myproxy-logon.");
                    }
                    break;
                }
                if (ftpclient == null) {
                    try {
                        ftpclient = new GridFTPClient(gridftphost, gridftpport);
                    }
                    catch (Exception e8) {
                        throw new DownloadException("Error getting new GridFTP client", e8);
                    }
                }
                try {
                    this.tryConnect(ftpclient, cred);
                }
                catch (Exception e9) {
                    try {
                        ftpclient.close();
                    }
                    catch (Exception unused) {
                        // empty catch block
                    }
                    throw new DownloadException("Error  connecting to GridFTP server " + gridftphost + ":" + String.valueOf(gridftpport), e9);
                }
            }
        }
        try {
            ftpclient.setType(1);
            ftpclient.setMode(1);
        }
        catch (Exception e2) {
            throw new DownloadException("Error setting type or mode on FTP client (host " + gridftphost + ", port " + String.valueOf(gridftpport) + ")", e2);
        }
        return ftpclient;
    }

    protected GridFTPClient checkConnection(CredentialManager credman, GridFTPClient ftpclient, String gridftphost, int gridftpport) throws CanceledException, DownloadException {
        if (ftpclient == null) {
            return this.gridFTPConnect(credman, gridftphost, gridftpport);
        }
        try {
            ftpclient.quote("NOOP");
            return ftpclient;
        }
        catch (Exception e) {
            try {
                ftpclient.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return this.gridFTPConnect(credman, gridftphost, gridftpport);
        }
    }

    Exception downloadURLGSIFTP(URI url, File destFile, CredentialManager credman, boolean updateOnly, TimeZone remoteTimeZone, int timeStampCheckDepth) throws CanceledException, DownloadException {
        return this.downloadURLGSIFTP(url, destFile, null, credman, 100, timeStampCheckDepth, updateOnly, remoteTimeZone, 0.0, 100.0);
    }

    Exception downloadURLGSIFTP(URI url, OutputStream os, CredentialManager credman, boolean updateOnly, TimeZone remoteTimeZone, int timeStampCheckDepth) throws CanceledException, DownloadException {
        return this.downloadURLGSIFTP(url, null, os, credman, 100, timeStampCheckDepth, updateOnly, remoteTimeZone, 0.0, 100.0);
    }

    Exception downloadURLGSIFTP(URI url, File destFile, OutputStream os, CredentialManager credman, int minChunks, int minDepth, boolean updateOnly, TimeZone remoteTimeZone, double progressStart, double progressEnd) throws CanceledException, DownloadException {
        if (this.isCancelled()) {
            throw new CanceledException("Operation canceled by user.");
        }
        String gridftphost = url.getHost();
        int gridftpport = url.getPort() == -1 ? 2811 : url.getPort();
        String remotepath = url.getPath();
        GridFTPClient ftpclient = this.gridFTPConnect(credman, gridftphost, gridftpport);
        double progress = progressStart;
        while (remotepath.length() > 1 && remotepath.endsWith("/")) {
            remotepath = remotepath.substring(0, remotepath.length() - 1);
        }
        ftpclient = this.checkConnection(credman, ftpclient, gridftphost, gridftpport);
        if (destFile != null && destFile.exists() && destFile.isDirectory()) {
            int lastremoteslash = remotepath.lastIndexOf(47);
            destFile = lastremoteslash == -1 ? new File(destFile, remotepath) : new File(destFile, remotepath.substring(lastremoteslash + 1));
        }
        this.downloadGSIFTPAux(ftpclient, gridftphost, gridftpport, remotepath, destFile, (DataSink)(os == null ? null : new DataSinkStream(os)), null, credman, minChunks, minDepth, updateOnly, remoteTimeZone, progressStart, progressEnd);
        if (ftpclient != null) {
            try {
                ftpclient.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private long getTimestamp(MlsxEntry info, TimeZone remoteTimeZone) {
        String modifystr = info.get("modify");
        if (modifystr.length() != 14) {
            return -1L;
        }
        int year = Integer.parseInt(modifystr.substring(0, 4));
        int mon = Integer.parseInt(modifystr.substring(4, 6)) - 1;
        int mday = Integer.parseInt(modifystr.substring(6, 8));
        int hour = Integer.parseInt(modifystr.substring(8, 10));
        int min = Integer.parseInt(modifystr.substring(10, 12));
        int sec = Integer.parseInt(modifystr.substring(12, 14));
        Calendar cal = null;
        cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(year, mon, mday, hour, min, sec);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void downloadGSIFTPAux(GridFTPClient ftpclient, String gridftphost, int gridftpport, String remotepath, File localfile, DataSink localsink, MlsxEntry info, CredentialManager credman, int minChunks, int minDepth, boolean updateOnly, TimeZone remoteTimeZone, double progressStart, double progressEnd) throws CanceledException, DownloadException {
        boolean localoutofdate;
        long remotelastmod;
        String infotype;
        class TimeStampQueueEntry {
            File _file;
            long _timestamp;

            TimeStampQueueEntry(File file, long timestamp) {
                this._file = file;
                this._timestamp = timestamp;
            }
        }
        ArrayList<TimeStampQueueEntry> timestampqueue;
        SimpleDateFormat dateformat;
        block68: {
            if (this.isCancelled()) {
                throw new CanceledException("Operation canceled by user.");
            }
            _logger.log(Level.FINE, "downloadGSIFTPAux(gridftphost=''{0}'', gridftpport={1}, remotepath=''{2}'', localfile=''{3}'', localsink=''{4}'', minChunks={5}, minDepth={6}, updateOnly={7}, remoteTimeZone=''{8}, progressStart={9}, progressEnd={10})", new Object[]{gridftphost, gridftpport, remotepath, localfile == null ? "<null>" : localfile.getAbsolutePath(), localsink == null ? "<null>" : localsink.toString(), minChunks, minDepth, updateOnly, remoteTimeZone == null ? "<null>" : remoteTimeZone.getDisplayName(), progressStart, progressEnd});
            dateformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            timestampqueue = new ArrayList<TimeStampQueueEntry>();
            ftpclient = this.checkConnection(credman, ftpclient, gridftphost, gridftpport);
            if (info == null) {
                try {
                    info = ftpclient.mlst(remotepath);
                }
                catch (Exception e) {
                    throw new DownloadException("Error getting file listing for remotepath " + remotepath, e);
                }
            }
            infotype = info.get("type");
            if (localfile != null && localfile.getName().startsWith("__DELETE__")) {
                String delname = localfile.getName().substring(10);
                File delfile = new File(localfile.getParent(), delname);
                if (!delfile.exists()) return;
                if (!"file".equals(infotype) || !delfile.isFile()) {
                    if (!"dir".equals(infotype)) return;
                    if (!delfile.isDirectory()) return;
                }
                this.publish(new ProgressUpdate((this._dryrun ? "(not) " : "") + "Deleting " + delfile.getAbsolutePath(), null, 0.0, 1));
                if (this._dryrun) return;
                File deldir = new File(localfile.getParent(), "__DELETED__");
                deldir.mkdir();
                delfile.renameTo(new File(deldir, delname));
                return;
            }
            remotelastmod = this.getTimestamp(info, remoteTimeZone);
            localoutofdate = true;
            if (updateOnly && localfile != null) {
                String outofdatestr = "out of date";
                if (remotelastmod != -1L && localfile.exists() && remotelastmod <= localfile.lastModified()) {
                    outofdatestr = "up-to-date";
                    localoutofdate = false;
                }
                _logger.log(Level.FINE, "Local file {0} seems {1} (local {2}, remote {3}) {4}", new Object[]{localfile.getAbsolutePath(), outofdatestr, dateformat.format(new Date(localfile.lastModified())), dateformat.format(new Date(remotelastmod)), localfile.getAbsolutePath()});
            }
            if (!"file".equals(infotype)) break block68;
            try {
                block70: {
                    block69: {
                        this.setProgress((int)progressStart);
                        if (!localoutofdate) break block69;
                        this.publish(new ProgressUpdate((this._dryrun ? "(not) " : "") + "Downloading '" + remotepath + "'", null, 0.0, 1));
                        this.resetPassive((FTPClient)ftpclient);
                        if (!this._dryrun) {
                            block67: {
                                long l;
                                boolean getsucceeded = false;
                                try {
                                    if (localfile != null) {
                                        ftpclient.get(remotepath, localfile);
                                    } else {
                                        ftpclient.get(remotepath, localsink, null);
                                    }
                                    getsucceeded = true;
                                    Object var25_28 = null;
                                    if (localfile == null || remotelastmod == -1L || !localfile.exists()) break block67;
                                    l = getsucceeded ? remotelastmod : remotelastmod - 1000L;
                                }
                                catch (Throwable throwable) {
                                    Object var25_29 = null;
                                    if (localfile != null && remotelastmod != -1L && localfile.exists()) {
                                        long modtime222 = getsucceeded ? remotelastmod : remotelastmod - 1000L;
                                        _logger.log(Level.FINE, "Setting timestamp: {0} {1}", new Object[]{localfile.getPath(), dateformat.format(new Date(modtime222))});
                                        localfile.setLastModified(modtime222);
                                    }
                                    if (localsink == null) throw throwable;
                                    localsink.close();
                                    throw throwable;
                                }
                                long modtime222 = l;
                                _logger.log(Level.FINE, "Setting timestamp: {0} {1}", new Object[]{localfile.getPath(), dateformat.format(new Date(modtime222))});
                                localfile.setLastModified(modtime222);
                            }
                            if (localsink != null) {
                                localsink.close();
                            }
                        }
                        break block70;
                    }
                    _logger.log(Level.FINE, "Skipped up-to-date ''{0}''", remotepath);
                    this.publish(new ProgressUpdate("Skipped up-to-date '" + remotepath + "'", 0.0));
                }
                this.setProgress((int)progressEnd);
                return;
            }
            catch (Exception e) {
                if (localfile == null) throw new DownloadException("Error getting file '" + remotepath + "'", e);
                throw new DownloadException("Error getting file '" + remotepath + "' to local file '" + localfile.toString() + "'", e);
            }
        }
        if (infotype.equals("dir")) {
            if (localfile == null) {
                throw new DownloadException("localfile must be specified when downloading from a directory!");
            }
            if (!localfile.exists()) {
                this.publish(new ProgressUpdate((this._dryrun ? "(not) " : "") + "Making directory '" + localfile.getAbsolutePath() + "'", 0.0));
                if (!this._dryrun) {
                    localfile.mkdir();
                    if (remotelastmod != -1L) {
                        _logger.log(Level.FINE, "Setting temporary timestamp: {0} {1}", new Object[]{localfile.getPath(), dateformat.format(new Date(remotelastmod - 1000L))});
                        localfile.setLastModified(remotelastmod - 1000L);
                        timestampqueue.add(new TimeStampQueueEntry(localfile, remotelastmod));
                    }
                }
            }
        }
        boolean fallthrough = true;
        if (minChunks <= 1 && minDepth <= 0) {
            if (localoutofdate) {
                ExecutorService executorService = null;
                TwoPartyTarClientFactoryImpl clientFactory = new TwoPartyTarClientFactoryImpl();
                GSSCredential cred = null;
                CredentialManager credentialManager = credman;
                synchronized (credentialManager) {
                    cred = credman.getCredential();
                    if (cred == null && (cred = credman.getLocalCredential()) == null) {
                        try {
                            credman.getNewCredential("Please enter MyProxy and GridFTP connection parameters");
                        }
                        catch (CredentialManagerException e) {
                            throw new DownloadException("Error getting new credential", e);
                        }
                        catch (MyProxyException e) {
                            throw new DownloadException("Error getting new credential", e);
                        }
                    }
                }
                TwoPartyTarTransfer tptt = new TwoPartyTarTransfer((TwoPartyTarClientFactoryI)clientFactory, gridftphost, gridftpport, cred);
                boolean dopopen = false;
                try {
                    dopopen = tptt.isPopenDriverSupported();
                }
                catch (Exception e) {
                    throw new DownloadException("Error checking if popen is supported", e);
                }
                if (dopopen) {
                    this.publish(new ProgressUpdate((this._dryrun ? "(not) " : "") + "Downloading (with tar-stream) '" + remotepath + "'", null, 0.0, 1));
                    if (!this._dryrun) {
                        PipedOutputStream pipeOut = new PipedOutputStream();
                        PipedInputStream pipeIn = null;
                        try {
                            pipeIn = new PipedInputStream(pipeOut);
                        }
                        catch (IOException e) {
                            throw new DownloadException("Error creating pipe", e);
                        }
                        final int localfilelen = localfile.getAbsolutePath().length();
                        executorService = Executors.newSingleThreadExecutor();
                        Future<?> untarfuture = null;
                        try {
                            UntarDirectoryEntryHandlerImplementation dirhandler = new UntarDirectoryEntryHandlerImplementation(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void handleUntarDirectoryEntry(TarArchiveEntry tae, File destDir) throws IOException {
                                    block4: {
                                        block3: {
                                            if (!tae.getName().startsWith("__DELETE__")) break block3;
                                            String delname = tae.getName().substring(10);
                                            File newfile = new File(destDir, delname);
                                            if (newfile.exists() && newfile.isDirectory()) {
                                                WorkerDownload.this.publish(new ProgressUpdate[]{new ProgressUpdate(null, "...deleting " + newfile.getAbsolutePath().substring(localfilelen), 0.0, -1)});
                                                File deldir = new File(destDir, "__DELETED__");
                                                deldir.mkdir();
                                                newfile.renameTo(new File(deldir, delname));
                                            }
                                            break block4;
                                        }
                                        File newfile = new File(destDir, tae.getName());
                                        WorkerDownload.this.publish(new ProgressUpdate[]{new ProgressUpdate(null, "..." + newfile.getAbsolutePath().substring(localfilelen), 0.0, -1)});
                                        boolean succeeded = false;
                                        try {
                                            super.handleUntarDirectoryEntry(tae, destDir);
                                            succeeded = true;
                                            long modtime = tae.getModTime().getTime();
                                            newfile.setLastModified(succeeded ? modtime : modtime - 1000L);
                                        }
                                        catch (Throwable throwable) {
                                            long modtime = tae.getModTime().getTime();
                                            newfile.setLastModified(succeeded ? modtime : modtime - 1000L);
                                            throw throwable;
                                        }
                                        timestampqueue.add(new TimeStampQueueEntry(newfile, tae.getModTime().getTime()));
                                    }
                                }
                            };
                            UntarFileEntryHandlerImplementation filehandler = new UntarFileEntryHandlerImplementation(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public void handleUntarFileEntry(TarArchiveInputStream tais, File destDir, TarArchiveEntry tae) throws IOException {
                                    if (tae.getName().startsWith("__DELETE__")) {
                                        String delname = tae.getName().substring(10);
                                        File newfile2 = new File(destDir, delname);
                                        if (!newfile2.exists()) return;
                                        if (!newfile2.isDirectory()) return;
                                        WorkerDownload.this.publish(new ProgressUpdate[]{new ProgressUpdate(null, "...deleting " + newfile2.getAbsolutePath().substring(localfilelen), 0.0, -1)});
                                        File deldir = new File(destDir, "__DELETED__");
                                        deldir.mkdir();
                                        newfile2.renameTo(new File(deldir, delname));
                                        return;
                                    }
                                    File newfile = new File(destDir, tae.getName());
                                    WorkerDownload.this.publish(new ProgressUpdate[]{new ProgressUpdate(null, "..." + newfile.getAbsolutePath().substring(localfilelen), 0.0, -1)});
                                    boolean succeeded = false;
                                    try {
                                        super.handleUntarFileEntry(tais, destDir, tae);
                                        succeeded = true;
                                        long modtime = tae.getModTime().getTime();
                                        newfile.setLastModified(succeeded ? modtime : modtime - 1000L);
                                        return;
                                    }
                                    catch (Throwable throwable) {
                                        long modtime = tae.getModTime().getTime();
                                        newfile.setLastModified(succeeded ? modtime : modtime - 1000L);
                                        throw throwable;
                                    }
                                }
                            };
                            untarfuture = executorService.submit((Runnable)new UntarFromPipeRunnable((InputStream)pipeIn, localfile.getParentFile().getAbsolutePath(), (UntarI)new CompressUntar((UntarDirectoryEntryHandler)dirhandler, (UntarFileEntryHandler)filehandler)));
                        }
                        catch (Exception e) {
                            throw new DownloadException("Error submitting untar task for execution", e);
                        }
                        String fullremotepath = remotepath;
                        this.setProgress((int)progressStart);
                        try {
                            tptt.downloadTarToPipe(fullremotepath, (OutputStream)pipeOut);
                        }
                        catch (Exception e) {
                            throw new DownloadException("Error downloading tar stream", e);
                        }
                        try {
                            try {
                                untarfuture.get();
                            }
                            catch (InterruptedException e) {
                                throw new CanceledException("Operation canceled", e);
                            }
                            catch (Exception e) {
                                throw new DownloadException("Error running untar task", e);
                            }
                            Object var36_59 = null;
                        }
                        catch (Throwable throwable) {
                            Object var36_60 = null;
                            int i = 0;
                            while (i < timestampqueue.size()) {
                                TimeStampQueueEntry e = (TimeStampQueueEntry)timestampqueue.get(i);
                                _logger.log(Level.FINE, "Setting timestamp: {0} {1}", new Object[]{e._file.getPath(), dateformat.format(new Date(e._timestamp))});
                                e._file.setLastModified(e._timestamp);
                                ++i;
                            }
                            throw throwable;
                        }
                        for (int i = 0; i < timestampqueue.size(); ++i) {
                            TimeStampQueueEntry e = (TimeStampQueueEntry)timestampqueue.get(i);
                            _logger.log(Level.FINE, "Setting timestamp: {0} {1}", new Object[]{e._file.getPath(), dateformat.format(new Date(e._timestamp))});
                            e._file.setLastModified(e._timestamp);
                        }
                        if (remotelastmod != -1L) {
                            _logger.log(Level.FINE, "Setting timestamp: {0} {1}", new Object[]{localfile.getPath(), dateformat.format(new Date(remotelastmod))});
                            localfile.setLastModified(remotelastmod);
                        }
                    }
                    this.setProgress((int)progressEnd);
                    return;
                }
            } else {
                _logger.log(Level.FINE, "Skipped up-to-date ''{0}''", remotepath);
                this.setProgress((int)progressEnd);
                this.publish(new ProgressUpdate("Skipped up-to-date '" + remotepath + "'", 0.0));
                return;
            }
        }
        if (!fallthrough) {
            return;
        }
        this.setProgress((int)progressStart);
        ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
        class StackEntry {
            String _remotepath = null;
            File _localfile = null;
            int _mindepth = 0;
            MlsxEntry _info = null;

            StackEntry(String remotepath, File localfile, int mindepth, MlsxEntry info) {
                this._remotepath = remotepath;
                this._localfile = localfile;
                this._mindepth = mindepth;
                this._info = info;
            }
        }
        stack.push(new StackEntry(remotepath, localfile, minDepth, info));
        while (!stack.isEmpty()) {
            int i;
            if (this.isCancelled()) {
                throw new CanceledException("Operation canceled by user.");
            }
            StackEntry sentry = null;
            sentry = stack.size() < --minChunks || minDepth > 0 ? (StackEntry)stack.removeFirst() : (StackEntry)stack.removeLast();
            String curremotepath = sentry._remotepath;
            File curlocalfile = sentry._localfile;
            int curmindepth = sentry._mindepth;
            MlsxEntry curinfo = sentry._info;
            _logger.log(Level.FINE, " curremotepath=''{0}'' curlocalfile=''{1}'' stack.size()={2} minChunks={3} minDepth={4}", new Object[]{curremotepath, curlocalfile, stack.size(), minChunks, curmindepth});
            if (stack.size() >= minChunks && curmindepth <= 0) {
                double progressChunk = (progressEnd - progressStart) / (double)(stack.size() + 1);
                this.downloadGSIFTPAux(ftpclient, gridftphost, gridftpport, curremotepath, curlocalfile, null, curinfo, credman, 1, 0, updateOnly, remoteTimeZone, progressStart, progressStart + progressChunk);
                progressStart += progressChunk;
                continue;
            }
            this.checkConnection(credman, ftpclient, gridftphost, gridftpport);
            this.resetPassive((FTPClient)ftpclient);
            Vector filelist = null;
            try {
                filelist = ftpclient.mlsd(curremotepath);
            }
            catch (Exception e) {
                throw new DownloadException("Error getting listing for directory " + curremotepath, e);
            }
            int numsubfiles = 0;
            int numsubdirs = 0;
            for (i = 0; i < filelist.size(); ++i) {
                MlsxEntry linfo = (MlsxEntry)filelist.elementAt(i);
                if (linfo.getFileName().equals(".") || linfo.getFileName().equals("..")) {
                    filelist.remove(i);
                    --i;
                    continue;
                }
                String linfotype = linfo.get("type");
                if (linfotype.equals("file")) {
                    ++numsubfiles;
                    continue;
                }
                if (!linfotype.equals("dir")) continue;
                ++numsubdirs;
            }
            if (numsubdirs == 0 && curmindepth <= 0) {
                double progressChunk = (progressEnd - progressStart) / (double)(stack.size() + 1);
                this.downloadGSIFTPAux(ftpclient, gridftphost, gridftpport, curremotepath, curlocalfile, null, info, credman, 1, 0, updateOnly, remoteTimeZone, progressStart, progressStart + progressChunk);
                progressStart += progressChunk;
                continue;
            }
            for (i = 0; i < filelist.size(); ++i) {
                if (this.isCancelled()) {
                    throw new CanceledException("Operation canceled by user.");
                }
                MlsxEntry subinfo = (MlsxEntry)filelist.elementAt(i);
                _logger.log(Level.FINE, "  file {0}", subinfo.getFileName());
                File newlocalfile = new File(curlocalfile, subinfo.getFileName());
                String newremotepath = curremotepath + "/" + subinfo.getFileName();
                String subinfotype = subinfo.get("type");
                if (subinfotype.equals("dir")) {
                    if (!newlocalfile.exists()) {
                        this.publish(new ProgressUpdate((this._dryrun ? "(not) " : "") + "Making directory '" + localfile.getAbsolutePath() + "'", 0.0));
                        if (!this._dryrun) {
                            newlocalfile.mkdir();
                            long sublastmod = this.getTimestamp(subinfo, remoteTimeZone);
                            if (sublastmod != -1L) {
                                _logger.log(Level.FINE, "Setting temporary timestamp: {0} {1}", new Object[]{newlocalfile.getPath(), dateformat.format(new Date(sublastmod - 1000L))});
                                newlocalfile.setLastModified(sublastmod - 1000L);
                                timestampqueue.add(new TimeStampQueueEntry(newlocalfile, sublastmod));
                            }
                        }
                        stack.addLast(new StackEntry(newremotepath, newlocalfile, 0, subinfo));
                        continue;
                    }
                    stack.addLast(new StackEntry(newremotepath, newlocalfile, curmindepth - 1, subinfo));
                    continue;
                }
                if (!subinfotype.equals("file")) continue;
                double progressChunk = (progressEnd - progressStart) / (double)(stack.size() + 1);
                this.downloadGSIFTPAux(ftpclient, gridftphost, gridftpport, newremotepath, newlocalfile, null, subinfo, credman, 1, 0, updateOnly, remoteTimeZone, progressStart, progressStart + progressChunk);
                progressStart += progressChunk;
            }
        }
        int i = 0;
        while (true) {
            if (i >= timestampqueue.size()) {
                this.setProgress((int)progressEnd);
                return;
            }
            TimeStampQueueEntry e = (TimeStampQueueEntry)timestampqueue.get(i);
            _logger.log(Level.FINE, "Setting timestamp: {0} {1}", new Object[]{e._file.getPath(), dateformat.format(new Date(e._timestamp))});
            e._file.setLastModified(e._timestamp);
            ++i;
        }
    }
}

