/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirndownloader;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbirn.fbirn.utilities.AppPropertyChangerCheckbox;
import org.nbirn.fbirn.utilities.AppPropertyChangerCombo;
import org.nbirn.fbirn.utilities.CredentialManager;
import org.nbirn.fbirn.utilities.ExceptionDialog;
import org.nbirn.fbirn.utilities.PropertySetManager;
import org.nbirn.fbirn.utilities.download.DownloaderCatalog;
import org.nbirn.fbirn.utilities.download.DownloaderCatalogEntry;
import org.nbirn.fbirn.utilities.download.ProgressBarListener;
import org.nbirn.fbirn.utilities.download.WorkerDownloadFromCatalog;
import org.nbirn.fbirn.utilities.download.WorkerDownloadFromURL;
import org.nbirn.fbirn.xcede2.catalog.CatalogEntry;
import org.nbirn.fbirndownloader.Main;

public class MainFrame
extends JFrame {
    final String XCEDE2NS = "http://www.xcede.org/xcede-2";
    private Main _main = null;
    private DownloaderCatalog _catalog = null;
    Properties _properties = null;
    CredentialManager _credman = null;
    WorkerDownloadFromCatalog _downloadworker = null;
    WorkerDownloadFromURL _catalogworker = null;
    private static Log _logger = LogFactory.getLog((String)MainFrame.class.getName());
    private final int _numsavedprops = 10;
    private JPanel _CheckboxPanelSpacer;
    private JCheckBox _DoCatalogCheckBox;
    private JButton _DownloadButton;
    private JPanel _DownloadPanel;
    private JProgressBar _DownloadProgressBar;
    private JPanel _DownloadProgressPanel;
    private JPanel _DownloadSpacerPanel;
    private JCheckBox _DryRunCheckBox;
    private JButton _OutputDirButton;
    private JFileChooser _OutputDirFileChooser;
    private JLabel _OutputDirLabel;
    private JPanel _OutputDirPanel;
    private JComboBox _OutputDirTextField;
    private JPanel _SourcePanel;
    private JPanel _SourceSpacer;
    private JLabel _SourceURLLabel;
    private JComboBox _SourceURLTextField;
    private JPanel _TopPanel;
    private JScrollPane _TopScrollPane;
    private JCheckBox _UpdateQuestionCheckBox;
    private JPanel _UpdateQuestionPanel;

    public MainFrame(Main main) {
        String propDoCatalog;
        String propUpdate;
        this.initComponents();
        this._main = main;
        Vector outputDirSet = this._main.getPropertySet("outputDir");
        this._OutputDirTextField.removeAllItems();
        for (int i = 0; i < outputDirSet.size(); ++i) {
            this._OutputDirTextField.addItem(this.makeObj((String)outputDirSet.get(i)));
        }
        Vector sourceURLSet = this._main.getPropertySet("sourceURL");
        this._SourceURLTextField.removeAllItems();
        for (int i = 0; i < sourceURLSet.size(); ++i) {
            this._SourceURLTextField.addItem(this.makeObj((String)sourceURLSet.get(i)));
        }
        String propDryRun = this._main.getProperty("dryRun");
        if (propDryRun != null) {
            this._DryRunCheckBox.setSelected(Boolean.valueOf(propDryRun));
        }
        if ((propUpdate = this._main.getProperty("update")) != null) {
            this._UpdateQuestionCheckBox.setSelected(Boolean.valueOf(propUpdate));
        }
        if ((propDoCatalog = this._main.getProperty("doCatalog")) != null) {
            this._DoCatalogCheckBox.setSelected(Boolean.valueOf(propDoCatalog));
        }
        AppPropertyChangerCombo catchanger = new AppPropertyChangerCombo((PropertySetManager)this._main, "sourceURL", this._SourceURLTextField);
        AppPropertyChangerCombo outputchanger = new AppPropertyChangerCombo((PropertySetManager)this._main, "outputDir", this._OutputDirTextField);
        this._SourceURLTextField.addActionListener((ActionListener)catchanger);
        this._OutputDirTextField.addActionListener((ActionListener)outputchanger);
        AppPropertyChangerCheckbox dryrunchanger = new AppPropertyChangerCheckbox((PropertySetManager)this._main, "dryRun", this._DryRunCheckBox);
        AppPropertyChangerCheckbox updatechanger = new AppPropertyChangerCheckbox((PropertySetManager)this._main, "update", this._UpdateQuestionCheckBox);
        AppPropertyChangerCheckbox docatalogchanger = new AppPropertyChangerCheckbox((PropertySetManager)this._main, "doCatalog", this._DoCatalogCheckBox);
        this._DryRunCheckBox.addItemListener((ItemListener)dryrunchanger);
        this._UpdateQuestionCheckBox.addItemListener((ItemListener)updatechanger);
        this._DoCatalogCheckBox.addItemListener((ItemListener)docatalogchanger);
        this.pack();
        this._credman = new CredentialManager((PropertySetManager)this._main, (Component)this);
    }

    private void initComponents() {
        this._OutputDirFileChooser = new JFileChooser();
        this._TopScrollPane = new JScrollPane();
        this._TopPanel = new JPanel();
        this._OutputDirPanel = new JPanel();
        this._OutputDirLabel = new JLabel();
        this._OutputDirTextField = new JComboBox();
        this._OutputDirButton = new JButton();
        this._SourcePanel = new JPanel();
        this._SourceURLLabel = new JLabel();
        this._SourceURLTextField = new JComboBox();
        this._DoCatalogCheckBox = new JCheckBox();
        this._SourceSpacer = new JPanel();
        this._DownloadPanel = new JPanel();
        this._DownloadButton = new JButton();
        this._UpdateQuestionPanel = new JPanel();
        this._UpdateQuestionCheckBox = new JCheckBox();
        this._CheckboxPanelSpacer = new JPanel();
        this._DryRunCheckBox = new JCheckBox();
        this._DownloadProgressBar = new JProgressBar();
        this._DownloadProgressPanel = new JPanel();
        this._DownloadSpacerPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("FBIRN Downloader");
        this.getContentPane().setLayout(new GridBagLayout());
        this._TopPanel.setLayout(new GridBagLayout());
        this._OutputDirPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._OutputDirPanel.setLayout(new GridBagLayout());
        this._OutputDirLabel.setFont(new Font("Dialog", 0, 12));
        this._OutputDirLabel.setText("Output dir:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        this._OutputDirPanel.add((Component)this._OutputDirLabel, gridBagConstraints);
        this._OutputDirTextField.setEditable(true);
        this._OutputDirTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this._OutputDirPanel.add((Component)this._OutputDirTextField, gridBagConstraints);
        this._OutputDirButton.setFont(new Font("Dialog", 0, 12));
        this._OutputDirButton.setText("Browse...");
        this._OutputDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this._OutputDirButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        this._OutputDirPanel.add((Component)this._OutputDirButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        this._TopPanel.add((Component)this._OutputDirPanel, gridBagConstraints);
        this._SourcePanel.setLayout(new GridBagLayout());
        this._SourceURLLabel.setFont(new Font("Dialog", 0, 12));
        this._SourceURLLabel.setText("Source URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        this._SourcePanel.add((Component)this._SourceURLLabel, gridBagConstraints);
        this._SourceURLTextField.setEditable(true);
        this._SourceURLTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this._SourcePanel.add((Component)this._SourceURLTextField, gridBagConstraints);
        this._DoCatalogCheckBox.setFont(new Font("Dialog", 0, 12));
        this._DoCatalogCheckBox.setSelected(true);
        this._DoCatalogCheckBox.setText("Source is an XCEDE2 download catalog");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this._SourcePanel.add((Component)this._DoCatalogCheckBox, gridBagConstraints);
        this._SourceSpacer.setPreferredSize(new Dimension(1, 10));
        this._SourceSpacer.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this._SourcePanel.add((Component)this._SourceSpacer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this._TopPanel.add((Component)this._SourcePanel, gridBagConstraints);
        this._DownloadPanel.setLayout(new GridBagLayout());
        this._DownloadButton.setText("Download");
        this._DownloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this._DownloadButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this._DownloadPanel.add((Component)this._DownloadButton, gridBagConstraints);
        this._UpdateQuestionPanel.setLayout(new GridBagLayout());
        this._UpdateQuestionCheckBox.setFont(new Font("Dialog", 0, 12));
        this._UpdateQuestionCheckBox.setSelected(true);
        this._UpdateQuestionCheckBox.setText("Update local files only if remote files are newer");
        this._UpdateQuestionPanel.add((Component)this._UpdateQuestionCheckBox, new GridBagConstraints());
        this._CheckboxPanelSpacer.setMinimumSize(new Dimension(20, 0));
        this._CheckboxPanelSpacer.setPreferredSize(new Dimension(20, 20));
        GroupLayout _CheckboxPanelSpacerLayout = new GroupLayout(this._CheckboxPanelSpacer);
        this._CheckboxPanelSpacer.setLayout(_CheckboxPanelSpacerLayout);
        _CheckboxPanelSpacerLayout.setHorizontalGroup(_CheckboxPanelSpacerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        _CheckboxPanelSpacerLayout.setVerticalGroup(_CheckboxPanelSpacerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this._UpdateQuestionPanel.add((Component)this._CheckboxPanelSpacer, new GridBagConstraints());
        this._DryRunCheckBox.setFont(new Font("Dialog", 0, 12));
        this._DryRunCheckBox.setText("Dry run (don't actually download anything)");
        this._UpdateQuestionPanel.add((Component)this._DryRunCheckBox, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this._DownloadPanel.add((Component)this._UpdateQuestionPanel, gridBagConstraints);
        this._DownloadProgressBar.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this._DownloadPanel.add((Component)this._DownloadProgressBar, gridBagConstraints);
        this._DownloadProgressPanel.setBorder(BorderFactory.createBevelBorder(1));
        this._DownloadProgressPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this._DownloadPanel.add((Component)this._DownloadProgressPanel, gridBagConstraints);
        this._DownloadSpacerPanel.setPreferredSize(new Dimension(0, 0));
        GroupLayout _DownloadSpacerPanelLayout = new GroupLayout(this._DownloadSpacerPanel);
        this._DownloadSpacerPanel.setLayout(_DownloadSpacerPanelLayout);
        _DownloadSpacerPanelLayout.setHorizontalGroup(_DownloadSpacerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        _DownloadSpacerPanelLayout.setVerticalGroup(_DownloadSpacerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this._DownloadPanel.add((Component)this._DownloadSpacerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this._TopPanel.add((Component)this._DownloadPanel, gridBagConstraints);
        this._TopScrollPane.setViewportView(this._TopPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this._TopScrollPane, gridBagConstraints);
        this.pack();
    }

    private Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _OutputDirButtonActionPerformed(ActionEvent evt) {
        while (true) {
            int returnVal;
            this._OutputDirFileChooser.setFileSelectionMode(1);
            Object selected = this._OutputDirTextField.getSelectedItem();
            if (selected != null) {
                File initdir = new File(selected.toString());
                this._OutputDirFileChooser.setCurrentDirectory(initdir);
            }
            if ((returnVal = this._OutputDirFileChooser.showOpenDialog(this)) == 0) {
                File file = this._OutputDirFileChooser.getSelectedFile();
                String outputDir = file.getAbsolutePath();
                if (!file.exists()) {
                    Object[] options = new Object[]{"Yes", "No"};
                    returnVal = JOptionPane.showOptionDialog(this, "Directory '" + outputDir + "' doesn't exist.\nWould you like to create it?", "Create Directory?", 0, 3, null, options, options[1]);
                    if (returnVal == 1) continue;
                    if (!file.mkdirs()) {
                        JOptionPane.showMessageDialog(this, "Error creating directory.", "Error", 0);
                        continue;
                    }
                }
                boolean found = false;
                for (int i = 0; i < this._OutputDirTextField.getItemCount(); ++i) {
                    if (!outputDir.equals(this._OutputDirTextField.getItemAt(i))) continue;
                    found = true;
                    this._OutputDirTextField.setSelectedIndex(i);
                }
                if (found) return;
                this._OutputDirTextField.insertItemAt(this.makeObj(outputDir), 0);
                this._OutputDirTextField.setSelectedIndex(0);
                return;
            }
            if (returnVal == 1) return;
        }
    }

    private void doCatalogDownloadStart() {
        URI url = null;
        try {
            url = new URI(this._SourceURLTextField.getSelectedItem().toString());
        }
        catch (URISyntaxException e) {
            _logger.error((Object)"Catalog URL is not a valid URL", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Catalog URL is not a valid URL", "Error", 0);
            this.doCatalogDownloadFinished(null, null);
            return;
        }
        Object doc = null;
        File tempfile = null;
        try {
            tempfile = File.createTempFile("fbirndownload.", ".xml");
            this._catalogworker = new WorkerDownloadFromURL(url, tempfile, this._credman);
            this.setCursor(Cursor.getPredefinedCursor(3));
            DownloadCatalogListener dclistener = new DownloadCatalogListener(this, this._catalogworker, tempfile);
            this._catalogworker.addPropertyChangeListener((PropertyChangeListener)dclistener);
            this._catalogworker.execute();
        }
        catch (Exception e) {
            this.exceptionDialog(new Exception("Error downloading catalog document.", e));
            this.doCatalogDownloadFinished(this._catalogworker, tempfile);
        }
    }

    private void doCatalogDownloadFinished(WorkerDownloadFromURL worker, File catalogFile) {
        this.setCursor(null);
        try {
            worker.get();
            if (worker != null) {
                this._catalog = new DownloaderCatalog();
                try {
                    this._catalog.parseCatalogFile(catalogFile);
                    this._DownloadButton.setEnabled(true);
                }
                catch (Exception e) {
                    this.exceptionDialog(new Exception("Error parsing catalog document", e));
                }
            }
        }
        catch (InterruptedException e) {
            this.exceptionDialog(new Exception("Error downloading catalog document", e));
        }
        catch (ExecutionException e) {
            this.exceptionDialog(new Exception("Error downloading catalog document", e));
        }
        if (catalogFile != null) {
            catalogFile.delete();
        }
        this.doDataDownloadStart();
    }

    private void _DownloadButtonActionPerformed(ActionEvent evt) {
        this._DownloadButton.setEnabled(false);
        if ("Cancel download".equals(this._DownloadButton.getText())) {
            if (this._downloadworker != null) {
                this._downloadworker.cancel(true);
            }
            this.doDataDownloadFinished(this._downloadworker);
            return;
        }
        Component[] progpanelchildren = this._DownloadProgressPanel.getComponents();
        for (int i = 0; i < progpanelchildren.length; ++i) {
            this._DownloadProgressPanel.remove(i);
        }
        this._credman.resetCanceled();
        if (this._DoCatalogCheckBox.isSelected()) {
            this.doCatalogDownloadStart();
        } else {
            this._catalog = new DownloaderCatalog();
            URI url = null;
            try {
                url = new URI(this._SourceURLTextField.getSelectedItem().toString());
            }
            catch (URISyntaxException e) {
                _logger.error((Object)"Source URL is not a valid URL", (Throwable)e);
                JOptionPane.showMessageDialog(this, "Source URL is not a valid URL", "Error", 0);
                this.doCatalogDownloadFinished(null, null);
                return;
            }
            DownloaderCatalogEntry entry = new DownloaderCatalogEntry();
            entry.setURI(url);
            if (this._UpdateQuestionCheckBox.isSelected()) {
                entry.setTimeStampCheckDepth(Integer.MAX_VALUE);
            }
            this._catalog.addEntry((CatalogEntry)entry);
            this.doDataDownloadStart();
        }
    }

    private void doDataDownloadStart() {
        if (this._catalog == null) {
            this.doDataDownloadFinished(null);
            return;
        }
        File outputDirFile = new File(this._OutputDirTextField.getSelectedItem().toString());
        if (!outputDirFile.exists()) {
            int option = JOptionPane.showOptionDialog(this, "Specified output directory '" + outputDirFile.getPath() + "' does not exist.  Do you wish to create this directory?", "Create directory?", 0, 3, null, null, null);
            if (option == 1) {
                this.doDataDownloadFinished(null);
                return;
            }
            if (!outputDirFile.mkdirs()) {
                JOptionPane.showMessageDialog(this, "Error creating output directory!", "Error", 0);
                this.doDataDownloadFinished(null);
                return;
            }
        } else if (!outputDirFile.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Specified output target exists but is not a directory!", "Error", 0);
            this.doDataDownloadFinished(null);
            return;
        }
        this._catalog.setParentPanel(this._DownloadProgressPanel);
        this._downloadworker = new WorkerDownloadFromCatalog(this._catalog, outputDirFile, null, this._credman, this._UpdateQuestionCheckBox.getSelectedObjects() != null, this._DryRunCheckBox.getSelectedObjects() != null, null, 100.0);
        this._DownloadProgressBar.setEnabled(true);
        this._DownloadProgressBar.setString("Downloading...");
        this._DownloadProgressBar.setStringPainted(true);
        this._DownloadProgressBar.setIndeterminate(true);
        this.setCursor(Cursor.getPredefinedCursor(3));
        DownloadListener dlistener = new DownloadListener(this, this._downloadworker);
        this._downloadworker.addPropertyChangeListener((PropertyChangeListener)dlistener);
        ProgressBarListener pblistener = new ProgressBarListener(this._DownloadProgressBar);
        this._downloadworker.addPropertyChangeListener((PropertyChangeListener)pblistener);
        this._downloadworker.execute();
        this._DownloadButton.setText("Cancel download");
        this._DownloadButton.setEnabled(true);
    }

    private void doDataDownloadFinished(WorkerDownloadFromCatalog worker) {
        this._downloadworker = null;
        this._DownloadProgressBar.setIndeterminate(false);
        this._DownloadProgressBar.setString("");
        this.setCursor(null);
        boolean succeeded = false;
        try {
            if (worker != null && worker.get() == null) {
                succeeded = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (succeeded) {
            this._DownloadProgressBar.setString("Success!");
        } else {
            this._DownloadProgressBar.setString("Error");
        }
        this._DownloadButton.setText("Download");
        this._DownloadButton.setEnabled(true);
        this._DownloadProgressBar.setEnabled(false);
    }

    private void exceptionDialog(Throwable e) {
        _logger.error((Object)"Encountered an execption", e);
        ExceptionDialog.show((Component)this, (Throwable)e);
    }

    class DownloadListener
    implements PropertyChangeListener {
        MainFrame _main;
        WorkerDownloadFromCatalog _worker;

        DownloadListener(MainFrame main, WorkerDownloadFromCatalog worker) {
            this._main = main;
            this._worker = worker;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName.equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                this._main.doDataDownloadFinished(this._worker);
            }
        }
    }

    class DownloadCatalogListener
    implements PropertyChangeListener {
        MainFrame _main;
        WorkerDownloadFromURL _worker;
        File _catalogFile;

        DownloadCatalogListener(MainFrame main, WorkerDownloadFromURL worker, File catalogFile) {
            this._main = main;
            this._worker = worker;
            this._catalogFile = catalogFile;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName.equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                this._main.doCatalogDownloadFinished(this._worker, this._catalogFile);
            }
        }
    }
}

