/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public abstract class ASN1Encodable
implements DEREncodable {
    public static final String DER = "DER";
    public static final String BER = "BER";

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(this);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded(String string) throws IOException {
        if (string.equals(DER)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(this);
            return byteArrayOutputStream.toByteArray();
        }
        return this.getEncoded();
    }

    public byte[] getDEREncoded() {
        try {
            return this.getEncoded(DER);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int hashCode() {
        return this.toASN1Object().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ASN1Encodable)) {
            return false;
        }
        ASN1Encodable aSN1Encodable = (ASN1Encodable)object;
        return this.toASN1Object().equals(aSN1Encodable.toASN1Object());
    }

    public DERObject getDERObject() {
        return this.toASN1Object();
    }

    public abstract DERObject toASN1Object();
}

