/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;

public abstract class ECPoint {
    ECCurve curve;
    ECFieldElement x;
    ECFieldElement y;

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this.curve = eCCurve;
        this.x = eCFieldElement;
        this.y = eCFieldElement2;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECFieldElement getX() {
        return this.x;
    }

    public ECFieldElement getY() {
        return this.y;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPoint)) {
            return false;
        }
        ECPoint eCPoint = (ECPoint)object;
        return this.x.equals(eCPoint.x) && this.y.equals(eCPoint.y);
    }

    public int hashCode() {
        return this.x.hashCode() ^ this.y.hashCode();
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint twice();

    public abstract ECPoint multiply(BigInteger var1);

    public static class F2m
    extends ECPoint {
        protected F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }

        public byte[] getEncoded() {
            return null;
        }

        public ECPoint add(ECPoint eCPoint) {
            return null;
        }

        public ECPoint subtract(ECPoint eCPoint) {
            return null;
        }

        public ECPoint twice() {
            return null;
        }

        public ECPoint multiply(BigInteger bigInteger) {
            return null;
        }
    }

    public static class Fp
    extends ECPoint {
        private boolean withCompression = true;

        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }

        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
            this.withCompression = bl;
        }

        private int getQLength(BigInteger bigInteger) {
            byte[] byArray = bigInteger.toByteArray();
            if (byArray[0] == 0) {
                return byArray.length - 1;
            }
            return byArray.length;
        }

        private byte[] intToBytes(BigInteger bigInteger, int n) {
            byte[] byArray = bigInteger.toByteArray();
            if (n < byArray.length) {
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, byArray.length - byArray2.length, byArray2, 0, byArray2.length);
                return byArray2;
            }
            if (n > byArray.length) {
                byte[] byArray3 = new byte[n];
                System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
                return byArray3;
            }
            return byArray;
        }

        public byte[] getEncoded() {
            int n = this.getQLength(this.getX().p);
            if (this.withCompression) {
                int n2 = this.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = this.intToBytes(this.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                return byArray2;
            }
            byte[] byArray = this.intToBytes(this.getX().toBigInteger(), n);
            byte[] byArray3 = this.intToBytes(this.getY().toBigInteger(), n);
            byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
            byArray4[0] = 4;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
            return byArray4;
        }

        public ECPoint add(ECPoint eCPoint) {
            ECFieldElement eCFieldElement = eCPoint.y.subtract(this.y).divide(eCPoint.x.subtract(this.x));
            ECFieldElement eCFieldElement2 = eCFieldElement.multiply(eCFieldElement).subtract(this.x).subtract(eCPoint.x);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(this.x.subtract(eCFieldElement2)).subtract(this.y);
            return new Fp(this.curve, eCFieldElement2, eCFieldElement3);
        }

        public ECPoint twice() {
            ECFieldElement eCFieldElement = this.curve.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = this.curve.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = this.x.multiply(this.x).multiply(eCFieldElement2).add(this.curve.a).divide(this.y.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(eCFieldElement3).subtract(this.x.multiply(eCFieldElement));
            ECFieldElement eCFieldElement5 = eCFieldElement3.multiply(this.x.subtract(eCFieldElement4)).subtract(this.y);
            return new Fp(this.curve, eCFieldElement4, eCFieldElement5);
        }

        public ECPoint subtract(ECPoint eCPoint) {
            return this.add(new Fp(this.curve, eCPoint.x, eCPoint.y.negate()));
        }

        public ECPoint multiply(BigInteger bigInteger) {
            BigInteger bigInteger2 = bigInteger;
            BigInteger bigInteger3 = bigInteger2.multiply(BigInteger.valueOf(3L));
            ECPoint eCPoint = this;
            int n = bigInteger3.bitLength() - 2;
            while (n > 0) {
                eCPoint = eCPoint.twice();
                if (bigInteger3.testBit(n) && !bigInteger2.testBit(n)) {
                    eCPoint = eCPoint.add(this);
                } else if (!bigInteger3.testBit(n) && bigInteger2.testBit(n)) {
                    eCPoint = eCPoint.subtract(this);
                }
                --n;
            }
            return eCPoint;
        }
    }
}

