/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.exception;

import java.io.PrintStream;
import java.io.PrintWriter;

public class FTPException
extends Exception {
    public static final int UNSPECIFIED = 0;
    protected int code = 0;
    private static String[] codeExplained = new String[]{"Unspecified category."};
    protected Exception cause;
    protected String customMessage;

    public String getCodeExplanation(int code) {
        if (codeExplained.length > code) {
            return codeExplained[code];
        }
        return "";
    }

    public FTPException(int code, String message) {
        this.code = code;
        this.customMessage = message;
    }

    public FTPException(int code) {
        this.code = code;
    }

    public void setRootCause(Exception c) {
        this.cause = c;
    }

    public Exception getRootCause() {
        return this.cause;
    }

    public void setCode(int c) {
        this.code = c;
    }

    public int getCode() {
        return this.code;
    }

    public void setCustomMessage(String m) {
        this.customMessage = m;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        if (this.code != 0) {
            buf.append(this.getCodeExplanation(this.code));
        }
        if (this.customMessage != null) {
            buf.append(" Custom message: ");
            buf.append(this.customMessage);
        }
        if (this.code != 0) {
            buf.append(" (error code ").append(String.valueOf(this.code)).append(")");
        }
        if (this.cause != null) {
            buf.append(" [Nested exception message: ");
            buf.append(this.cause.getMessage());
            buf.append("]");
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        String answer = super.toString();
        if (this.cause != null && this.cause != this) {
            answer = answer + " [Nested exception is " + this.cause.toString() + "]";
        }
        return answer;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        if (this.cause != null) {
            String superString = super.toString();
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.print(superString + (superString.endsWith(".") ? "" : ".") + "  Nested exception is ");
                this.cause.printStackTrace(ps);
            }
        } else {
            super.printStackTrace(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        if (this.cause != null) {
            String superString = super.toString();
            PrintWriter printWriter = pw;
            synchronized (printWriter) {
                pw.print(superString + (superString.endsWith(".") ? "" : ".") + "  Nested exception is ");
                this.cause.printStackTrace(pw);
            }
        } else {
            super.printStackTrace(pw);
        }
    }
}

