/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gram;

import org.globus.gram.Gram;
import org.globus.gram.GramJob;
import org.globus.gram.GramJobListener;
import org.globus.util.deactivator.Deactivator;

public class GramTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        GramJob job1 = new GramJob("&(executable=/bin/sleep)(directory=/tmp)(arguments=15)");
        GramJob job2 = new GramJob("&(executable=/bin/sleep)(directory=/tmp)(arguments=25)");
        GramJob job3 = new GramJob("&(executable=/bin/sleep)(directory=/tmp)(arguments=35)");
        String contact = null;
        if (args.length == 0) {
            System.err.println("Usage: java GramTest [resource manager]");
            System.exit(1);
        }
        contact = args[0];
        try {
            job1.addListener(new GramJobListener(){

                @Override
                public void statusChanged(GramJob job) {
                    System.out.println("Job1 status change \n    ID     : " + job.getIDAsString() + "\n" + "    Status : " + job.getStatusAsString());
                }
            });
            job3.addListener(new GramJobListener(){

                @Override
                public void statusChanged(GramJob job) {
                    System.out.println("Job3 status change \n    ID     : " + job.getIDAsString() + "\n" + "    Status : " + job.getStatusAsString());
                }
            });
            job2.addListener(new GramJobListener(){

                @Override
                public void statusChanged(GramJob job) {
                    System.out.println("Job2 status change \n    ID     : " + job.getIDAsString() + "\n" + "    Status : " + job.getStatusAsString());
                    if (job.getStatus() == 2) {
                        try {
                            System.out.println("disconnecting from job2");
                            job.unbind();
                            System.out.println("canceling job2");
                            job.cancel();
                        }
                        catch (Exception e) {
                            System.out.println(e);
                        }
                    }
                }
            });
            System.out.println("submitting job1...");
            job1.request(contact);
            System.out.println("job submited: " + job1.getIDAsString());
            System.out.println("submitting job2...");
            job2.request(contact);
            System.out.println("job submited: " + job2.getIDAsString());
            System.out.println("submitting job3 in batch mode...");
            job3.request(contact, true);
            System.out.println("job submited: " + job3.getIDAsString());
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            System.out.println("rebinding to job3..");
            job3.bind();
            try {
                while (Gram.getActiveJobs() != 0) {
                    Thread.sleep(2000L);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            System.out.println("Test completed.");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            Deactivator.deactivateAll();
        }
    }
}

