/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.proxy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.globus.common.CoGProperties;
import org.globus.tools.proxy.DefaultProxyOptionsPanel;
import org.globus.tools.proxy.PKCS11ProxyOptionsPanel;
import org.globus.tools.proxy.ProxyOptionsPanel;

public class ProxyOptionsWindow
extends JDialog
implements ActionListener {
    private ProxyOptionsPanel optionsPanel;
    private CoGProperties properties;
    private JButton applyBt = null;
    private JButton cancelBt = null;

    public ProxyOptionsWindow(Dialog owner, boolean modal, boolean pkcs11) {
        super(owner, modal);
        this.setTitle("Options");
        if (pkcs11) {
            this.optionsPanel = new PKCS11ProxyOptionsPanel();
            this.optionsPanel.setBorder(BorderFactory.createTitledBorder(" PKCS11 Options "));
        } else {
            this.optionsPanel = new DefaultProxyOptionsPanel();
            this.optionsPanel.setBorder(BorderFactory.createTitledBorder(" Proxy Options "));
        }
        JPanel buttonPanel = new JPanel();
        this.applyBt = new JButton("Apply");
        this.applyBt.addActionListener(this);
        buttonPanel.add(this.applyBt);
        this.cancelBt = new JButton("Cancel");
        this.cancelBt.addActionListener(this);
        buttonPanel.add(this.cancelBt);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.optionsPanel, "Center");
        contentPane.add((Component)buttonPanel, "South");
    }

    public void setProperties(CoGProperties props) {
        if (props == null) {
            throw new IllegalArgumentException("Properties cannot be null");
        }
        this.properties = props;
        this.optionsPanel.set(props);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancelBt) {
            this.properties = null;
            this.dispose();
        } else if (source == this.applyBt && this.optionsPanel.validateSettings()) {
            this.optionsPanel.get(this.properties);
            this.dispose();
        }
    }

    public CoGProperties getProperties() {
        return this.properties;
    }
}

