/*
 * Decompiled with CFR 0.152.
 */
package org.birncommunity.sample.gridftp;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.birncommunity.sample.gridftp.TwoPartyTransfer;
import org.birncommunity.sample.proxy.LocalCredentialHelper;
import org.birncommunity.util.FileNameUtil;
import org.birncommunity.util.MethodParameterChecker;
import org.globus.ftp.GridFTPClient;

public class CreateDirectory {
    private static Log log = LogFactory.getLog(CreateDirectory.class);
    private String host;
    private int port;
    private String directory;

    public static void main(String[] args) throws Exception {
        if (args.length != 3 || args[0].equals("-h") || args[0].equals("--help")) {
            log.error((Object)("Usage: java " + CreateDirectory.class.getName() + " <host> <port> <directory>"));
            log.error((Object)"host: GridFTP server hostname");
            log.error((Object)"port: GridFTP server port");
            log.error((Object)"directory: Directory to be created (UNIX-style path)");
            log.error((Object)"");
            log.error((Object)"A user proxy certificate needs to be in place in /tmp");
            log.error((Object)"");
            log.error((Object)("Example: java " + TwoPartyTransfer.class.getName() + " chi-vm-4.isi.edu 2811 /tmp/testdir"));
            log.error((Object)"This will create the directory chi-vm-4.isi.edu/tmp/testdir in a way like the UNIX command \"mkdir -p /tmp/testdir\" would create it");
            System.exit(1);
        }
        String host = args[0];
        int port = new Integer(args[1]);
        String directory = args[2];
        new CreateDirectory(host, port, directory).createDir();
    }

    public CreateDirectory(String host, int port, String directory) {
        new MethodParameterChecker().verifyNotNull(new Object[]{host, port, directory});
        this.host = host;
        this.port = port;
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDir() throws Exception {
        GridFTPClient client = null;
        try {
            FileNameUtil fnu = new FileNameUtil();
            String tmpDir = this.directory;
            LinkedList<String> dirs = new LinkedList<String>();
            client = new GridFTPClient(this.host, this.port);
            client.authenticate(new LocalCredentialHelper().getDefaultCredential());
            dirs.add(this.directory);
            while ((tmpDir = fnu.getUNIXParentDirName(tmpDir)) != null) {
                dirs.add(tmpDir);
            }
            for (int i = dirs.size() - 1; i > -1; --i) {
                log.debug((Object)("checking dir " + (String)dirs.get(i)));
                if (client.exists((String)dirs.get(i))) continue;
                log.debug((Object)("creating dir " + (String)dirs.get(i)));
                client.makeDir((String)dirs.get(i));
            }
        }
        finally {
            try {
                if (client != null) {
                    client.close(true);
                }
            }
            catch (Exception e) {
                log.error((Object)"Can't close connection.", (Throwable)e);
            }
        }
    }
}

